/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.product.internal.search;

import com.liferay.commerce.product.model.CPOptionCategory;
import com.liferay.commerce.product.model.CPSpecificationOption;
import com.liferay.commerce.product.service.CPOptionCategoryLocalService;
import com.liferay.commerce.product.service.CPSpecificationOptionLocalService;
import com.liferay.portal.kernel.dao.orm.IndexableActionableDynamicQuery;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.search.BaseIndexer;
import com.liferay.portal.kernel.search.BooleanQuery;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.IndexWriterHelper;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.Summary;
import com.liferay.portal.kernel.search.filter.BooleanFilter;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.LocalizationUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(enabled=false, immediate=true, service={Indexer.class})
public class CPSpecificationOptionIndexer
extends BaseIndexer<CPSpecificationOption> {
    public static final String CLASS_NAME = CPSpecificationOption.class.getName();
    private static final Log _log = LogFactoryUtil.getLog(CPSpecificationOptionIndexer.class);
    @Reference
    private CPOptionCategoryLocalService _cpOptionCategoryLocalService;
    @Reference
    private CPSpecificationOptionLocalService _cpSpecificationOptionLocalService;
    @Reference
    private IndexWriterHelper _indexWriterHelper;

    public CPSpecificationOptionIndexer() {
        this.setDefaultSelectedFieldNames(new String[]{"companyId", "entryClassName", "entryClassPK", "modified", "title", "uid", "key"});
        this.setFilterSearch(true);
        this.setPermissionAware(true);
    }

    public String getClassName() {
        return CLASS_NAME;
    }

    public void postProcessContextBooleanFilter(BooleanFilter contextBooleanFilter, SearchContext searchContext) throws Exception {
        Map attributes = searchContext.getAttributes();
        if (attributes.containsKey("facetable")) {
            boolean facetable = GetterUtil.getBoolean(attributes.get("facetable"));
            contextBooleanFilter.addRequiredTerm("facetable", facetable);
        }
    }

    public void postProcessSearchQuery(BooleanQuery searchQuery, BooleanFilter fullQueryBooleanFilter, SearchContext searchContext) throws Exception {
        String expandoAttributes;
        this.addSearchTerm(searchQuery, searchContext, "cpOptionCategoryId", false);
        this.addSearchTerm(searchQuery, searchContext, "cpOptionCategoryTitle", false);
        this.addSearchLocalizedTerm(searchQuery, searchContext, "cpOptionCategoryTitle", false);
        this.addSearchLocalizedTerm(searchQuery, searchContext, "description", false);
        this.addSearchTerm(searchQuery, searchContext, "entryClassPK", false);
        this.addSearchTerm(searchQuery, searchContext, "key", false);
        this.addSearchTerm(searchQuery, searchContext, "title", false);
        this.addSearchLocalizedTerm(searchQuery, searchContext, "title", false);
        this.addSearchTerm(searchQuery, searchContext, "userName", false);
        LinkedHashMap params = (LinkedHashMap)searchContext.getAttribute("params");
        if (params != null && Validator.isNotNull((String)(expandoAttributes = (String)params.get("expandoAttributes")))) {
            this.addSearchExpando(searchQuery, searchContext, expandoAttributes);
        }
    }

    protected void doDelete(CPSpecificationOption cpSpecificationOption) throws Exception {
        this.deleteDocument(cpSpecificationOption.getCompanyId(), cpSpecificationOption.getCPSpecificationOptionId());
    }

    protected Document doGetDocument(CPSpecificationOption cpSpecificationOption) throws Exception {
        String[] languageIds;
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Indexing specification option " + cpSpecificationOption));
        }
        Document document = this.getBaseModelDocument(CLASS_NAME, (BaseModel)cpSpecificationOption);
        CPOptionCategory cpOptionCategory = this._cpOptionCategoryLocalService.fetchCPOptionCategory(cpSpecificationOption.getCPOptionCategoryId());
        for (String languageId : languageIds = LocalizationUtil.getAvailableLanguageIds((String)cpSpecificationOption.getTitle())) {
            String title = cpSpecificationOption.getTitle(languageId);
            document.addText(LocalizationUtil.getLocalizedName((String)"title", (String)languageId), title);
            String description = cpSpecificationOption.getDescription(languageId);
            document.addText(LocalizationUtil.getLocalizedName((String)"description", (String)languageId), description);
            if (cpOptionCategory != null) {
                document.addText(LocalizationUtil.getLocalizedName((String)"cpOptionCategoryTitle", (String)languageId), cpOptionCategory.getTitle(languageId));
                document.addKeyword("cpOptionCategoryId", cpOptionCategory.getCPOptionCategoryId());
            }
            document.addKeyword("facetable", cpSpecificationOption.isFacetable());
            document.addText("key", cpSpecificationOption.getKey());
            document.addText("content", title);
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Document " + cpSpecificationOption + " indexed successfully"));
        }
        return document;
    }

    protected Summary doGetSummary(Document document, Locale locale, String snippet, PortletRequest portletRequest, PortletResponse portletResponse) {
        Summary summary = this.createSummary(document, "title", "description");
        summary.setMaxContentLength(200);
        return summary;
    }

    protected void doReindex(CPSpecificationOption cpSpecificationOption) throws Exception {
        this._indexWriterHelper.updateDocument(this.getSearchEngineId(), cpSpecificationOption.getCompanyId(), this.getDocument(cpSpecificationOption), this.isCommitImmediately());
    }

    protected void doReindex(String className, long classPK) throws Exception {
        this.doReindex(this._cpSpecificationOptionLocalService.getCPSpecificationOption(classPK));
    }

    protected void doReindex(String[] ids) throws Exception {
        long companyId = GetterUtil.getLong((String)ids[0]);
        this.reindexCPSpecificationOptions(companyId);
    }

    protected void reindexCPSpecificationOptions(long companyId) throws PortalException {
        IndexableActionableDynamicQuery indexableActionableDynamicQuery = this._cpSpecificationOptionLocalService.getIndexableActionableDynamicQuery();
        indexableActionableDynamicQuery.setCompanyId(companyId);
        indexableActionableDynamicQuery.setPerformActionMethod(cpSpecificationOption -> {
            block2: {
                try {
                    indexableActionableDynamicQuery.addDocuments(new Document[]{this.getDocument(cpSpecificationOption)});
                }
                catch (PortalException portalException) {
                    if (!_log.isWarnEnabled()) break block2;
                    long cpSpecificationOptionId = cpSpecificationOption.getCPSpecificationOptionId();
                    _log.warn((Object)("Unable to index commerce product specification option " + cpSpecificationOptionId), (Throwable)portalException);
                }
            }
        });
        indexableActionableDynamicQuery.setSearchEngineId(this.getSearchEngineId());
        indexableActionableDynamicQuery.performActions();
    }
}

