/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.product.internal.search;

import com.liferay.commerce.product.model.CommerceCatalog;
import com.liferay.commerce.product.service.CommerceCatalogLocalService;
import com.liferay.portal.kernel.dao.orm.IndexableActionableDynamicQuery;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.search.BaseIndexer;
import com.liferay.portal.kernel.search.BooleanClauseOccur;
import com.liferay.portal.kernel.search.BooleanQuery;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.IndexWriterHelper;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.Summary;
import com.liferay.portal.kernel.search.filter.BooleanFilter;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.Locale;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(enabled=false, immediate=true, service={Indexer.class})
public class CommerceCatalogIndexer
extends BaseIndexer<CommerceCatalog> {
    public static final String CLASS_NAME = CommerceCatalog.class.getName();
    private static final Log _log = LogFactoryUtil.getLog(CommerceCatalogIndexer.class);
    @Reference
    private CommerceCatalogLocalService _commerceCatalogLocalService;
    @Reference
    private IndexWriterHelper _indexWriterHelper;

    public CommerceCatalogIndexer() {
        this.setDefaultSelectedFieldNames(new String[]{"entryClassName", "entryClassPK", "uid"});
        this.setFilterSearch(true);
        this.setPermissionAware(true);
    }

    public String getClassName() {
        return CLASS_NAME;
    }

    public void postProcessContextBooleanFilter(BooleanFilter contextBooleanFilter, SearchContext searchContext) throws Exception {
        String catalogName;
        contextBooleanFilter.addRequiredTerm("companyId", searchContext.getCompanyId());
        String catalogId = GetterUtil.getString((Object)searchContext.getAttribute("entryClassPK"));
        if (!Validator.isBlank((String)catalogId)) {
            contextBooleanFilter.addTerm("entryClassPK", catalogId, BooleanClauseOccur.MUST);
        }
        if (!Validator.isBlank((String)(catalogName = GetterUtil.getString((Object)searchContext.getAttribute("name"))))) {
            contextBooleanFilter.addTerm("name", catalogName, BooleanClauseOccur.MUST);
        }
    }

    public void postProcessSearchQuery(BooleanQuery searchQuery, BooleanFilter fullQueryBooleanFilter, SearchContext searchContext) throws Exception {
        this.addSearchTerm(searchQuery, searchContext, "entryClassPK", false);
        this.addSearchTerm(searchQuery, searchContext, "name", false);
    }

    protected void doDelete(CommerceCatalog commerceCatalog) throws Exception {
        this.deleteDocument(commerceCatalog.getCompanyId(), commerceCatalog.getCommerceCatalogId());
    }

    protected Document doGetDocument(CommerceCatalog commerceCatalog) throws Exception {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Indexing commerce catalog " + commerceCatalog));
        }
        Document document = this.getBaseModelDocument(CLASS_NAME, (BaseModel)commerceCatalog);
        document.addKeyword("groupId", commerceCatalog.getGroupId());
        document.addKeyword("name", commerceCatalog.getName());
        document.addKeyword("catalogDefaultLanguageId", commerceCatalog.getCatalogDefaultLanguageId());
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Document " + commerceCatalog + " indexed successfully"));
        }
        return document;
    }

    protected Summary doGetSummary(Document document, Locale locale, String snippet, PortletRequest portletRequest, PortletResponse portletResponse) {
        Summary summary = this.createSummary(document, "entryClassPK", "name");
        summary.setMaxContentLength(200);
        return summary;
    }

    protected void doReindex(CommerceCatalog commerceCatalog) throws Exception {
        this._indexWriterHelper.updateDocument(this.getSearchEngineId(), commerceCatalog.getCompanyId(), this.getDocument(commerceCatalog), this.isCommitImmediately());
    }

    protected void doReindex(String className, long classPK) throws Exception {
        this.doReindex(this._commerceCatalogLocalService.getCommerceCatalog(classPK));
    }

    protected void doReindex(String[] ids) throws Exception {
        long companyId = GetterUtil.getLong((String)ids[0]);
        this.reindexCommerceCatalogs(companyId);
    }

    protected void reindexCommerceCatalogs(long companyId) throws PortalException {
        IndexableActionableDynamicQuery indexableActionableDynamicQuery = this._commerceCatalogLocalService.getIndexableActionableDynamicQuery();
        indexableActionableDynamicQuery.setCompanyId(companyId);
        indexableActionableDynamicQuery.setPerformActionMethod(commerceCatalog -> {
            block2: {
                try {
                    indexableActionableDynamicQuery.addDocuments(new Document[]{this.getDocument(commerceCatalog)});
                }
                catch (PortalException portalException) {
                    if (!_log.isWarnEnabled()) break block2;
                    _log.warn((Object)("Unable to index commerce catalog " + commerceCatalog.getCommerceCatalogId()), (Throwable)portalException);
                }
            }
        });
        indexableActionableDynamicQuery.setSearchEngineId(this.getSearchEngineId());
        indexableActionableDynamicQuery.performActions();
    }
}

