/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.product.internal.search;

import com.liferay.commerce.product.model.CommerceChannel;
import com.liferay.commerce.product.service.CommerceChannelLocalService;
import com.liferay.portal.kernel.dao.orm.IndexableActionableDynamicQuery;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.search.BaseIndexer;
import com.liferay.portal.kernel.search.BooleanClauseOccur;
import com.liferay.portal.kernel.search.BooleanQuery;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.IndexWriterHelper;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.Summary;
import com.liferay.portal.kernel.search.filter.BooleanFilter;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.Locale;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(enabled=false, immediate=true, service={Indexer.class})
public class CommerceChannelIndexer
extends BaseIndexer<CommerceChannel> {
    public static final String CLASS_NAME = CommerceChannel.class.getName();
    private static final Log _log = LogFactoryUtil.getLog(CommerceChannelIndexer.class);
    @Reference
    private CommerceChannelLocalService _commerceChannelLocalService;
    @Reference
    private IndexWriterHelper _indexWriterHelper;

    public CommerceChannelIndexer() {
        this.setDefaultSelectedFieldNames(new String[]{"entryClassName", "entryClassPK", "uid"});
        this.setFilterSearch(true);
        this.setPermissionAware(true);
    }

    public String getClassName() {
        return CLASS_NAME;
    }

    public void postProcessContextBooleanFilter(BooleanFilter contextBooleanFilter, SearchContext searchContext) throws Exception {
        String channelName;
        contextBooleanFilter.addRequiredTerm("companyId", searchContext.getCompanyId());
        String channelId = GetterUtil.getString((Object)searchContext.getAttribute("entryClassPK"));
        if (!Validator.isBlank((String)channelId)) {
            contextBooleanFilter.addTerm("entryClassPK", channelId, BooleanClauseOccur.MUST);
        }
        if (!Validator.isBlank((String)(channelName = GetterUtil.getString((Object)searchContext.getAttribute("name"))))) {
            contextBooleanFilter.addTerm("name", channelName, BooleanClauseOccur.MUST);
        }
    }

    public void postProcessSearchQuery(BooleanQuery searchQuery, BooleanFilter fullQueryBooleanFilter, SearchContext searchContext) throws Exception {
        this.addSearchTerm(searchQuery, searchContext, "entryClassPK", false);
        this.addSearchTerm(searchQuery, searchContext, "name", false);
    }

    protected void doDelete(CommerceChannel commerceChannel) throws Exception {
        this.deleteDocument(commerceChannel.getCompanyId(), commerceChannel.getCommerceChannelId());
    }

    protected Document doGetDocument(CommerceChannel commerceChannel) throws Exception {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Indexing commerce channel " + commerceChannel));
        }
        Document document = this.getBaseModelDocument(CLASS_NAME, (BaseModel)commerceChannel);
        document.addKeyword("name", commerceChannel.getName());
        Group group = this._commerceChannelLocalService.getCommerceChannelGroup(commerceChannel.getCommerceChannelId());
        document.addKeyword("commerceChannelGroupId", group.getGroupId());
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Document " + commerceChannel + " indexed successfully"));
        }
        return document;
    }

    protected Summary doGetSummary(Document document, Locale locale, String snippet, PortletRequest portletRequest, PortletResponse portletResponse) {
        Summary summary = this.createSummary(document, "entryClassPK", "name");
        summary.setMaxContentLength(200);
        return summary;
    }

    protected void doReindex(CommerceChannel commerceChannel) throws Exception {
        this._indexWriterHelper.updateDocument(this.getSearchEngineId(), commerceChannel.getCompanyId(), this.getDocument(commerceChannel), this.isCommitImmediately());
    }

    protected void doReindex(String className, long classPK) throws Exception {
        this.doReindex(this._commerceChannelLocalService.getCommerceChannel(classPK));
    }

    protected void doReindex(String[] ids) throws Exception {
        long companyId = GetterUtil.getLong((String)ids[0]);
        this.reindexCommerceChannels(companyId);
    }

    protected void reindexCommerceChannels(long companyId) throws PortalException {
        IndexableActionableDynamicQuery indexableActionableDynamicQuery = this._commerceChannelLocalService.getIndexableActionableDynamicQuery();
        indexableActionableDynamicQuery.setCompanyId(companyId);
        indexableActionableDynamicQuery.setPerformActionMethod(commerceChannel -> {
            block2: {
                try {
                    indexableActionableDynamicQuery.addDocuments(new Document[]{this.getDocument(commerceChannel)});
                }
                catch (PortalException portalException) {
                    if (!_log.isWarnEnabled()) break block2;
                    _log.warn((Object)("Unable to index commerce channel " + commerceChannel.getCommerceChannelId()), (Throwable)portalException);
                }
            }
        });
        indexableActionableDynamicQuery.setSearchEngineId(this.getSearchEngineId());
        indexableActionableDynamicQuery.performActions();
    }
}

