/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.product.internal.type;

import com.liferay.commerce.product.internal.type.comparator.CPTypeServiceWrapperDisplayOrderComparator;
import com.liferay.commerce.product.type.CPType;
import com.liferay.commerce.product.type.CPTypeServicesTracker;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerCustomizerFactory;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMap;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMapFactory;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

@Component(enabled=false, immediate=true, service={CPTypeServicesTracker.class})
public class CPTypeServicesTrackerImpl
implements CPTypeServicesTracker {
    private static final Log _log = LogFactoryUtil.getLog(CPTypeServicesTrackerImpl.class);
    private ServiceTrackerMap<String, ServiceTrackerCustomizerFactory.ServiceWrapper<CPType>> _cpTypeServiceTrackerMap;
    private final Comparator<ServiceTrackerCustomizerFactory.ServiceWrapper<CPType>> _cpTypeServiceWrapperDisplayOrderComparator = new CPTypeServiceWrapperDisplayOrderComparator();

    public CPType getCPType(String name) {
        if (Validator.isNull((String)name)) {
            return null;
        }
        ServiceTrackerCustomizerFactory.ServiceWrapper cpTypeServiceWrapper = (ServiceTrackerCustomizerFactory.ServiceWrapper)this._cpTypeServiceTrackerMap.getService((Object)name);
        if (cpTypeServiceWrapper == null) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("No commerce product type registered with name " + name));
            }
            return null;
        }
        return (CPType)cpTypeServiceWrapper.getService();
    }

    public Set<String> getCPTypeNames() {
        return this._cpTypeServiceTrackerMap.keySet();
    }

    public List<CPType> getCPTypes() {
        ArrayList<Object> cpTypes = new ArrayList<Object>();
        List cpTypeServiceWrappers = ListUtil.fromCollection((Collection)this._cpTypeServiceTrackerMap.values());
        Collections.sort(cpTypeServiceWrappers, this._cpTypeServiceWrapperDisplayOrderComparator);
        for (ServiceTrackerCustomizerFactory.ServiceWrapper cpTypeServiceWrapper : cpTypeServiceWrappers) {
            cpTypes.add(cpTypeServiceWrapper.getService());
        }
        return Collections.unmodifiableList(cpTypes);
    }

    @Activate
    protected void activate(BundleContext bundleContext) {
        this._cpTypeServiceTrackerMap = ServiceTrackerMapFactory.openSingleValueMap((BundleContext)bundleContext, CPType.class, (String)"commerce.product.type.name", (ServiceTrackerCustomizer)ServiceTrackerCustomizerFactory.serviceWrapper((BundleContext)bundleContext));
    }

    @Deactivate
    protected void deactivate() {
        this._cpTypeServiceTrackerMap.close();
    }
}

