/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.product.internal.upgrade.base;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.dao.db.IndexMetadata;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.util.ObjectValuePair;
import com.liferay.portal.kernel.util.StringUtil;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.util.List;
import java.util.Objects;

public abstract class BaseCommerceProductServiceUpgradeProcess
extends UpgradeProcess {
    private static final Log _log = LogFactoryUtil.getLog(BaseCommerceProductServiceUpgradeProcess.class);

    protected void addColumn(Class<?> entityClass, String tableName, String columnName, String columnType) throws Exception {
        if (_log.isInfoEnabled()) {
            _log.info((Object)String.format("Adding column %s to table %s", columnName, tableName));
        }
        if (!this.hasColumn(tableName, columnName)) {
            this.alter(entityClass, new UpgradeProcess.Alterable[]{new UpgradeProcess.AlterTableAddColumn((UpgradeProcess)this, columnName + " " + columnType)});
        } else if (_log.isInfoEnabled()) {
            _log.info((Object)String.format("Column %s already exists on table %s", columnName, tableName));
        }
    }

    protected void addIndexes(String tableName) throws Exception {
        Class<?> clazz = ((Object)((Object)this)).getClass();
        List indexesSQL = this.getIndexesSQL(clazz.getClassLoader(), tableName);
        for (ObjectValuePair indexSQL : indexesSQL) {
            IndexMetadata indexMetadata = (IndexMetadata)indexSQL.getValue();
            if (_log.isInfoEnabled()) {
                _log.info((Object)String.format("Adding index %s to table %s", indexMetadata.getIndexName(), tableName));
            }
            if (!this.tableHasIndex(tableName, indexMetadata.getIndexName())) {
                this.runSQL(indexMetadata.getCreateSQL(null));
                continue;
            }
            if (!_log.isInfoEnabled()) continue;
            _log.info((Object)String.format("Index %s already exists on table %s", indexMetadata.getIndexName(), tableName));
        }
    }

    protected void dropColumn(String tableName, String columnName) throws Exception {
        if (_log.isInfoEnabled()) {
            _log.info((Object)String.format("Dropping column %s from table %s", columnName, tableName));
        }
        if (this.hasColumn(tableName, columnName)) {
            this.runSQL(StringBundler.concat((String[])new String[]{"alter table ", tableName, " drop column ", columnName}));
        } else if (_log.isInfoEnabled()) {
            _log.info((Object)String.format("Column %s already does not exist on table %s", columnName, tableName));
        }
    }

    protected void renameColumn(Class<?> tableClass, String tableName, String oldColumnName, String newColumnName) throws Exception {
        String newColumnSimpleName;
        if (_log.isInfoEnabled()) {
            _log.info((Object)String.format("Renaming column %s to table %s", oldColumnName, tableName));
        }
        if (!this.hasColumn(tableName, newColumnSimpleName = StringUtil.extractFirst((String)newColumnName, (String)" "))) {
            this.alter(tableClass, new UpgradeProcess.Alterable[]{new UpgradeProcess.AlterColumnName((UpgradeProcess)this, oldColumnName, newColumnName)});
        } else if (_log.isInfoEnabled()) {
            _log.info((Object)String.format("Column %s already exists on table %s", newColumnName, tableName));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean tableHasIndex(String tableName, String indexName) throws Exception {
        DatabaseMetaData metadata = this.connection.getMetaData();
        try (ResultSet resultSet = metadata.getIndexInfo(null, null, tableName, false, false);){
            String curIndexName;
            do {
                if (!resultSet.next()) return false;
            } while (!Objects.equals(indexName, curIndexName = resultSet.getString("index_name")));
            boolean bl = true;
            return bl;
        }
        catch (Exception exception) {
            if (!_log.isDebugEnabled()) return false;
            _log.debug((Object)exception, (Throwable)exception);
        }
        return false;
    }
}

