/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.product.internal.upgrade.v1_10_1;

import com.liferay.commerce.account.configuration.CommerceAccountGroupServiceConfiguration;
import com.liferay.commerce.product.model.CommerceChannel;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.module.configuration.ConfigurationProvider;
import com.liferay.portal.kernel.service.ClassNameLocalService;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.settings.GroupServiceSettingsLocator;
import com.liferay.portal.kernel.settings.ModifiableSettings;
import com.liferay.portal.kernel.settings.Settings;
import com.liferay.portal.kernel.settings.SettingsFactory;
import com.liferay.portal.kernel.settings.SettingsLocator;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class CommerceSiteTypeUpgradeProcess
extends UpgradeProcess {
    private final ClassNameLocalService _classNameLocalService;
    private final ConfigurationProvider _configurationProvider;
    private final GroupLocalService _groupLocalService;
    private final SettingsFactory _settingsFactory;

    public CommerceSiteTypeUpgradeProcess(ClassNameLocalService classNameLocalService, GroupLocalService groupLocalService, ConfigurationProvider configurationProvider, SettingsFactory settingsFactory) {
        this._classNameLocalService = classNameLocalService;
        this._groupLocalService = groupLocalService;
        this._configurationProvider = configurationProvider;
        this._settingsFactory = settingsFactory;
    }

    protected void doUpgrade() throws Exception {
        try (Statement s = this.connection.createStatement();
             ResultSet resultSet = s.executeQuery("select siteGroupId from CommerceChannel");){
            while (resultSet.next()) {
                long groupId = resultSet.getLong("siteGroupId");
                Settings settings = this._settingsFactory.getSettings((SettingsLocator)new GroupServiceSettingsLocator(this._getCommerceChannelGroupIdBySiteGroupId(groupId), "com.liferay.commerce.account"));
                ModifiableSettings modifiableSettings = settings.getModifiableSettings();
                CommerceAccountGroupServiceConfiguration commerceAccountGroupServiceConfiguration = (CommerceAccountGroupServiceConfiguration)this._configurationProvider.getConfiguration(CommerceAccountGroupServiceConfiguration.class, (SettingsLocator)new GroupServiceSettingsLocator(groupId, "com.liferay.commerce.account"));
                modifiableSettings.setValue("commerceSiteType", String.valueOf(commerceAccountGroupServiceConfiguration.commerceSiteType()));
                modifiableSettings.store();
            }
        }
    }

    private long _getCommerceChannelGroupIdBySiteGroupId(long groupId) throws SQLException {
        long companyId = 0L;
        long commerceChannelId = 0L;
        String sql = "select * from CommerceChannel where siteGroupId = " + groupId;
        try (Statement s = this.connection.createStatement();){
            s.setMaxRows(1);
            try (ResultSet resultSet = s.executeQuery(sql);){
                if (resultSet.next()) {
                    companyId = resultSet.getLong("companyId");
                    commerceChannelId = resultSet.getLong("commerceChannelId");
                }
            }
        }
        long classNameId = this._classNameLocalService.getClassNameId(CommerceChannel.class.getName());
        Group group = this._groupLocalService.fetchGroup(companyId, classNameId, commerceChannelId);
        if (group != null) {
            return group.getGroupId();
        }
        return 0L;
    }
}

