/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.product.internal.upgrade.v1_11_0;

import com.liferay.asset.kernel.model.AssetCategory;
import com.liferay.asset.kernel.service.AssetCategoryLocalService;
import com.liferay.portal.kernel.dao.jdbc.AutoBatchPreparedStatementUtil;
import com.liferay.portal.kernel.exception.NoSuchClassNameException;
import com.liferay.portal.kernel.exception.NoSuchGroupException;
import com.liferay.portal.kernel.service.ClassNameLocalService;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;

public class CPAttachmentFileEntryGroupUpgradeProcess
extends UpgradeProcess {
    private final AssetCategoryLocalService _assetCategoryLocalService;
    private final ClassNameLocalService _classNameLocalService;

    public CPAttachmentFileEntryGroupUpgradeProcess(AssetCategoryLocalService assetCategoryLocalService, ClassNameLocalService classNameLocalService) {
        this._assetCategoryLocalService = assetCategoryLocalService;
        this._classNameLocalService = classNameLocalService;
    }

    protected void doUpgrade() throws Exception {
        try (Statement s = this.connection.createStatement();
             ResultSet resultSet = s.executeQuery("select classNameId, classPK from CPAttachmentFileEntry");){
            long cpDefinitionClassNameId = this._getCPDefinitionClassNameId();
            long assetCategoryClassNameId = this._classNameLocalService.getClassNameId(AssetCategory.class);
            String updateCPAttachmentFileEntrySQL = "update CPAttachmentFileEntry set groupId = ? where classNameId = ? and classPK = ?";
            try (PreparedStatement preparedStatement = AutoBatchPreparedStatementUtil.concurrentAutoBatch((Connection)this.connection, (String)updateCPAttachmentFileEntrySQL);){
                while (resultSet.next()) {
                    long groupId;
                    long classNameId = resultSet.getLong("classNameId");
                    long classPK = resultSet.getLong("classPK");
                    if (classNameId == assetCategoryClassNameId) {
                        AssetCategory assetCategory = this._assetCategoryLocalService.getAssetCategory(classPK);
                        groupId = assetCategory.getGroupId();
                    } else {
                        if (classNameId != cpDefinitionClassNameId) continue;
                        groupId = this._getGroupIdFromCPDefinition(classPK);
                    }
                    preparedStatement.setLong(1, groupId);
                    preparedStatement.setLong(2, classNameId);
                    preparedStatement.setLong(3, classPK);
                    preparedStatement.addBatch();
                }
                preparedStatement.executeBatch();
            }
        }
    }

    private long _getCPDefinitionClassNameId() throws Exception {
        try (Statement s = this.connection.createStatement();
             ResultSet resultSet = s.executeQuery("select classNameId from ClassName_ where value = 'com.liferay.commerce.product.model.CPDefinition'");){
            if (resultSet.next()) {
                long l = resultSet.getLong("classNameId");
                return l;
            }
        }
        throw new NoSuchClassNameException();
    }

    private long _getGroupIdFromCPDefinition(long cpDefinitionId) throws Exception {
        try (Statement s = this.connection.createStatement();
             ResultSet resultSet = s.executeQuery("select groupId from CPDefinition where cpDefinitionId = " + cpDefinitionId);){
            if (resultSet.next()) {
                long l = resultSet.getLong("groupId");
                return l;
            }
        }
        throw new NoSuchGroupException();
    }
}

