/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.product.internal.upgrade.v1_11_1;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.service.LayoutLocalService;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import java.sql.ResultSet;
import java.sql.Statement;

public class CPDisplayLayoutUpgradeProcess
extends UpgradeProcess {
    private static final String _DELETE_CPDISPLAYLAYOUT_SQL = "DELETE FROM CPDisplayLayout where CPDisplayLayoutId = '%s'";
    private static final String _SELECT_CPDISPLAYLAYOUT_SQL = "SELECT CPDisplayLayoutId, groupId, layoutUuid FROM CPDisplayLayout";
    private static final Log _log = LogFactoryUtil.getLog(CPDisplayLayoutUpgradeProcess.class);
    private final LayoutLocalService _layoutLocalService;

    public CPDisplayLayoutUpgradeProcess(LayoutLocalService layoutLocalService) {
        this._layoutLocalService = layoutLocalService;
    }

    protected void doUpgrade() throws Exception {
        try (Statement s = this.connection.createStatement(1003, 1007);
             ResultSet resultSet = s.executeQuery(_SELECT_CPDISPLAYLAYOUT_SQL);){
            while (resultSet.next()) {
                String layoutUuid;
                long groupId = resultSet.getLong("groupId");
                Layout layout = this._fetchLayout(groupId, layoutUuid = resultSet.getString("layoutUuid"));
                if (layout != null) continue;
                long cpDisplayLayoutId = resultSet.getLong("CPDisplayLayoutId");
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)String.format("Removing CPDisplayLayout entry id: %s", cpDisplayLayoutId));
                }
                this.runSQL(String.format(_DELETE_CPDISPLAYLAYOUT_SQL, cpDisplayLayoutId));
            }
        }
    }

    private Layout _fetchLayout(long groupId, String layoutUuid) {
        Layout layout = this._layoutLocalService.fetchLayout(layoutUuid, groupId, false);
        if (layout != null) {
            return layout;
        }
        return this._layoutLocalService.fetchLayout(layoutUuid, groupId, true);
    }
}

