/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.product.internal.upgrade.v1_3_0;

import com.liferay.commerce.product.internal.upgrade.base.BaseCommerceProductServiceUpgradeProcess;
import com.liferay.commerce.product.model.impl.CPDefinitionLinkModelImpl;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.util.StringUtil;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;

public class CPDefinitionLinkUpgradeProcess
extends BaseCommerceProductServiceUpgradeProcess {
    private static final Log _log = LogFactoryUtil.getLog(CPDefinitionLinkUpgradeProcess.class);

    protected void doUpgrade() throws Exception {
        this.addColumn(CPDefinitionLinkModelImpl.class, "CPDefinitionLink", "CProductId", "LONG");
        this._renameColumn(CPDefinitionLinkModelImpl.class, "CPDefinitionLink", "CPDefinitionId1", "CPDefinitionId LONG");
        try (PreparedStatement preparedStatement = this.connection.prepareStatement("update CPDefinitionLink set CProductId = ? where CPDefinitionId2 = ?");
             Statement s = this.connection.createStatement();
             ResultSet resultSet = s.executeQuery("select * from CPDefinitionLink");){
            while (resultSet.next()) {
                long cpDefinitionId2 = resultSet.getLong("CPDefinitionId2");
                preparedStatement.setLong(1, this._getCProductId(cpDefinitionId2));
                preparedStatement.setLong(2, cpDefinitionId2);
                preparedStatement.execute();
            }
        }
        this.dropColumn("CPDefinitionLink", "CPDefinitionId2");
    }

    private long _getCProductId(long cpDefinitionId) throws Exception {
        try (Statement s = this.connection.createStatement();
             ResultSet resultSet = s.executeQuery("select CProductId from CPDefinition where CPDefinitionId = " + cpDefinitionId);){
            if (resultSet.next()) {
                long l = resultSet.getLong("CProductId");
                return l;
            }
        }
        return 0L;
    }

    private void _renameColumn(Class<?> tableClass, String tableName, String oldColumnName, String newColumnName) throws Exception {
        String newColumnSimpleName;
        if (_log.isInfoEnabled()) {
            _log.info((Object)String.format("Renaming column %s to %s in table %s", oldColumnName, newColumnName, tableName));
        }
        if (!this.hasColumn(tableName, newColumnSimpleName = StringUtil.extractFirst((String)newColumnName, (String)" "))) {
            this.alter(tableClass, new UpgradeProcess.Alterable[]{new UpgradeProcess.AlterColumnName((UpgradeProcess)this, oldColumnName, newColumnName)});
        } else if (_log.isInfoEnabled()) {
            _log.info((Object)String.format("Column %s already exists on table %s", newColumnName, tableName));
        }
    }
}

