/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.product.internal.upgrade.v1_3_0;

import com.liferay.commerce.product.model.CPDefinition;
import com.liferay.commerce.product.model.CProduct;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.dao.jdbc.AutoBatchPreparedStatementUtil;
import com.liferay.portal.kernel.service.ClassNameLocalService;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;

public class CPFriendlyURLEntryUpgradeProcess
extends UpgradeProcess {
    private final ClassNameLocalService _classNameLocalService;

    public CPFriendlyURLEntryUpgradeProcess(ClassNameLocalService classNameLocalService) {
        this._classNameLocalService = classNameLocalService;
    }

    protected void doUpgrade() throws Exception {
        if (!this.hasTable("CPFriendlyURLEntry")) {
            return;
        }
        long cpDefinitionClassNameId = this._classNameLocalService.getClassNameId(CPDefinition.class);
        long cProductClassNameId = this._classNameLocalService.getClassNameId(CProduct.class);
        String updateCPFriendlyURLSQL = "update CPFriendlyURLEntry set classNameId = ?, classPK = ? where classNameId = ? and classPK = ?";
        String selectCPFriendlyURLEntrySQL = StringBundler.concat((Object[])new Object[]{"select distinct classPK, CProductId from CPFriendlyURLEntry ", "inner join CPDefinition on CPDefinition.CPDefinitionId = ", "CPFriendlyURLEntry.classPK where classNameId = ", cpDefinitionClassNameId});
        try (PreparedStatement preparedStatement = AutoBatchPreparedStatementUtil.concurrentAutoBatch((Connection)this.connection, (String)updateCPFriendlyURLSQL);
             Statement s = this.connection.createStatement();
             ResultSet resultSet = s.executeQuery(selectCPFriendlyURLEntrySQL);){
            while (resultSet.next()) {
                long classPK = resultSet.getLong("classPK");
                long cProductId = resultSet.getLong("CProductId");
                preparedStatement.setLong(1, cProductClassNameId);
                preparedStatement.setLong(2, cProductId);
                preparedStatement.setLong(3, cpDefinitionClassNameId);
                preparedStatement.setLong(4, classPK);
                preparedStatement.addBatch();
            }
            preparedStatement.executeBatch();
        }
    }
}

