/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.product.internal.upgrade.v1_3_0;

import com.liferay.commerce.product.internal.upgrade.base.BaseCommerceProductServiceUpgradeProcess;
import com.liferay.commerce.product.model.impl.CPDefinitionModelImpl;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.dao.jdbc.AutoBatchPreparedStatementUtil;
import com.liferay.portal.kernel.uuid.PortalUUIDUtil;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;

public class CProductUpgradeProcess
extends BaseCommerceProductServiceUpgradeProcess {
    protected void doUpgrade() throws Exception {
        if (!this.hasTable("CProduct")) {
            this.runSQL("create table CProduct (uuid_ VARCHAR(75) null,externalReferenceCode VARCHAR(75) null,CProductId LONG not null primary key,groupId LONG,companyId LONG,userId LONG,userName VARCHAR(75) null,createDate DATE null,modifiedDate DATE null,publishedCPDefinitionId LONG,latestVersion INTEGER)");
        }
        this.addColumn(CPDefinitionModelImpl.class, "CPDefinition", "CProductId", "LONG");
        this.addColumn(CPDefinitionModelImpl.class, "CPDefinition", "version", "INTEGER");
        String insertCProductSQL = StringBundler.concat((String[])new String[]{"insert into CProduct (uuid_, CProductId, groupId, companyId, ", "userId, userName, createDate, modifiedDate, ", "publishedCPDefinitionId, latestVersion) values (?, ?, ?, ?, ?, ", "?, ?, ?, ?, 1)"});
        String updateCPDefinitionSQL = "update CPDefinition set CProductId = ?, version = 1 where CPDefinitionId = ?";
        try (PreparedStatement preparedStatement1 = AutoBatchPreparedStatementUtil.concurrentAutoBatch((Connection)this.connection, (String)insertCProductSQL);
             PreparedStatement preparedStatement2 = AutoBatchPreparedStatementUtil.concurrentAutoBatch((Connection)this.connection, (String)updateCPDefinitionSQL);
             Statement s = this.connection.createStatement(1003, 1007);
             ResultSet resultSet = s.executeQuery("select cpDefinitionId, groupId, companyId, userId, userName from CPDefinition");){
            while (resultSet.next()) {
                String uuid = PortalUUIDUtil.generate();
                long cProductId = this.increment();
                long groupId = resultSet.getLong("groupId");
                long companyId = resultSet.getLong("companyId");
                long userId = resultSet.getLong("userId");
                String userName = resultSet.getString("userName");
                long cpDefinitionId = resultSet.getLong("CPDefinitionId");
                preparedStatement1.setString(1, uuid);
                preparedStatement1.setLong(2, cProductId);
                preparedStatement1.setLong(3, groupId);
                preparedStatement1.setLong(4, companyId);
                preparedStatement1.setLong(5, userId);
                preparedStatement1.setString(6, userName);
                Date date = new Date(System.currentTimeMillis());
                preparedStatement1.setDate(7, date);
                preparedStatement1.setDate(8, date);
                preparedStatement1.setLong(9, cpDefinitionId);
                preparedStatement1.addBatch();
                preparedStatement2.setLong(1, cProductId);
                preparedStatement2.setLong(2, cpDefinitionId);
                preparedStatement2.addBatch();
            }
            preparedStatement1.executeBatch();
            preparedStatement2.executeBatch();
        }
    }
}

