/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.product.internal.upgrade.v1_6_0;

import com.liferay.commerce.product.model.CPDefinition;
import com.liferay.commerce.product.model.CommerceCatalog;
import com.liferay.commerce.product.model.CommerceChannel;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.dao.jdbc.AutoBatchPreparedStatementUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.service.ClassNameLocalService;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;

public class CommerceCatalogUpgradeProcess
extends UpgradeProcess {
    private final ClassNameLocalService _classNameLocalService;
    private final GroupLocalService _groupLocalService;

    public CommerceCatalogUpgradeProcess(ClassNameLocalService classNameLocalService, GroupLocalService groupLocalService) {
        this._classNameLocalService = classNameLocalService;
        this._groupLocalService = groupLocalService;
    }

    protected void doUpgrade() throws Exception {
        if (!this.hasTable("CommerceChannel")) {
            this.runSQL("create table CommerceChannel (externalReferenceCode VARCHAR(75) null,commerceChannelId LONG not null primary key,companyId LONG,userId LONG,userName VARCHAR(75) null,createDate DATE null,modifiedDate DATE null,siteGroupId LONG,name VARCHAR(75) null,type_ VARCHAR(75) null,typeSettings VARCHAR(75) null,commerceCurrencyCode VARCHAR(75) null,priceDisplayType VARCHAR(75) null,discountsTargetNetPrice BOOLEAN)");
        }
        if (!this.hasTable("CommerceChannelRel")) {
            this.runSQL("create table CommerceChannelRel (commerceChannelRelId LONG not null primary key,companyId LONG,userId LONG,userName VARCHAR(75) null,createDate DATE null,modifiedDate DATE null,classNameId LONG,classPK LONG,commerceChannelId LONG)");
        }
        if (!this.hasTable("CommerceCatalog")) {
            this.runSQL("create table CommerceCatalog (externalReferenceCode VARCHAR(75) null,commerceCatalogId LONG not null primary key,companyId LONG,userId LONG,userName VARCHAR(75) null,createDate DATE null,modifiedDate DATE null,name VARCHAR(75) null,commerceCurrencyCode VARCHAR(75) null,catalogDefaultLanguageId VARCHAR(75) null,system_ BOOLEAN)");
        }
        String insertCommerceCatalogSQL = StringBundler.concat((String[])new String[]{"insert into CommerceCatalog (commerceCatalogId, companyId, ", "userId, userName, createDate, modifiedDate, name, ", "catalogDefaultLanguageId) values (?, ?, ?, ?, ?, ?, ?, ?)"});
        String insertCommerceChannelSQL = StringBundler.concat((String[])new String[]{"insert into CommerceChannel (commerceChannelId, companyId, ", "userId, userName, createDate, modifiedDate, name, siteGroupId, ", "type_) values (?, ?, ?, ?, ?, ?, ?, ?, ?)"});
        String insertCommerceChannelRelSQL = StringBundler.concat((String[])new String[]{"insert into CommerceChannelRel (commerceChannelRelId, companyId, ", "userId, userName, createDate, modifiedDate, classNameId, ", "classPK, commerceChannelId) values (?, ?, ?, ?, ?, ?, ?, ?, ?)"});
        try (PreparedStatement preparedStatement1 = AutoBatchPreparedStatementUtil.concurrentAutoBatch((Connection)this.connection, (String)insertCommerceCatalogSQL);
             PreparedStatement preparedStatement2 = AutoBatchPreparedStatementUtil.concurrentAutoBatch((Connection)this.connection, (String)insertCommerceChannelSQL);
             PreparedStatement preparedStatement3 = AutoBatchPreparedStatementUtil.concurrentAutoBatch((Connection)this.connection, (String)insertCommerceChannelRelSQL);
             Statement s1 = this.connection.createStatement(1003, 1007);
             ResultSet resultSet = s1.executeQuery("select distinct groupId, companyId, userId, userName, defaultLanguageId from CPDefinition");){
            long cpDefinitionClassNameId = this._classNameLocalService.getClassNameId(CPDefinition.class.getName());
            while (resultSet.next()) {
                long commerceCatalogId = this.increment();
                long commerceChannelId = this.increment();
                long groupId = resultSet.getLong("groupId");
                long companyId = resultSet.getLong("companyId");
                long userId = resultSet.getLong("userId");
                String userName = resultSet.getString("userName");
                Date date = new Date(System.currentTimeMillis());
                String defaultLanguageId = resultSet.getString("defaultLanguageId");
                Group siteGroup = this._groupLocalService.getGroup(groupId);
                preparedStatement1.setLong(1, commerceCatalogId);
                preparedStatement1.setLong(2, companyId);
                preparedStatement1.setLong(3, userId);
                preparedStatement1.setString(4, userName);
                preparedStatement1.setDate(5, date);
                preparedStatement1.setDate(6, date);
                preparedStatement1.setString(7, siteGroup.getName(defaultLanguageId));
                preparedStatement1.setString(8, defaultLanguageId);
                preparedStatement1.addBatch();
                preparedStatement2.setLong(1, commerceChannelId);
                preparedStatement2.setLong(2, companyId);
                preparedStatement2.setLong(3, userId);
                preparedStatement2.setString(4, userName);
                preparedStatement2.setDate(5, date);
                preparedStatement2.setDate(6, date);
                preparedStatement2.setString(7, siteGroup.getName(defaultLanguageId));
                preparedStatement2.setLong(8, siteGroup.getGroupId());
                preparedStatement2.setString(9, "site");
                preparedStatement2.addBatch();
                Group catalogGroup = this._groupLocalService.addGroup(userId, 0L, CommerceCatalog.class.getName(), commerceCatalogId, 0L, siteGroup.getNameMap(), null, 3, false, 0, null, false, true, null);
                Group channelGroup = this._groupLocalService.addGroup(userId, 0L, CommerceChannel.class.getName(), commerceChannelId, 0L, siteGroup.getNameMap(), null, 3, false, 0, null, false, true, null);
                String updateTableGroupIdSQL = "update %s set groupId = %s where groupId = %s";
                this.runSQL(String.format(updateTableGroupIdSQL, "CPDefinition", catalogGroup.getGroupId(), siteGroup.getGroupId()));
                Statement s2 = this.connection.createStatement(1003, 1007);
                ResultSet cpDefinitionsResultSet = s2.executeQuery("select distinct cpDefinitionId from CPDefinition where groupId = " + catalogGroup.getGroupId());
                while (cpDefinitionsResultSet.next()) {
                    long commerceChannelRelId = this.increment();
                    preparedStatement3.setLong(1, commerceChannelRelId);
                    preparedStatement3.setLong(2, companyId);
                    preparedStatement3.setLong(3, userId);
                    preparedStatement3.setString(4, userName);
                    preparedStatement3.setDate(5, date);
                    preparedStatement3.setDate(6, date);
                    preparedStatement3.setLong(7, cpDefinitionClassNameId);
                    preparedStatement3.setLong(8, cpDefinitionsResultSet.getLong("cpDefinitionId"));
                    preparedStatement3.setLong(9, commerceChannelId);
                    preparedStatement3.addBatch();
                }
                this.runSQL(String.format(updateTableGroupIdSQL, "AssetEntry", catalogGroup.getGroupId(), siteGroup.getGroupId()));
                this.runSQL(String.format(updateTableGroupIdSQL, "AssetCategory", catalogGroup.getGroupId(), siteGroup.getGroupId()));
                this.runSQL(String.format(updateTableGroupIdSQL, "CPAttachmentFileEntry", catalogGroup.getGroupId(), siteGroup.getGroupId()));
                this.runSQL(String.format(updateTableGroupIdSQL, "CPDefinitionLink", catalogGroup.getGroupId(), siteGroup.getGroupId()));
                this.runSQL(String.format(updateTableGroupIdSQL, "CPDefinitionOptionRel", catalogGroup.getGroupId(), siteGroup.getGroupId()));
                this.runSQL(String.format(updateTableGroupIdSQL, "CPDefinitionOptionValueRel", catalogGroup.getGroupId(), siteGroup.getGroupId()));
                this.runSQL(String.format(updateTableGroupIdSQL, "CPDSpecificationOptionValue", catalogGroup.getGroupId(), siteGroup.getGroupId()));
                this.runSQL(String.format(updateTableGroupIdSQL, "CPDisplayLayout", catalogGroup.getGroupId(), siteGroup.getGroupId()));
                this.runSQL(String.format(updateTableGroupIdSQL, "CPInstance", catalogGroup.getGroupId(), siteGroup.getGroupId()));
                this.runSQL(String.format(updateTableGroupIdSQL, "CProduct", catalogGroup.getGroupId(), siteGroup.getGroupId()));
                if (this.hasTable("CPFriendlyURLEntry")) {
                    this.runSQL(String.format(updateTableGroupIdSQL, "CPFriendlyURLEntry", 0L, siteGroup.getGroupId()));
                }
                this.runSQL(String.format(updateTableGroupIdSQL, "CommerceOrder", channelGroup.getGroupId(), siteGroup.getGroupId()));
                this.runSQL(String.format(updateTableGroupIdSQL, "CommerceShipment", channelGroup.getGroupId(), siteGroup.getGroupId()));
                this.runSQL(String.format(updateTableGroupIdSQL, "CommercePriceList", catalogGroup.getGroupId(), siteGroup.getGroupId()));
            }
            preparedStatement1.executeBatch();
            preparedStatement2.executeBatch();
            preparedStatement3.executeBatch();
        }
    }
}

