/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.product.internal.upgrade.v1_8_0;

import com.liferay.commerce.product.model.CPDefinition;
import com.liferay.portal.kernel.dao.jdbc.AutoBatchPreparedStatementUtil;
import com.liferay.portal.kernel.service.ClassNameLocalService;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;

public class CPAttachmentFileEntryUpgradeProcess
extends UpgradeProcess {
    private final ClassNameLocalService _classNameLocalService;

    public CPAttachmentFileEntryUpgradeProcess(ClassNameLocalService classNameLocalService) {
        this._classNameLocalService = classNameLocalService;
    }

    protected void doUpgrade() throws Exception {
        long classNameId = this._classNameLocalService.getClassNameId(CPDefinition.class);
        String updateCPAttachmentFileEntrySQL = "update CPAttachmentFileEntry set groupId = ? where classNameId = ? and classPK = ?";
        String selectCPDefinitionSQL = "select CPDefinition.groupId, CPDefinitionId from CPDefinition inner join CPAttachmentFileEntry on CPDefinitionId = classPK";
        try (PreparedStatement preparedStatement = AutoBatchPreparedStatementUtil.concurrentAutoBatch((Connection)this.connection, (String)updateCPAttachmentFileEntrySQL);
             Statement s = this.connection.createStatement();
             ResultSet resultSet = s.executeQuery(selectCPDefinitionSQL);){
            while (resultSet.next()) {
                preparedStatement.setLong(1, resultSet.getLong("groupId"));
                preparedStatement.setLong(2, classNameId);
                preparedStatement.setLong(3, resultSet.getLong("CPDefinitionId"));
                preparedStatement.addBatch();
            }
            preparedStatement.executeBatch();
        }
    }
}

