/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.product.internal.upgrade.v2_0_0;

import com.liferay.commerce.product.internal.upgrade.base.BaseCommerceProductServiceUpgradeProcess;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.dao.jdbc.AutoBatchPreparedStatementUtil;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONException;
import com.liferay.portal.kernel.json.JSONFactory;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.uuid.PortalUUID;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;

public class CPInstanceOptionValueRelUpgradeProcess
extends BaseCommerceProductServiceUpgradeProcess {
    private static final String _SELECT_CP_DEFINITION_OPTION_REL_ID = "select CPDefinitionOptionRelId from CPDefinitionOptionRel where CPDefinitionId = ? and key_ = ?";
    private static final String _SELECT_CP_DEFINITION_OPTION_VALUE_REL_ID = "select CPDefinitionOptionValueRelId from CPDefinitionOptionValueRel where CPDefinitionOptionRelId = ? and key_ = ?";
    private PreparedStatement _cpDefinitionOptionRelIdPreparedStatement;
    private PreparedStatement _cpDefinitionOptionValueRelIdPreparedStatement;
    private final JSONFactory _jsonFactory;
    private final PortalUUID _portalUUID;

    public CPInstanceOptionValueRelUpgradeProcess(JSONFactory jsonFactory, PortalUUID portalUUID) {
        this._jsonFactory = jsonFactory;
        this._portalUUID = portalUUID;
    }

    protected void doUpgrade() throws Exception {
        if (!this.hasTable("CPInstanceOptionValueRel")) {
            this.runSQL("create table CPInstanceOptionValueRel (uuid_ VARCHAR(75) null,CPInstanceOptionValueRelId LONG not null primary key,groupId LONG,companyId LONG,userId LONG,userName VARCHAR(75) null,createDate DATE null,modifiedDate DATE null,CPDefinitionOptionRelId LONG,CPDefinitionOptionValueRelId LONG,CPInstanceId LONG)");
        }
        this._importContentFromCPInstanceJsonField();
        this.dropColumn("CPInstance", "json");
    }

    private PreparedStatement _cpDefinitionOptionRelIdPreparedStatement() throws SQLException {
        if (this._cpDefinitionOptionRelIdPreparedStatement != null) {
            return this._cpDefinitionOptionRelIdPreparedStatement;
        }
        this._cpDefinitionOptionRelIdPreparedStatement = this.connection.prepareStatement(_SELECT_CP_DEFINITION_OPTION_REL_ID);
        return this._cpDefinitionOptionRelIdPreparedStatement;
    }

    private PreparedStatement _cpDefinitionOptionValueRelIdPreparedStatement() throws SQLException {
        if (this._cpDefinitionOptionValueRelIdPreparedStatement != null) {
            return this._cpDefinitionOptionValueRelIdPreparedStatement;
        }
        this._cpDefinitionOptionValueRelIdPreparedStatement = this.connection.prepareStatement(_SELECT_CP_DEFINITION_OPTION_VALUE_REL_ID);
        return this._cpDefinitionOptionValueRelIdPreparedStatement;
    }

    private long _getCPDefinitionOptionRelId(long cpDefinitionId, String cpDefinitionOptionRelKey) throws SQLException {
        PreparedStatement preparedStatement = this._cpDefinitionOptionRelIdPreparedStatement();
        preparedStatement.setLong(1, cpDefinitionId);
        preparedStatement.setString(2, cpDefinitionOptionRelKey);
        try (ResultSet resultSet = preparedStatement.executeQuery();){
            if (resultSet.next()) {
                long l = resultSet.getLong("CPDefinitionOptionRelId");
                return l;
            }
        }
        return 0L;
    }

    private long _getCPDefinitionOptionValueRelId(long cpDefinitionOptionRelId, String cpDefinitionOptionValueKey) throws SQLException {
        PreparedStatement preparedStatement = this._cpDefinitionOptionValueRelIdPreparedStatement();
        preparedStatement.setLong(1, cpDefinitionOptionRelId);
        preparedStatement.setString(2, cpDefinitionOptionValueKey);
        try (ResultSet resultSet = preparedStatement.executeQuery();){
            if (resultSet.next()) {
                long l = resultSet.getLong("CPDefinitionOptionValueRelId");
                return l;
            }
        }
        return 0L;
    }

    private void _importContentFromCPInstanceJsonField() throws Exception {
        String insertCPInstanceOptionValueRelSQL = StringBundler.concat((String[])new String[]{"insert into CPInstanceOptionValueRel(uuid_, ", "CPInstanceOptionValueRelId, groupId, companyId, userId, ", "userName, createDate, modifiedDate, CPDefinitionOptionRelId, ", "CPDefinitionOptionValueRelId, CPInstanceId) values (?, ?, ?, ?, ", "?, ?, ?, ?, ?, ?, ?)"});
        try (PreparedStatement preparedStatement = AutoBatchPreparedStatementUtil.concurrentAutoBatch((Connection)this.connection, (String)insertCPInstanceOptionValueRelSQL);
             Statement s = this.connection.createStatement(1003, 1007);
             ResultSet resultSet = s.executeQuery("select CPInstanceId, groupId, companyId, userId, userName, CPDefinitionId, json from CPInstance");){
            while (resultSet.next()) {
                this._queueInsertCPInstanceOptionValueRelCommands(preparedStatement, resultSet);
            }
            preparedStatement.executeBatch();
        }
    }

    private boolean _isDuplicatedCPInstanceOption(Map<String, String> processedCPInstanceOptions, String cpDefinitionOptionRelKey, String cpDefinitionOptionValueKey) {
        String processedCPDefinitionOptionValueKey = processedCPInstanceOptions.get(cpDefinitionOptionRelKey);
        return processedCPDefinitionOptionValueKey != null && processedCPDefinitionOptionValueKey.equals(cpDefinitionOptionValueKey);
    }

    private void _queueInsertCPInstanceOptionValueRelCommands(PreparedStatement preparedStatement, ResultSet resultSet) throws JSONException, SQLException {
        long groupId = resultSet.getLong("groupId");
        long companyId = resultSet.getLong("companyId");
        long userId = resultSet.getLong("userId");
        String userName = resultSet.getString("userName");
        long cpInstanceId = resultSet.getLong("CPInstanceId");
        long cpDefinitionId = resultSet.getLong("CPDefinitionId");
        String json = resultSet.getString("json");
        HashMap<String, String> processedCPInstanceOptions = new HashMap<String, String>();
        JSONArray jsonArray = this._jsonFactory.createJSONArray(json);
        for (int i = 0; i < jsonArray.length(); ++i) {
            JSONObject jsonObject = jsonArray.getJSONObject(i);
            String cpDefinitionOptionRelKey = jsonObject.getString("key");
            long cpDefinitionOptionRelId = this._getCPDefinitionOptionRelId(cpDefinitionId, cpDefinitionOptionRelKey);
            JSONArray cpDefinitionOptionValueRelJSONArray = jsonObject.getJSONArray("value");
            for (int j = 0; j < cpDefinitionOptionValueRelJSONArray.length(); ++j) {
                String cpDefinitionOptionValueRelKey = cpDefinitionOptionValueRelJSONArray.getString(j);
                if (this._isDuplicatedCPInstanceOption(processedCPInstanceOptions, cpDefinitionOptionRelKey, cpDefinitionOptionValueRelKey)) continue;
                processedCPInstanceOptions.put(cpDefinitionOptionRelKey, cpDefinitionOptionValueRelKey);
                long cpDefinitionOptionValueRelId = this._getCPDefinitionOptionValueRelId(cpDefinitionOptionRelId, cpDefinitionOptionValueRelKey);
                String uuid = this._portalUUID.generate();
                long cpInstanceOptionValueRelId = this.increment();
                preparedStatement.setString(1, uuid);
                preparedStatement.setLong(2, cpInstanceOptionValueRelId);
                preparedStatement.setLong(3, groupId);
                preparedStatement.setLong(4, companyId);
                preparedStatement.setLong(5, userId);
                preparedStatement.setString(6, userName);
                Date date = new Date(System.currentTimeMillis());
                preparedStatement.setDate(7, date);
                preparedStatement.setDate(8, date);
                preparedStatement.setLong(9, cpDefinitionOptionRelId);
                preparedStatement.setLong(10, cpDefinitionOptionValueRelId);
                preparedStatement.setLong(11, cpInstanceId);
                preparedStatement.addBatch();
            }
        }
    }
}

