/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.product.internal.upgrade.v2_5_0;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.dao.jdbc.AutoBatchPreparedStatementUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;

public class FriendlyURLEntryUpgradeProcess
extends UpgradeProcess {
    private final GroupLocalService _groupLocalService;

    public FriendlyURLEntryUpgradeProcess(GroupLocalService groupLocalService) {
        this._groupLocalService = groupLocalService;
    }

    public void doUpgrade() throws Exception {
        if (!this.hasTable("CPFriendlyURLEntry")) {
            return;
        }
        String insertFriendlyUREntrySQL = StringBundler.concat((String[])new String[]{"insert into FriendlyURLEntry (mvccVersion, uuid_, ", "defaultLanguageId, friendlyURLEntryId, groupId, companyId, ", "createDate, modifiedDate, classNameId, classPK) values (?, ?, ?, ", "?, ?, ?, ?, ?, ?, ?)"});
        String insertFriendlyUREntryMappingSQL = StringBundler.concat((String[])new String[]{"insert into FriendlyURLEntryMapping (mvccVersion, ", "friendlyURLEntryMappingId, classNameId, classPK, ", "friendlyURLEntryId) values (?, ?, ?, ?, ?)"});
        String insertFriendlyUREntryLocalizationSQL = StringBundler.concat((String[])new String[]{"insert into FriendlyURLEntryLocalization (mvccVersion, ", "friendlyURLEntryLocalizationId, companyId, friendlyURLEntryId, ", "languageId, urlTitle, groupId, classNameId, classPK)", "values (?, ?, ?, ?, ?, ?, ?, ?, ?)"});
        String selectCPFriendlyURLEntrySQL = "select * from CPFriendlyURLEntry order by main desc";
        try (PreparedStatement preparedStatement1 = AutoBatchPreparedStatementUtil.concurrentAutoBatch((Connection)this.connection, (String)insertFriendlyUREntrySQL);
             PreparedStatement preparedStatement2 = AutoBatchPreparedStatementUtil.concurrentAutoBatch((Connection)this.connection, (String)insertFriendlyUREntryMappingSQL);
             PreparedStatement preparedStatement3 = this.connection.prepareStatement(insertFriendlyUREntryLocalizationSQL);
             Statement s1 = this.connection.createStatement();
             ResultSet resultSet = s1.executeQuery(selectCPFriendlyURLEntrySQL);){
            while (resultSet.next()) {
                long friendlyURLEntryLocalizationId;
                long classNameId = resultSet.getLong("classNameId");
                long classPK = resultSet.getLong("classPK");
                long companyId = resultSet.getLong("companyId");
                Date date = new Date(System.currentTimeMillis());
                Group group = this._groupLocalService.getCompanyGroup(companyId);
                String languageId = resultSet.getString("languageId");
                boolean main = resultSet.getBoolean("main");
                long friendlyURLEntryId = this._getFriendlyURLEntryId(classNameId, classPK);
                if (friendlyURLEntryId <= 0L) {
                    friendlyURLEntryId = this.increment();
                    preparedStatement1.setLong(1, 0L);
                    String uuid = resultSet.getString("uuid_");
                    preparedStatement1.setString(2, uuid);
                    preparedStatement1.setString(3, languageId);
                    preparedStatement1.setLong(4, friendlyURLEntryId);
                    preparedStatement1.setLong(5, group.getGroupId());
                    preparedStatement1.setLong(6, companyId);
                    preparedStatement1.setDate(7, date);
                    preparedStatement1.setDate(8, date);
                    preparedStatement1.setLong(9, classNameId);
                    preparedStatement1.setLong(10, classPK);
                    preparedStatement1.execute();
                }
                long friendlyURLEntryMappingId = this._getFriendlyURLEntryMappingId(classNameId, classPK);
                if (main && friendlyURLEntryMappingId <= 0L) {
                    friendlyURLEntryMappingId = this.increment();
                    preparedStatement2.setLong(1, 0L);
                    preparedStatement2.setLong(2, friendlyURLEntryMappingId);
                    preparedStatement2.setLong(3, classNameId);
                    preparedStatement2.setLong(4, classPK);
                    preparedStatement2.setLong(5, friendlyURLEntryId);
                    preparedStatement2.execute();
                }
                if ((friendlyURLEntryLocalizationId = this._getFriendlyURLEntryLocalizationId(languageId, classNameId, classPK)) > 0L) continue;
                friendlyURLEntryLocalizationId = this.increment();
                preparedStatement3.setLong(1, 0L);
                preparedStatement3.setLong(2, friendlyURLEntryLocalizationId);
                preparedStatement3.setLong(3, companyId);
                preparedStatement3.setLong(4, friendlyURLEntryId);
                preparedStatement3.setString(5, languageId);
                String urlTitle = resultSet.getString("urlTitle");
                urlTitle = this._getUniqueURLTitle(group.getGroupId(), classNameId, urlTitle);
                preparedStatement3.setString(6, urlTitle);
                preparedStatement3.setLong(7, group.getGroupId());
                preparedStatement3.setLong(8, classNameId);
                preparedStatement3.setLong(9, classPK);
                preparedStatement3.execute();
            }
        }
    }

    /*
     * Exception decompiling
     */
    private long _getFriendlyURLEntryId(long classNameId, long classPK) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    private long _getFriendlyURLEntryLocalizationId(String languageId, long classNameId, long classPK) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    private long _getFriendlyURLEntryMappingId(long classNameId, long classPK) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    private String _getUniqueURLTitle(long groupId, long classNameId, String urlTitle) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

