/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.product.internal.upgrade.v3_2_0;

import com.liferay.asset.kernel.model.AssetCategory;
import com.liferay.commerce.product.model.CProduct;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.dao.jdbc.AutoBatchPreparedStatementUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.service.ClassNameLocalService;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.List;

public class FriendlyURLEntryUpgradeProcess
extends UpgradeProcess {
    private final ClassNameLocalService _classNameLocalService;
    private final GroupLocalService _groupLocalService;

    public FriendlyURLEntryUpgradeProcess(ClassNameLocalService classNameLocalService, GroupLocalService groupLocalService) {
        this._classNameLocalService = classNameLocalService;
        this._groupLocalService = groupLocalService;
    }

    public void doUpgrade() throws Exception {
        if (!this.hasTable("FriendlyURLEntry")) {
            return;
        }
        long assetCategoryClassNameId = this._classNameLocalService.getClassNameId(AssetCategory.class);
        long cProductClassNameId = this._classNameLocalService.getClassNameId(CProduct.class);
        try (PreparedStatement preparedStatement1 = this.connection.prepareStatement(StringBundler.concat((Object[])new Object[]{"select * from FriendlyURLEntry where classNameId in (", assetCategoryClassNameId, ",", cProductClassNameId, ")"}));
             PreparedStatement preparedStatement2 = AutoBatchPreparedStatementUtil.concurrentAutoBatch((Connection)this.connection, (String)"update FriendlyURLEntry set groupId = ? where friendlyURLEntryId = ?");
             PreparedStatement preparedStatement3 = AutoBatchPreparedStatementUtil.concurrentAutoBatch((Connection)this.connection, (String)"update FriendlyURLEntryLocalization set groupId = ? where friendlyURLEntryId = ?");
             ResultSet resultSet = preparedStatement1.executeQuery();){
            while (resultSet.next()) {
                Group group;
                long companyId = resultSet.getLong("companyId");
                long groupId = resultSet.getLong("groupId");
                List groupIds = this._groupLocalService.getGroupIds(companyId, true);
                if (groupIds.contains(groupId) || (groupIds = this._groupLocalService.getGroupIds(companyId, false)).contains(groupId) || groupId == (group = this._groupLocalService.getCompanyGroup(companyId)).getGroupId()) continue;
                long friendlyURLEntryId = resultSet.getLong("friendlyURLEntryId");
                preparedStatement2.setLong(1, group.getGroupId());
                preparedStatement2.setLong(2, friendlyURLEntryId);
                preparedStatement2.execute();
                preparedStatement3.setLong(1, group.getGroupId());
                preparedStatement3.setLong(2, friendlyURLEntryId);
                preparedStatement3.execute();
            }
        }
    }
}

