/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.product.internal.url;

import com.liferay.commerce.product.configuration.CPFriendlyURLConfiguration;
import com.liferay.commerce.product.url.CPFriendlyURL;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.module.configuration.ConfigurationException;
import com.liferay.portal.kernel.module.configuration.ConfigurationProvider;
import com.liferay.portal.kernel.settings.CompanyServiceSettingsLocator;
import com.liferay.portal.kernel.settings.SettingsLocator;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(enabled=false, immediate=true, service={CPFriendlyURL.class})
public class CPFriendlyURLImpl
implements CPFriendlyURL {
    @Reference
    private ConfigurationProvider _configurationProvider;

    public String getAssetCategoryURLSeparator(long companyId) {
        CPFriendlyURLConfiguration cpURLConfiguration = this._getCPFriendlyURLConfiguration(companyId);
        return "/" + cpURLConfiguration.assetCategoryURLSeparator() + "/";
    }

    public String getProductURLSeparator(long companyId) {
        CPFriendlyURLConfiguration cpFriendlyURLConfiguration = this._getCPFriendlyURLConfiguration(companyId);
        return "/" + cpFriendlyURLConfiguration.productURLSeparator() + "/";
    }

    private CPFriendlyURLConfiguration _getCPFriendlyURLConfiguration(long companyId) {
        try {
            return (CPFriendlyURLConfiguration)this._configurationProvider.getConfiguration(CPFriendlyURLConfiguration.class, (SettingsLocator)new CompanyServiceSettingsLocator(companyId, "com.liferay.commerce.product.friendly.url", CPFriendlyURLConfiguration.class.getName()));
        }
        catch (ConfigurationException configurationException) {
            throw new SystemException((Throwable)configurationException);
        }
    }
}

