/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.product.internal.util;

import com.liferay.commerce.product.catalog.CPCatalogEntry;
import com.liferay.commerce.product.util.CPCompareHelper;
import com.liferay.commerce.product.util.CPDefinitionHelper;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.StringUtil;
import java.util.ArrayList;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(enabled=false, immediate=true, service={CPCompareHelper.class})
public class CPCompareHelperImpl
implements CPCompareHelper {
    private static final Log _log = LogFactoryUtil.getLog(CPCompareHelperImpl.class);
    @Reference
    private CPDefinitionHelper _cpDefinitionHelper;

    public List<CPCatalogEntry> getCPCatalogEntries(long groupId, long commerceAccountId, String cpDefinitionIdsCookieValue) throws PortalException {
        List<Long> cpDefinitionIds = this._getCpDefinitionIds(cpDefinitionIdsCookieValue);
        if (cpDefinitionIds.isEmpty()) {
            return new ArrayList<CPCatalogEntry>();
        }
        ArrayList<CPCatalogEntry> cpCatalogEntries = new ArrayList<CPCatalogEntry>();
        for (long cpDefinitionId : cpDefinitionIds) {
            CPCatalogEntry cpCatalogEntry = null;
            try {
                cpCatalogEntry = this._cpDefinitionHelper.getCPCatalogEntry(commerceAccountId, groupId, cpDefinitionId, LocaleUtil.getDefault());
            }
            catch (PortalException portalException) {
                if (!_log.isWarnEnabled()) continue;
                _log.warn((Object)portalException, (Throwable)portalException);
                continue;
            }
            if (cpCatalogEntry == null) continue;
            cpCatalogEntries.add(cpCatalogEntry);
        }
        return cpCatalogEntries;
    }

    public List<Long> getCPDefinitionIds(long groupId, long commerceAccountId, String cpDefinitionIdsCookieValue) {
        List<Long> cpDefinitionIds = this._getCpDefinitionIds(cpDefinitionIdsCookieValue);
        if (cpDefinitionIds.isEmpty()) {
            return new ArrayList<Long>();
        }
        ArrayList<Long> activeCPDefinitionIds = new ArrayList<Long>();
        for (long cpDefinitionId : cpDefinitionIds) {
            CPCatalogEntry cpCatalogEntry = null;
            try {
                cpCatalogEntry = this._cpDefinitionHelper.getCPCatalogEntry(commerceAccountId, groupId, cpDefinitionId, LocaleUtil.getDefault());
            }
            catch (PortalException portalException) {
                if (!_log.isWarnEnabled()) continue;
                _log.warn((Object)portalException, (Throwable)portalException);
                continue;
            }
            if (cpCatalogEntry == null) continue;
            activeCPDefinitionIds.add(cpDefinitionId);
        }
        return activeCPDefinitionIds;
    }

    public String getCPDefinitionIdsCookieKey(long commerceChannelGroupId) {
        return "COMMERCE_COMPARE_cpDefinitionIds_" + commerceChannelGroupId;
    }

    private List<Long> _getCpDefinitionIds(String cookieValue) {
        return ListUtil.fromArray((long[])StringUtil.split((String)cookieValue, (String)":", (long)-1L));
    }
}

