/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.product.internal.util;

import com.liferay.commerce.product.util.CPContentContributor;
import com.liferay.commerce.product.util.CPContentContributorRegistry;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerCustomizerFactory;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMap;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMapFactory;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

@Component(enabled=false, immediate=true, service={CPContentContributorRegistry.class})
public class CPContentContributorRegistryImpl
implements CPContentContributorRegistry {
    private static final Log _log = LogFactoryUtil.getLog(CPContentContributorRegistryImpl.class);
    private ServiceTrackerMap<String, ServiceTrackerCustomizerFactory.ServiceWrapper<CPContentContributor>> _serviceTrackerMap;

    public CPContentContributor getCPContentContributor(String key) {
        if (Validator.isNull((String)key)) {
            return null;
        }
        ServiceTrackerCustomizerFactory.ServiceWrapper cpContentContributorServiceWrapper = (ServiceTrackerCustomizerFactory.ServiceWrapper)this._serviceTrackerMap.getService((Object)key);
        if (cpContentContributorServiceWrapper == null) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("No commerce product content contributor registered with key " + key));
            }
            return null;
        }
        return (CPContentContributor)cpContentContributorServiceWrapper.getService();
    }

    public List<CPContentContributor> getCPContentContributors() {
        ArrayList<Object> cpContentContributors = new ArrayList<Object>();
        List cpContentContributorServiceWrappers = ListUtil.fromCollection((Collection)this._serviceTrackerMap.values());
        for (ServiceTrackerCustomizerFactory.ServiceWrapper cpContentContributorServiceWrapper : cpContentContributorServiceWrappers) {
            cpContentContributors.add(cpContentContributorServiceWrapper.getService());
        }
        return Collections.unmodifiableList(cpContentContributors);
    }

    @Activate
    protected void activate(BundleContext bundleContext) {
        this._serviceTrackerMap = ServiceTrackerMapFactory.openSingleValueMap((BundleContext)bundleContext, CPContentContributor.class, (String)"commerce.product.content.contributor.name", (ServiceTrackerCustomizer)ServiceTrackerCustomizerFactory.serviceWrapper((BundleContext)bundleContext));
    }

    @Deactivate
    protected void deactivate() {
        this._serviceTrackerMap.close();
    }
}

