/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.product.internal.util;

import com.liferay.commerce.product.catalog.CPCatalogEntry;
import com.liferay.commerce.product.catalog.CPQuery;
import com.liferay.commerce.product.data.source.CPDataSourceResult;
import com.liferay.commerce.product.internal.catalog.DatabaseCPCatalogEntryImpl;
import com.liferay.commerce.product.internal.catalog.IndexCPCatalogEntryImpl;
import com.liferay.commerce.product.internal.search.CPDefinitionSearcher;
import com.liferay.commerce.product.model.CPDefinition;
import com.liferay.commerce.product.model.CProduct;
import com.liferay.commerce.product.model.CommerceChannel;
import com.liferay.commerce.product.permission.CommerceProductViewPermission;
import com.liferay.commerce.product.service.CPDefinitionLocalService;
import com.liferay.commerce.product.service.CPInstanceLocalService;
import com.liferay.commerce.product.service.CProductLocalService;
import com.liferay.commerce.product.service.CommerceChannelLocalService;
import com.liferay.commerce.product.url.CPFriendlyURL;
import com.liferay.commerce.product.util.CPDefinitionHelper;
import com.liferay.friendly.url.model.FriendlyURLEntry;
import com.liferay.friendly.url.service.FriendlyURLEntryLocalService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.Hits;
import com.liferay.portal.kernel.search.QueryConfig;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.search.SortFactoryUtil;
import com.liferay.portal.kernel.security.permission.PermissionThreadLocal;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.LayoutLocalService;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.Validator;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Locale;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(enabled=false, immediate=true, service={CPDefinitionHelper.class})
public class CPDefinitionHelperImpl
implements CPDefinitionHelper {
    private static final Log _log = LogFactoryUtil.getLog(CPDefinitionHelperImpl.class);
    @Reference
    private CommerceChannelLocalService _commerceChannelLocalService;
    @Reference
    private CommerceProductViewPermission _commerceProductViewPermission;
    @Reference
    private CPDefinitionLocalService _cpDefinitionLocalService;
    @Reference
    private CPFriendlyURL _cpFriendlyURL;
    @Reference
    private CPInstanceLocalService _cpInstanceLocalService;
    @Reference
    private CProductLocalService _cProductLocalService;
    @Reference
    private FriendlyURLEntryLocalService _friendlyURLEntryLocalService;
    @Reference
    private GroupLocalService _groupLocalService;
    @Reference
    private LayoutLocalService _layoutLocalService;
    @Reference
    private Portal _portal;

    public CPCatalogEntry getCPCatalogEntry(Document document, Locale locale) {
        return new IndexCPCatalogEntryImpl(document, this._cpDefinitionLocalService, this._cpInstanceLocalService, locale);
    }

    public CPCatalogEntry getCPCatalogEntry(long commerceAccountId, long groupId, long cpDefinitionId, Locale locale) throws PortalException {
        this._commerceProductViewPermission.check(PermissionThreadLocal.getPermissionChecker(), commerceAccountId, groupId, cpDefinitionId);
        CPDefinition cpDefinition = this._cpDefinitionLocalService.getCPDefinition(cpDefinitionId);
        if (!cpDefinition.isApproved() || !cpDefinition.isPublished()) {
            return null;
        }
        return new DatabaseCPCatalogEntryImpl(cpDefinition, this._cpInstanceLocalService, locale);
    }

    public String getFriendlyURL(long cpDefinitionId, ThemeDisplay themeDisplay) throws PortalException {
        CPDefinition cpDefinition = this._cpDefinitionLocalService.getCPDefinition(cpDefinitionId);
        return this._getFriendlyURL(cpDefinition.getCProductId(), themeDisplay);
    }

    public CPDataSourceResult search(long groupId, SearchContext searchContext, CPQuery cpQuery, int start, int end) throws PortalException {
        Document[] documents;
        ArrayList<CPCatalogEntry> cpCatalogEntries = new ArrayList<CPCatalogEntry>();
        CPDefinitionSearcher cpDefinitionSearcher = this._getCPDefinitionSearcher(groupId, searchContext, cpQuery, start, end);
        Hits hits = cpDefinitionSearcher.search(searchContext);
        for (Document document : documents = hits.getDocs()) {
            cpCatalogEntries.add(this.getCPCatalogEntry(document, searchContext.getLocale()));
        }
        return new CPDataSourceResult(cpCatalogEntries, hits.getLength());
    }

    public long searchCount(long groupId, SearchContext searchContext, CPQuery cpQuery) throws PortalException {
        CPDefinitionSearcher cpDefinitionSearcher = this._getCPDefinitionSearcher(groupId, searchContext, cpQuery, 0, 0);
        return cpDefinitionSearcher.searchCount(searchContext);
    }

    private long _checkChannelGroupId(long groupId) {
        Group group = this._groupLocalService.fetchGroup(groupId);
        String className = group.getClassName();
        if (className.equals(CommerceChannel.class.getName())) {
            return groupId;
        }
        CommerceChannel commerceChannel = this._commerceChannelLocalService.fetchCommerceChannelBySiteGroupId(groupId);
        if (commerceChannel != null) {
            return commerceChannel.getGroupId();
        }
        return groupId;
    }

    private CPDefinitionSearcher _getCPDefinitionSearcher(long groupId, SearchContext searchContext, CPQuery cpQuery, int start, int end) {
        CPDefinitionSearcher cpDefinitionSearcher = new CPDefinitionSearcher(cpQuery);
        searchContext.setAttribute("published", (Serializable)Boolean.TRUE);
        searchContext.setAttribute("commerceChannelGroupId", (Serializable)Long.valueOf(this._checkChannelGroupId(groupId)));
        searchContext.setAttribute("secure", (Serializable)Boolean.TRUE);
        searchContext.setEnd(end);
        searchContext.setSorts(this._getSorts(cpQuery));
        searchContext.setStart(start);
        QueryConfig queryConfig = searchContext.getQueryConfig();
        queryConfig.setScoreEnabled(false);
        return cpDefinitionSearcher;
    }

    private String _getFriendlyURL(long cProductId, ThemeDisplay themeDisplay) throws PortalException {
        long plid;
        Group group;
        Layout layout;
        FriendlyURLEntry friendlyURLEntry;
        block12: {
            friendlyURLEntry = null;
            try {
                friendlyURLEntry = this._friendlyURLEntryLocalService.getMainFriendlyURLEntry(this._portal.getClassNameId(CProduct.class), cProductId);
            }
            catch (Exception exception) {
                if (_log.isInfoEnabled()) {
                    _log.info((Object)("No friendly URL found for " + cProductId), (Throwable)exception);
                }
                return "";
            }
            layout = null;
            group = themeDisplay.getScopeGroup();
            CProduct cProduct = this._cProductLocalService.getCProduct(cProductId);
            String layoutUuid = this._cpDefinitionLocalService.getLayoutUuid(group.getGroupId(), cProduct.getPublishedCPDefinitionId());
            if (Validator.isNotNull((String)layoutUuid)) {
                block11: {
                    try {
                        layout = this._layoutLocalService.getLayoutByUuidAndGroupId(layoutUuid, group.getGroupId(), true);
                    }
                    catch (PortalException portalException) {
                        if (!_log.isDebugEnabled()) break block11;
                        _log.debug((Object)portalException, (Throwable)portalException);
                    }
                }
                if (layout == null) {
                    try {
                        layout = this._layoutLocalService.getLayoutByUuidAndGroupId(layoutUuid, group.getGroupId(), false);
                    }
                    catch (PortalException portalException) {
                        if (!_log.isDebugEnabled()) break block12;
                        _log.debug((Object)portalException, (Throwable)portalException);
                    }
                }
            }
        }
        if (layout == null && (plid = this._portal.getPlidFromPortletId(group.getGroupId(), "com_liferay_commerce_product_content_web_internal_portlet_CPContentPortlet")) > 0L) {
            layout = this._layoutLocalService.getLayout(plid);
        }
        if (layout == null) {
            layout = themeDisplay.getLayout();
        }
        String currentSiteURL = this._portal.getGroupFriendlyURL(layout.getLayoutSet(), themeDisplay);
        String urlSeparator = this._cpFriendlyURL.getProductURLSeparator(themeDisplay.getCompanyId());
        String productFriendlyURL = currentSiteURL + urlSeparator + friendlyURLEntry.getUrlTitle(themeDisplay.getLanguageId());
        return this._portal.addPreservedParameters(themeDisplay, productFriendlyURL);
    }

    private String _getOrderByCol(String sortField) {
        if (sortField.equals("modifiedDate")) {
            sortField = "modified";
        }
        return sortField;
    }

    private Sort _getSort(String orderByType, String sortField) {
        return SortFactoryUtil.getSort(CPDefinition.class, (int)this._getSortType(sortField), (String)this._getOrderByCol(sortField), (String)orderByType);
    }

    private Sort[] _getSorts(CPQuery cpQuery) {
        Sort sort1 = this._getSort(cpQuery.getOrderByType1(), cpQuery.getOrderByCol1());
        Sort sort2 = this._getSort(cpQuery.getOrderByType2(), cpQuery.getOrderByCol2());
        return new Sort[]{sort1, sort2};
    }

    private int _getSortType(String fieldType) {
        int sortType = 3;
        if (fieldType.equals("createDate") || fieldType.equals("expirationDate") || fieldType.equals("publishDate") || fieldType.equals("modifiedDate")) {
            sortType = 6;
        } else if (fieldType.equals("priority") || fieldType.equals("basePrice")) {
            sortType = 7;
        }
        return sortType;
    }
}

