/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.product.internal.util;

import com.liferay.commerce.account.util.CommerceAccountHelper;
import com.liferay.commerce.media.CommerceMediaResolver;
import com.liferay.commerce.product.catalog.CPCatalogEntry;
import com.liferay.commerce.product.catalog.CPSku;
import com.liferay.commerce.product.exception.CPDefinitionIgnoreSKUCombinationsException;
import com.liferay.commerce.product.exception.NoSuchCPInstanceException;
import com.liferay.commerce.product.internal.catalog.CPSkuImpl;
import com.liferay.commerce.product.internal.util.comparator.CPDefinitionOptionRelComparator;
import com.liferay.commerce.product.model.CPAttachmentFileEntry;
import com.liferay.commerce.product.model.CPDefinition;
import com.liferay.commerce.product.model.CPDefinitionOptionRel;
import com.liferay.commerce.product.model.CPDefinitionOptionValueRel;
import com.liferay.commerce.product.model.CPInstance;
import com.liferay.commerce.product.model.CPInstanceOptionValueRel;
import com.liferay.commerce.product.permission.CommerceProductViewPermission;
import com.liferay.commerce.product.service.CPAttachmentFileEntryLocalService;
import com.liferay.commerce.product.service.CPDefinitionLocalService;
import com.liferay.commerce.product.service.CPDefinitionOptionRelLocalService;
import com.liferay.commerce.product.service.CPDefinitionOptionValueRelLocalService;
import com.liferay.commerce.product.service.CPInstanceLocalService;
import com.liferay.commerce.product.service.CPInstanceOptionValueRelLocalService;
import com.liferay.commerce.product.service.CommerceChannelLocalService;
import com.liferay.commerce.product.util.CPInstanceHelper;
import com.liferay.commerce.product.util.DDMFormValuesHelper;
import com.liferay.commerce.product.util.JsonHelper;
import com.liferay.commerce.product.util.comparator.CPDefinitionOptionValueRelPriorityComparator;
import com.liferay.dynamic.data.mapping.form.field.type.DDMFormFieldTypeServicesTracker;
import com.liferay.dynamic.data.mapping.form.renderer.DDMFormRenderer;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONFactory;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.security.permission.PermissionThreadLocal;
import com.liferay.portal.kernel.util.KeyValuePair;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.Validator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(enabled=false, immediate=true, service={CPInstanceHelper.class})
public class CPInstanceHelperImpl
implements CPInstanceHelper {
    @Reference
    private CommerceAccountHelper _commerceAccountHelper;
    @Reference
    private CommerceChannelLocalService _commerceChannelLocalService;
    @Reference
    private CommerceMediaResolver _commerceMediaResolver;
    @Reference
    private CommerceProductViewPermission _commerceProductViewPermission;
    @Reference
    private CPAttachmentFileEntryLocalService _cpAttachmentFileEntryLocalService;
    @Reference
    private CPDefinitionLocalService _cpDefinitionLocalService;
    @Reference
    private CPDefinitionOptionRelLocalService _cpDefinitionOptionRelLocalService;
    @Reference
    private CPDefinitionOptionValueRelLocalService _cpDefinitionOptionValueRelLocalService;
    @Reference
    private CPInstanceLocalService _cpInstanceLocalService;
    @Reference
    private CPInstanceOptionValueRelLocalService _cpInstanceOptionValueRelLocalService;
    @Reference
    private DDMFormFieldTypeServicesTracker _ddmFormFieldTypeServicesTracker;
    @Reference
    private DDMFormRenderer _ddmFormRenderer;
    @Reference
    private DDMFormValuesHelper _ddmFormValuesHelper;
    @Reference
    private JSONFactory _jsonFactory;
    @Reference
    private JsonHelper _jsonHelper;
    @Reference
    private Portal _portal;

    public CPInstance fetchCPInstance(long cpDefinitionId, String serializedDDMFormValues) throws PortalException {
        CPDefinition cpDefinition = this._cpDefinitionLocalService.getCPDefinition(cpDefinitionId);
        if (cpDefinition.isIgnoreSKUCombinations()) {
            return this.getDefaultCPInstance(cpDefinitionId);
        }
        if (this._jsonHelper.isEmpty(serializedDDMFormValues)) {
            return null;
        }
        return this._fetchCPInstanceBySKUContributors(cpDefinitionId, serializedDDMFormValues);
    }

    public List<CPDefinitionOptionValueRel> filterCPDefinitionOptionValueRels(long cpDefinitionOptionRelId, List<Long> skuCombinationCPDefinitionOptionValueRelIds) throws PortalException {
        List cpInstanceOptionValueRels = this._cpInstanceOptionValueRelLocalService.getCPDefinitionOptionRelCPInstanceOptionValueRels(cpDefinitionOptionRelId);
        ArrayList<CPDefinitionOptionValueRel> filtered = new ArrayList<CPDefinitionOptionValueRel>();
        for (CPInstanceOptionValueRel cpInstanceOptionValueRel : cpInstanceOptionValueRels) {
            CPDefinitionOptionValueRel cpDefinitionOptionValueRel;
            if (!this._hasCPInstanceCPDefinitionOptionValueRelIds(cpInstanceOptionValueRel.getCPInstanceId(), skuCombinationCPDefinitionOptionValueRelIds) || filtered.contains(cpDefinitionOptionValueRel = this._cpDefinitionOptionValueRelLocalService.getCPInstanceCPDefinitionOptionValueRel(cpDefinitionOptionRelId, cpInstanceOptionValueRel.getCPInstanceId()))) continue;
            filtered.add(cpDefinitionOptionValueRel);
        }
        Collections.sort(filtered);
        return filtered;
    }

    public List<CPAttachmentFileEntry> getCPAttachmentFileEntries(long commerceAccountId, long commerceChannelGroupId, long cpDefinitionId, String serializedDDMFormValues, int type) throws Exception {
        return this.getCPAttachmentFileEntries(commerceAccountId, commerceChannelGroupId, cpDefinitionId, serializedDDMFormValues, type, -1, -1);
    }

    public List<CPAttachmentFileEntry> getCPAttachmentFileEntries(long commerceAccountId, long commerceChannelGroupId, long cpDefinitionId, String serializedDDMFormValues, int type, int start, int end) throws Exception {
        this._commerceProductViewPermission.check(PermissionThreadLocal.getPermissionChecker(), commerceAccountId, commerceChannelGroupId, cpDefinitionId);
        return this._cpAttachmentFileEntryLocalService.getCPAttachmentFileEntries(cpDefinitionId, serializedDDMFormValues, type, start, end);
    }

    public Map<CPDefinitionOptionRel, List<CPDefinitionOptionValueRel>> getCPDefinitionOptionRelsMap(long cpDefinitionId, boolean skuContributor, boolean publicStore) {
        List cpDefinitionOptionRels = skuContributor ? this._cpDefinitionOptionRelLocalService.getCPDefinitionOptionRels(cpDefinitionId, true) : this._cpDefinitionOptionRelLocalService.getCPDefinitionOptionRels(cpDefinitionId);
        if (cpDefinitionOptionRels.isEmpty()) {
            return Collections.emptyMap();
        }
        TreeMap<CPDefinitionOptionRel, List<CPDefinitionOptionValueRel>> cpDefinitionOptionRelsMap = new TreeMap<CPDefinitionOptionRel, List<CPDefinitionOptionValueRel>>(new CPDefinitionOptionRelComparator());
        for (CPDefinitionOptionRel cpDefinitionOptionRel : cpDefinitionOptionRels) {
            if (cpDefinitionOptionRel.isSkuContributor() && publicStore) {
                cpDefinitionOptionRelsMap.put(cpDefinitionOptionRel, this.getCPInstanceCPDefinitionOptionValueRels(cpDefinitionId, cpDefinitionOptionRel.getCPDefinitionOptionRelId()));
                continue;
            }
            cpDefinitionOptionRelsMap.put(cpDefinitionOptionRel, cpDefinitionOptionRel.getCPDefinitionOptionValueRels());
        }
        return cpDefinitionOptionRelsMap;
    }

    public Map<CPDefinitionOptionRel, List<CPDefinitionOptionValueRel>> getCPDefinitionOptionRelsMap(long cpDefinitionId, String json) throws PortalException {
        HashMap<CPDefinitionOptionRel, List<CPDefinitionOptionValueRel>> cpDefinitionOptionRelListMap = new HashMap<CPDefinitionOptionRel, List<CPDefinitionOptionValueRel>>();
        if (Validator.isNull((String)json)) {
            return cpDefinitionOptionRelListMap;
        }
        JSONArray jsonArray = this._jsonFactory.createJSONArray(json);
        for (int i = 0; i < jsonArray.length(); ++i) {
            JSONObject jsonObject = jsonArray.getJSONObject(i);
            CPDefinitionOptionRel cpDefinitionOptionRel = this._cpDefinitionOptionRelLocalService.fetchCPDefinitionOptionRelByKey(cpDefinitionId, jsonObject.getString("key"));
            if (cpDefinitionOptionRel == null) continue;
            JSONArray valueJSONArray = jsonObject.getJSONArray("value");
            for (int j = 0; j < valueJSONArray.length(); ++j) {
                CPDefinitionOptionValueRel cpDefinitionOptionValueRel = this._cpDefinitionOptionValueRelLocalService.fetchCPDefinitionOptionValueRel(cpDefinitionOptionRel.getCPDefinitionOptionRelId(), valueJSONArray.getString(j));
                if (cpDefinitionOptionValueRel == null) continue;
                ArrayList<CPDefinitionOptionValueRel> cpDefinitionOptionValueRels = (ArrayList<CPDefinitionOptionValueRel>)cpDefinitionOptionRelListMap.get(cpDefinitionOptionRel);
                if (cpDefinitionOptionValueRels == null) {
                    cpDefinitionOptionValueRels = new ArrayList<CPDefinitionOptionValueRel>();
                    cpDefinitionOptionRelListMap.put(cpDefinitionOptionRel, cpDefinitionOptionValueRels);
                }
                cpDefinitionOptionValueRels.add(cpDefinitionOptionValueRel);
            }
        }
        return cpDefinitionOptionRelListMap;
    }

    public Map<CPDefinitionOptionRel, List<CPDefinitionOptionValueRel>> getCPInstanceCPDefinitionOptionRelsMap(long cpInstanceId) throws PortalException {
        List cpInstanceCPInstanceOptionValueRels = this._cpInstanceOptionValueRelLocalService.getCPInstanceCPInstanceOptionValueRels(cpInstanceId);
        if (cpInstanceCPInstanceOptionValueRels.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<CPDefinitionOptionRel, List<CPDefinitionOptionValueRel>> cpDefinitionOptionRelsMap = new HashMap<CPDefinitionOptionRel, List<CPDefinitionOptionValueRel>>();
        for (CPInstanceOptionValueRel cpInstanceCPInstanceOptionValueRel : cpInstanceCPInstanceOptionValueRels) {
            CPDefinitionOptionRel cpDefinitionOptionRel = this._cpDefinitionOptionRelLocalService.getCPDefinitionOptionRel(cpInstanceCPInstanceOptionValueRel.getCPDefinitionOptionRelId());
            ArrayList<CPDefinitionOptionValueRel> cpDefinitionOptionValueRels = (ArrayList<CPDefinitionOptionValueRel>)cpDefinitionOptionRelsMap.get(cpDefinitionOptionRel);
            if (cpDefinitionOptionValueRels == null) {
                cpDefinitionOptionValueRels = new ArrayList<CPDefinitionOptionValueRel>();
                cpDefinitionOptionRelsMap.put(cpDefinitionOptionRel, cpDefinitionOptionValueRels);
            }
            cpDefinitionOptionValueRels.add(this._cpDefinitionOptionValueRelLocalService.getCPDefinitionOptionValueRel(cpInstanceCPInstanceOptionValueRel.getCPDefinitionOptionValueRelId()));
        }
        return cpDefinitionOptionRelsMap;
    }

    public List<CPDefinitionOptionValueRel> getCPInstanceCPDefinitionOptionValueRels(long cpDefinitionId, long cpDefinitionOptionRelId) {
        List cpDefinitionCPInstanceOptionValueRels = this._cpInstanceOptionValueRelLocalService.getCPDefinitionCPInstanceOptionValueRels(cpDefinitionId);
        ArrayList<CPDefinitionOptionValueRel> cpDefinitionOptionValueRels = new ArrayList<CPDefinitionOptionValueRel>();
        for (CPInstanceOptionValueRel cpInstanceOptionValueRel : cpDefinitionCPInstanceOptionValueRels) {
            CPDefinitionOptionValueRel cpDefinitionOptionValueRel;
            if (cpDefinitionOptionRelId != cpInstanceOptionValueRel.getCPDefinitionOptionRelId() || (cpDefinitionOptionValueRel = this._cpDefinitionOptionValueRelLocalService.fetchCPDefinitionOptionValueRel(cpInstanceOptionValueRel.getCPDefinitionOptionValueRelId())) == null || cpDefinitionOptionValueRels.contains(cpDefinitionOptionValueRel)) continue;
            cpDefinitionOptionValueRels.add(cpDefinitionOptionValueRel);
        }
        Collections.sort(cpDefinitionOptionValueRels, new CPDefinitionOptionValueRelPriorityComparator(true));
        return cpDefinitionOptionValueRels;
    }

    public List<CPInstanceOptionValueRel> getCPInstanceCPInstanceOptionValueRels(long cpInstanceId) {
        return this._cpInstanceOptionValueRelLocalService.getCPInstanceCPInstanceOptionValueRels(cpInstanceId);
    }

    public String getCPInstanceThumbnailSrc(long cpInstanceId) throws Exception {
        CPInstance cpInstance = this._cpInstanceLocalService.fetchCPInstance(cpInstanceId);
        if (cpInstance == null) {
            return "";
        }
        Map cpDefinitionOptionRelKeysCPDefinitionOptionValueRelKeys = this._cpDefinitionOptionRelLocalService.getCPDefinitionOptionRelKeysCPDefinitionOptionValueRelKeys(cpInstanceId);
        JSONArray keyValuesJSONArray = this._jsonHelper.toJSONArray(cpDefinitionOptionRelKeysCPDefinitionOptionValueRelKeys);
        List cpAttachmentFileEntries = this._cpAttachmentFileEntryLocalService.getCPAttachmentFileEntries(cpInstance.getCPDefinitionId(), keyValuesJSONArray.toString(), 0, 0, 1);
        if (cpAttachmentFileEntries.isEmpty()) {
            CPDefinition cpDefinition = cpInstance.getCPDefinition();
            return cpDefinition.getDefaultImageThumbnailSrc();
        }
        CPAttachmentFileEntry cpAttachmentFileEntry = (CPAttachmentFileEntry)cpAttachmentFileEntries.get(0);
        return this._commerceMediaResolver.getThumbnailURL(-1L, cpAttachmentFileEntry.getCPAttachmentFileEntryId());
    }

    public CPInstance getDefaultCPInstance(long cpDefinitionId) throws PortalException {
        CPDefinition cpDefinition = this._cpDefinitionLocalService.getCPDefinition(cpDefinitionId);
        if (!cpDefinition.isIgnoreSKUCombinations()) {
            throw new CPDefinitionIgnoreSKUCombinationsException("Unable to get default CP instance if SKU combination present");
        }
        List approvedCPInstances = this._cpInstanceLocalService.getCPDefinitionApprovedCPInstances(cpDefinitionId);
        if (approvedCPInstances.isEmpty()) {
            return null;
        }
        if (approvedCPInstances.size() > 1) {
            throw new NoSuchCPInstanceException("Unable to find default CP instance for CP definition ID " + cpDefinitionId);
        }
        return (CPInstance)approvedCPInstances.get(0);
    }

    public CPSku getDefaultCPSku(CPCatalogEntry cpCatalogEntry) throws Exception {
        if (!cpCatalogEntry.isIgnoreSKUCombinations()) {
            return null;
        }
        CPInstance cpInstance = this.getDefaultCPInstance(cpCatalogEntry.getCPDefinitionId());
        if (cpInstance == null) {
            return null;
        }
        return new CPSkuImpl(cpInstance);
    }

    public List<KeyValuePair> getKeyValuePairs(long cpDefinitionId, String json, Locale locale) throws PortalException {
        ArrayList<KeyValuePair> values = new ArrayList<KeyValuePair>();
        if (Validator.isNull((String)json)) {
            return values;
        }
        JSONArray jsonArray = this._jsonHelper.getJSONArray(json);
        for (int i = 0; i < jsonArray.length(); ++i) {
            JSONObject jsonObject = jsonArray.getJSONObject(i);
            String key = jsonObject.getString("key");
            CPDefinitionOptionRel cpDefinitionOptionRel = this._cpDefinitionOptionRelLocalService.fetchCPDefinitionOptionRelByKey(cpDefinitionId, key);
            if (cpDefinitionOptionRel == null) continue;
            JSONArray valueJSONArray = this._jsonHelper.getValueAsJSONArray("value", jsonObject);
            for (int j = 0; j < valueJSONArray.length(); ++j) {
                String value = valueJSONArray.getString(j);
                CPDefinitionOptionValueRel cpDefinitionOptionValueRel = this._cpDefinitionOptionValueRelLocalService.fetchCPDefinitionOptionValueRel(cpDefinitionOptionRel.getCPDefinitionOptionRelId(), value);
                value = cpDefinitionOptionValueRel != null ? cpDefinitionOptionValueRel.getName(locale) : valueJSONArray.getString(j);
                KeyValuePair keyValuePair = new KeyValuePair();
                keyValuePair.setKey(cpDefinitionOptionRel.getName(locale));
                keyValuePair.setValue(value);
                values.add(keyValuePair);
            }
        }
        return values;
    }

    private CPInstance _fetchCPInstanceBySKUContributors(long cpDefinitionId, String json) throws PortalException {
        int skuContributorCPDefinitionOptionRelsCount = this._cpDefinitionOptionRelLocalService.getCPDefinitionOptionRelsCount(cpDefinitionId, true);
        if (skuContributorCPDefinitionOptionRelsCount == 0) {
            return null;
        }
        Map cpDefinitionOptionRelCPDefinitionOptionValueRelIds = this._cpDefinitionOptionRelLocalService.getCPDefinitionOptionRelCPDefinitionOptionValueRelIds(cpDefinitionId, true, json);
        if (cpDefinitionOptionRelCPDefinitionOptionValueRelIds.isEmpty() || skuContributorCPDefinitionOptionRelsCount != cpDefinitionOptionRelCPDefinitionOptionValueRelIds.size()) {
            return null;
        }
        List cpDefinitionCPInstanceOptionValueRels = this._cpInstanceOptionValueRelLocalService.getCPDefinitionCPInstanceOptionValueRels(cpDefinitionId);
        HashMap<Long, Integer> cpInstanceCPInstanceOptionValueHits = new HashMap<Long, Integer>();
        for (CPInstanceOptionValueRel cpInstanceOptionValueRel : cpDefinitionCPInstanceOptionValueRels) {
            List cpDefinitionOptionValueIds;
            if (!cpDefinitionOptionRelCPDefinitionOptionValueRelIds.containsKey(cpInstanceOptionValueRel.getCPDefinitionOptionRelId()) || !(cpDefinitionOptionValueIds = (List)cpDefinitionOptionRelCPDefinitionOptionValueRelIds.get(cpInstanceOptionValueRel.getCPDefinitionOptionRelId())).contains(cpInstanceOptionValueRel.getCPDefinitionOptionValueRelId())) continue;
            if (cpInstanceCPInstanceOptionValueHits.containsKey(cpInstanceOptionValueRel.getCPInstanceId())) {
                int value = (Integer)cpInstanceCPInstanceOptionValueHits.get(cpInstanceOptionValueRel.getCPInstanceId());
                cpInstanceCPInstanceOptionValueHits.put(cpInstanceOptionValueRel.getCPInstanceId(), value + 1);
                continue;
            }
            cpInstanceCPInstanceOptionValueHits.put(cpInstanceOptionValueRel.getCPInstanceId(), 1);
        }
        if (cpInstanceCPInstanceOptionValueHits.isEmpty()) {
            return null;
        }
        long cpInstanceId = this._getTopId(cpInstanceCPInstanceOptionValueHits);
        if (skuContributorCPDefinitionOptionRelsCount != (Integer)cpInstanceCPInstanceOptionValueHits.get(cpInstanceId)) {
            return null;
        }
        return this._cpInstanceLocalService.getCPInstance(cpInstanceId);
    }

    private long _getTopId(Map<Long, Integer> idIdHits) {
        long topId = 0L;
        int topIdHits = 0;
        for (Map.Entry<Long, Integer> idIdHitsEntry : idIdHits.entrySet()) {
            if (topIdHits > idIdHitsEntry.getValue()) continue;
            topId = idIdHitsEntry.getKey();
            topIdHits = idIdHitsEntry.getValue();
        }
        return topId;
    }

    private boolean _hasCPInstanceCPDefinitionOptionValueRelIds(long cpInstanceId, List<Long> skuCombinationCPDefinitionOptionValueRelIds) {
        for (Long skuCombinationCPDefinitionOptionValueRelId : skuCombinationCPDefinitionOptionValueRelIds) {
            if (this._cpInstanceOptionValueRelLocalService.hasCPInstanceCPDefinitionOptionValueRel(skuCombinationCPDefinitionOptionValueRelId.longValue(), cpInstanceId)) continue;
            return false;
        }
        return true;
    }
}

