/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.product.internal.util;

import com.liferay.commerce.product.internal.util.comparator.CPSubscriptionTypeServiceWrapperOrderComparator;
import com.liferay.commerce.product.util.CPSubscriptionType;
import com.liferay.commerce.product.util.CPSubscriptionTypeRegistry;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerCustomizerFactory;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMap;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMapFactory;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

@Component(enabled=false, immediate=true, service={CPSubscriptionTypeRegistry.class})
public class CPSubscriptionTypeRegistryImpl
implements CPSubscriptionTypeRegistry {
    private static final Log _log = LogFactoryUtil.getLog(CPSubscriptionTypeRegistryImpl.class);
    private static final Comparator<ServiceTrackerCustomizerFactory.ServiceWrapper<CPSubscriptionType>> _cpSubscriptionTypeServiceWrapperOrderComparator = new CPSubscriptionTypeServiceWrapperOrderComparator();
    private ServiceTrackerMap<String, ServiceTrackerCustomizerFactory.ServiceWrapper<CPSubscriptionType>> _serviceTrackerMap;

    public CPSubscriptionType getCPSubscriptionType(String name) {
        if (Validator.isNull((String)name)) {
            return null;
        }
        ServiceTrackerCustomizerFactory.ServiceWrapper cpSubscriptionTypeServiceWrapper = (ServiceTrackerCustomizerFactory.ServiceWrapper)this._serviceTrackerMap.getService((Object)name);
        if (cpSubscriptionTypeServiceWrapper == null) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("No commerce product subscription type registered with name " + name));
            }
            return null;
        }
        return (CPSubscriptionType)cpSubscriptionTypeServiceWrapper.getService();
    }

    public List<CPSubscriptionType> getCPSubscriptionTypes() {
        ArrayList<Object> cpSubscriptionTypes = new ArrayList<Object>();
        List cpSubscriptionTypeServiceWrappers = ListUtil.fromCollection((Collection)this._serviceTrackerMap.values());
        Collections.sort(cpSubscriptionTypeServiceWrappers, _cpSubscriptionTypeServiceWrapperOrderComparator);
        for (ServiceTrackerCustomizerFactory.ServiceWrapper cpSubscriptionTypeServiceWrapper : cpSubscriptionTypeServiceWrappers) {
            cpSubscriptionTypes.add(cpSubscriptionTypeServiceWrapper.getService());
        }
        return Collections.unmodifiableList(cpSubscriptionTypes);
    }

    @Activate
    protected void activate(BundleContext bundleContext) {
        this._serviceTrackerMap = ServiceTrackerMapFactory.openSingleValueMap((BundleContext)bundleContext, CPSubscriptionType.class, (String)"commerce.product.subscription.type.name", (ServiceTrackerCustomizer)ServiceTrackerCustomizerFactory.serviceWrapper((BundleContext)bundleContext));
    }

    @Deactivate
    protected void deactivate() {
        this._serviceTrackerMap.close();
    }
}

