/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.product.internal.util;

import com.liferay.commerce.product.util.CPVersionContributor;
import com.liferay.commerce.product.util.CPVersionContributorRegistry;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerCustomizerFactory;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMap;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMapFactory;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

@Component(enabled=false, immediate=true, service={CPVersionContributorRegistry.class})
public class CPVersionContributorRegistryImpl
implements CPVersionContributorRegistry {
    private static final Log _log = LogFactoryUtil.getLog(CPVersionContributorRegistryImpl.class);
    private ServiceTrackerMap<String, ServiceTrackerCustomizerFactory.ServiceWrapper<CPVersionContributor>> _serviceTrackerMap;

    public CPVersionContributor getCPVersionContributor(String key) {
        if (Validator.isNull((String)key)) {
            return null;
        }
        ServiceTrackerCustomizerFactory.ServiceWrapper cpVersionContributorServiceWrapper = (ServiceTrackerCustomizerFactory.ServiceWrapper)this._serviceTrackerMap.getService((Object)key);
        if (cpVersionContributorServiceWrapper == null) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("No commerce product version contributor registered with key " + key));
            }
            return null;
        }
        return (CPVersionContributor)cpVersionContributorServiceWrapper.getService();
    }

    public List<CPVersionContributor> getCPVersionContributors() {
        Collection cpVersionContributorServiceWrappers = this._serviceTrackerMap.values();
        ArrayList<Object> cpVersionContributors = new ArrayList<Object>(cpVersionContributorServiceWrappers.size());
        for (ServiceTrackerCustomizerFactory.ServiceWrapper cpVersionContributorServiceWrapper : cpVersionContributorServiceWrappers) {
            cpVersionContributors.add(cpVersionContributorServiceWrapper.getService());
        }
        return Collections.unmodifiableList(cpVersionContributors);
    }

    @Activate
    protected void activate(BundleContext bundleContext) {
        this._serviceTrackerMap = ServiceTrackerMapFactory.openSingleValueMap((BundleContext)bundleContext, CPVersionContributor.class, (String)"commerce.product.content.contributor.name", (ServiceTrackerCustomizer)ServiceTrackerCustomizerFactory.serviceWrapper((BundleContext)bundleContext));
    }

    @Deactivate
    protected void deactivate() {
        this._serviceTrackerMap.close();
    }
}

