/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.product.internal.util;

import com.liferay.commerce.product.util.DDMFormValuesHelper;
import com.liferay.dynamic.data.mapping.model.DDMForm;
import com.liferay.dynamic.data.mapping.model.UnlocalizedValue;
import com.liferay.dynamic.data.mapping.model.Value;
import com.liferay.dynamic.data.mapping.storage.DDMFormFieldValue;
import com.liferay.dynamic.data.mapping.storage.DDMFormValues;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONFactory;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(enabled=false, immediate=true, service={DDMFormValuesHelper.class})
public class DDMFormValuesHelperImpl
implements DDMFormValuesHelper {
    @Reference
    private JSONFactory _jsonFactory;

    @Deprecated
    public String cleanDDMFormValuesJSON(String json) throws PortalException {
        return json;
    }

    public DDMFormValues deserialize(DDMForm ddmForm, String json, Locale locale) throws PortalException {
        DDMFormValues ddmFormValues = new DDMFormValues(ddmForm);
        ddmFormValues.addAvailableLocale(locale);
        ddmFormValues.setDefaultLocale(locale);
        ArrayList<DDMFormFieldValue> ddmFormFieldValues = new ArrayList<DDMFormFieldValue>();
        JSONArray jsonArray = this._jsonFactory.createJSONArray(json);
        for (int i = 0; i < jsonArray.length(); ++i) {
            DDMFormFieldValue ddmFormFieldValue = this.getDDMFormFieldValue(jsonArray.getJSONObject(i));
            if (ddmFormFieldValue == null || ddmFormFieldValue.getValue() == null) continue;
            ddmFormFieldValues.add(ddmFormFieldValue);
        }
        if (ddmFormFieldValues.isEmpty()) {
            return null;
        }
        ddmFormValues.setDDMFormFieldValues(ddmFormFieldValues);
        return ddmFormValues;
    }

    @Deprecated
    public boolean equals(String json1, String json2) throws PortalException {
        throw new UnsupportedOperationException();
    }

    public String serialize(DDMFormValues ddmFormValues) {
        JSONArray jsonArray = this._jsonFactory.createJSONArray();
        if (ddmFormValues == null) {
            return jsonArray.toString();
        }
        List ddmFormFieldValues = ddmFormValues.getDDMFormFieldValues();
        for (DDMFormFieldValue ddmFormFieldValue : ddmFormFieldValues) {
            JSONObject jsonObject = this._toJSONObject(ddmFormFieldValue);
            jsonArray.put(jsonObject);
        }
        return jsonArray.toString();
    }

    protected DDMFormFieldValue getDDMFormFieldValue(JSONObject jsonObject) {
        String key = jsonObject.getString("key");
        if (Validator.isNull((String)key)) {
            return null;
        }
        DDMFormFieldValue ddmFormFieldValue = new DDMFormFieldValue();
        ddmFormFieldValue.setName(key);
        JSONArray valueJSONArray = jsonObject.getJSONArray("value");
        if (valueJSONArray != null) {
            ddmFormFieldValue.setValue((Value)new UnlocalizedValue(valueJSONArray.toString()));
        } else {
            ddmFormFieldValue.setValue((Value)new UnlocalizedValue(""));
        }
        return ddmFormFieldValue;
    }

    private JSONObject _toJSONObject(DDMFormFieldValue ddmFormFieldValue) {
        JSONObject jsonObject = this._jsonFactory.createJSONObject();
        jsonObject.put("key", ddmFormFieldValue.getName());
        Value value = ddmFormFieldValue.getValue();
        String valueString = value.getString(LocaleUtil.ROOT);
        jsonObject.put("value", valueString);
        return jsonObject;
    }
}

