/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.product.internal.util;

import com.liferay.commerce.product.util.JsonHelper;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONException;
import com.liferay.portal.kernel.json.JSONFactory;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.util.Validator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(enabled=false, immediate=true, service={JsonHelper.class})
public class JsonHelperImpl
implements JsonHelper {
    @Reference
    private JSONFactory _jsonFactory;

    public String getFirstElementStringValue(String jsonArrayString) {
        if (!this.isArray(jsonArrayString)) {
            throw new IllegalArgumentException(String.format("%s is not a valid JSON array expression", jsonArrayString));
        }
        int start = jsonArrayString.indexOf("\"");
        if (start == -1) {
            throw new IndexOutOfBoundsException(String.format("%s JSON array has no first element", jsonArrayString));
        }
        return jsonArrayString.substring(start + 1, jsonArrayString.indexOf("\"", start + 1));
    }

    public JSONArray getJSONArray(String json) throws JSONException {
        if (this.isArray(json)) {
            return this._jsonFactory.createJSONArray(json);
        }
        JSONArray jsonArray = this._jsonFactory.createJSONArray();
        jsonArray.put(this._jsonFactory.createJSONObject(json));
        return jsonArray;
    }

    public JSONArray getValueAsJSONArray(String key, JSONObject jsonObject) {
        JSONArray valueJSONArray = jsonObject.getJSONArray(key);
        if (valueJSONArray != null) {
            return valueJSONArray;
        }
        valueJSONArray = this._jsonFactory.createJSONArray();
        String valueString = jsonObject.getString(key);
        if (valueString == null) {
            return valueJSONArray;
        }
        valueJSONArray.put(valueString);
        return valueJSONArray;
    }

    public boolean isArray(String json) {
        if (Validator.isNull((String)json)) {
            return false;
        }
        return json.startsWith("[") && json.endsWith("]");
    }

    public boolean isEmpty(String json) {
        return Validator.isNull((String)json) || Objects.equals(json, "[]") || Objects.equals(json, "{}");
    }

    public JSONArray toJSONArray(Map<String, List<String>> keyValues) {
        JSONArray jsonArray = this._jsonFactory.createJSONArray();
        for (Map.Entry<String, List<String>> keyValuesEntry : keyValues.entrySet()) {
            JSONObject arrayEntryJSONObject = this._jsonFactory.createJSONObject();
            arrayEntryJSONObject.put("key", keyValuesEntry.getKey());
            JSONArray valuesJSONArray = this._jsonFactory.createJSONArray();
            List<String> values = keyValuesEntry.getValue();
            for (String value : values) {
                valuesJSONArray.put(value);
            }
            arrayEntryJSONObject.put("value", valuesJSONArray);
            jsonArray.put(arrayEntryJSONObject);
        }
        return jsonArray;
    }
}

