/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.product.internal.util;

import com.liferay.commerce.product.model.CPDefinitionOptionRel;
import com.liferay.commerce.product.model.CPDefinitionOptionValueRel;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;

public class SKUCombinationsIterator
implements Iterator<CPDefinitionOptionValueRel[]> {
    private final int _combinationLength;
    private final CPDefinitionOptionValueRel[][] _cpDefinitionOptionValueRels;
    private final int[] _currentIndexes;
    private boolean _hasNext;
    private final int[] _maxIndexes;

    public SKUCombinationsIterator(Map<CPDefinitionOptionRel, CPDefinitionOptionValueRel[]> cpDefinitionOptionRelMap) {
        this._combinationLength = cpDefinitionOptionRelMap.size();
        this._cpDefinitionOptionValueRels = new CPDefinitionOptionValueRel[this._combinationLength][];
        this._currentIndexes = new int[this._combinationLength];
        this._maxIndexes = new int[this._combinationLength];
        if (this._combinationLength == 0) {
            this._hasNext = false;
            return;
        }
        this._hasNext = true;
        int valuesIndex = 0;
        ArrayList<CPDefinitionOptionRel> cpDefinitionOptionRels = new ArrayList<CPDefinitionOptionRel>(cpDefinitionOptionRelMap.keySet());
        for (CPDefinitionOptionRel cpDefinitionOptionRel : cpDefinitionOptionRels) {
            this._cpDefinitionOptionValueRels[valuesIndex++] = cpDefinitionOptionRelMap.get(cpDefinitionOptionRel);
        }
        for (int i = 0; i < this._combinationLength; ++i) {
            if (this._cpDefinitionOptionValueRels[i].length == 0) {
                this._hasNext = false;
                return;
            }
            this._currentIndexes[i] = 0;
            this._maxIndexes[i] = this._cpDefinitionOptionValueRels[i].length - 1;
        }
    }

    @Override
    public boolean hasNext() {
        return this._hasNext;
    }

    @Override
    public CPDefinitionOptionValueRel[] next() {
        if (!this._hasNext) {
            throw new NoSuchElementException("No more combinations are available");
        }
        CPDefinitionOptionValueRel[] combination = this._getCombinationByCurrentIndexes();
        this._nextIndexesCombination();
        return combination;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Remove operation is not supported");
    }

    private CPDefinitionOptionValueRel[] _getCombinationByCurrentIndexes() {
        CPDefinitionOptionValueRel[] combination = new CPDefinitionOptionValueRel[this._combinationLength];
        for (int i = 0; i < this._combinationLength; ++i) {
            combination[i] = this._cpDefinitionOptionValueRels[i][this._currentIndexes[i]];
        }
        return combination;
    }

    private void _nextIndexesCombination() {
        for (int i = this._combinationLength - 1; i >= 0; --i) {
            if (this._currentIndexes[i] < this._maxIndexes[i]) {
                int n = i;
                this._currentIndexes[n] = this._currentIndexes[n] + 1;
                return;
            }
            this._currentIndexes[i] = 0;
        }
        this._hasNext = false;
    }
}

