/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.product.service.impl;

import com.liferay.commerce.product.exception.CPAttachmentFileEntryDisplayDateException;
import com.liferay.commerce.product.exception.CPAttachmentFileEntryExpirationDateException;
import com.liferay.commerce.product.exception.DuplicateCPAttachmentFileEntryException;
import com.liferay.commerce.product.model.CPAttachmentFileEntry;
import com.liferay.commerce.product.model.CPDefinition;
import com.liferay.commerce.product.service.base.CPAttachmentFileEntryLocalServiceBaseImpl;
import com.liferay.commerce.product.util.JsonHelper;
import com.liferay.portal.kernel.dao.orm.QueryDefinition;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONFactory;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.ClassName;
import com.liferay.portal.kernel.model.Repository;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.portletfilerepository.PortletFileRepositoryUtil;
import com.liferay.portal.kernel.repository.capabilities.TemporaryFileEntriesCapability;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.repository.model.Folder;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.Hits;
import com.liferay.portal.kernel.search.Indexable;
import com.liferay.portal.kernel.search.IndexableType;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerRegistryUtil;
import com.liferay.portal.kernel.search.QueryConfig;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.search.SortFactoryUtil;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.systemevent.SystemEvent;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.TempFileEntryUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.workflow.WorkflowHandlerRegistryUtil;
import com.liferay.portal.spring.extender.service.ServiceReference;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;

public class CPAttachmentFileEntryLocalServiceImpl
extends CPAttachmentFileEntryLocalServiceBaseImpl {
    private static final Log _log = LogFactoryUtil.getLog(CPAttachmentFileEntryLocalServiceImpl.class);
    @ServiceReference(type=JSONFactory.class)
    private JSONFactory _jsonFactory;
    @ServiceReference(type=JsonHelper.class)
    private JsonHelper _jsonHelper;
    @ServiceReference(type=Portal.class)
    private Portal _portal;

    @Deprecated
    public CPAttachmentFileEntry addCPAttachmentFileEntry(long classNameId, long classPK, long fileEntryId, int displayDateMonth, int displayDateDay, int displayDateYear, int displayDateHour, int displayDateMinute, int expirationDateMonth, int expirationDateDay, int expirationDateYear, int expirationDateHour, int expirationDateMinute, boolean neverExpire, Map<Locale, String> titleMap, String json, double priority, int type, ServiceContext serviceContext) throws PortalException {
        return this.addCPAttachmentFileEntry(null, serviceContext.getUserId(), serviceContext.getScopeGroupId(), classNameId, classPK, fileEntryId, displayDateMonth, displayDateDay, displayDateYear, displayDateHour, displayDateMinute, expirationDateMonth, expirationDateDay, expirationDateYear, expirationDateHour, expirationDateMinute, neverExpire, titleMap, json, priority, type, serviceContext);
    }

    @Indexable(type=IndexableType.REINDEX)
    public CPAttachmentFileEntry addCPAttachmentFileEntry(String externalReferenceCode, long userId, long groupId, long classNameId, long classPK, long fileEntryId, int displayDateMonth, int displayDateDay, int displayDateYear, int displayDateHour, int displayDateMinute, int expirationDateMonth, int expirationDateDay, int expirationDateYear, int expirationDateHour, int expirationDateMinute, boolean neverExpire, Map<Locale, String> titleMap, String json, double priority, int type, ServiceContext serviceContext) throws PortalException {
        User user = this.userLocalService.getUser(userId);
        Date expirationDate = null;
        Date displayDate = PortalUtil.getDate((int)displayDateMonth, (int)displayDateDay, (int)displayDateYear, (int)displayDateHour, (int)displayDateMinute, (TimeZone)user.getTimeZone(), CPAttachmentFileEntryDisplayDateException.class);
        if (!neverExpire) {
            expirationDate = PortalUtil.getDate((int)expirationDateMonth, (int)expirationDateDay, (int)expirationDateYear, (int)expirationDateHour, (int)expirationDateMinute, (TimeZone)user.getTimeZone(), CPAttachmentFileEntryExpirationDateException.class);
        }
        if (expirationDate != null && (expirationDate.before(new Date()) || displayDate != null && expirationDate.before(displayDate))) {
            throw new CPAttachmentFileEntryExpirationDateException("Expiration date " + expirationDate + " is in the past");
        }
        long cpAttachmentFileEntryId = this.counterLocalService.increment();
        CPAttachmentFileEntry cpAttachmentFileEntry = this.cpAttachmentFileEntryPersistence.create(cpAttachmentFileEntryId);
        if (classNameId == this.classNameLocalService.getClassNameId(CPDefinition.class) && this.cpDefinitionLocalService.isVersionable(classPK)) {
            CPDefinition newCPDefinition = this.cpDefinitionLocalService.copyCPDefinition(classPK);
            classPK = newCPDefinition.getCPDefinitionId();
        }
        cpAttachmentFileEntry.setExternalReferenceCode(externalReferenceCode);
        cpAttachmentFileEntry.setGroupId(groupId);
        cpAttachmentFileEntry.setCompanyId(user.getCompanyId());
        cpAttachmentFileEntry.setUserId(user.getUserId());
        cpAttachmentFileEntry.setUserName(user.getFullName());
        cpAttachmentFileEntry.setClassNameId(classNameId);
        cpAttachmentFileEntry.setClassPK(classPK);
        FileEntry fileEntry = this.dlAppLocalService.getFileEntry(fileEntryId);
        fileEntryId = this._getFileEntryId(fileEntry, user.getUserId(), groupId, cpAttachmentFileEntry.getClassName(), cpAttachmentFileEntry.getClassPK());
        CPAttachmentFileEntry existingCPAttachmentFileEntry = this.cpAttachmentFileEntryPersistence.fetchByC_C_F(classNameId, classPK, fileEntryId);
        if (existingCPAttachmentFileEntry != null) {
            throw new DuplicateCPAttachmentFileEntryException();
        }
        Date date = new Date();
        cpAttachmentFileEntry.setFileEntryId(fileEntryId);
        cpAttachmentFileEntry.setDisplayDate(displayDate);
        cpAttachmentFileEntry.setExpirationDate(expirationDate);
        if (expirationDate == null || expirationDate.after(date)) {
            cpAttachmentFileEntry.setStatus(2);
        } else {
            cpAttachmentFileEntry.setStatus(3);
        }
        cpAttachmentFileEntry.setTitleMap(this._getValidLocalizedMap(LocaleUtil.getSiteDefault(), fileEntry.getFileName(), titleMap));
        cpAttachmentFileEntry.setJson(json);
        cpAttachmentFileEntry.setPriority(priority);
        cpAttachmentFileEntry.setType(type);
        cpAttachmentFileEntry.setExpandoBridgeAttributes(serviceContext);
        cpAttachmentFileEntry = (CPAttachmentFileEntry)this.cpAttachmentFileEntryPersistence.update((BaseModel)cpAttachmentFileEntry);
        this.reindex(classNameId, classPK);
        return this.startWorkflowInstance(user.getUserId(), cpAttachmentFileEntry, serviceContext);
    }

    public CPAttachmentFileEntry addOrUpdateCPAttachmentFileEntry(String externalReferenceCode, long groupId, long classNameId, long classPK, long cpAttachmentFileEntryId, long fileEntryId, int displayDateMonth, int displayDateDay, int displayDateYear, int displayDateHour, int displayDateMinute, int expirationDateMonth, int expirationDateDay, int expirationDateYear, int expirationDateHour, int expirationDateMinute, boolean neverExpire, Map<Locale, String> titleMap, String json, double priority, int type, ServiceContext serviceContext) throws PortalException {
        CPAttachmentFileEntry cpAttachmentFileEntry = null;
        if (cpAttachmentFileEntryId != 0L) {
            cpAttachmentFileEntry = this.cpAttachmentFileEntryPersistence.fetchByPrimaryKey(cpAttachmentFileEntryId);
        } else if (Validator.isNotNull((String)externalReferenceCode)) {
            cpAttachmentFileEntry = this.cpAttachmentFileEntryLocalService.fetchByExternalReferenceCode(externalReferenceCode, serviceContext.getCompanyId());
        }
        cpAttachmentFileEntry = cpAttachmentFileEntry == null ? this.cpAttachmentFileEntryLocalService.addCPAttachmentFileEntry(externalReferenceCode, serviceContext.getUserId(), groupId, classNameId, classPK, fileEntryId, displayDateMonth, displayDateDay, displayDateYear, displayDateHour, displayDateMinute, expirationDateMonth, expirationDateDay, expirationDateYear, expirationDateHour, expirationDateMinute, neverExpire, titleMap, json, priority, type, serviceContext) : this.cpAttachmentFileEntryLocalService.updateCPAttachmentFileEntry(cpAttachmentFileEntry.getCPAttachmentFileEntryId(), fileEntryId, displayDateMonth, displayDateDay, displayDateYear, displayDateHour, displayDateMinute, expirationDateMonth, expirationDateDay, expirationDateYear, expirationDateHour, expirationDateMinute, neverExpire, titleMap, json, priority, type, serviceContext);
        return cpAttachmentFileEntry;
    }

    public void checkCPAttachmentFileEntries() throws PortalException {
        this.checkCPAttachmentFileEntriesByDisplayDate();
        this.checkCPAttachmentFileEntriesByExpirationDate();
    }

    public void checkCPAttachmentFileEntriesByDisplayDate(long classNameId, long classPK) throws PortalException {
        List cpAttachmentFileEntries = null;
        cpAttachmentFileEntries = classPK > 0L ? this.cpAttachmentFileEntryPersistence.findByC_C_LtD_S(classNameId, classPK, new Date(), 7) : this.cpAttachmentFileEntryPersistence.findByLtD_S(new Date(), 7);
        for (CPAttachmentFileEntry cpAttachmentFileEntry : cpAttachmentFileEntries) {
            long userId = PortalUtil.getValidUserId((long)cpAttachmentFileEntry.getCompanyId(), (long)cpAttachmentFileEntry.getUserId());
            ServiceContext serviceContext = new ServiceContext();
            serviceContext.setCommand("update");
            serviceContext.setScopeGroupId(cpAttachmentFileEntry.getGroupId());
            this.cpAttachmentFileEntryLocalService.updateStatus(userId, cpAttachmentFileEntry.getCPAttachmentFileEntryId(), 0, serviceContext, new HashMap());
        }
    }

    public void deleteCPAttachmentFileEntries(String className, long classPK) throws PortalException {
        List cpAttachmentFileEntries = this.cpAttachmentFileEntryPersistence.findByC_C(this.classNameLocalService.getClassNameId(className), classPK);
        for (CPAttachmentFileEntry cpAttachmentFileEntry : cpAttachmentFileEntries) {
            this.cpAttachmentFileEntryLocalService.deleteCPAttachmentFileEntry(cpAttachmentFileEntry);
        }
    }

    @Override
    @Indexable(type=IndexableType.DELETE)
    @SystemEvent(type=1)
    public CPAttachmentFileEntry deleteCPAttachmentFileEntry(CPAttachmentFileEntry cpAttachmentFileEntry) throws PortalException {
        long cpDefinitionClassNameId = this.classNameLocalService.getClassNameId(CPDefinition.class);
        if (cpAttachmentFileEntry.getClassNameId() == cpDefinitionClassNameId && this.cpDefinitionLocalService.isVersionable(cpAttachmentFileEntry.getClassPK())) {
            CPDefinition newCPDefinition = this.cpDefinitionLocalService.copyCPDefinition(cpAttachmentFileEntry.getClassPK());
            cpAttachmentFileEntry = this.cpAttachmentFileEntryPersistence.findByC_C_F(cpDefinitionClassNameId, newCPDefinition.getCPDefinitionId(), cpAttachmentFileEntry.getFileEntryId());
        }
        this.cpAttachmentFileEntryPersistence.remove((BaseModel)cpAttachmentFileEntry);
        this.expandoRowLocalService.deleteRows(cpAttachmentFileEntry.getCPAttachmentFileEntryId());
        this.reindex(cpAttachmentFileEntry.getClassNameId(), cpAttachmentFileEntry.getClassPK());
        return cpAttachmentFileEntry;
    }

    @Override
    public CPAttachmentFileEntry deleteCPAttachmentFileEntry(long cpAttachmentFileEntryId) throws PortalException {
        CPAttachmentFileEntry cpAttachmentFileEntry = this.cpAttachmentFileEntryPersistence.findByPrimaryKey(cpAttachmentFileEntryId);
        return this.cpAttachmentFileEntryLocalService.deleteCPAttachmentFileEntry(cpAttachmentFileEntry);
    }

    public CPAttachmentFileEntry fetchByExternalReferenceCode(String externalReferenceCode, long companyId) {
        return this.cpAttachmentFileEntryPersistence.fetchByC_ERC(companyId, externalReferenceCode);
    }

    public Folder getAttachmentsFolder(long userId, long groupId, String className, long classPK) throws PortalException {
        ServiceContext serviceContext = new ServiceContext();
        serviceContext.setAddGroupPermissions(true);
        serviceContext.setAddGuestPermissions(true);
        Repository repository = PortletFileRepositoryUtil.addPortletRepository((long)groupId, (String)"com.liferay.commerce.product", (ServiceContext)serviceContext);
        Folder classNameFolder = PortletFileRepositoryUtil.addPortletFolder((long)userId, (long)repository.getRepositoryId(), (long)0L, (String)className, (ServiceContext)serviceContext);
        return PortletFileRepositoryUtil.addPortletFolder((long)userId, (long)repository.getRepositoryId(), (long)classNameFolder.getFolderId(), (String)String.valueOf(classPK), (ServiceContext)serviceContext);
    }

    public List<CPAttachmentFileEntry> getCPAttachmentFileEntries(long classNameId, long classPK, int type, int status, int start, int end) throws PortalException {
        if (status == -1) {
            return this.cpAttachmentFileEntryPersistence.findByC_C_T_NotST(classNameId, classPK, type, 8, start, end);
        }
        return this.cpAttachmentFileEntryPersistence.findByC_C_T_ST(classNameId, classPK, type, status, start, end);
    }

    public List<CPAttachmentFileEntry> getCPAttachmentFileEntries(long classNameId, long classPK, int type, int status, int start, int end, OrderByComparator<CPAttachmentFileEntry> orderByComparator) throws PortalException {
        if (status == -1) {
            return this.cpAttachmentFileEntryPersistence.findByC_C_T_NotST(classNameId, classPK, type, 8, start, end, orderByComparator);
        }
        return this.cpAttachmentFileEntryPersistence.findByC_C_T_ST(classNameId, classPK, type, status, start, end, orderByComparator);
    }

    public List<CPAttachmentFileEntry> getCPAttachmentFileEntries(long cpDefinitionId, String serializedDDMFormValues, int type, int start, int end) throws Exception {
        Document[] documents;
        ArrayList<CPAttachmentFileEntry> cpAttachmentFileEntries = new ArrayList<CPAttachmentFileEntry>();
        CPDefinition cpDefinition = this.cpDefinitionLocalService.getCPDefinition(cpDefinitionId);
        long cpDefinitionClassNameId = this._portal.getClassNameId(CPDefinition.class);
        JSONArray jsonArray = this._jsonFactory.createJSONArray();
        if (this._jsonHelper.isArray(serializedDDMFormValues)) {
            jsonArray = this._jsonFactory.createJSONArray(serializedDDMFormValues);
        }
        Indexer indexer = IndexerRegistryUtil.nullSafeGetIndexer(CPAttachmentFileEntry.class);
        SearchContext searchContext = new SearchContext();
        HashMap attributes = HashMapBuilder.put((Object)"relatedEntityClassNameId", (Object)cpDefinitionClassNameId).put((Object)"relatedEntityClassPK", (Object)cpDefinitionId).put((Object)"status", (Object)0).put((Object)"type", (Object)type).build();
        ArrayList<String> optionsKeys = new ArrayList<String>();
        for (int i = 0; i < jsonArray.length(); ++i) {
            JSONObject jsonObject = jsonArray.getJSONObject(i);
            JSONArray valueAsJSONArray = this._jsonHelper.getValueAsJSONArray("value", jsonObject);
            String[] values = new String[valueAsJSONArray.length()];
            if (values.length == 0) continue;
            for (int j = 0; j < valueAsJSONArray.length(); ++j) {
                values[j] = valueAsJSONArray.getString(j);
            }
            String key = jsonObject.getString("key");
            String fieldName = "ATTRIBUTE_" + key + "_VALUES_IDS";
            attributes.put(fieldName, values);
            optionsKeys.add(fieldName);
        }
        if (!optionsKeys.isEmpty()) {
            attributes.put("OPTIONS", ArrayUtil.toStringArray(optionsKeys));
        }
        searchContext.setAttributes((Map)attributes);
        searchContext.setCompanyId(cpDefinition.getCompanyId());
        searchContext.setEnd(end);
        searchContext.setGroupIds(new long[]{cpDefinition.getGroupId()});
        Sort prioritySort = SortFactoryUtil.create((String)"priority", (boolean)false);
        searchContext.setSorts(new Sort[]{prioritySort});
        searchContext.setStart(start);
        QueryConfig queryConfig = searchContext.getQueryConfig();
        queryConfig.setHighlightEnabled(false);
        queryConfig.setScoreEnabled(false);
        queryConfig.addSelectedFieldNames(new String[]{"entryClassPK"});
        Hits hits = indexer.search(searchContext);
        for (Document document : documents = hits.getDocs()) {
            long classPK = GetterUtil.getLong((String)document.get("entryClassPK"));
            cpAttachmentFileEntries.add(this.getCPAttachmentFileEntry(classPK));
        }
        return cpAttachmentFileEntries;
    }

    public int getCPAttachmentFileEntriesCount(long classNameId, long classPK, int type, int status) {
        if (status == -1) {
            return this.cpAttachmentFileEntryPersistence.countByC_C_T_NotST(classNameId, classPK, type, 8);
        }
        return this.cpAttachmentFileEntryPersistence.countByC_C_T_ST(classNameId, classPK, type, status);
    }

    @Indexable(type=IndexableType.REINDEX)
    public CPAttachmentFileEntry updateCPAttachmentFileEntry(long cpAttachmentFileEntryId, long fileEntryId, int displayDateMonth, int displayDateDay, int displayDateYear, int displayDateHour, int displayDateMinute, int expirationDateMonth, int expirationDateDay, int expirationDateYear, int expirationDateHour, int expirationDateMinute, boolean neverExpire, Map<Locale, String> titleMap, String json, double priority, int type, ServiceContext serviceContext) throws PortalException {
        return this.updateCPAttachmentFileEntry(serviceContext.getUserId(), cpAttachmentFileEntryId, fileEntryId, displayDateMonth, displayDateDay, displayDateYear, displayDateHour, displayDateMinute, expirationDateMonth, expirationDateDay, expirationDateYear, expirationDateHour, expirationDateMinute, neverExpire, titleMap, json, priority, type, serviceContext);
    }

    @Indexable(type=IndexableType.REINDEX)
    public CPAttachmentFileEntry updateCPAttachmentFileEntry(long userId, long cpAttachmentFileEntryId, long fileEntryId, int displayDateMonth, int displayDateDay, int displayDateYear, int displayDateHour, int displayDateMinute, int expirationDateMonth, int expirationDateDay, int expirationDateYear, int expirationDateHour, int expirationDateMinute, boolean neverExpire, Map<Locale, String> titleMap, String json, double priority, int type, ServiceContext serviceContext) throws PortalException {
        User user = this.userLocalService.getUser(userId);
        CPAttachmentFileEntry cpAttachmentFileEntry = this.cpAttachmentFileEntryPersistence.findByPrimaryKey(cpAttachmentFileEntryId);
        long cpDefinitionClassNameId = this.classNameLocalService.getClassNameId(CPDefinition.class);
        if (cpAttachmentFileEntry.getClassNameId() == cpDefinitionClassNameId && this.cpDefinitionLocalService.isVersionable(cpAttachmentFileEntry.getClassPK())) {
            CPDefinition newCPDefinition = this.cpDefinitionLocalService.copyCPDefinition(cpAttachmentFileEntry.getClassPK());
            cpAttachmentFileEntry = this.cpAttachmentFileEntryPersistence.findByC_C_F(cpDefinitionClassNameId, newCPDefinition.getCPDefinitionId(), cpAttachmentFileEntry.getFileEntryId());
        }
        Date expirationDate = null;
        Date displayDate = PortalUtil.getDate((int)displayDateMonth, (int)displayDateDay, (int)displayDateYear, (int)displayDateHour, (int)displayDateMinute, (TimeZone)user.getTimeZone(), CPAttachmentFileEntryDisplayDateException.class);
        if (!neverExpire) {
            expirationDate = PortalUtil.getDate((int)expirationDateMonth, (int)expirationDateDay, (int)expirationDateYear, (int)expirationDateHour, (int)expirationDateMinute, (TimeZone)user.getTimeZone(), CPAttachmentFileEntryExpirationDateException.class);
        }
        if (expirationDate != null && (expirationDate.before(new Date()) || displayDate != null && expirationDate.before(displayDate))) {
            throw new CPAttachmentFileEntryExpirationDateException("Expiration date " + expirationDate + " is in the past");
        }
        Date date = new Date();
        FileEntry fileEntry = this.dlAppLocalService.getFileEntry(fileEntryId);
        fileEntryId = this._getFileEntryId(fileEntry, user.getUserId(), cpAttachmentFileEntry.getGroupId(), cpAttachmentFileEntry.getClassName(), cpAttachmentFileEntry.getClassPK());
        cpAttachmentFileEntry.setFileEntryId(fileEntryId);
        cpAttachmentFileEntry.setDisplayDate(displayDate);
        cpAttachmentFileEntry.setExpirationDate(expirationDate);
        if (expirationDate == null || expirationDate.after(date)) {
            cpAttachmentFileEntry.setStatus(2);
        } else {
            cpAttachmentFileEntry.setStatus(3);
        }
        cpAttachmentFileEntry.setTitleMap(this._getValidLocalizedMap(LocaleUtil.getSiteDefault(), fileEntry.getFileName(), titleMap));
        cpAttachmentFileEntry.setJson(json);
        cpAttachmentFileEntry.setPriority(priority);
        cpAttachmentFileEntry.setType(type);
        cpAttachmentFileEntry.setExpandoBridgeAttributes(serviceContext);
        cpAttachmentFileEntry = (CPAttachmentFileEntry)this.cpAttachmentFileEntryPersistence.update((BaseModel)cpAttachmentFileEntry);
        return this.startWorkflowInstance(user.getUserId(), cpAttachmentFileEntry, serviceContext);
    }

    @Indexable(type=IndexableType.REINDEX)
    public CPAttachmentFileEntry updateStatus(long userId, long cpAttachmentFileEntryId, int status, ServiceContext serviceContext, Map<String, Serializable> workflowContext) throws PortalException {
        Date expirationDate;
        User user = this.userLocalService.getUser(userId);
        Date date = new Date();
        CPAttachmentFileEntry cpAttachmentFileEntry = this.cpAttachmentFileEntryPersistence.findByPrimaryKey(cpAttachmentFileEntryId);
        if (status == 0 && cpAttachmentFileEntry.getDisplayDate() != null && date.before(cpAttachmentFileEntry.getDisplayDate())) {
            status = 7;
        }
        Date modifiedDate = serviceContext.getModifiedDate(date);
        if (status == 0 && (expirationDate = cpAttachmentFileEntry.getExpirationDate()) != null && expirationDate.before(date)) {
            cpAttachmentFileEntry.setExpirationDate(null);
        }
        if (status == 3) {
            cpAttachmentFileEntry.setExpirationDate(date);
        }
        cpAttachmentFileEntry.setStatus(status);
        cpAttachmentFileEntry.setStatusByUserId(user.getUserId());
        cpAttachmentFileEntry.setStatusByUserName(user.getFullName());
        cpAttachmentFileEntry.setStatusDate(modifiedDate);
        cpAttachmentFileEntry = (CPAttachmentFileEntry)this.cpAttachmentFileEntryPersistence.update((BaseModel)cpAttachmentFileEntry);
        this.reindex(cpAttachmentFileEntry.getClassNameId(), cpAttachmentFileEntry.getClassPK());
        return cpAttachmentFileEntry;
    }

    @Deprecated
    public CPAttachmentFileEntry upsertCPAttachmentFileEntry(String externalReferenceCode, long groupId, long classNameId, long classPK, long fileEntryId, int displayDateMonth, int displayDateDay, int displayDateYear, int displayDateHour, int displayDateMinute, int expirationDateMonth, int expirationDateDay, int expirationDateYear, int expirationDateHour, int expirationDateMinute, boolean neverExpire, Map<Locale, String> titleMap, String json, double priority, int type, ServiceContext serviceContext) throws PortalException {
        return this.addOrUpdateCPAttachmentFileEntry(externalReferenceCode, groupId, classNameId, classPK, 0L, fileEntryId, displayDateMonth, displayDateDay, displayDateYear, displayDateHour, displayDateMinute, expirationDateMonth, expirationDateDay, expirationDateYear, expirationDateHour, expirationDateMinute, neverExpire, titleMap, json, priority, type, serviceContext);
    }

    protected void checkCPAttachmentFileEntriesByDisplayDate() throws PortalException {
        this.checkCPAttachmentFileEntriesByDisplayDate(0L, 0L);
    }

    protected void checkCPAttachmentFileEntriesByExpirationDate() throws PortalException {
        List cpAttachmentFileEntries = this.cpAttachmentFileEntryFinder.findByExpirationDate(new Date(), new QueryDefinition(0));
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Expiring " + cpAttachmentFileEntries.size() + " commerce product attachment file entries"));
        }
        if (cpAttachmentFileEntries != null && !cpAttachmentFileEntries.isEmpty()) {
            for (CPAttachmentFileEntry cpAttachmentFileEntry : cpAttachmentFileEntries) {
                long userId = PortalUtil.getValidUserId((long)cpAttachmentFileEntry.getCompanyId(), (long)cpAttachmentFileEntry.getUserId());
                ServiceContext serviceContext = new ServiceContext();
                serviceContext.setCommand("update");
                serviceContext.setScopeGroupId(cpAttachmentFileEntry.getGroupId());
                this.cpAttachmentFileEntryLocalService.updateStatus(userId, cpAttachmentFileEntry.getCPAttachmentFileEntryId(), 3, serviceContext, new HashMap());
            }
        }
    }

    protected void reindex(long classNameId, long classPK) throws PortalException {
        ClassName className = this.classNameLocalService.getClassName(classNameId);
        String classNameValue = className.getValue();
        if (classNameValue.equals(CPDefinition.class.getName())) {
            Indexer indexer = IndexerRegistryUtil.nullSafeGetIndexer(CPDefinition.class);
            indexer.reindex(CPDefinition.class.getName(), classPK);
        }
    }

    protected CPAttachmentFileEntry startWorkflowInstance(long userId, CPAttachmentFileEntry cpAttachmentFileEntry, ServiceContext serviceContext) throws PortalException {
        HashMap workflowContext = new HashMap();
        return (CPAttachmentFileEntry)WorkflowHandlerRegistryUtil.startWorkflowInstance((long)cpAttachmentFileEntry.getCompanyId(), (long)cpAttachmentFileEntry.getGroupId(), (long)userId, (String)CPAttachmentFileEntry.class.getName(), (long)cpAttachmentFileEntry.getCPAttachmentFileEntryId(), (Object)cpAttachmentFileEntry, (ServiceContext)serviceContext, workflowContext);
    }

    private long _getFileEntryId(FileEntry fileEntry, long userId, long groupId, String className, long classPK) throws PortalException {
        boolean tempFile = fileEntry.isRepositoryCapabilityProvided(TemporaryFileEntriesCapability.class);
        if (!tempFile) {
            return fileEntry.getFileEntryId();
        }
        Folder folder = this.cpAttachmentFileEntryLocalService.getAttachmentsFolder(userId, groupId, className, classPK);
        String uniqueFileName = PortletFileRepositoryUtil.getUniqueFileName((long)groupId, (long)folder.getFolderId(), (String)fileEntry.getFileName());
        FileEntry newFileEntry = PortletFileRepositoryUtil.addPortletFileEntry((long)groupId, (long)userId, (String)className, (long)classPK, (String)"com.liferay.commerce.product", (long)folder.getFolderId(), (InputStream)fileEntry.getContentStream(), (String)uniqueFileName, (String)fileEntry.getMimeType(), (boolean)true);
        TempFileEntryUtil.deleteTempFileEntry((long)fileEntry.getFileEntryId());
        return newFileEntry.getFileEntryId();
    }

    private Map<Locale, String> _getValidLocalizedMap(Locale defaultLocale, String defaultTitle, Map<Locale, String> titleMap) {
        if (Validator.isNotNull((String)titleMap.get(defaultLocale))) {
            return titleMap;
        }
        HashMap<Locale, String> validTitleMap = new HashMap<Locale, String>(titleMap);
        validTitleMap.put(defaultLocale, defaultTitle);
        return validTitleMap;
    }
}

