/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.product.service.impl;

import com.liferay.asset.kernel.model.AssetCategory;
import com.liferay.commerce.product.exception.NoSuchCPDefinitionException;
import com.liferay.commerce.product.model.CPAttachmentFileEntry;
import com.liferay.commerce.product.model.CPDefinition;
import com.liferay.commerce.product.model.CommerceCatalog;
import com.liferay.commerce.product.service.base.CPAttachmentFileEntryServiceBaseImpl;
import com.liferay.document.library.kernel.model.DLFileEntry;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.ClassedModel;
import com.liferay.portal.kernel.search.Indexable;
import com.liferay.portal.kernel.search.IndexableType;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermissionFactory;
import com.liferay.portal.kernel.security.permission.resource.PortletResourcePermission;
import com.liferay.portal.kernel.security.permission.resource.PortletResourcePermissionFactory;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.spring.extender.service.ServiceReference;
import com.liferay.portlet.asset.service.permission.AssetCategoryPermission;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class CPAttachmentFileEntryServiceImpl
extends CPAttachmentFileEntryServiceBaseImpl {
    private static volatile ModelResourcePermission<CommerceCatalog> _commerceCatalogModelResourcePermission = ModelResourcePermissionFactory.getInstance(CPAttachmentFileEntryServiceImpl.class, (String)"_commerceCatalogModelResourcePermission", CommerceCatalog.class);
    private static volatile ModelResourcePermission<DLFileEntry> _dlFileEntryModelResourcePermission = ModelResourcePermissionFactory.getInstance(CPAttachmentFileEntryServiceImpl.class, (String)"_dlFileEntryModelResourcePermission", DLFileEntry.class);
    private static volatile PortletResourcePermission _portletResourcePermission = PortletResourcePermissionFactory.getInstance(CPAttachmentFileEntryServiceImpl.class, (String)"_portletResourcePermission", (String)"com.liferay.commerce.product");
    @ServiceReference(type=Portal.class)
    private Portal _portal;

    public CPAttachmentFileEntry addCPAttachmentFileEntry(long userId, long groupId, long classNameId, long classPK, long fileEntryId, int displayDateMonth, int displayDateDay, int displayDateYear, int displayDateHour, int displayDateMinute, int expirationDateMonth, int expirationDateDay, int expirationDateYear, int expirationDateHour, int expirationDateMinute, boolean neverExpire, Map<Locale, String> titleMap, String json, double priority, int type, ServiceContext serviceContext) throws PortalException {
        this.checkCPAttachmentFileEntryPermissions(serviceContext.getScopeGroupId(), classNameId, classPK, type);
        return this.cpAttachmentFileEntryLocalService.addCPAttachmentFileEntry(null, userId, groupId, classNameId, classPK, fileEntryId, displayDateMonth, displayDateDay, displayDateYear, displayDateHour, displayDateMinute, expirationDateMonth, expirationDateDay, expirationDateYear, expirationDateHour, expirationDateMinute, neverExpire, titleMap, json, priority, type, serviceContext);
    }

    public CPAttachmentFileEntry addOrUpdateCPAttachmentFileEntry(String externalReferenceCode, long groupId, long classNameId, long classPK, long cpAttachmentFileEntryId, long fileEntryId, int displayDateMonth, int displayDateDay, int displayDateYear, int displayDateHour, int displayDateMinute, int expirationDateMonth, int expirationDateDay, int expirationDateYear, int expirationDateHour, int expirationDateMinute, boolean neverExpire, Map<Locale, String> titleMap, String json, double priority, int type, ServiceContext serviceContext) throws PortalException {
        CPAttachmentFileEntry cpAttachmentFileEntry = null;
        if (cpAttachmentFileEntryId != 0L) {
            cpAttachmentFileEntry = this.cpAttachmentFileEntryPersistence.fetchByPrimaryKey(cpAttachmentFileEntryId);
        } else if (Validator.isNotNull((String)externalReferenceCode)) {
            cpAttachmentFileEntry = this.cpAttachmentFileEntryPersistence.fetchByC_ERC(serviceContext.getCompanyId(), externalReferenceCode);
        }
        if (cpAttachmentFileEntry == null) {
            this.checkCPAttachmentFileEntryPermissions(serviceContext.getScopeGroupId(), classNameId, classPK, type);
        } else {
            this.checkCPAttachmentFileEntryPermissions(cpAttachmentFileEntry);
        }
        return this.cpAttachmentFileEntryLocalService.addOrUpdateCPAttachmentFileEntry(externalReferenceCode, groupId, classNameId, classPK, cpAttachmentFileEntryId, fileEntryId, displayDateMonth, displayDateDay, displayDateYear, displayDateHour, displayDateMinute, expirationDateMonth, expirationDateDay, expirationDateYear, expirationDateHour, expirationDateMinute, neverExpire, titleMap, json, priority, type, serviceContext);
    }

    public void deleteCPAttachmentFileEntry(long cpAttachmentFileEntryId) throws PortalException {
        this.checkCPAttachmentFileEntryPermissions(cpAttachmentFileEntryId);
        this.cpAttachmentFileEntryLocalService.deleteCPAttachmentFileEntry(cpAttachmentFileEntryId);
    }

    public CPAttachmentFileEntry fetchByExternalReferenceCode(String externalReferenceCode, long companyId) throws PortalException {
        CPAttachmentFileEntry cpAttachmentFileEntry = this.cpAttachmentFileEntryLocalService.fetchByExternalReferenceCode(externalReferenceCode, companyId);
        if (cpAttachmentFileEntry != null) {
            long cpDefinitionClassNameId = this._portal.getClassNameId(CPDefinition.class);
            if (cpDefinitionClassNameId == cpAttachmentFileEntry.getClassNameId()) {
                this._checkCommerceCatalog(cpAttachmentFileEntry.getClassPK(), "VIEW");
            } else {
                this.checkCPAttachmentFileEntryPermissions(cpAttachmentFileEntry);
            }
        }
        return cpAttachmentFileEntry;
    }

    public CPAttachmentFileEntry fetchCPAttachmentFileEntry(long cpAttachmentFileEntryId) throws PortalException {
        CPAttachmentFileEntry cpAttachmentFileEntry = this.cpAttachmentFileEntryLocalService.fetchCPAttachmentFileEntry(cpAttachmentFileEntryId);
        if (cpAttachmentFileEntry != null) {
            long cpDefinitionClassNameId = this._portal.getClassNameId(CPDefinition.class);
            long assetCategoryClassNameId = this._portal.getClassNameId(AssetCategory.class);
            if (cpDefinitionClassNameId == cpAttachmentFileEntry.getClassNameId()) {
                this._checkCommerceCatalog(cpAttachmentFileEntry.getClassPK(), "VIEW");
            } else if (assetCategoryClassNameId == cpAttachmentFileEntry.getClassNameId()) {
                AssetCategoryPermission.check((PermissionChecker)this.getPermissionChecker(), (long)cpAttachmentFileEntry.getClassPK(), (String)"VIEW");
            } else {
                this.checkCPAttachmentFileEntryPermissions(cpAttachmentFileEntryId);
            }
        }
        return cpAttachmentFileEntry;
    }

    public List<CPAttachmentFileEntry> getCPAttachmentFileEntries(long classNameId, long classPK, int type, int status, int start, int end) throws PortalException {
        this.checkCPAttachmentFileEntryPermissions(classNameId, classPK, "VIEW");
        ArrayList<CPAttachmentFileEntry> filteredCPAttachmentFileEntries = new ArrayList<CPAttachmentFileEntry>();
        List cpAttachmentFileEntries = this.cpAttachmentFileEntryLocalService.getCPAttachmentFileEntries(classNameId, classPK, type, status, start, end);
        for (CPAttachmentFileEntry cpAttachmentFileEntry : cpAttachmentFileEntries) {
            DLFileEntry dlFileEntry = this.dlFileEntryLocalService.fetchDLFileEntry(cpAttachmentFileEntry.getFileEntryId());
            if (dlFileEntry == null || !_dlFileEntryModelResourcePermission.contains(this.getPermissionChecker(), (ClassedModel)dlFileEntry, "VIEW")) continue;
            filteredCPAttachmentFileEntries.add(cpAttachmentFileEntry);
        }
        return filteredCPAttachmentFileEntries;
    }

    public List<CPAttachmentFileEntry> getCPAttachmentFileEntries(long classNameId, long classPK, int type, int status, int start, int end, OrderByComparator<CPAttachmentFileEntry> orderByComparator) throws PortalException {
        this.checkCPAttachmentFileEntryPermissions(classNameId, classPK, "VIEW");
        ArrayList<CPAttachmentFileEntry> filteredCPAttachmentFileEntries = new ArrayList<CPAttachmentFileEntry>();
        List cpAttachmentFileEntries = this.cpAttachmentFileEntryLocalService.getCPAttachmentFileEntries(classNameId, classPK, type, status, start, end, orderByComparator);
        for (CPAttachmentFileEntry cpAttachmentFileEntry : cpAttachmentFileEntries) {
            DLFileEntry dlFileEntry = this.dlFileEntryLocalService.fetchDLFileEntry(cpAttachmentFileEntry.getFileEntryId());
            if (dlFileEntry == null || !_dlFileEntryModelResourcePermission.contains(this.getPermissionChecker(), (ClassedModel)dlFileEntry, "VIEW")) continue;
            filteredCPAttachmentFileEntries.add(cpAttachmentFileEntry);
        }
        return filteredCPAttachmentFileEntries;
    }

    public int getCPAttachmentFileEntriesCount(long classNameId, long classPK, int type, int status) throws PortalException {
        this.checkCPAttachmentFileEntryPermissions(classNameId, classPK, "VIEW");
        return this.cpAttachmentFileEntryLocalService.getCPAttachmentFileEntriesCount(classNameId, classPK, type, status);
    }

    public CPAttachmentFileEntry getCPAttachmentFileEntry(long cpAttachmentFileEntryId) throws PortalException {
        CPAttachmentFileEntry cpAttachmentFileEntry = this.cpAttachmentFileEntryLocalService.getCPAttachmentFileEntry(cpAttachmentFileEntryId);
        if (cpAttachmentFileEntry != null) {
            long cpDefinitionClassNameId = this._portal.getClassNameId(CPDefinition.class);
            long assetCategoryClassNameId = this._portal.getClassNameId(AssetCategory.class);
            if (cpDefinitionClassNameId == cpAttachmentFileEntry.getClassNameId()) {
                this._checkCommerceCatalog(cpAttachmentFileEntry.getClassPK(), "VIEW");
            } else if (assetCategoryClassNameId == cpAttachmentFileEntry.getClassNameId()) {
                AssetCategoryPermission.check((PermissionChecker)this.getPermissionChecker(), (long)cpAttachmentFileEntry.getClassPK(), (String)"VIEW");
            } else {
                this.checkCPAttachmentFileEntryPermissions(cpAttachmentFileEntryId);
            }
        }
        return cpAttachmentFileEntry;
    }

    @Indexable(type=IndexableType.REINDEX)
    public CPAttachmentFileEntry updateCPAttachmentFileEntry(long cpAttachmentFileEntryId, long fileEntryId, int displayDateMonth, int displayDateDay, int displayDateYear, int displayDateHour, int displayDateMinute, int expirationDateMonth, int expirationDateDay, int expirationDateYear, int expirationDateHour, int expirationDateMinute, boolean neverExpire, Map<Locale, String> titleMap, String json, double priority, int type, ServiceContext serviceContext) throws PortalException {
        this.checkCPAttachmentFileEntryPermissions(cpAttachmentFileEntryId);
        return this.cpAttachmentFileEntryLocalService.updateCPAttachmentFileEntry(cpAttachmentFileEntryId, fileEntryId, displayDateMonth, displayDateDay, displayDateYear, displayDateHour, displayDateMinute, expirationDateMonth, expirationDateDay, expirationDateYear, expirationDateHour, expirationDateMinute, neverExpire, titleMap, json, priority, type, serviceContext);
    }

    @Deprecated
    public CPAttachmentFileEntry upsertCPAttachmentFileEntry(String externalReferenceCode, long groupId, long classNameId, long classPK, long fileEntryId, int displayDateMonth, int displayDateDay, int displayDateYear, int displayDateHour, int displayDateMinute, int expirationDateMonth, int expirationDateDay, int expirationDateYear, int expirationDateHour, int expirationDateMinute, boolean neverExpire, Map<Locale, String> titleMap, String json, double priority, int type, ServiceContext serviceContext) throws PortalException {
        CPAttachmentFileEntry cpAttachmentFileEntry = this.cpAttachmentFileEntryLocalService.fetchByExternalReferenceCode(externalReferenceCode, serviceContext.getCompanyId());
        if (cpAttachmentFileEntry == null) {
            this.checkCPAttachmentFileEntryPermissions(serviceContext.getScopeGroupId(), classNameId, classPK, type);
        } else {
            this.checkCPAttachmentFileEntryPermissions(cpAttachmentFileEntry);
        }
        return this.cpAttachmentFileEntryLocalService.addOrUpdateCPAttachmentFileEntry(externalReferenceCode, groupId, classNameId, classPK, 0L, fileEntryId, displayDateMonth, displayDateDay, displayDateYear, displayDateHour, displayDateMinute, expirationDateMonth, expirationDateDay, expirationDateYear, expirationDateHour, expirationDateMinute, neverExpire, titleMap, json, priority, type, serviceContext);
    }

    protected void checkCPAttachmentFileEntryPermissions(CPAttachmentFileEntry cpAttachmentFileEntry) throws PortalException {
        this.checkCPAttachmentFileEntryPermissions(cpAttachmentFileEntry.getGroupId(), cpAttachmentFileEntry.getClassNameId(), cpAttachmentFileEntry.getClassPK(), cpAttachmentFileEntry.getType());
    }

    protected void checkCPAttachmentFileEntryPermissions(long cpAttachmentFileEntryId) throws PortalException {
        this.checkCPAttachmentFileEntryPermissions(this.cpAttachmentFileEntryLocalService.getCPAttachmentFileEntry(cpAttachmentFileEntryId));
    }

    protected void checkCPAttachmentFileEntryPermissions(long scopeGroupId, long classNameId, long classPK, int type) throws PortalException {
        String actionKey = this.getActionKeyByCPAttachmentFileEntryType(type);
        _portletResourcePermission.check(this.getPermissionChecker(), scopeGroupId, actionKey);
        this.checkCPAttachmentFileEntryPermissions(classNameId, classPK, "UPDATE");
    }

    protected void checkCPAttachmentFileEntryPermissions(long classNameId, long classPK, String actionId) throws PortalException {
        long cpDefinitionClassNameId = this._portal.getClassNameId(CPDefinition.class);
        if (classNameId == cpDefinitionClassNameId) {
            this._checkCommerceCatalog(classPK, actionId);
        }
    }

    protected String getActionKeyByCPAttachmentFileEntryType(int type) {
        if (type == 1) {
            return "MANAGE_COMMERCE_PRODUCT_ATTACHMENTS";
        }
        return "MANAGE_COMMERCE_PRODUCT_IMAGES";
    }

    private void _checkCommerceCatalog(long cpDefinitionId, String actionId) throws PortalException {
        CPDefinition cpDefinition = this.cpDefinitionLocalService.fetchCPDefinition(cpDefinitionId);
        if (cpDefinition == null) {
            throw new NoSuchCPDefinitionException();
        }
        CommerceCatalog commerceCatalog = this.commerceCatalogLocalService.fetchCommerceCatalogByGroupId(cpDefinition.getGroupId());
        if (commerceCatalog == null) {
            throw new PrincipalException();
        }
        _commerceCatalogModelResourcePermission.check(this.getPermissionChecker(), (ClassedModel)commerceCatalog, actionId);
    }
}

