/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.product.service.impl;

import com.liferay.commerce.product.model.CPDefinition;
import com.liferay.commerce.product.model.CPDefinitionLink;
import com.liferay.commerce.product.model.CProduct;
import com.liferay.commerce.product.service.base.CPDefinitionLinkLocalServiceBaseImpl;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerRegistryUtil;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import java.util.List;

public class CPDefinitionLinkLocalServiceImpl
extends CPDefinitionLinkLocalServiceBaseImpl {
    @Deprecated
    public CPDefinitionLink addCPDefinitionLink(long cpDefinitionId1, long cpDefinitionId2, double priority, String type, ServiceContext serviceContext) throws PortalException {
        CPDefinition cpDefinition2 = this.cpDefinitionPersistence.findByPrimaryKey(cpDefinitionId2);
        return this.addCPDefinitionLinkByCProductId(cpDefinitionId1, cpDefinition2.getCProductId(), priority, type, serviceContext);
    }

    public CPDefinitionLink addCPDefinitionLinkByCProductId(long cpDefinitionId, long cProductId, double priority, String type, ServiceContext serviceContext) throws PortalException {
        CPDefinition cpDefinition;
        if (this.cpDefinitionLocalService.isVersionable(cpDefinitionId)) {
            cpDefinition = this.cpDefinitionLocalService.copyCPDefinition(cpDefinitionId);
            cpDefinitionId = cpDefinition.getCPDefinitionId();
        } else {
            cpDefinition = this.cpDefinitionPersistence.findByPrimaryKey(cpDefinitionId);
        }
        User user = this.userLocalService.getUser(serviceContext.getUserId());
        long cpDefinitionLinkId = this.counterLocalService.increment();
        CPDefinitionLink cpDefinitionLink = this.cpDefinitionLinkPersistence.create(cpDefinitionLinkId);
        cpDefinitionLink.setGroupId(cpDefinition.getGroupId());
        cpDefinitionLink.setCompanyId(user.getCompanyId());
        cpDefinitionLink.setUserId(user.getUserId());
        cpDefinitionLink.setUserName(user.getFullName());
        cpDefinitionLink.setCPDefinitionId(cpDefinition.getCPDefinitionId());
        cpDefinitionLink.setCProductId(cProductId);
        cpDefinitionLink.setPriority(priority);
        cpDefinitionLink.setType(type);
        cpDefinitionLink.setExpandoBridgeAttributes(serviceContext);
        cpDefinitionLink = (CPDefinitionLink)this.cpDefinitionLinkPersistence.update((BaseModel)cpDefinitionLink);
        CProduct cProduct = this.cProductLocalService.getCProduct(cProductId);
        this.reindexCPDefinition(cProduct.getPublishedCPDefinitionId());
        this.reindexCPDefinition(cpDefinitionId);
        return cpDefinitionLink;
    }

    @Override
    public CPDefinitionLink deleteCPDefinitionLink(CPDefinitionLink cpDefinitionLink) throws PortalException {
        if (this.cpDefinitionLocalService.isVersionable(cpDefinitionLink.getCPDefinitionId())) {
            try {
                CPDefinition newCPDefinition = this.cpDefinitionLocalService.copyCPDefinition(cpDefinitionLink.getCPDefinitionId());
                cpDefinitionLink = this.cpDefinitionLinkPersistence.findByC_C_T(newCPDefinition.getCPDefinitionId(), cpDefinitionLink.getCProductId(), cpDefinitionLink.getType());
            }
            catch (PortalException portalException) {
                throw new SystemException((Throwable)portalException);
            }
        }
        this.cpDefinitionLinkPersistence.remove((BaseModel)cpDefinitionLink);
        this.expandoRowLocalService.deleteRows(cpDefinitionLink.getCPDefinitionLinkId());
        CProduct cProduct = this.cProductLocalService.getCProduct(cpDefinitionLink.getCProductId());
        this.reindexCPDefinition(cProduct.getPublishedCPDefinitionId());
        this.reindexCPDefinition(cpDefinitionLink.getCPDefinitionId());
        return cpDefinitionLink;
    }

    @Override
    public CPDefinitionLink deleteCPDefinitionLink(long cpDefinitionLinkId) throws PortalException {
        CPDefinitionLink cpDefinitionLink = this.cpDefinitionLinkPersistence.findByPrimaryKey(cpDefinitionLinkId);
        return this.cpDefinitionLinkLocalService.deleteCPDefinitionLink(cpDefinitionLink);
    }

    @Deprecated
    public void deleteCPDefinitionLinks(long cpDefinitionId) throws PortalException {
        this.deleteCPDefinitionLinksByCPDefinitionId(cpDefinitionId);
        CPDefinition cpDefinition = this.cpDefinitionPersistence.fetchByPrimaryKey(cpDefinitionId);
        if (cpDefinition != null) {
            this.deleteCPDefinitionLinksByCProductId(cpDefinition.getCProductId());
        }
    }

    public void deleteCPDefinitionLinksByCPDefinitionId(long cpDefinitionId) throws PortalException {
        List cpDefinitionLinks = this.cpDefinitionLinkPersistence.findByCPDefinitionId(cpDefinitionId);
        for (CPDefinitionLink cpDefinitionLink : cpDefinitionLinks) {
            this.cpDefinitionLinkLocalService.deleteCPDefinitionLink(cpDefinitionLink);
        }
    }

    public void deleteCPDefinitionLinksByCProductId(long cProductId) throws PortalException {
        List cpDefinitionLinks = this.cpDefinitionLinkPersistence.findByCProductId(cProductId);
        for (CPDefinitionLink cpDefinitionLink : cpDefinitionLinks) {
            this.cpDefinitionLinkLocalService.deleteCPDefinitionLink(cpDefinitionLink);
        }
    }

    public List<CPDefinitionLink> getCPDefinitionLinks(long cpDefinitionId) {
        return this.cpDefinitionLinkPersistence.findByCPDefinitionId(cpDefinitionId);
    }

    public List<CPDefinitionLink> getCPDefinitionLinks(long cpDefinitionId, int start, int end) {
        return this.cpDefinitionLinkPersistence.findByCPDefinitionId(cpDefinitionId, start, end);
    }

    public List<CPDefinitionLink> getCPDefinitionLinks(long cpDefinitionId, String type) {
        return this.cpDefinitionLinkPersistence.findByCPD_T(cpDefinitionId, type);
    }

    public List<CPDefinitionLink> getCPDefinitionLinks(long cpDefinitionId, String type, int start, int end, OrderByComparator<CPDefinitionLink> orderByComparator) {
        return this.cpDefinitionLinkPersistence.findByCPD_T(cpDefinitionId, type, start, end, orderByComparator);
    }

    public int getCPDefinitionLinksCount(long cpDefinitionId) {
        return this.cpDefinitionLinkPersistence.countByCPDefinitionId(cpDefinitionId);
    }

    public int getCPDefinitionLinksCount(long cpDefinitionId, String type) {
        return this.cpDefinitionLinkPersistence.countByCPD_T(cpDefinitionId, type);
    }

    public List<CPDefinitionLink> getReverseCPDefinitionLinks(long cProductId, String type) {
        return this.cpDefinitionLinkPersistence.findByCP_T(cProductId, type);
    }

    public CPDefinitionLink updateCPDefinitionLink(long cpDefinitionLinkId, double priority, ServiceContext serviceContext) throws PortalException {
        CPDefinitionLink cpDefinitionLink = this.cpDefinitionLinkPersistence.findByPrimaryKey(cpDefinitionLinkId);
        if (this.cpDefinitionLocalService.isVersionable(cpDefinitionLink.getCPDefinitionId())) {
            CPDefinition newCPDefinition = this.cpDefinitionLocalService.copyCPDefinition(cpDefinitionLink.getCPDefinitionId());
            cpDefinitionLink = this.cpDefinitionLinkPersistence.findByC_C_T(newCPDefinition.getCPDefinitionId(), cpDefinitionLink.getCProductId(), cpDefinitionLink.getType());
        }
        cpDefinitionLink.setPriority(priority);
        cpDefinitionLink.setExpandoBridgeAttributes(serviceContext);
        cpDefinitionLink = (CPDefinitionLink)this.cpDefinitionLinkPersistence.update((BaseModel)cpDefinitionLink);
        this.reindexCPDefinition(cpDefinitionLink.getCPDefinitionId());
        CProduct cProduct = this.cProductPersistence.findByPrimaryKey(cpDefinitionLink.getCProductId());
        this.reindexCPDefinition(cProduct.getPublishedCPDefinitionId());
        return cpDefinitionLink;
    }

    public void updateCPDefinitionLinkCProductIds(long cpDefinitionId, long[] cProductIds, String type, ServiceContext serviceContext) throws PortalException {
        if (cProductIds == null) {
            return;
        }
        List<CPDefinitionLink> cpDefinitionLinks = this.getCPDefinitionLinks(cpDefinitionId, type);
        for (CPDefinitionLink cpDefinitionLink : cpDefinitionLinks) {
            if (ArrayUtil.contains((long[])cProductIds, (long)cpDefinitionLink.getCProductId())) continue;
            this.cpDefinitionLinkLocalService.deleteCPDefinitionLink(cpDefinitionLink);
        }
        CPDefinition cpDefinition = this.cpDefinitionPersistence.findByPrimaryKey(cpDefinitionId);
        for (long cProductId : cProductIds) {
            CPDefinitionLink cpDefinitionLink;
            if (cpDefinition.getCProductId() != cProductId && (cpDefinitionLink = this.cpDefinitionLinkPersistence.fetchByC_C_T(cpDefinitionId, cProductId, type)) == null) {
                this.cpDefinitionLinkLocalService.addCPDefinitionLinkByCProductId(cpDefinitionId, cProductId, 0.0, type, serviceContext);
            }
            CProduct cProduct = this.cProductLocalService.getCProduct(cProductId);
            this.reindexCPDefinition(cProduct.getPublishedCPDefinitionId());
        }
        this.reindexCPDefinition(cpDefinitionId);
    }

    @Deprecated
    public void updateCPDefinitionLinks(long cpDefinitionId1, long[] cpDefinitionIds2, String type, ServiceContext serviceContext) throws PortalException {
        if (cpDefinitionIds2 == null) {
            return;
        }
        long[] cProductIds = new long[cpDefinitionIds2.length];
        for (int i = 0; i < cProductIds.length; ++i) {
            long cpDefinitionId = cpDefinitionIds2[i];
            CPDefinition cpDefinition = this.cpDefinitionPersistence.findByPrimaryKey(cpDefinitionId);
            cProductIds[i] = cpDefinition.getCProductId();
        }
        this.cpDefinitionLinkLocalService.updateCPDefinitionLinkCProductIds(cpDefinitionId1, cProductIds, type, serviceContext);
    }

    protected void reindexCPDefinition(long cpDefinitionId) throws PortalException {
        Indexer indexer = IndexerRegistryUtil.nullSafeGetIndexer(CPDefinition.class);
        indexer.reindex(CPDefinition.class.getName(), cpDefinitionId);
    }
}

