/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.product.service.impl;

import com.liferay.commerce.product.exception.NoSuchCPDefinitionException;
import com.liferay.commerce.product.model.CPDefinition;
import com.liferay.commerce.product.model.CPDefinitionLink;
import com.liferay.commerce.product.model.CProduct;
import com.liferay.commerce.product.model.CommerceCatalog;
import com.liferay.commerce.product.service.base.CPDefinitionLinkServiceBaseImpl;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.ClassedModel;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermissionFactory;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.OrderByComparator;
import java.util.List;

public class CPDefinitionLinkServiceImpl
extends CPDefinitionLinkServiceBaseImpl {
    private static volatile ModelResourcePermission<CommerceCatalog> _commerceCatalogModelResourcePermission = ModelResourcePermissionFactory.getInstance(CPDefinitionLinkServiceImpl.class, (String)"_commerceCatalogModelResourcePermission", CommerceCatalog.class);

    public CPDefinitionLink addCPDefinitionLink(long cpDefinitionId, long cProductId, double priority, String type, ServiceContext serviceContext) throws PortalException {
        this._checkCommerceCatalog(cpDefinitionId, "UPDATE");
        return this.cpDefinitionLinkLocalService.addCPDefinitionLinkByCProductId(cpDefinitionId, cProductId, priority, type, serviceContext);
    }

    public void deleteCPDefinitionLink(long cpDefinitionLinkId) throws PortalException {
        CPDefinitionLink cpDefinitionLink = this.cpDefinitionLinkLocalService.getCPDefinitionLink(cpDefinitionLinkId);
        this._checkCommerceCatalog(cpDefinitionLink.getCPDefinitionId(), "UPDATE");
        CProduct cProduct = cpDefinitionLink.getCProduct();
        this._checkCommerceCatalog(cProduct.getPublishedCPDefinitionId(), "UPDATE");
        this.cpDefinitionLinkLocalService.deleteCPDefinitionLink(cpDefinitionLinkId);
    }

    public CPDefinitionLink fetchCPDefinitionLink(long cpDefinitionLinkId) throws PortalException {
        CPDefinitionLink cpDefinitionLink = this.cpDefinitionLinkLocalService.fetchCPDefinitionLink(cpDefinitionLinkId);
        if (cpDefinitionLink != null) {
            this._checkCommerceCatalog(cpDefinitionLink.getCPDefinitionId(), "VIEW");
            CProduct cProduct = cpDefinitionLink.getCProduct();
            this._checkCommerceCatalog(cProduct.getPublishedCPDefinitionId(), "VIEW");
        }
        return cpDefinitionLink;
    }

    public CPDefinitionLink getCPDefinitionLink(long cpDefinitionLinkId) throws PortalException {
        CPDefinitionLink cpDefinitionLink = this.cpDefinitionLinkLocalService.getCPDefinitionLink(cpDefinitionLinkId);
        CProduct cProduct = cpDefinitionLink.getCProduct();
        this._checkCommerceCatalog(cProduct.getPublishedCPDefinitionId(), "VIEW");
        this._checkCommerceCatalog(cpDefinitionLink.getCPDefinitionId(), "VIEW");
        return this.cpDefinitionLinkLocalService.getCPDefinitionLink(cpDefinitionLinkId);
    }

    public List<CPDefinitionLink> getCPDefinitionLinks(long cpDefinitionId) throws PortalException {
        this._checkCommerceCatalog(cpDefinitionId, "VIEW");
        return this.cpDefinitionLinkLocalService.getCPDefinitionLinks(cpDefinitionId);
    }

    public List<CPDefinitionLink> getCPDefinitionLinks(long cpDefinitionId, int start, int end) throws PortalException {
        this._checkCommerceCatalog(cpDefinitionId, "VIEW");
        return this.cpDefinitionLinkLocalService.getCPDefinitionLinks(cpDefinitionId, start, end);
    }

    public List<CPDefinitionLink> getCPDefinitionLinks(long cpDefinitionId, String type) throws PortalException {
        this._checkCommerceCatalog(cpDefinitionId, "VIEW");
        return this.cpDefinitionLinkLocalService.getCPDefinitionLinks(cpDefinitionId, type);
    }

    public List<CPDefinitionLink> getCPDefinitionLinks(long cpDefinitionId, String type, int start, int end, OrderByComparator<CPDefinitionLink> orderByComparator) throws PortalException {
        this._checkCommerceCatalog(cpDefinitionId, "VIEW");
        return this.cpDefinitionLinkLocalService.getCPDefinitionLinks(cpDefinitionId, type, start, end, orderByComparator);
    }

    public int getCPDefinitionLinksCount(long cpDefinitionId) throws PortalException {
        this._checkCommerceCatalog(cpDefinitionId, "VIEW");
        return this.cpDefinitionLinkLocalService.getCPDefinitionLinksCount(cpDefinitionId);
    }

    public int getCPDefinitionLinksCount(long cpDefinitionId, String type) throws PortalException {
        this._checkCommerceCatalog(cpDefinitionId, "VIEW");
        return this.cpDefinitionLinkLocalService.getCPDefinitionLinksCount(cpDefinitionId, type);
    }

    public CPDefinitionLink updateCPDefinitionLink(long cpDefinitionLinkId, double priority, ServiceContext serviceContext) throws PortalException {
        CPDefinitionLink cpDefinitionLink = this.cpDefinitionLinkLocalService.getCPDefinitionLink(cpDefinitionLinkId);
        this._checkCommerceCatalog(cpDefinitionLink.getCPDefinitionId(), "UPDATE");
        CProduct cProduct = cpDefinitionLink.getCProduct();
        this._checkCommerceCatalog(cProduct.getPublishedCPDefinitionId(), "UPDATE");
        return this.cpDefinitionLinkLocalService.updateCPDefinitionLink(cpDefinitionLinkId, priority, serviceContext);
    }

    public void updateCPDefinitionLinks(long cpDefinitionId, long[] cpDefinitionIds2, String type, ServiceContext serviceContext) throws PortalException {
        this._checkCommerceCatalog(cpDefinitionId, "UPDATE");
        this.cpDefinitionLinkLocalService.updateCPDefinitionLinks(cpDefinitionId, cpDefinitionIds2, type, serviceContext);
    }

    private void _checkCommerceCatalog(long cpDefinitionId, String actionId) throws PortalException {
        CPDefinition cpDefinition = this.cpDefinitionLocalService.fetchCPDefinition(cpDefinitionId);
        if (cpDefinition == null) {
            throw new NoSuchCPDefinitionException();
        }
        CommerceCatalog commerceCatalog = this.commerceCatalogLocalService.fetchCommerceCatalogByGroupId(cpDefinition.getGroupId());
        if (commerceCatalog == null) {
            throw new PrincipalException();
        }
        _commerceCatalogModelResourcePermission.check(this.getPermissionChecker(), (ClassedModel)commerceCatalog, actionId);
    }
}

