/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.product.service.impl;

import com.liferay.asset.kernel.model.AssetEntry;
import com.liferay.commerce.product.configuration.CProductVersionConfiguration;
import com.liferay.commerce.product.exception.CPDefinitionDisplayDateException;
import com.liferay.commerce.product.exception.CPDefinitionExpirationDateException;
import com.liferay.commerce.product.exception.CPDefinitionIgnoreSKUCombinationsException;
import com.liferay.commerce.product.exception.CPDefinitionMetaDescriptionException;
import com.liferay.commerce.product.exception.CPDefinitionMetaKeywordsException;
import com.liferay.commerce.product.exception.CPDefinitionMetaTitleException;
import com.liferay.commerce.product.exception.CPDefinitionProductTypeNameException;
import com.liferay.commerce.product.model.CPAttachmentFileEntry;
import com.liferay.commerce.product.model.CPDefinition;
import com.liferay.commerce.product.model.CPDefinitionLink;
import com.liferay.commerce.product.model.CPDefinitionLocalization;
import com.liferay.commerce.product.model.CPDefinitionOptionRel;
import com.liferay.commerce.product.model.CPDefinitionOptionValueRel;
import com.liferay.commerce.product.model.CPDefinitionSpecificationOptionValue;
import com.liferay.commerce.product.model.CPDisplayLayout;
import com.liferay.commerce.product.model.CPInstance;
import com.liferay.commerce.product.model.CProduct;
import com.liferay.commerce.product.model.impl.CPDefinitionImpl;
import com.liferay.commerce.product.service.base.CPDefinitionLocalServiceBaseImpl;
import com.liferay.commerce.product.type.CPType;
import com.liferay.commerce.product.type.CPTypeServicesTracker;
import com.liferay.commerce.product.util.CPVersionContributor;
import com.liferay.commerce.product.util.CPVersionContributorRegistryUtil;
import com.liferay.dynamic.data.mapping.exception.NoSuchStructureException;
import com.liferay.dynamic.data.mapping.model.DDMStructure;
import com.liferay.dynamic.data.mapping.service.DDMStructureLocalService;
import com.liferay.friendly.url.model.FriendlyURLEntry;
import com.liferay.friendly.url.model.FriendlyURLEntryLocalization;
import com.liferay.friendly.url.service.FriendlyURLEntryLocalService;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.dao.orm.QueryDefinition;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.module.configuration.ConfigurationProviderUtil;
import com.liferay.portal.kernel.search.BaseModelSearchResult;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.Hits;
import com.liferay.portal.kernel.search.Indexable;
import com.liferay.portal.kernel.search.IndexableType;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerRegistryUtil;
import com.liferay.portal.kernel.search.QueryConfig;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.SearchException;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.search.facet.Facet;
import com.liferay.portal.kernel.search.facet.MultiValueFacet;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.settings.SettingsLocator;
import com.liferay.portal.kernel.settings.SystemSettingsLocator;
import com.liferay.portal.kernel.systemevent.SystemEvent;
import com.liferay.portal.kernel.transaction.TransactionCommitCallbackUtil;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.LinkedHashMapBuilder;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.OrderByComparatorFactoryUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.uuid.PortalUUIDUtil;
import com.liferay.portal.kernel.workflow.WorkflowHandlerRegistryUtil;
import com.liferay.portal.spring.extender.service.ServiceReference;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.Callable;
import java.util.stream.LongStream;
import java.util.stream.Stream;
import javax.servlet.http.HttpServletRequest;

public class CPDefinitionLocalServiceImpl
extends CPDefinitionLocalServiceBaseImpl {
    private static final String[] _SELECTED_FIELD_NAMES = new String[]{"entryClassPK", "companyId", "groupId", "uid"};
    private static final Log _log = LogFactoryUtil.getLog(CPDefinitionLocalServiceImpl.class);
    @ServiceReference(type=CPTypeServicesTracker.class)
    private CPTypeServicesTracker _cpTypeServicesTracker;
    @ServiceReference(type=DDMStructureLocalService.class)
    private DDMStructureLocalService _ddmStructureLocalService;
    @ServiceReference(type=FriendlyURLEntryLocalService.class)
    private FriendlyURLEntryLocalService _friendlyURLEntryLocalService;
    @ServiceReference(type=GroupLocalService.class)
    private GroupLocalService _groupLocalService;

    @Indexable(type=IndexableType.REINDEX)
    public CPDefinition addCPDefinition(String externalReferenceCode, long groupId, long userId, Map<Locale, String> nameMap, Map<Locale, String> shortDescriptionMap, Map<Locale, String> descriptionMap, Map<Locale, String> urlTitleMap, Map<Locale, String> metaTitleMap, Map<Locale, String> metaDescriptionMap, Map<Locale, String> metaKeywordsMap, String productTypeName, boolean ignoreSKUCombinations, boolean shippable, boolean freeShipping, boolean shipSeparately, double shippingExtraPrice, double width, double height, double depth, double weight, long cpTaxCategoryId, boolean taxExempt, boolean telcoOrElectronics, String ddmStructureKey, boolean published, int displayDateMonth, int displayDateDay, int displayDateYear, int displayDateHour, int displayDateMinute, int expirationDateMonth, int expirationDateDay, int expirationDateYear, int expirationDateHour, int expirationDateMinute, boolean neverExpire, String defaultSku, boolean subscriptionEnabled, int subscriptionLength, String subscriptionType, UnicodeProperties subscriptionTypeSettingsUnicodeProperties, long maxSubscriptionCycles, boolean deliverySubscriptionEnabled, int deliverySubscriptionLength, String deliverySubscriptionType, UnicodeProperties deliverySubscriptionTypeSettingsUnicodeProperties, long deliveryMaxSubscriptionCycles, ServiceContext serviceContext) throws PortalException {
        User user = this.userLocalService.getUser(userId);
        Date expirationDate = null;
        Date date = new Date();
        Date displayDate = PortalUtil.getDate((int)displayDateMonth, (int)displayDateDay, (int)displayDateYear, (int)displayDateHour, (int)displayDateMinute, (TimeZone)user.getTimeZone(), CPDefinitionDisplayDateException.class);
        if (!neverExpire) {
            expirationDate = PortalUtil.getDate((int)expirationDateMonth, (int)expirationDateDay, (int)expirationDateYear, (int)expirationDateHour, (int)expirationDateMinute, (TimeZone)user.getTimeZone(), CPDefinitionExpirationDateException.class);
        }
        if (Validator.isBlank((String)externalReferenceCode)) {
            externalReferenceCode = null;
        }
        this.validate(groupId, ddmStructureKey, metaTitleMap, metaDescriptionMap, metaKeywordsMap, displayDate, expirationDate, productTypeName);
        long cpDefinitionId = this.counterLocalService.increment();
        CPDefinition cpDefinition = this.cpDefinitionPersistence.create(cpDefinitionId);
        CProduct cProduct = this.cProductLocalService.addCProduct(externalReferenceCode, groupId, userId, new ServiceContext());
        cpDefinition.setGroupId(groupId);
        cpDefinition.setCompanyId(user.getCompanyId());
        cpDefinition.setUserId(user.getUserId());
        cpDefinition.setUserName(user.getFullName());
        cpDefinition.setCProductId(cProduct.getCProductId());
        cpDefinition.setCPTaxCategoryId(cpTaxCategoryId);
        cpDefinition.setProductTypeName(productTypeName);
        cpDefinition.setIgnoreSKUCombinations(ignoreSKUCombinations);
        cpDefinition.setShippable(shippable);
        cpDefinition.setFreeShipping(freeShipping);
        cpDefinition.setShipSeparately(shipSeparately);
        cpDefinition.setShippingExtraPrice(shippingExtraPrice);
        cpDefinition.setWidth(width);
        cpDefinition.setHeight(height);
        cpDefinition.setDepth(depth);
        cpDefinition.setWeight(weight);
        cpDefinition.setTaxExempt(taxExempt);
        cpDefinition.setTelcoOrElectronics(telcoOrElectronics);
        cpDefinition.setDDMStructureKey(ddmStructureKey);
        cpDefinition.setPublished(published);
        cpDefinition.setDisplayDate(displayDate);
        cpDefinition.setExpirationDate(expirationDate);
        cpDefinition.setSubscriptionEnabled(subscriptionEnabled);
        cpDefinition.setSubscriptionLength(subscriptionLength);
        cpDefinition.setSubscriptionType(subscriptionType);
        cpDefinition.setSubscriptionTypeSettingsProperties(subscriptionTypeSettingsUnicodeProperties);
        cpDefinition.setMaxSubscriptionCycles(maxSubscriptionCycles);
        cpDefinition.setDeliverySubscriptionEnabled(deliverySubscriptionEnabled);
        cpDefinition.setDeliverySubscriptionLength(deliverySubscriptionLength);
        cpDefinition.setDeliverySubscriptionType(deliverySubscriptionType);
        cpDefinition.setDeliverySubscriptionTypeSettingsProperties(deliverySubscriptionTypeSettingsUnicodeProperties);
        cpDefinition.setDeliveryMaxSubscriptionCycles(deliveryMaxSubscriptionCycles);
        cpDefinition.setAccountGroupFilterEnabled(false);
        cpDefinition.setChannelFilterEnabled(false);
        cpDefinition.setVersion(1);
        if (expirationDate == null || expirationDate.after(date)) {
            cpDefinition.setStatus(2);
        } else {
            cpDefinition.setStatus(3);
        }
        cpDefinition.setStatusByUserId(user.getUserId());
        cpDefinition.setStatusDate(serviceContext.getModifiedDate(date));
        cpDefinition.setExpandoBridgeAttributes(serviceContext);
        cpDefinition = (CPDefinition)this.cpDefinitionPersistence.update((BaseModel)cpDefinition);
        this._addCPDefinitionLocalizedFields(user.getCompanyId(), cpDefinitionId, nameMap, shortDescriptionMap, descriptionMap, metaTitleMap, metaDescriptionMap, metaKeywordsMap);
        if (Validator.isNotNull((String)defaultSku)) {
            ServiceContext cpInstanceServiceContext = new ServiceContext();
            cpInstanceServiceContext.setScopeGroupId(groupId);
            cpInstanceServiceContext.setUserId(userId);
            this.cpInstanceLocalService.addCPInstance(externalReferenceCode, cpDefinitionId, groupId, defaultSku, null, null, published, null, cpDefinition.getWidth(), cpDefinition.getHeight(), cpDefinition.getDepth(), cpDefinition.getWeight(), BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, published, displayDateMonth, displayDateDay, displayDateYear, displayDateHour, displayDateMinute, expirationDateMonth, expirationDateDay, expirationDateYear, expirationDateHour, expirationDateMinute, neverExpire, cpInstanceServiceContext);
        }
        Group companyGroup = this._groupLocalService.getCompanyGroup(cpDefinition.getCompanyId());
        Map<Object, Object> newURLTitleMap = new HashMap();
        newURLTitleMap = MapUtil.isEmpty(urlTitleMap) ? this._getUniqueUrlTitles(cpDefinition, nameMap) : this._getUniqueUrlTitles(cpDefinition, urlTitleMap);
        this._friendlyURLEntryLocalService.addFriendlyURLEntry(companyGroup.getGroupId(), this.classNameLocalService.getClassNameId(CProduct.class), cProduct.getCProductId(), newURLTitleMap, serviceContext);
        this.updateAsset(user.getUserId(), cpDefinition, serviceContext.getAssetCategoryIds(), serviceContext.getAssetTagNames(), serviceContext.getAssetLinkEntryIds(), serviceContext.getAssetPriority());
        return this.startWorkflowInstance(user.getUserId(), cpDefinition, serviceContext);
    }

    @Indexable(type=IndexableType.REINDEX)
    public CPDefinition addCPDefinition(String externalReferenceCode, long groupId, long userId, Map<Locale, String> nameMap, Map<Locale, String> shortDescriptionMap, Map<Locale, String> descriptionMap, Map<Locale, String> urlTitleMap, Map<Locale, String> metaTitleMap, Map<Locale, String> metaDescriptionMap, Map<Locale, String> metaKeywordsMap, String productTypeName, boolean ignoreSKUCombinations, boolean shippable, boolean freeShipping, boolean shipSeparately, double shippingExtraPrice, double width, double height, double depth, double weight, long cpTaxCategoryId, boolean taxExempt, boolean telcoOrElectronics, String ddmStructureKey, boolean published, int displayDateMonth, int displayDateDay, int displayDateYear, int displayDateHour, int displayDateMinute, int expirationDateMonth, int expirationDateDay, int expirationDateYear, int expirationDateHour, int expirationDateMinute, boolean neverExpire, String defaultSku, boolean subscriptionEnabled, int subscriptionLength, String subscriptionType, UnicodeProperties subscriptionTypeSettingsUnicodeProperties, long maxSubscriptionCycles, ServiceContext serviceContext) throws PortalException {
        return this.cpDefinitionLocalService.addCPDefinition(externalReferenceCode, groupId, userId, nameMap, shortDescriptionMap, descriptionMap, urlTitleMap, metaTitleMap, metaDescriptionMap, metaKeywordsMap, productTypeName, ignoreSKUCombinations, shippable, freeShipping, shipSeparately, shippingExtraPrice, width, height, depth, weight, cpTaxCategoryId, taxExempt, telcoOrElectronics, ddmStructureKey, published, displayDateMonth, displayDateDay, displayDateYear, displayDateHour, displayDateMinute, expirationDateMonth, expirationDateDay, expirationDateYear, expirationDateHour, expirationDateMinute, neverExpire, defaultSku, subscriptionEnabled, subscriptionLength, subscriptionType, subscriptionTypeSettingsUnicodeProperties, maxSubscriptionCycles, false, 1, null, null, 0L, serviceContext);
    }

    public CPDefinition addOrUpdateCPDefinition(String externalReferenceCode, long groupId, long userId, Map<Locale, String> nameMap, Map<Locale, String> shortDescriptionMap, Map<Locale, String> descriptionMap, Map<Locale, String> urlTitleMap, Map<Locale, String> metaTitleMap, Map<Locale, String> metaDescriptionMap, Map<Locale, String> metaKeywordsMap, String productTypeName, boolean ignoreSKUCombinations, boolean shippable, boolean freeShipping, boolean shipSeparately, double shippingExtraPrice, double width, double height, double depth, double weight, long cpTaxCategoryId, boolean taxExempt, boolean telcoOrElectronics, String ddmStructureKey, boolean published, int displayDateMonth, int displayDateDay, int displayDateYear, int displayDateHour, int displayDateMinute, int expirationDateMonth, int expirationDateDay, int expirationDateYear, int expirationDateHour, int expirationDateMinute, boolean neverExpire, String defaultSku, boolean subscriptionEnabled, int subscriptionLength, String subscriptionType, UnicodeProperties subscriptionTypeSettingsUnicodeProperties, long maxSubscriptionCycles, boolean deliverySubscriptionEnabled, int deliverySubscriptionLength, String deliverySubscriptionType, UnicodeProperties deliverySubscriptionTypeSettingsUnicodeProperties, long deliveryMaxSubscriptionCycles, ServiceContext serviceContext) throws PortalException {
        if (Validator.isBlank((String)externalReferenceCode)) {
            externalReferenceCode = null;
        } else {
            CProduct cProduct = this.cProductLocalService.fetchCProductByReferenceCode(serviceContext.getCompanyId(), externalReferenceCode);
            if (cProduct != null) {
                CPDefinition cpDefinition = this.cpDefinitionLocalService.updateCPDefinition(cProduct.getPublishedCPDefinitionId(), nameMap, shortDescriptionMap, descriptionMap, urlTitleMap, metaTitleMap, metaDescriptionMap, metaKeywordsMap, ignoreSKUCombinations, shippable, freeShipping, shipSeparately, shippingExtraPrice, width, height, depth, weight, cpTaxCategoryId, taxExempt, telcoOrElectronics, ddmStructureKey, published, displayDateMonth, displayDateDay, displayDateYear, displayDateHour, displayDateMinute, expirationDateMonth, expirationDateDay, expirationDateYear, expirationDateHour, expirationDateMinute, neverExpire, serviceContext);
                return this.cpDefinitionLocalService.updateSubscriptionInfo(cpDefinition.getCPDefinitionId(), subscriptionEnabled, subscriptionLength, subscriptionType, subscriptionTypeSettingsUnicodeProperties, maxSubscriptionCycles, deliverySubscriptionEnabled, deliverySubscriptionLength, deliverySubscriptionType, deliverySubscriptionTypeSettingsUnicodeProperties, deliveryMaxSubscriptionCycles);
            }
        }
        return this.cpDefinitionLocalService.addCPDefinition(externalReferenceCode, groupId, userId, nameMap, shortDescriptionMap, descriptionMap, urlTitleMap, metaTitleMap, metaDescriptionMap, metaKeywordsMap, productTypeName, ignoreSKUCombinations, shippable, freeShipping, shipSeparately, shippingExtraPrice, width, height, depth, weight, cpTaxCategoryId, taxExempt, telcoOrElectronics, ddmStructureKey, published, displayDateMonth, displayDateDay, displayDateYear, displayDateHour, displayDateMinute, expirationDateMonth, expirationDateDay, expirationDateYear, expirationDateHour, expirationDateMinute, neverExpire, defaultSku, subscriptionEnabled, subscriptionLength, subscriptionType, subscriptionTypeSettingsUnicodeProperties, maxSubscriptionCycles, deliverySubscriptionEnabled, deliverySubscriptionLength, deliverySubscriptionType, deliverySubscriptionTypeSettingsUnicodeProperties, deliveryMaxSubscriptionCycles, serviceContext);
    }

    public CPDefinition addOrUpdateCPDefinition(String externalReferenceCode, long groupId, long userId, Map<Locale, String> nameMap, Map<Locale, String> shortDescriptionMap, Map<Locale, String> descriptionMap, Map<Locale, String> urlTitleMap, Map<Locale, String> metaTitleMap, Map<Locale, String> metaDescriptionMap, Map<Locale, String> metaKeywordsMap, String productTypeName, boolean ignoreSKUCombinations, boolean shippable, boolean freeShipping, boolean shipSeparately, double shippingExtraPrice, double width, double height, double depth, double weight, long cpTaxCategoryId, boolean taxExempt, boolean telcoOrElectronics, String ddmStructureKey, boolean published, int displayDateMonth, int displayDateDay, int displayDateYear, int displayDateHour, int displayDateMinute, int expirationDateMonth, int expirationDateDay, int expirationDateYear, int expirationDateHour, int expirationDateMinute, boolean neverExpire, String defaultSku, boolean subscriptionEnabled, int subscriptionLength, String subscriptionType, UnicodeProperties subscriptionTypeSettingsUnicodeProperties, long maxSubscriptionCycles, ServiceContext serviceContext) throws PortalException {
        return this.cpDefinitionLocalService.addOrUpdateCPDefinition(externalReferenceCode, groupId, userId, nameMap, shortDescriptionMap, descriptionMap, urlTitleMap, metaTitleMap, metaDescriptionMap, metaKeywordsMap, productTypeName, ignoreSKUCombinations, shippable, freeShipping, shipSeparately, shippingExtraPrice, width, height, depth, weight, cpTaxCategoryId, taxExempt, telcoOrElectronics, ddmStructureKey, published, displayDateMonth, displayDateDay, displayDateYear, displayDateHour, displayDateMinute, expirationDateMonth, expirationDateDay, expirationDateYear, expirationDateHour, expirationDateMinute, neverExpire, defaultSku, subscriptionEnabled, subscriptionLength, subscriptionType, subscriptionTypeSettingsUnicodeProperties, maxSubscriptionCycles, false, 1, null, null, 0L, serviceContext);
    }

    public void checkCPDefinitions() throws PortalException {
        this.checkCPDefinitionsByDisplayDate();
        this.checkCPDefinitionsByExpirationDate();
    }

    public CPDefinition copyCPDefinition(long cpDefinitionId) throws PortalException {
        CPDefinition cpDefinition = this.cpDefinitionLocalService.getCPDefinition(cpDefinitionId);
        return this.copyCPDefinition(cpDefinitionId, cpDefinition.getGroupId());
    }

    @Indexable(type=IndexableType.REINDEX)
    public CPDefinition copyCPDefinition(long cpDefinitionId, long groupId) throws PortalException {
        CPDefinition originalCPDefinition = this.cpDefinitionLocalService.getCPDefinition(cpDefinitionId);
        CPDefinition newCPDefinition = (CPDefinition)originalCPDefinition.clone();
        long newCPDefinitionId = this.counterLocalService.increment();
        newCPDefinition.setCPDefinitionId(newCPDefinitionId);
        if (originalCPDefinition.isPublished() && this.cpDefinitionLocalService.isVersionable(originalCPDefinition)) {
            originalCPDefinition.setPublished(false);
            originalCPDefinition = (CPDefinition)this.cpDefinitionPersistence.update((BaseModel)originalCPDefinition);
            newCPDefinition.setVersion(this.cProductLocalService.increment(originalCPDefinition.getCProductId()));
        } else {
            CProduct originalCProduct = originalCPDefinition.getCProduct();
            CProduct newCProduct = (CProduct)originalCProduct.clone();
            newCProduct.setCProductId(this.counterLocalService.increment());
            newCProduct.setUuid(PortalUUIDUtil.generate());
            newCProduct.setPublishedCPDefinitionId(newCPDefinitionId);
            newCPDefinition.setCProductId(newCProduct.getCProductId());
            this.cProductPersistence.update((BaseModel)newCProduct);
        }
        newCPDefinition.setGroupId(groupId);
        newCPDefinition.setUuid(PortalUUIDUtil.generate());
        newCPDefinition = (CPDefinition)this.cpDefinitionPersistence.update((BaseModel)newCPDefinition);
        long cpDefinitionClassNameId = this.classNameLocalService.getClassNameId(CPDefinition.class);
        AssetEntry assetEntry = this.assetEntryLocalService.fetchEntry(cpDefinitionClassNameId, cpDefinitionId);
        if (assetEntry != null) {
            AssetEntry newAssetEntry = (AssetEntry)assetEntry.clone();
            newAssetEntry.setEntryId(this.counterLocalService.increment());
            newAssetEntry.setClassPK(newCPDefinitionId);
            this.assetEntryLocalService.addAssetEntry(newAssetEntry);
        }
        List cpDefinitionLocalizations = this.cpDefinitionLocalizationPersistence.findByCPDefinitionId(cpDefinitionId);
        for (Object cpDefinitionLocalization : cpDefinitionLocalizations) {
            CPDefinitionLocalization newCPDefinitionLocalization = (CPDefinitionLocalization)cpDefinitionLocalization.clone();
            newCPDefinitionLocalization.setCpDefinitionLocalizationId(this.counterLocalService.increment());
            newCPDefinitionLocalization.setCPDefinitionId(newCPDefinitionId);
            if (originalCPDefinition.getCProductId() != newCPDefinition.getCProductId()) {
                newCPDefinitionLocalization.setName(LanguageUtil.format((Locale)LocaleUtil.fromLanguageId((String)newCPDefinitionLocalization.getLanguageId()), (String)"copy-of-x", (Object)newCPDefinitionLocalization.getName()));
            }
            this.cpDefinitionLocalizationPersistence.update((BaseModel)newCPDefinitionLocalization);
        }
        List cpAttachmentFileEntries = this.cpAttachmentFileEntryPersistence.findByC_C(cpDefinitionClassNameId, cpDefinitionId);
        for (Object cpAttachmentFileEntry : cpAttachmentFileEntries) {
            CPAttachmentFileEntry newCPAttachmentFileEntry = (CPAttachmentFileEntry)cpAttachmentFileEntry.clone();
            newCPAttachmentFileEntry.setUuid(PortalUUIDUtil.generate());
            newCPAttachmentFileEntry.setCPAttachmentFileEntryId(this.counterLocalService.increment());
            newCPAttachmentFileEntry.setClassPK(newCPDefinitionId);
            this.cpAttachmentFileEntryPersistence.update((BaseModel)newCPAttachmentFileEntry);
        }
        List cpDefinitionLinks = this.cpDefinitionLinkPersistence.findByCPDefinitionId(cpDefinitionId);
        for (Object cpDefinitionLink : cpDefinitionLinks) {
            CPDefinitionLink newCPDefinitionLink = (CPDefinitionLink)cpDefinitionLink.clone();
            newCPDefinitionLink.setUuid(PortalUUIDUtil.generate());
            newCPDefinitionLink.setCPDefinitionLinkId(this.counterLocalService.increment());
            newCPDefinitionLink.setCPDefinitionId(newCPDefinitionId);
            this.cpDefinitionLinkPersistence.update((BaseModel)newCPDefinitionLink);
        }
        List cpDefinitionOptionRels = this.cpDefinitionOptionRelPersistence.findByCPDefinitionId(cpDefinitionId);
        for (Object cpDefinitionOptionRel : cpDefinitionOptionRels) {
            CPDefinitionOptionRel newCPDefinitionOptionRel = (CPDefinitionOptionRel)cpDefinitionOptionRel.clone();
            newCPDefinitionOptionRel.setUuid(PortalUUIDUtil.generate());
            long newCPDefinitionOptionRelId = this.counterLocalService.increment();
            newCPDefinitionOptionRel.setCPDefinitionOptionRelId(newCPDefinitionOptionRelId);
            newCPDefinitionOptionRel.setCPDefinitionId(newCPDefinitionId);
            this.cpDefinitionOptionRelPersistence.update((BaseModel)newCPDefinitionOptionRel);
            List cpDefinitionOptionValueRels = this.cpDefinitionOptionValueRelPersistence.findByCPDefinitionOptionRelId(cpDefinitionOptionRel.getCPDefinitionOptionRelId());
            for (CPDefinitionOptionValueRel cpDefinitionOptionValueRel : cpDefinitionOptionValueRels) {
                CPDefinitionOptionValueRel newCPDefinitionOptionValueRel = (CPDefinitionOptionValueRel)cpDefinitionOptionValueRel.clone();
                newCPDefinitionOptionValueRel.setUuid(PortalUUIDUtil.generate());
                newCPDefinitionOptionValueRel.setCPDefinitionOptionValueRelId(this.counterLocalService.increment());
                newCPDefinitionOptionValueRel.setCPDefinitionOptionRelId(newCPDefinitionOptionRelId);
                this.cpDefinitionOptionValueRelPersistence.update((BaseModel)newCPDefinitionOptionValueRel);
            }
        }
        List cpDefinitionSpecificationOptionValues = this.cpDefinitionSpecificationOptionValuePersistence.findByCPDefinitionId(cpDefinitionId);
        for (Object cpDefinitionSpecificationOptionValue : cpDefinitionSpecificationOptionValues) {
            CPDefinitionSpecificationOptionValue newCPDefinitionSpecificationOptionValue = (CPDefinitionSpecificationOptionValue)cpDefinitionSpecificationOptionValue.clone();
            newCPDefinitionSpecificationOptionValue.setUuid(PortalUUIDUtil.generate());
            newCPDefinitionSpecificationOptionValue.setCPDefinitionSpecificationOptionValueId(this.counterLocalService.increment());
            newCPDefinitionSpecificationOptionValue.setCPDefinitionId(newCPDefinitionId);
            this.cpDefinitionSpecificationOptionValuePersistence.update((BaseModel)newCPDefinitionSpecificationOptionValue);
        }
        List cpDisplayLayouts = this.cpDisplayLayoutPersistence.findByC_C(cpDefinitionClassNameId, cpDefinitionId);
        for (CPDisplayLayout cpDisplayLayout : cpDisplayLayouts) {
            CPDisplayLayout newCPDisplayLayout = (CPDisplayLayout)cpDisplayLayout.clone();
            newCPDisplayLayout.setUuid(PortalUUIDUtil.generate());
            newCPDisplayLayout.setCPDisplayLayoutId(this.counterLocalService.increment());
            newCPDisplayLayout.setClassPK(newCPDefinitionId);
            this.cpDisplayLayoutPersistence.update((BaseModel)newCPDisplayLayout);
        }
        List cpInstances = this.cpInstancePersistence.findByCPDefinitionId(cpDefinitionId);
        for (Object cpInstance : cpInstances) {
            CPInstance newCPInstance = (CPInstance)cpInstance.clone();
            newCPInstance.setUuid(PortalUUIDUtil.generate());
            newCPInstance.setCPInstanceId(this.counterLocalService.increment());
            newCPInstance.setCPDefinitionId(newCPDefinitionId);
            this.cpInstancePersistence.update((BaseModel)newCPInstance);
        }
        List cpVersionContributors = CPVersionContributorRegistryUtil.getCPVersionContributors();
        for (CPVersionContributor cpVersionContributor : cpVersionContributors) {
            cpVersionContributor.onUpdate(cpDefinitionId, newCPDefinitionId);
        }
        if (this.cpDefinitionLocalService.isVersionable(originalCPDefinition)) {
            this.cProductLocalService.updatePublishedCPDefinitionId(newCPDefinition.getCProductId(), newCPDefinition.getCPDefinitionId());
            final long cProductId = newCPDefinition.getCProductId();
            TransactionCommitCallbackUtil.registerCallback((Callable)new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    CPDefinitionLocalServiceImpl.this.cpDefinitionLocalService.maintainVersionThreshold(cProductId);
                    return null;
                }
            });
        }
        return newCPDefinition;
    }

    public void deleteAssetCategoryCPDefinition(long cpDefinitionId, long categoryId, ServiceContext serviceContext) throws PortalException {
        AssetEntry assetEntry = this.assetEntryLocalService.getEntry(CPDefinition.class.getName(), cpDefinitionId);
        long[] categoryIds = ArrayUtil.remove((long[])assetEntry.getCategoryIds(), (long)categoryId);
        serviceContext.setAssetCategoryIds(categoryIds);
        serviceContext.setAssetTagNames(assetEntry.getTagNames());
        this.cpDefinitionLocalService.updateCPDefinitionCategorization(cpDefinitionId, serviceContext);
    }

    @Override
    @Indexable(type=IndexableType.DELETE)
    @SystemEvent(type=1)
    public CPDefinition deleteCPDefinition(CPDefinition cpDefinition) throws PortalException {
        int cpDefinitionsCount = this.cpDefinitionPersistence.countByC_S(cpDefinition.getCProductId(), -1);
        if (!this._isVersioningEnabled() || this._isVersioningEnabled() && cpDefinitionsCount == 1) {
            this.cProductLocalService.deleteCProduct(cpDefinition.getCProductId());
        }
        this.cpDefinitionLocalizationPersistence.removeByCPDefinitionId(cpDefinition.getCPDefinitionId());
        this.cpDefinitionSpecificationOptionValueLocalService.deleteCPDefinitionSpecificationOptionValues(cpDefinition.getCPDefinitionId());
        this.cpInstanceLocalService.deleteCPInstances(cpDefinition.getCPDefinitionId());
        this.cpDefinitionOptionRelLocalService.deleteCPDefinitionOptionRels(cpDefinition.getCPDefinitionId());
        this.cpAttachmentFileEntryLocalService.deleteCPAttachmentFileEntries(CPDefinition.class.getName(), cpDefinition.getCPDefinitionId());
        this.cpDefinitionLinkLocalService.deleteCPDefinitionLinksByCPDefinitionId(cpDefinition.getCPDefinitionId());
        CPType cpType = this._cpTypeServicesTracker.getCPType(cpDefinition.getProductTypeName());
        if (cpType != null) {
            cpType.deleteCPDefinition(cpDefinition.getCPDefinitionId());
        }
        Group companyGroup = this._groupLocalService.getCompanyGroup(cpDefinition.getCompanyId());
        this._friendlyURLEntryLocalService.deleteFriendlyURLEntry(companyGroup.getGroupId(), CProduct.class, cpDefinition.getCProductId());
        this.cpDisplayLayoutLocalService.deleteCPDisplayLayouts(CPDefinition.class, cpDefinition.getCPDefinitionId());
        List cpVersionContributors = CPVersionContributorRegistryUtil.getCPVersionContributors();
        for (CPVersionContributor cpVersionContributor : cpVersionContributors) {
            cpVersionContributor.onDelete(cpDefinition.getCPDefinitionId());
        }
        this.cpDefinitionPersistence.remove((BaseModel)cpDefinition);
        this.assetEntryLocalService.deleteEntry(CPDefinition.class.getName(), cpDefinition.getCPDefinitionId());
        this.expandoRowLocalService.deleteRows(cpDefinition.getCPDefinitionId());
        this.workflowInstanceLinkLocalService.deleteWorkflowInstanceLinks(cpDefinition.getCompanyId(), cpDefinition.getGroupId(), CPDefinition.class.getName(), cpDefinition.getCPDefinitionId());
        return cpDefinition;
    }

    @Override
    public CPDefinition deleteCPDefinition(long cpDefinitionId) throws PortalException {
        CPDefinition cpDefinition = this.cpDefinitionPersistence.findByPrimaryKey(cpDefinitionId);
        return this.cpDefinitionLocalService.deleteCPDefinition(cpDefinition);
    }

    public void deleteCPDefinitions(long companyId) throws PortalException {
        List cpDefinitions = this.cpDefinitionPersistence.findByCompanyId(companyId);
        for (CPDefinition cpDefinition : cpDefinitions) {
            this.cpDefinitionLocalService.deleteCPDefinition(cpDefinition);
        }
    }

    public void deleteCPDefinitions(long cProductId, int status) {
        this.cpDefinitionPersistence.removeByC_S(cProductId, status);
    }

    public CPDefinition fetchCPDefinitionByCProductExternalReferenceCode(String externalReferenceCode, long companyId) {
        if (Validator.isNull((String)externalReferenceCode)) {
            return null;
        }
        CProduct cProduct = this.cProductLocalService.fetchCProductByReferenceCode(companyId, externalReferenceCode);
        if (cProduct == null) {
            return null;
        }
        CPDefinition cpDefinition = this.cpDefinitionPersistence.fetchByPrimaryKey(cProduct.getPublishedCPDefinitionId());
        if (cpDefinition != null) {
            return cpDefinition;
        }
        return this.cpDefinitionPersistence.fetchByC_V(cProduct.getCProductId(), cProduct.getLatestVersion());
    }

    public CPDefinition fetchCPDefinitionByCProductId(long cProductId) {
        CProduct cProduct = this.cProductLocalService.fetchCProduct(cProductId);
        if (cProduct == null) {
            return null;
        }
        CPDefinition cpDefinition = this.cpDefinitionPersistence.fetchByPrimaryKey(cProduct.getPublishedCPDefinitionId());
        if (cpDefinition != null) {
            return cpDefinition;
        }
        return this.cpDefinitionPersistence.fetchByC_V(cProduct.getCProductId(), cProduct.getLatestVersion());
    }

    public Map<Locale, String> getCPDefinitionDescriptionMap(long cpDefinitionId) {
        HashMap<Locale, String> cpDefinitionLocalizationDescriptionMap = new HashMap<Locale, String>();
        List cpDefinitionLocalizationList = this.cpDefinitionLocalizationPersistence.findByCPDefinitionId(cpDefinitionId);
        for (CPDefinitionLocalization cpDefinitionLocalization : cpDefinitionLocalizationList) {
            cpDefinitionLocalizationDescriptionMap.put(LocaleUtil.fromLanguageId((String)cpDefinitionLocalization.getLanguageId()), cpDefinitionLocalization.getDescription());
        }
        return cpDefinitionLocalizationDescriptionMap;
    }

    public List<String> getCPDefinitionLocalizationLanguageIds(long cpDefinitionId) {
        List cpDefinitionLocalizationList = this.cpDefinitionLocalizationPersistence.findByCPDefinitionId(cpDefinitionId);
        ArrayList<String> availableLanguageIds = new ArrayList<String>();
        for (CPDefinitionLocalization cpDefinitionLocalization : cpDefinitionLocalizationList) {
            availableLanguageIds.add(cpDefinitionLocalization.getLanguageId());
        }
        return availableLanguageIds;
    }

    public Map<Locale, String> getCPDefinitionMetaDescriptionMap(long cpDefinitionId) {
        HashMap<Locale, String> cpDefinitionLocalizationMetaDescriptionMap = new HashMap<Locale, String>();
        List cpDefinitionLocalizationList = this.cpDefinitionLocalizationPersistence.findByCPDefinitionId(cpDefinitionId);
        for (CPDefinitionLocalization cpDefinitionLocalization : cpDefinitionLocalizationList) {
            cpDefinitionLocalizationMetaDescriptionMap.put(LocaleUtil.fromLanguageId((String)cpDefinitionLocalization.getLanguageId()), cpDefinitionLocalization.getMetaDescription());
        }
        return cpDefinitionLocalizationMetaDescriptionMap;
    }

    public Map<Locale, String> getCPDefinitionMetaKeywordsMap(long cpDefinitionId) {
        HashMap<Locale, String> cpDefinitionLocalizationMetaKeywordsMap = new HashMap<Locale, String>();
        List cpDefinitionLocalizationList = this.cpDefinitionLocalizationPersistence.findByCPDefinitionId(cpDefinitionId);
        for (CPDefinitionLocalization cpDefinitionLocalization : cpDefinitionLocalizationList) {
            cpDefinitionLocalizationMetaKeywordsMap.put(LocaleUtil.fromLanguageId((String)cpDefinitionLocalization.getLanguageId()), cpDefinitionLocalization.getMetaKeywords());
        }
        return cpDefinitionLocalizationMetaKeywordsMap;
    }

    public Map<Locale, String> getCPDefinitionMetaTitleMap(long cpDefinitionId) {
        HashMap<Locale, String> cpDefinitionLocalizationMetaTitleMap = new HashMap<Locale, String>();
        List cpDefinitionLocalizationList = this.cpDefinitionLocalizationPersistence.findByCPDefinitionId(cpDefinitionId);
        for (CPDefinitionLocalization cpDefinitionLocalization : cpDefinitionLocalizationList) {
            cpDefinitionLocalizationMetaTitleMap.put(LocaleUtil.fromLanguageId((String)cpDefinitionLocalization.getLanguageId()), cpDefinitionLocalization.getMetaTitle());
        }
        return cpDefinitionLocalizationMetaTitleMap;
    }

    public Map<Locale, String> getCPDefinitionNameMap(long cpDefinitionId) {
        HashMap<Locale, String> cpDefinitionLocalizationNameMap = new HashMap<Locale, String>();
        List cpDefinitionLocalizationList = this.cpDefinitionLocalizationPersistence.findByCPDefinitionId(cpDefinitionId);
        for (CPDefinitionLocalization cpDefinitionLocalization : cpDefinitionLocalizationList) {
            cpDefinitionLocalizationNameMap.put(LocaleUtil.fromLanguageId((String)cpDefinitionLocalization.getLanguageId()), cpDefinitionLocalization.getName());
        }
        return cpDefinitionLocalizationNameMap;
    }

    public List<CPDefinition> getCPDefinitions(long groupId, boolean subscriptionEnabled) {
        return this.cpDefinitionPersistence.findByG_SE(groupId, subscriptionEnabled);
    }

    public List<CPDefinition> getCPDefinitions(long groupId, int status, int start, int end) {
        if (status == -1) {
            return this.cpDefinitionPersistence.findByGroupId(groupId, start, end);
        }
        return this.cpDefinitionPersistence.findByG_S(groupId, status, start, end);
    }

    public List<CPDefinition> getCPDefinitions(long groupId, int status, int start, int end, OrderByComparator<CPDefinition> orderByComparator) {
        if (status == -1) {
            return this.cpDefinitionPersistence.findByGroupId(groupId, start, end, orderByComparator);
        }
        return this.cpDefinitionPersistence.findByG_S(groupId, status, start, end, orderByComparator);
    }

    public List<CPDefinition> getCPDefinitions(long groupId, String productTypeName, String languageId, int status, int start, int end, OrderByComparator<CPDefinition> orderByComparator) {
        QueryDefinition queryDefinition = new QueryDefinition(status, start, end, orderByComparator);
        return this.cpDefinitionFinder.findByG_P_S(groupId, productTypeName, languageId, queryDefinition);
    }

    public int getCPDefinitionsCount(long groupId, boolean subscriptionEnabled) {
        return this.cpDefinitionPersistence.countByG_SE(groupId, subscriptionEnabled);
    }

    public int getCPDefinitionsCount(long groupId, int status) {
        if (status == -1) {
            return this.cpDefinitionPersistence.countByGroupId(groupId);
        }
        return this.cpDefinitionPersistence.countByG_S(groupId, status);
    }

    public int getCPDefinitionsCount(long groupId, String productTypeName, String languageId, int status) {
        QueryDefinition queryDefinition = new QueryDefinition(status);
        return this.cpDefinitionFinder.countByG_P_S(groupId, productTypeName, languageId, queryDefinition);
    }

    public Map<Locale, String> getCPDefinitionShortDescriptionMap(long cpDefinitionId) {
        HashMap<Locale, String> cpDefinitionLocalizationShortDescriptionMap = new HashMap<Locale, String>();
        List cpDefinitionLocalizationList = this.cpDefinitionLocalizationPersistence.findByCPDefinitionId(cpDefinitionId);
        for (CPDefinitionLocalization cpDefinitionLocalization : cpDefinitionLocalizationList) {
            cpDefinitionLocalizationShortDescriptionMap.put(LocaleUtil.fromLanguageId((String)cpDefinitionLocalization.getLanguageId()), cpDefinitionLocalization.getShortDescription());
        }
        return cpDefinitionLocalizationShortDescriptionMap;
    }

    public CPAttachmentFileEntry getDefaultImage(long cpDefinitionId) throws PortalException {
        long classNameId = this.classNameLocalService.getClassNameId(CPDefinition.class);
        List cpAttachmentFileEntries = this.cpAttachmentFileEntryLocalService.getCPAttachmentFileEntries(classNameId, cpDefinitionId, 0, 0, 0, 1);
        if (cpAttachmentFileEntries.isEmpty()) {
            return null;
        }
        return (CPAttachmentFileEntry)cpAttachmentFileEntries.get(0);
    }

    public List<Facet> getFacets(String filterFields, String filterValues, SearchContext searchContext) {
        ArrayList<Facet> facets = new ArrayList<Facet>();
        if (Validator.isNotNull((String)filterFields) && Validator.isNotNull((String)filterValues)) {
            HashMap facetMap = new HashMap();
            String[] filterFieldsArray = StringUtil.split((String)filterFields);
            String[] filterValuesArray = StringUtil.split((String)filterValues);
            for (int i = 0; i < filterFieldsArray.length; ++i) {
                String key = filterFieldsArray[i];
                String value = filterValuesArray[i];
                if (key.startsWith("OPTION_")) {
                    key = StringUtil.removeSubstring((String)key, (String)"OPTION_");
                    key = this._getIndexFieldName(key, searchContext.getLanguageId());
                }
                ArrayList<String> facetValues = null;
                if (facetMap.containsKey(key)) {
                    facetValues = (ArrayList<String>)facetMap.get(key);
                }
                if (facetValues == null) {
                    facetValues = new ArrayList<String>();
                }
                facetValues.add(value);
                facetMap.put(key, facetValues);
            }
            for (Map.Entry entry : facetMap.entrySet()) {
                String fieldName = (String)entry.getKey();
                Object[] values = ArrayUtil.toStringArray((Collection)((Collection)entry.getValue()));
                MultiValueFacet multiValueFacet = new MultiValueFacet(searchContext);
                multiValueFacet.setFieldName(fieldName);
                multiValueFacet.setValues((String[])values);
                searchContext.setAttribute(fieldName, (Serializable)((Object)StringUtil.merge((Object[])values)));
                if (fieldName.equals("assetCategoryIds")) {
                    Stream<Object> stream = Arrays.stream(values);
                    LongStream longStream = stream.mapToLong(GetterUtil::getLong);
                    searchContext.setAssetCategoryIds(longStream.toArray());
                }
                facets.add((Facet)multiValueFacet);
            }
        }
        return facets;
    }

    public String getLayoutUuid(long groupId, long cpDefinitionId) {
        CPDisplayLayout cpDisplayLayout = this.cpDisplayLayoutLocalService.fetchCPDisplayLayout(groupId, CPDefinition.class, cpDefinitionId);
        if (cpDisplayLayout == null) {
            return null;
        }
        return cpDisplayLayout.getLayoutUuid();
    }

    public Map<Locale, String> getUrlTitleMap(long cpDefinitionId) {
        CPDefinition cpDefinition = this.cpDefinitionPersistence.fetchByPrimaryKey(cpDefinitionId);
        if (cpDefinition == null) {
            return Collections.emptyMap();
        }
        HashMap<Locale, String> urlTitleMap = new HashMap<Locale, String>();
        try {
            FriendlyURLEntry friendlyURLEntry = this._friendlyURLEntryLocalService.getMainFriendlyURLEntry(this.classNameLocalService.getClassNameId(CProduct.class), cpDefinition.getCProductId());
            List friendlyURLEntryLocalizations = this._friendlyURLEntryLocalService.getFriendlyURLEntryLocalizations(friendlyURLEntry.getFriendlyURLEntryId());
            for (FriendlyURLEntryLocalization friendlyURLEntryLocalization : friendlyURLEntryLocalizations) {
                urlTitleMap.put(LocaleUtil.fromLanguageId((String)friendlyURLEntryLocalization.getLanguageId()), friendlyURLEntryLocalization.getUrlTitle());
            }
        }
        catch (Exception exception) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)exception, (Throwable)exception);
            }
            return Collections.emptyMap();
        }
        return urlTitleMap;
    }

    public String getUrlTitleMapAsXML(long cpDefinitionId) throws PortalException {
        try {
            CPDefinition cpDefinition = this.cpDefinitionPersistence.findByPrimaryKey(cpDefinitionId);
            FriendlyURLEntry friendlyURLEntry = this._friendlyURLEntryLocalService.getMainFriendlyURLEntry(this.classNameLocalService.getClassNameId(CProduct.class), cpDefinition.getCProductId());
            return friendlyURLEntry.getUrlTitleMapAsXML();
        }
        catch (Exception exception) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)exception, (Throwable)exception);
            }
            return "";
        }
    }

    public boolean hasChildCPDefinitions(long cpDefinitionId) {
        int count = this.cpDefinitionOptionRelLocalService.getCPDefinitionOptionRelsCount(cpDefinitionId);
        return count > 0 && this.cpDefinitionOptionRelLocalService.hasLinkedCPInstanceCPDefinitionOptionRels(cpDefinitionId);
    }

    public boolean isPublishedCPDefinition(CPDefinition cpDefinition) {
        CProduct cProduct = this.cProductLocalService.fetchCProduct(cpDefinition.getCProductId());
        return cProduct != null && cProduct.getPublishedCPDefinitionId() == cpDefinition.getCPDefinitionId();
    }

    public boolean isPublishedCPDefinition(long cpDefinitionId) {
        CPDefinition cpDefinition = this.cpDefinitionLocalService.fetchCPDefinition(cpDefinitionId);
        if (cpDefinition == null) {
            return false;
        }
        return this.isPublishedCPDefinition(cpDefinition);
    }

    public boolean isVersionable(CPDefinition cpDefinition) {
        if (!this._isVersioningEnabled()) {
            return false;
        }
        return this.isPublishedCPDefinition(cpDefinition);
    }

    public boolean isVersionable(long cpDefinitionId) {
        if (!this._isVersioningEnabled()) {
            return false;
        }
        return this.isPublishedCPDefinition(cpDefinitionId);
    }

    public boolean isVersionable(long cpDefinitionId, HttpServletRequest httpServletRequest) {
        if (httpServletRequest == null) {
            return this.isVersionable(cpDefinitionId);
        }
        boolean versionable = GetterUtil.getBoolean((Object)httpServletRequest.getAttribute("versionable#" + cpDefinitionId), (boolean)true);
        if (versionable) {
            return this.isVersionable(cpDefinitionId);
        }
        return false;
    }

    public void maintainVersionThreshold(long cProductId) throws PortalException {
        int threshold = 0;
        try {
            CProductVersionConfiguration cProductVersionConfiguration = (CProductVersionConfiguration)ConfigurationProviderUtil.getConfiguration(CProductVersionConfiguration.class, (SettingsLocator)new SystemSettingsLocator(CProductVersionConfiguration.class.getName()));
            threshold = cProductVersionConfiguration.versionThreshold();
        }
        catch (PortalException portalException) {
            _log.error((Object)portalException, (Throwable)portalException);
            return;
        }
        OrderByComparator orderByComparator = OrderByComparatorFactoryUtil.create((String)"CPDefinition", (Object[])new Object[]{"version", false});
        List deletableCPDefinitions = this.cpDefinitionPersistence.findByC_S(cProductId, 0, threshold, threshold + Short.MAX_VALUE, orderByComparator);
        for (CPDefinition cpDefinition : deletableCPDefinitions) {
            this.cpDefinitionLocalService.deleteCPDefinition(cpDefinition);
        }
    }

    public BaseModelSearchResult<CPDefinition> searchCPDefinitions(long companyId, long[] groupIds, String keywords, int status, int start, int end, Sort sort) throws PortalException {
        SearchContext searchContext = this.buildSearchContext(companyId, groupIds, keywords, status, start, end, sort);
        return this.searchCPDefinitions(searchContext);
    }

    public BaseModelSearchResult<CPDefinition> searchCPDefinitions(long companyId, long[] groupIds, String keywords, String filterFields, String filterValues, int start, int end, Sort sort) throws PortalException {
        SearchContext searchContext = this.buildSearchContext(companyId, groupIds, keywords, -1, start, end, sort);
        List<Facet> facets = this.getFacets(filterFields, filterValues, searchContext);
        searchContext.setFacets(facets);
        return this.searchCPDefinitions(searchContext);
    }

    public BaseModelSearchResult<CPDefinition> searchCPDefinitionsByChannelGroupId(long companyId, long[] groupIds, long channelGroupId, String keywords, int status, int start, int end, Sort sort) throws PortalException {
        SearchContext searchContext = this.buildSearchContext(companyId, groupIds, keywords, status, start, end, sort);
        searchContext.setAttribute("commerceChannelGroupId", (Serializable)Long.valueOf(channelGroupId));
        searchContext.setAttribute("secure", (Serializable)Boolean.TRUE);
        return this.searchCPDefinitions(searchContext);
    }

    public void updateAsset(long userId, CPDefinition cpDefinition, long[] assetCategoryIds, String[] assetTagNames, long[] assetLinkEntryIds, Double priority) throws PortalException {
        Group companyGroup = this.groupLocalService.getCompanyGroup(cpDefinition.getCompanyId());
        AssetEntry assetEntry = this.assetEntryLocalService.updateEntry(userId, companyGroup.getGroupId(), cpDefinition.getCreateDate(), cpDefinition.getModifiedDate(), CPDefinition.class.getName(), cpDefinition.getCPDefinitionId(), cpDefinition.getUuid(), 0L, assetCategoryIds, assetTagNames, true, true, null, null, cpDefinition.getCreateDate(), null, "text/plain", cpDefinition.getNameMapAsXML(), cpDefinition.getDescriptionMapAsXML(), null, null, null, 0, 0, priority);
        this.assetLinkLocalService.updateLinks(userId, assetEntry.getEntryId(), assetLinkEntryIds, 0);
    }

    @Indexable(type=IndexableType.REINDEX)
    public CPDefinition updateCPDefinition(long cpDefinitionId, Map<Locale, String> nameMap, Map<Locale, String> shortDescriptionMap, Map<Locale, String> descriptionMap, Map<Locale, String> urlTitleMap, Map<Locale, String> metaTitleMap, Map<Locale, String> metaDescriptionMap, Map<Locale, String> metaKeywordsMap, boolean ignoreSKUCombinations, boolean shippable, boolean freeShipping, boolean shipSeparately, double shippingExtraPrice, double width, double height, double depth, double weight, long cpTaxCategoryId, boolean taxExempt, boolean telcoOrElectronics, String ddmStructureKey, boolean published, int displayDateMonth, int displayDateDay, int displayDateYear, int displayDateHour, int displayDateMinute, int expirationDateMonth, int expirationDateDay, int expirationDateYear, int expirationDateHour, int expirationDateMinute, boolean neverExpire, ServiceContext serviceContext) throws PortalException {
        User user = this.userLocalService.getUser(serviceContext.getUserId());
        CPDefinition cpDefinition = this.cpDefinitionPersistence.findByPrimaryKey(cpDefinitionId);
        long groupId = cpDefinition.getGroupId();
        Date expirationDate = null;
        Date date = new Date();
        Date displayDate = PortalUtil.getDate((int)displayDateMonth, (int)displayDateDay, (int)displayDateYear, (int)displayDateHour, (int)displayDateMinute, (TimeZone)user.getTimeZone(), CPDefinitionDisplayDateException.class);
        if (!neverExpire) {
            expirationDate = PortalUtil.getDate((int)expirationDateMonth, (int)expirationDateDay, (int)expirationDateYear, (int)expirationDateHour, (int)expirationDateMinute, (TimeZone)user.getTimeZone(), CPDefinitionExpirationDateException.class);
        }
        this.validate(groupId, ddmStructureKey, metaTitleMap, metaDescriptionMap, metaKeywordsMap, displayDate, expirationDate, cpDefinition.getProductTypeName());
        if (this.cpDefinitionLocalService.isVersionable(cpDefinition)) {
            cpDefinition = this.cpDefinitionLocalService.copyCPDefinition(cpDefinitionId);
            if (serviceContext.getWorkflowAction() != 1) {
                this.cProductLocalService.updatePublishedCPDefinitionId(cpDefinition.getCProductId(), cpDefinitionId);
            }
        }
        cpDefinition.setCPTaxCategoryId(cpTaxCategoryId);
        cpDefinition.setIgnoreSKUCombinations(ignoreSKUCombinations);
        cpDefinition.setShippable(shippable);
        cpDefinition.setFreeShipping(freeShipping);
        cpDefinition.setShipSeparately(shipSeparately);
        cpDefinition.setShippingExtraPrice(shippingExtraPrice);
        cpDefinition.setWidth(width);
        cpDefinition.setHeight(height);
        cpDefinition.setDepth(depth);
        cpDefinition.setWeight(weight);
        cpDefinition.setTaxExempt(taxExempt);
        cpDefinition.setTelcoOrElectronics(telcoOrElectronics);
        cpDefinition.setDDMStructureKey(ddmStructureKey);
        cpDefinition.setPublished(published);
        cpDefinition.setDisplayDate(displayDate);
        cpDefinition.setExpirationDate(expirationDate);
        if (expirationDate == null || expirationDate.after(date)) {
            cpDefinition.setStatus(2);
        } else {
            cpDefinition.setStatus(3);
        }
        cpDefinition.setStatusByUserId(user.getUserId());
        cpDefinition.setStatusDate(serviceContext.getModifiedDate(date));
        cpDefinition.setExpandoBridgeAttributes(serviceContext);
        cpDefinition = (CPDefinition)this.cpDefinitionPersistence.update((BaseModel)cpDefinition);
        Map<Object, Object> newUrlTitleMap = new HashMap();
        newUrlTitleMap = MapUtil.isEmpty(urlTitleMap) ? this._getUniqueUrlTitles(cpDefinition, nameMap) : this._getUniqueUrlTitles(cpDefinition, urlTitleMap);
        this._updateCPDefinitionLocalizedFields(cpDefinition.getCompanyId(), cpDefinition.getCPDefinitionId(), nameMap, shortDescriptionMap, descriptionMap, metaTitleMap, metaDescriptionMap, metaKeywordsMap);
        long classNameId = this.classNameLocalService.getClassNameId(CProduct.class);
        long classPK = cpDefinition.getCProductId();
        try {
            FriendlyURLEntry friendlyURLEntry = this._friendlyURLEntryLocalService.getMainFriendlyURLEntry(classNameId, classPK);
            this._friendlyURLEntryLocalService.updateFriendlyURLEntry(friendlyURLEntry.getFriendlyURLEntryId(), friendlyURLEntry.getClassNameId(), friendlyURLEntry.getClassPK(), friendlyURLEntry.getDefaultLanguageId(), newUrlTitleMap);
        }
        catch (Exception exception) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)exception, (Throwable)exception);
            }
            Group companyGroup = this._groupLocalService.getCompanyGroup(cpDefinition.getCompanyId());
            this._friendlyURLEntryLocalService.addFriendlyURLEntry(companyGroup.getGroupId(), classNameId, classPK, newUrlTitleMap, serviceContext);
        }
        this.updateAsset(user.getUserId(), cpDefinition, serviceContext.getAssetCategoryIds(), serviceContext.getAssetTagNames(), serviceContext.getAssetLinkEntryIds(), serviceContext.getAssetPriority());
        return this.startWorkflowInstance(user.getUserId(), cpDefinition, serviceContext);
    }

    public CPDefinition updateCPDefinition(long cpDefinitionId, Map<Locale, String> nameMap, Map<Locale, String> shortDescriptionMap, Map<Locale, String> descriptionMap, Map<Locale, String> urlTitleMap, Map<Locale, String> metaTitleMap, Map<Locale, String> metaDescriptionMap, Map<Locale, String> metaKeywordsMap, boolean ignoreSKUCombinations, String ddmStructureKey, boolean published, int displayDateMonth, int displayDateDay, int displayDateYear, int displayDateHour, int displayDateMinute, int expirationDateMonth, int expirationDateDay, int expirationDateYear, int expirationDateHour, int expirationDateMinute, boolean neverExpire, ServiceContext serviceContext) throws PortalException {
        CPDefinition cpDefinition = this.cpDefinitionPersistence.findByPrimaryKey(cpDefinitionId);
        return this.cpDefinitionLocalService.updateCPDefinition(cpDefinitionId, nameMap, shortDescriptionMap, descriptionMap, urlTitleMap, metaTitleMap, metaDescriptionMap, metaKeywordsMap, ignoreSKUCombinations, cpDefinition.isShippable(), cpDefinition.isFreeShipping(), cpDefinition.isShipSeparately(), cpDefinition.getShippingExtraPrice(), cpDefinition.getWidth(), cpDefinition.getHeight(), cpDefinition.getDepth(), cpDefinition.getWeight(), cpDefinition.getCPTaxCategoryId(), cpDefinition.isTaxExempt(), cpDefinition.isTelcoOrElectronics(), ddmStructureKey, published, displayDateMonth, displayDateDay, displayDateYear, displayDateHour, displayDateMinute, expirationDateMonth, expirationDateDay, expirationDateYear, expirationDateHour, expirationDateMinute, neverExpire, serviceContext);
    }

    @Indexable(type=IndexableType.REINDEX)
    public CPDefinition updateCPDefinitionAccountGroupFilter(long cpDefinitionId, boolean enable) throws PortalException {
        CPDefinition cpDefinition = this.cpDefinitionLocalService.getCPDefinition(cpDefinitionId);
        cpDefinition.setAccountGroupFilterEnabled(enable);
        return (CPDefinition)this.cpDefinitionPersistence.update((BaseModel)cpDefinition);
    }

    @Indexable(type=IndexableType.REINDEX)
    public CPDefinition updateCPDefinitionCategorization(long cpDefinitionId, ServiceContext serviceContext) throws PortalException {
        CPDefinition cpDefinition = this.cpDefinitionPersistence.findByPrimaryKey(cpDefinitionId);
        if (this.cpDefinitionLocalService.isVersionable(cpDefinition)) {
            cpDefinition = this.cpDefinitionLocalService.copyCPDefinition(cpDefinitionId);
            cpDefinitionId = cpDefinition.getCPDefinitionId();
        }
        this.updateStatus(serviceContext.getUserId(), cpDefinitionId, cpDefinition.getStatus(), serviceContext, new HashMap<String, Serializable>());
        Group companyGroup = this.groupLocalService.getCompanyGroup(serviceContext.getCompanyId());
        this.assetEntryLocalService.updateEntry(serviceContext.getUserId(), companyGroup.getGroupId(), CPDefinition.class.getName(), cpDefinition.getCPDefinitionId(), serviceContext.getAssetCategoryIds(), serviceContext.getAssetTagNames());
        return (CPDefinition)this.cpDefinitionPersistence.update((BaseModel)cpDefinition);
    }

    @Indexable(type=IndexableType.REINDEX)
    public CPDefinition updateCPDefinitionChannelFilter(long cpDefinitionId, boolean enable) throws PortalException {
        CPDefinition cpDefinition = this.cpDefinitionLocalService.getCPDefinition(cpDefinitionId);
        cpDefinition.setChannelFilterEnabled(enable);
        return (CPDefinition)this.cpDefinitionPersistence.update((BaseModel)cpDefinition);
    }

    @Indexable(type=IndexableType.REINDEX)
    public CPDefinition updateCPDefinitionIgnoreSKUCombinations(long cpDefinitionId, boolean ignoreSKUCombinations, ServiceContext serviceContext) throws PortalException {
        this.checkCPInstances(serviceContext.getUserId(), cpDefinitionId, ignoreSKUCombinations);
        CPDefinition cpDefinition = this.cpDefinitionPersistence.findByPrimaryKey(cpDefinitionId);
        cpDefinition.setIgnoreSKUCombinations(ignoreSKUCombinations);
        return (CPDefinition)this.cpDefinitionPersistence.update((BaseModel)cpDefinition);
    }

    public void updateCPDefinitionsByCPTaxCategoryId(long cpTaxCategoryId) throws PortalException {
        List cpDefinitions = this.cpDefinitionPersistence.findByCPTaxCategoryId(cpTaxCategoryId);
        for (CPDefinition cpDefinition : cpDefinitions) {
            this.updateTaxCategoryInfo(cpDefinition.getCPDefinitionId(), 0L, cpDefinition.isTaxExempt(), cpDefinition.isTelcoOrElectronics());
        }
    }

    public CPDefinition updateExternalReferenceCode(String externalReferenceCode, long cpDefinitionId) throws PortalException {
        CPDefinition cpDefinition = this.cpDefinitionLocalService.getCPDefinition(cpDefinitionId);
        this.cProductLocalService.updateCProductExternalReferenceCode(externalReferenceCode, cpDefinition.getCProductId());
        return this.cpDefinitionLocalService.getCPDefinition(cpDefinitionId);
    }

    @Indexable(type=IndexableType.REINDEX)
    public CPDefinition updateShippingInfo(long cpDefinitionId, boolean shippable, boolean freeShipping, boolean shipSeparately, double shippingExtraPrice, double width, double height, double depth, double weight, ServiceContext serviceContext) throws PortalException {
        CPDefinition cpDefinition = this.cpDefinitionPersistence.findByPrimaryKey(cpDefinitionId);
        if (this.cpDefinitionLocalService.isVersionable(cpDefinition)) {
            cpDefinition = this.cpDefinitionLocalService.copyCPDefinition(cpDefinitionId);
        }
        cpDefinition.setShippable(shippable);
        cpDefinition.setFreeShipping(freeShipping);
        cpDefinition.setShipSeparately(shipSeparately);
        cpDefinition.setShippingExtraPrice(shippingExtraPrice);
        cpDefinition.setWidth(width);
        cpDefinition.setHeight(height);
        cpDefinition.setDepth(depth);
        cpDefinition.setWeight(weight);
        return (CPDefinition)this.cpDefinitionPersistence.update((BaseModel)cpDefinition);
    }

    @Indexable(type=IndexableType.REINDEX)
    public CPDefinition updateStatus(long userId, long cpDefinitionId, int status, ServiceContext serviceContext, Map<String, Serializable> workflowContext) throws PortalException {
        Date expirationDate;
        User user = this.userLocalService.getUser(userId);
        Date date = new Date();
        CPDefinition cpDefinition = this.cpDefinitionPersistence.findByPrimaryKey(cpDefinitionId);
        if (status == 0 && cpDefinition.getDisplayDate() != null && date.before(cpDefinition.getDisplayDate())) {
            status = 7;
        }
        Date modifiedDate = serviceContext.getModifiedDate(date);
        if (status == 0 && (expirationDate = cpDefinition.getExpirationDate()) != null && expirationDate.before(date)) {
            cpDefinition.setExpirationDate(null);
        }
        if (status == 3) {
            cpDefinition.setExpirationDate(date);
        }
        cpDefinition.setStatus(status);
        cpDefinition.setStatusByUserId(user.getUserId());
        cpDefinition.setStatusByUserName(user.getFullName());
        cpDefinition.setStatusDate(modifiedDate);
        cpDefinition = (CPDefinition)this.cpDefinitionPersistence.update((BaseModel)cpDefinition);
        if (status == 0) {
            this.assetEntryLocalService.updateEntry(CPDefinition.class.getName(), cpDefinition.getCPDefinitionId(), cpDefinition.getDisplayDate(), cpDefinition.getExpirationDate(), true, true);
            this.cProductLocalService.updatePublishedCPDefinitionId(cpDefinition.getCProductId(), cpDefinition.getCPDefinitionId());
        } else {
            this.assetEntryLocalService.updateVisible(CPDefinition.class.getName(), cpDefinitionId, false);
        }
        this.reindexCPInstances(cpDefinition);
        return cpDefinition;
    }

    @Indexable(type=IndexableType.REINDEX)
    public CPDefinition updateSubscriptionInfo(long cpDefinitionId, boolean subscriptionEnabled, int subscriptionLength, String subscriptionType, UnicodeProperties subscriptionTypeSettingsUnicodeProperties, long maxSubscriptionCycles, boolean deliverySubscriptionEnabled, int deliverySubscriptionLength, String deliverySubscriptionType, UnicodeProperties deliverySubscriptionTypeSettingsUnicodeProperties, long deliveryMaxSubscriptionCycles) throws PortalException {
        CPDefinition cpDefinition = this.cpDefinitionPersistence.findByPrimaryKey(cpDefinitionId);
        if (this.cpDefinitionLocalService.isVersionable(cpDefinition)) {
            cpDefinition = this.cpDefinitionLocalService.copyCPDefinition(cpDefinitionId);
        }
        cpDefinition.setSubscriptionEnabled(subscriptionEnabled);
        cpDefinition.setSubscriptionLength(subscriptionLength);
        cpDefinition.setSubscriptionType(subscriptionType);
        cpDefinition.setSubscriptionTypeSettingsProperties(subscriptionTypeSettingsUnicodeProperties);
        cpDefinition.setMaxSubscriptionCycles(maxSubscriptionCycles);
        cpDefinition.setDeliverySubscriptionEnabled(deliverySubscriptionEnabled);
        cpDefinition.setDeliverySubscriptionLength(deliverySubscriptionLength);
        cpDefinition.setDeliverySubscriptionType(deliverySubscriptionType);
        cpDefinition.setDeliverySubscriptionTypeSettingsProperties(deliverySubscriptionTypeSettingsUnicodeProperties);
        cpDefinition.setDeliveryMaxSubscriptionCycles(deliveryMaxSubscriptionCycles);
        return (CPDefinition)this.cpDefinitionPersistence.update((BaseModel)cpDefinition);
    }

    @Deprecated
    public CPDefinition updateSubscriptionInfo(long cpDefinitionId, boolean subscriptionEnabled, int subscriptionLength, String subscriptionType, UnicodeProperties subscriptionTypeSettingsUnicodeProperties, long maxSubscriptionCycles, ServiceContext serviceContext) throws PortalException {
        return this.cpDefinitionLocalService.updateSubscriptionInfo(cpDefinitionId, subscriptionEnabled, subscriptionLength, subscriptionType, subscriptionTypeSettingsUnicodeProperties, maxSubscriptionCycles, false, 1, null, null, 0L);
    }

    public CPDefinition updateTaxCategoryInfo(long cpDefinitionId, long cpTaxCategoryId, boolean taxExempt, boolean telcoOrElectronics) throws PortalException {
        CPDefinition cpDefinition = this.cpDefinitionPersistence.findByPrimaryKey(cpDefinitionId);
        if (this.cpDefinitionLocalService.isVersionable(cpDefinition)) {
            cpDefinition = this.cpDefinitionLocalService.copyCPDefinition(cpDefinitionId);
        }
        cpDefinition.setCPTaxCategoryId(cpTaxCategoryId);
        cpDefinition.setTaxExempt(taxExempt);
        cpDefinition.setTelcoOrElectronics(telcoOrElectronics);
        return (CPDefinition)this.cpDefinitionPersistence.update((BaseModel)cpDefinition);
    }

    protected SearchContext buildSearchContext(long companyId, long[] groupIds, String keywords, int status, int start, int end, Sort sort) {
        SearchContext searchContext = new SearchContext();
        searchContext.setAttributes((Map)HashMapBuilder.put((Object)"content", (Object)keywords).put((Object)"description", (Object)keywords).put((Object)"entryClassPK", (Object)keywords).put((Object)"name", (Object)keywords).put((Object)"status", (Object)status).put((Object)"params", (Object)LinkedHashMapBuilder.put((Object)"keywords", (Object)keywords).build()).build());
        searchContext.setCompanyId(companyId);
        searchContext.setEnd(end);
        if (groupIds.length > 0) {
            searchContext.setGroupIds(groupIds);
        }
        if (Validator.isNotNull((String)keywords)) {
            searchContext.setKeywords(keywords);
        }
        if (sort != null) {
            searchContext.setSorts(new Sort[]{sort});
        }
        searchContext.setStart(start);
        QueryConfig queryConfig = searchContext.getQueryConfig();
        queryConfig.setHighlightEnabled(false);
        queryConfig.setScoreEnabled(false);
        return searchContext;
    }

    protected void checkCPDefinitionsByDisplayDate() throws PortalException {
        List cpDefinitions = this.cpDefinitionPersistence.findByLtD_S(new Date(), 7);
        for (CPDefinition cpDefinition : cpDefinitions) {
            long userId = PortalUtil.getValidUserId((long)cpDefinition.getCompanyId(), (long)cpDefinition.getUserId());
            ServiceContext serviceContext = new ServiceContext();
            serviceContext.setCommand("update");
            serviceContext.setScopeGroupId(cpDefinition.getGroupId());
            this.cpDefinitionLocalService.updateStatus(userId, cpDefinition.getCPDefinitionId(), 0, serviceContext, new HashMap());
            if (!cpDefinition.isApproved()) continue;
            long classNameId = this.classNameLocalService.getClassNameId(cpDefinition.getModelClassName());
            this.cpAttachmentFileEntryLocalService.checkCPAttachmentFileEntriesByDisplayDate(classNameId, cpDefinition.getCPDefinitionId());
            this.cpInstanceLocalService.checkCPInstancesByDisplayDate(cpDefinition.getCPDefinitionId());
        }
    }

    protected void checkCPDefinitionsByExpirationDate() throws PortalException {
        List cpDefinitions = this.cpDefinitionFinder.findByExpirationDate(new Date(), new QueryDefinition(0));
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Expiring " + cpDefinitions.size() + " commerce product definitions"));
        }
        if (cpDefinitions != null && !cpDefinitions.isEmpty()) {
            for (CPDefinition cpDefinition : cpDefinitions) {
                long userId = PortalUtil.getValidUserId((long)cpDefinition.getCompanyId(), (long)cpDefinition.getUserId());
                ServiceContext serviceContext = new ServiceContext();
                serviceContext.setCommand("update");
                serviceContext.setScopeGroupId(cpDefinition.getGroupId());
                this.cpDefinitionLocalService.updateStatus(userId, cpDefinition.getCPDefinitionId(), 3, serviceContext, new HashMap());
            }
        }
    }

    protected void checkCPInstances(long userId, long cpDefinitionId, boolean ignoreSKUCombinations) throws PortalException {
        if (ignoreSKUCombinations) {
            int cpInstancesCount = this.cpInstanceLocalService.getCPDefinitionInstancesCount(cpDefinitionId, 0);
            if (cpInstancesCount <= 1) {
                return;
            }
            throw new CPDefinitionIgnoreSKUCombinationsException();
        }
        int cpDefinitionOptionRelsCount = this.cpDefinitionOptionRelLocalService.getCPDefinitionOptionRelsCount(cpDefinitionId, true);
        if (cpDefinitionOptionRelsCount == 0) {
            return;
        }
        List cpInstances = this.cpInstanceLocalService.getCPDefinitionInstances(cpDefinitionId, 0, -1, -1, null);
        for (CPInstance cpInstance : cpInstances) {
            if (this.cpInstanceOptionValueRelLocalService.hasCPInstanceOptionValueRel(cpInstance.getCPInstanceId())) continue;
            this.cpInstanceLocalService.updateStatus(userId, cpInstance.getCPInstanceId(), 5);
        }
    }

    protected List<CPDefinition> getCPDefinitions(Hits hits) throws PortalException {
        List documents = hits.toList();
        ArrayList<CPDefinition> cpDefinitions = new ArrayList<CPDefinition>(documents.size());
        for (Document document : documents) {
            long cpDefinitionId = GetterUtil.getLong((String)document.get("entryClassPK"));
            CPDefinition cpDefinition = this.fetchCPDefinition(cpDefinitionId);
            if (cpDefinition == null) {
                cpDefinitions = null;
                Indexer indexer = IndexerRegistryUtil.getIndexer(CPDefinition.class);
                long companyId = GetterUtil.getLong((String)document.get("companyId"));
                indexer.delete(companyId, document.getUID());
                continue;
            }
            if (cpDefinitions == null) continue;
            cpDefinitions.add(cpDefinition);
        }
        return cpDefinitions;
    }

    protected void reindexCPInstances(CPDefinition cpDefinition) throws PortalException {
        Indexer indexer = IndexerRegistryUtil.nullSafeGetIndexer(CPInstance.class);
        indexer.reindex((Collection)cpDefinition.getCPInstances());
    }

    protected BaseModelSearchResult<CPDefinition> searchCPDefinitions(SearchContext searchContext) throws PortalException {
        Indexer indexer = IndexerRegistryUtil.nullSafeGetIndexer(CPDefinition.class);
        for (int i = 0; i < 10; ++i) {
            Hits hits = indexer.search(searchContext, _SELECTED_FIELD_NAMES);
            List<CPDefinition> cpDefinitions = this.getCPDefinitions(hits);
            if (cpDefinitions == null) continue;
            return new BaseModelSearchResult(cpDefinitions, hits.getLength());
        }
        throw new SearchException("Unable to fix the search index after 10 attempts");
    }

    protected CPDefinition startWorkflowInstance(long userId, CPDefinition cpDefinition, ServiceContext serviceContext) throws PortalException {
        HashMap workflowContext = new HashMap();
        return (CPDefinition)WorkflowHandlerRegistryUtil.startWorkflowInstance((long)cpDefinition.getCompanyId(), (long)cpDefinition.getGroupId(), (long)userId, (String)CPDefinition.class.getName(), (long)cpDefinition.getCPDefinitionId(), (Object)cpDefinition, (ServiceContext)serviceContext, workflowContext);
    }

    protected void validate(long groupId, String ddmStructureKey, Map<Locale, String> metaTitleMap, Map<Locale, String> metaDescriptionMap, Map<Locale, String> metaKeywordsMap, Date displayDate, Date expirationDate, String productTypeName) throws PortalException {
        long classNameId;
        DDMStructure ddmStructure;
        if (Validator.isNotNull((String)ddmStructureKey) && (ddmStructure = this._ddmStructureLocalService.fetchStructure(groupId, classNameId = this.classNameLocalService.getClassNameId(CPDefinition.class.getName()), ddmStructureKey, true)) == null) {
            throw new NoSuchStructureException();
        }
        if (metaTitleMap != null) {
            for (Map.Entry<Locale, String> entry : metaTitleMap.entrySet()) {
                CPDefinitionMetaTitleException cpDefinitionMetaTitleException = CPDefinitionImpl.validateMetaTitle(entry.getValue());
                if (cpDefinitionMetaTitleException == null) continue;
                throw cpDefinitionMetaTitleException;
            }
        }
        if (metaDescriptionMap != null) {
            for (Map.Entry<Locale, String> entry : metaDescriptionMap.entrySet()) {
                CPDefinitionMetaDescriptionException cpDefinitionMetaDescriptionException = CPDefinitionImpl.validateMetaDescription(entry.getValue());
                if (cpDefinitionMetaDescriptionException == null) continue;
                throw cpDefinitionMetaDescriptionException;
            }
        }
        if (metaKeywordsMap != null) {
            for (Map.Entry<Locale, String> entry : metaKeywordsMap.entrySet()) {
                CPDefinitionMetaKeywordsException cpDefinitionMetaKeywordsException = CPDefinitionImpl.validateMetaKeyword(entry.getValue());
                if (cpDefinitionMetaKeywordsException == null) continue;
                throw cpDefinitionMetaKeywordsException;
            }
        }
        if (expirationDate != null && (expirationDate.before(new Date()) || displayDate != null && expirationDate.before(displayDate))) {
            throw new CPDefinitionExpirationDateException("Expiration date " + expirationDate + " is in the past");
        }
        CPType cpType = this._cpTypeServicesTracker.getCPType(productTypeName);
        if (cpType == null) {
            throw new CPDefinitionProductTypeNameException();
        }
    }

    private List<CPDefinitionLocalization> _addCPDefinitionLocalizedFields(long companyId, long cpDefinitionId, Map<Locale, String> nameMap, Map<Locale, String> shortDescriptionMap, Map<Locale, String> descriptionMap, Map<Locale, String> metaTitleMap, Map<Locale, String> metaDescriptionMap, Map<Locale, String> metaKeywordsMap) throws PortalException {
        HashSet<Locale> localeSet = new HashSet<Locale>();
        localeSet.addAll(nameMap.keySet());
        if (shortDescriptionMap != null) {
            localeSet.addAll(shortDescriptionMap.keySet());
        }
        if (descriptionMap != null) {
            localeSet.addAll(descriptionMap.keySet());
        }
        if (metaTitleMap != null) {
            localeSet.addAll(metaTitleMap.keySet());
        }
        if (metaDescriptionMap != null) {
            localeSet.addAll(metaDescriptionMap.keySet());
        }
        if (metaKeywordsMap != null) {
            localeSet.addAll(metaKeywordsMap.keySet());
        }
        ArrayList<CPDefinitionLocalization> cpDefinitionLocalizations = new ArrayList<CPDefinitionLocalization>();
        for (Locale locale : localeSet) {
            String name = nameMap.get(locale);
            String shortDescription = null;
            String description = null;
            String metaTitle = null;
            String metaDescription = null;
            String metaKeywords = null;
            if (shortDescriptionMap != null) {
                shortDescription = shortDescriptionMap.get(locale);
            }
            if (descriptionMap != null) {
                description = descriptionMap.get(locale);
            }
            if (metaTitleMap != null) {
                metaTitle = metaTitleMap.get(locale);
            }
            if (metaDescriptionMap != null) {
                metaDescription = metaDescriptionMap.get(locale);
            }
            if (metaKeywordsMap != null) {
                metaKeywords = metaKeywordsMap.get(locale);
            }
            if (Validator.isNull((String)name) && Validator.isNull((String)shortDescription) && Validator.isNull((String)description) && Validator.isNull((String)metaTitle) && Validator.isNull((String)metaDescription) && Validator.isNull((String)metaKeywords)) continue;
            CPDefinitionLocalization cpDefinitionLocalization = this._addCPDefinitionLocalizedFields(companyId, cpDefinitionId, name, shortDescription, description, metaTitle, metaDescription, metaKeywords, LocaleUtil.toLanguageId((Locale)locale));
            cpDefinitionLocalizations.add(cpDefinitionLocalization);
        }
        return cpDefinitionLocalizations;
    }

    private CPDefinitionLocalization _addCPDefinitionLocalizedFields(long companyId, long cpDefinitionId, String name, String shortDescription, String description, String metaTitle, String metaDescription, String metaKeywords, String languageId) throws PortalException {
        CPDefinitionLocalization cpDefinitionLocalization = this.cpDefinitionLocalizationPersistence.fetchByCPDefinitionId_LanguageId(cpDefinitionId, languageId);
        if (cpDefinitionLocalization == null) {
            long cpDefinitionLocalizationId = this.counterLocalService.increment();
            cpDefinitionLocalization = this.cpDefinitionLocalizationPersistence.create(cpDefinitionLocalizationId);
            cpDefinitionLocalization.setCompanyId(companyId);
            cpDefinitionLocalization.setCPDefinitionId(cpDefinitionId);
            cpDefinitionLocalization.setName(name);
            cpDefinitionLocalization.setShortDescription(shortDescription);
            cpDefinitionLocalization.setDescription(description);
            cpDefinitionLocalization.setMetaTitle(metaTitle);
            cpDefinitionLocalization.setMetaDescription(metaDescription);
            cpDefinitionLocalization.setMetaKeywords(metaKeywords);
            cpDefinitionLocalization.setLanguageId(languageId);
        } else {
            cpDefinitionLocalization.setName(name);
            cpDefinitionLocalization.setShortDescription(shortDescription);
            cpDefinitionLocalization.setDescription(description);
            cpDefinitionLocalization.setMetaTitle(metaTitle);
            cpDefinitionLocalization.setMetaDescription(metaDescription);
            cpDefinitionLocalization.setMetaKeywords(metaKeywords);
        }
        return (CPDefinitionLocalization)this.cpDefinitionLocalizationPersistence.update((BaseModel)cpDefinitionLocalization);
    }

    private String _getIndexFieldName(String optionKey, String languageId) {
        return StringBundler.concat((String[])new String[]{languageId, "_ATTRIBUTE_", optionKey, "_VALUES_NAMES"});
    }

    private Map<String, String> _getUniqueUrlTitles(CPDefinition cpDefinition, Map<Locale, String> urlTitleMap) throws PortalException {
        HashMap<String, String> newURLTitleMap = new HashMap<String, String>();
        Group companyGroup = this._groupLocalService.getCompanyGroup(cpDefinition.getCompanyId());
        long classNameId = this.classNameLocalService.getClassNameId(CProduct.class);
        for (Map.Entry<Locale, String> titleEntry : urlTitleMap.entrySet()) {
            String urlTitle = urlTitleMap.get(titleEntry.getKey());
            if (!Validator.isNotNull((String)urlTitle)) continue;
            urlTitle = this._friendlyURLEntryLocalService.getUniqueUrlTitle(companyGroup.getGroupId(), classNameId, cpDefinition.getCProductId(), titleEntry.getValue());
            newURLTitleMap.put(LocaleUtil.toLanguageId((Locale)titleEntry.getKey()), urlTitle);
        }
        return newURLTitleMap;
    }

    private boolean _isVersioningEnabled() {
        try {
            CProductVersionConfiguration cProductVersionConfiguration = (CProductVersionConfiguration)ConfigurationProviderUtil.getConfiguration(CProductVersionConfiguration.class, (SettingsLocator)new SystemSettingsLocator(CProductVersionConfiguration.class.getName()));
            if (cProductVersionConfiguration.enabled()) {
                return true;
            }
        }
        catch (PortalException portalException) {
            _log.error((Object)portalException, (Throwable)portalException);
        }
        return false;
    }

    private List<CPDefinitionLocalization> _updateCPDefinitionLocalizedFields(long companyId, long cpDefinitionId, Map<Locale, String> nameMap, Map<Locale, String> shortDescriptionMap, Map<Locale, String> descriptionMap, Map<Locale, String> metaTitleMap, Map<Locale, String> metaDescriptionMap, Map<Locale, String> metaKeywordsMap) throws PortalException {
        ArrayList oldCPDefinitionLocalizations = new ArrayList(this.cpDefinitionLocalizationPersistence.findByCPDefinitionId(cpDefinitionId));
        List<CPDefinitionLocalization> newCPDefinitionLocalizations = this._addCPDefinitionLocalizedFields(companyId, cpDefinitionId, nameMap, shortDescriptionMap, descriptionMap, metaTitleMap, metaDescriptionMap, metaKeywordsMap);
        oldCPDefinitionLocalizations.removeAll(newCPDefinitionLocalizations);
        for (CPDefinitionLocalization oldCPDefinitionLocalization : oldCPDefinitionLocalizations) {
            this.cpDefinitionLocalizationPersistence.remove((BaseModel)oldCPDefinitionLocalization);
        }
        return newCPDefinitionLocalizations;
    }
}

