/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.product.service.impl;

import com.liferay.commerce.product.configuration.CPOptionConfiguration;
import com.liferay.commerce.product.constants.CPConstants;
import com.liferay.commerce.product.exception.CPDefinitionOptionRelPriceTypeException;
import com.liferay.commerce.product.exception.CPDefinitionOptionSKUContributorException;
import com.liferay.commerce.product.exception.DuplicateCPDefinitionOptionRelKeyException;
import com.liferay.commerce.product.model.CPDefinition;
import com.liferay.commerce.product.model.CPDefinitionOptionRel;
import com.liferay.commerce.product.model.CPDefinitionOptionValueRel;
import com.liferay.commerce.product.model.CPInstance;
import com.liferay.commerce.product.model.CPInstanceOptionValueRel;
import com.liferay.commerce.product.model.CPOption;
import com.liferay.commerce.product.service.base.CPDefinitionOptionRelLocalServiceBaseImpl;
import com.liferay.commerce.product.util.JsonHelper;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONFactory;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.module.configuration.ConfigurationException;
import com.liferay.portal.kernel.module.configuration.ConfigurationProvider;
import com.liferay.portal.kernel.search.BaseModelSearchResult;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.Hits;
import com.liferay.portal.kernel.search.Indexable;
import com.liferay.portal.kernel.search.IndexableType;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerRegistryUtil;
import com.liferay.portal.kernel.search.QueryConfig;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.SearchException;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.security.auth.PrincipalThreadLocal;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.settings.SettingsLocator;
import com.liferay.portal.kernel.settings.SystemSettingsLocator;
import com.liferay.portal.kernel.systemevent.SystemEvent;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.LinkedHashMapBuilder;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.spring.extender.service.ServiceReference;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import javax.servlet.http.HttpServletRequest;

public class CPDefinitionOptionRelLocalServiceImpl
extends CPDefinitionOptionRelLocalServiceBaseImpl {
    private static final String[] _SELECTED_FIELD_NAMES = new String[]{"entryClassPK", "companyId", "groupId", "uid"};
    @ServiceReference(type=ConfigurationProvider.class)
    private ConfigurationProvider _configurationProvider;
    @ServiceReference(type=JSONFactory.class)
    private JSONFactory _jsonFactory;
    @ServiceReference(type=JsonHelper.class)
    private JsonHelper _jsonHelper;

    public CPDefinitionOptionRel addCPDefinitionOptionRel(long cpDefinitionId, long cpOptionId, boolean importOptionValue, ServiceContext serviceContext) throws PortalException {
        CPOption cpOption = this.cpOptionLocalService.getCPOption(cpOptionId);
        return this.cpDefinitionOptionRelLocalService.addCPDefinitionOptionRel(cpDefinitionId, cpOptionId, cpOption.getNameMap(), cpOption.getDescriptionMap(), cpOption.getDDMFormFieldTypeName(), 0.0, cpOption.isFacetable(), cpOption.isRequired(), cpOption.isSkuContributor(), importOptionValue, serviceContext);
    }

    public CPDefinitionOptionRel addCPDefinitionOptionRel(long cpDefinitionId, long cpOptionId, Map<Locale, String> nameMap, Map<Locale, String> descriptionMap, String ddmFormFieldTypeName, double priority, boolean facetable, boolean required, boolean skuContributor, boolean importOptionValue, ServiceContext serviceContext) throws PortalException {
        return this.cpDefinitionOptionRelLocalService.addCPDefinitionOptionRel(cpDefinitionId, cpOptionId, nameMap, descriptionMap, ddmFormFieldTypeName, priority, facetable, required, skuContributor, importOptionValue, null, serviceContext);
    }

    @Indexable(type=IndexableType.REINDEX)
    public CPDefinitionOptionRel addCPDefinitionOptionRel(long cpDefinitionId, long cpOptionId, Map<Locale, String> nameMap, Map<Locale, String> descriptionMap, String ddmFormFieldTypeName, double priority, boolean facetable, boolean required, boolean skuContributor, boolean importOptionValue, String priceType, ServiceContext serviceContext) throws PortalException {
        this._validateDDMFormFieldTypeName(ddmFormFieldTypeName, skuContributor);
        CPOption cpOption = this.cpOptionLocalService.getCPOption(cpOptionId);
        this._validateCPDefinitionOptionKey(cpDefinitionId, cpOption.getKey());
        User user = this.userLocalService.getUser(serviceContext.getUserId());
        long groupId = serviceContext.getScopeGroupId();
        long cpDefinitionOptionRelId = this.counterLocalService.increment();
        CPDefinitionOptionRel cpDefinitionOptionRel = this.cpDefinitionOptionRelPersistence.create(cpDefinitionOptionRelId);
        this._validatePriceType(cpDefinitionOptionRel, priceType);
        if (this.cpDefinitionLocalService.isVersionable(cpDefinitionId, serviceContext.getRequest())) {
            CPDefinition newCPDefinition = this.cpDefinitionLocalService.copyCPDefinition(cpDefinitionId);
            cpDefinitionId = newCPDefinition.getCPDefinitionId();
            HttpServletRequest httpServletRequest = serviceContext.getRequest();
            httpServletRequest.setAttribute("versionable#" + cpDefinitionId, (Object)Boolean.FALSE);
        }
        cpDefinitionOptionRel.setGroupId(groupId);
        cpDefinitionOptionRel.setCompanyId(user.getCompanyId());
        cpDefinitionOptionRel.setUserId(user.getUserId());
        cpDefinitionOptionRel.setUserName(user.getFullName());
        cpDefinitionOptionRel.setCPDefinitionId(cpDefinitionId);
        cpDefinitionOptionRel.setCPOptionId(cpOptionId);
        cpDefinitionOptionRel.setNameMap(nameMap);
        cpDefinitionOptionRel.setDescriptionMap(descriptionMap);
        cpDefinitionOptionRel.setDDMFormFieldTypeName(ddmFormFieldTypeName);
        cpDefinitionOptionRel.setPriority(priority);
        cpDefinitionOptionRel.setFacetable(facetable);
        cpDefinitionOptionRel.setRequired(required);
        cpDefinitionOptionRel.setSkuContributor(skuContributor);
        cpDefinitionOptionRel.setKey(cpOption.getKey());
        cpDefinitionOptionRel.setPriceType(priceType);
        cpDefinitionOptionRel.setExpandoBridgeAttributes(serviceContext);
        cpDefinitionOptionRel = (CPDefinitionOptionRel)this.cpDefinitionOptionRelPersistence.update((BaseModel)cpDefinitionOptionRel);
        if (importOptionValue) {
            this.cpDefinitionOptionValueRelLocalService.importCPDefinitionOptionRels(cpDefinitionOptionRelId, serviceContext);
        }
        this.cpInstanceLocalService.inactivateIncompatibleCPInstances(user.getUserId(), cpDefinitionId);
        this._updateCPDefinitionIgnoreSKUCombinations(cpDefinitionId, serviceContext);
        this.reindexCPDefinition(cpDefinitionId);
        return cpDefinitionOptionRel;
    }

    public CPDefinitionOptionRel addCPDefinitionOptionRel(long cpDefinitionId, long cpOptionId, ServiceContext serviceContext) throws PortalException {
        return this.cpDefinitionOptionRelLocalService.addCPDefinitionOptionRel(cpDefinitionId, cpOptionId, true, serviceContext);
    }

    @Override
    @Indexable(type=IndexableType.DELETE)
    @SystemEvent(type=1)
    public CPDefinitionOptionRel deleteCPDefinitionOptionRel(CPDefinitionOptionRel cpDefinitionOptionRel) throws PortalException {
        if (this.cpDefinitionLocalService.isVersionable(cpDefinitionOptionRel.getCPDefinitionId())) {
            CPDefinition newCPDefinition = this.cpDefinitionLocalService.copyCPDefinition(cpDefinitionOptionRel.getCPDefinitionId());
            cpDefinitionOptionRel = this.cpDefinitionOptionRelPersistence.findByC_C(newCPDefinition.getCPDefinitionId(), cpDefinitionOptionRel.getCPOptionId());
        }
        List cpDefinitionOptionValueRels = this.cpDefinitionOptionValueRelLocalService.getCPDefinitionOptionValueRels(cpDefinitionOptionRel.getCPDefinitionOptionRelId(), -1, -1);
        for (CPDefinitionOptionValueRel cpDefinitionOptionValueRel : cpDefinitionOptionValueRels) {
            this.cpDefinitionOptionValueRelPersistence.remove((BaseModel)cpDefinitionOptionValueRel);
            this.expandoRowLocalService.deleteRows(cpDefinitionOptionValueRel.getCPDefinitionOptionValueRelId());
        }
        this.cpDefinitionOptionRelPersistence.remove((BaseModel)cpDefinitionOptionRel);
        this.expandoRowLocalService.deleteRows(cpDefinitionOptionRel.getCPDefinitionOptionRelId());
        this.cpInstanceLocalService.inactivateCPDefinitionOptionRelCPInstances(PrincipalThreadLocal.getUserId(), cpDefinitionOptionRel.getCPDefinitionId(), cpDefinitionOptionRel.getCPDefinitionOptionRelId());
        this._updateCPDefinitionIgnoreSKUCombinations(cpDefinitionOptionRel.getCPDefinitionId(), new ServiceContext());
        this.reindexCPDefinition(cpDefinitionOptionRel.getCPDefinitionId());
        return cpDefinitionOptionRel;
    }

    @Override
    public CPDefinitionOptionRel deleteCPDefinitionOptionRel(long cpDefinitionOptionRelId) throws PortalException {
        CPDefinitionOptionRel cpDefinitionOptionRel = this.cpDefinitionOptionRelPersistence.findByPrimaryKey(cpDefinitionOptionRelId);
        return this.cpDefinitionOptionRelLocalService.deleteCPDefinitionOptionRel(cpDefinitionOptionRel);
    }

    public void deleteCPDefinitionOptionRels(long cpDefinitionId) throws PortalException {
        List cpDefinitionOptionRels = this.cpDefinitionOptionRelLocalService.getCPDefinitionOptionRels(cpDefinitionId, -1, -1);
        for (CPDefinitionOptionRel cpDefinitionOptionRel : cpDefinitionOptionRels) {
            this.cpDefinitionOptionRelLocalService.deleteCPDefinitionOptionRel(cpDefinitionOptionRel);
        }
    }

    public CPDefinitionOptionRel fetchCPDefinitionOptionRel(long cpDefinitionId, long cpOptionId) {
        return this.cpDefinitionOptionRelPersistence.fetchByC_C(cpDefinitionId, cpOptionId);
    }

    public CPDefinitionOptionRel fetchCPDefinitionOptionRelByKey(long cpDefinitionId, String key) {
        return this.cpDefinitionOptionRelPersistence.fetchByC_K(cpDefinitionId, key);
    }

    public Map<Long, List<Long>> getCPDefinitionOptionRelCPDefinitionOptionValueRelIds(long cpDefinitionId, boolean skuContributorsOnly, String json) throws PortalException {
        if (this._jsonHelper.isEmpty(json)) {
            return Collections.emptyMap();
        }
        HashMap<Long, List<Long>> cpDefinitionOptionRelIdCPDefinitionOptionValueRelIds = new HashMap<Long, List<Long>>();
        JSONArray jsonArray = this._jsonFactory.createJSONArray();
        if (this._jsonHelper.isArray(json)) {
            jsonArray = this._jsonFactory.createJSONArray(json);
        } else {
            jsonArray.put(this._jsonFactory.createJSONObject(json));
        }
        for (int i = 0; i < jsonArray.length(); ++i) {
            JSONObject jsonObject = jsonArray.getJSONObject(i);
            CPDefinitionOptionRel cpDefinitionOptionRel = this.cpDefinitionOptionRelLocalService.fetchCPDefinitionOptionRelByKey(cpDefinitionId, jsonObject.getString("key"));
            if (cpDefinitionOptionRel == null || skuContributorsOnly && !cpDefinitionOptionRel.isSkuContributor()) continue;
            JSONArray valueJSONArray = this._jsonHelper.getValueAsJSONArray("value", jsonObject);
            for (int j = 0; j < valueJSONArray.length(); ++j) {
                CPDefinitionOptionValueRel cpDefinitionOptionValueRel = this.cpDefinitionOptionValueRelLocalService.fetchCPDefinitionOptionValueRel(cpDefinitionOptionRel.getCPDefinitionOptionRelId(), valueJSONArray.getString(j));
                if (cpDefinitionOptionValueRel == null) continue;
                ArrayList<Long> cpDefinitionOptionValueRelIds = (ArrayList<Long>)cpDefinitionOptionRelIdCPDefinitionOptionValueRelIds.get(cpDefinitionOptionRel.getCPDefinitionOptionRelId());
                if (cpDefinitionOptionValueRelIds == null) {
                    cpDefinitionOptionValueRelIds = new ArrayList<Long>();
                    cpDefinitionOptionRelIdCPDefinitionOptionValueRelIds.put(cpDefinitionOptionRel.getCPDefinitionOptionRelId(), cpDefinitionOptionValueRelIds);
                }
                cpDefinitionOptionValueRelIds.add(cpDefinitionOptionValueRel.getCPDefinitionOptionValueRelId());
            }
        }
        return cpDefinitionOptionRelIdCPDefinitionOptionValueRelIds;
    }

    public Map<Long, List<Long>> getCPDefinitionOptionRelCPDefinitionOptionValueRelIds(long cpDefinitionId, String json) throws PortalException {
        return this.cpDefinitionOptionRelLocalService.getCPDefinitionOptionRelCPDefinitionOptionValueRelIds(cpDefinitionId, false, json);
    }

    public Map<String, List<String>> getCPDefinitionOptionRelKeysCPDefinitionOptionValueRelKeys(long cpInstanceId) throws PortalException {
        CPInstance cpInstance = this.cpInstanceLocalService.getCPInstance(cpInstanceId);
        if (cpInstance.isInactive()) {
            return Collections.emptyMap();
        }
        List cpInstanceOptionValueRels = this.cpInstanceOptionValueRelPersistence.findByCPInstanceId(cpInstanceId);
        HashMap<String, List<String>> cpDefinitionOptionRelKeysCPDefinitionOptionValueRelKeys = new HashMap<String, List<String>>();
        for (CPInstanceOptionValueRel cpInstanceOptionValueRel : cpInstanceOptionValueRels) {
            CPDefinitionOptionRel cpDefinitionOptionRel = this.cpDefinitionOptionRelPersistence.fetchByPrimaryKey(cpInstanceOptionValueRel.getCPDefinitionOptionRelId());
            if (cpDefinitionOptionRel == null) continue;
            ArrayList<String> cpDefinitionOptionValueRelKeys = (ArrayList<String>)cpDefinitionOptionRelKeysCPDefinitionOptionValueRelKeys.get(cpDefinitionOptionRel.getKey());
            if (cpDefinitionOptionValueRelKeys == null) {
                cpDefinitionOptionValueRelKeys = new ArrayList<String>();
                cpDefinitionOptionRelKeysCPDefinitionOptionValueRelKeys.put(cpDefinitionOptionRel.getKey(), cpDefinitionOptionValueRelKeys);
            }
            if (cpInstanceOptionValueRel.getCPDefinitionOptionValueRelId() == 0L) continue;
            CPDefinitionOptionValueRel cpDefinitionOptionValueRel = this.cpDefinitionOptionValueRelPersistence.findByPrimaryKey(cpInstanceOptionValueRel.getCPDefinitionOptionValueRelId());
            cpDefinitionOptionValueRelKeys.add(cpDefinitionOptionValueRel.getKey());
        }
        return cpDefinitionOptionRelKeysCPDefinitionOptionValueRelKeys;
    }

    public List<CPDefinitionOptionRel> getCPDefinitionOptionRels(long cpDefinitionId) {
        return this.cpDefinitionOptionRelPersistence.findByCPDefinitionId(cpDefinitionId);
    }

    public List<CPDefinitionOptionRel> getCPDefinitionOptionRels(long cpDefinitionId, boolean skuContributor) {
        return this.cpDefinitionOptionRelPersistence.findByC_SC(cpDefinitionId, skuContributor);
    }

    public List<CPDefinitionOptionRel> getCPDefinitionOptionRels(long cpDefinitionId, int start, int end) {
        return this.cpDefinitionOptionRelPersistence.findByCPDefinitionId(cpDefinitionId, start, end);
    }

    public List<CPDefinitionOptionRel> getCPDefinitionOptionRels(long cpDefinitionId, int start, int end, OrderByComparator<CPDefinitionOptionRel> orderByComparator) {
        return this.cpDefinitionOptionRelPersistence.findByCPDefinitionId(cpDefinitionId, start, end, orderByComparator);
    }

    public int getCPDefinitionOptionRelsCount(long cpDefinitionId) {
        return this.cpDefinitionOptionRelPersistence.countByCPDefinitionId(cpDefinitionId);
    }

    public int getCPDefinitionOptionRelsCount(long cpDefinitionId, boolean skuContributor) {
        return this.cpDefinitionOptionRelPersistence.countByC_SC(cpDefinitionId, skuContributor);
    }

    public boolean hasCPDefinitionPriceContributorCPDefinitionOptionRels(long cpDefinitionId) {
        List cpDefinitionOptionRels = this.cpDefinitionOptionRelPersistence.findByCPDefinitionId(cpDefinitionId);
        if (cpDefinitionOptionRels.isEmpty()) {
            return false;
        }
        for (CPDefinitionOptionRel cpDefinitionOptionRel : cpDefinitionOptionRels) {
            if (!cpDefinitionOptionRel.isPriceContributor()) continue;
            return true;
        }
        return false;
    }

    public boolean hasCPDefinitionRequiredCPDefinitionOptionRels(long cpDefinitionId) {
        long count = this.cpDefinitionOptionRelPersistence.countByCPDI_R(cpDefinitionId, true);
        return count != 0L;
    }

    public boolean hasLinkedCPInstanceCPDefinitionOptionRels(long cpDefinitionId) {
        List cpDefinitionOptionRels = this.cpDefinitionOptionRelPersistence.findByCPDefinitionId(cpDefinitionId);
        if (cpDefinitionOptionRels.isEmpty()) {
            return false;
        }
        for (CPDefinitionOptionRel cpDefinitionOptionRel : cpDefinitionOptionRels) {
            if (!cpDefinitionOptionRel.isPriceContributor()) continue;
            for (CPDefinitionOptionValueRel cpDefinitionOptionValueRel : cpDefinitionOptionRel.getCPDefinitionOptionValueRels()) {
                CPInstance cpInstance;
                if (Validator.isNull((String)cpDefinitionOptionValueRel.getCPInstanceUuid()) || (cpInstance = cpDefinitionOptionValueRel.fetchCPInstance()) == null) continue;
                return true;
            }
        }
        return false;
    }

    public Hits search(SearchContext searchContext) {
        try {
            Indexer indexer = IndexerRegistryUtil.nullSafeGetIndexer(CPDefinitionOptionRel.class);
            return indexer.search(searchContext);
        }
        catch (Exception exception) {
            throw new SystemException((Throwable)exception);
        }
    }

    @Deprecated
    public BaseModelSearchResult<CPDefinitionOptionRel> searchCPDefinitionOptionRels(long companyId, long groupId, long cpDefinitionId, String keywords, int start, int end, Sort sort) throws PortalException {
        return this.searchCPDefinitionOptionRels(companyId, groupId, cpDefinitionId, keywords, start, end, new Sort[]{sort});
    }

    public BaseModelSearchResult<CPDefinitionOptionRel> searchCPDefinitionOptionRels(long companyId, long groupId, long cpDefinitionId, String keywords, int start, int end, Sort[] sorts) throws PortalException {
        SearchContext searchContext = this.buildSearchContext(companyId, groupId, cpDefinitionId, keywords, start, end, sorts);
        return this.searchCPOptions(searchContext);
    }

    public int searchCPDefinitionOptionRelsCount(long companyId, long groupId, long cpDefinitionId, String keywords) throws PortalException {
        SearchContext searchContext = this.buildSearchContext(companyId, groupId, cpDefinitionId, keywords, -1, -1, null);
        return this.searchCPDefinitionOptionRelsCount(searchContext);
    }

    public CPDefinitionOptionRel updateCPDefinitionOptionRel(long cpDefinitionOptionRelId, long cpOptionId, Map<Locale, String> nameMap, Map<Locale, String> descriptionMap, String ddmFormFieldTypeName, double priority, boolean facetable, boolean required, boolean skuContributor, ServiceContext serviceContext) throws PortalException {
        return this.cpDefinitionOptionRelLocalService.updateCPDefinitionOptionRel(cpDefinitionOptionRelId, cpOptionId, nameMap, descriptionMap, ddmFormFieldTypeName, priority, facetable, required, skuContributor, null, serviceContext);
    }

    @Indexable(type=IndexableType.REINDEX)
    public CPDefinitionOptionRel updateCPDefinitionOptionRel(long cpDefinitionOptionRelId, long cpOptionId, Map<Locale, String> nameMap, Map<Locale, String> descriptionMap, String ddmFormFieldTypeName, double priority, boolean facetable, boolean required, boolean skuContributor, String priceType, ServiceContext serviceContext) throws PortalException {
        this._validateDDMFormFieldTypeName(ddmFormFieldTypeName, skuContributor);
        CPDefinitionOptionRel cpDefinitionOptionRel = this.cpDefinitionOptionRelPersistence.findByPrimaryKey(cpDefinitionOptionRelId);
        this._validatePriceType(cpDefinitionOptionRel, priceType);
        if (this.cpDefinitionLocalService.isVersionable(cpDefinitionOptionRel.getCPDefinitionId(), serviceContext.getRequest())) {
            CPDefinition newCPDefinition = this.cpDefinitionLocalService.copyCPDefinition(cpDefinitionOptionRel.getCPDefinitionId());
            cpDefinitionOptionRel = this.cpDefinitionOptionRelPersistence.findByC_C(newCPDefinition.getCPDefinitionId(), cpDefinitionOptionRel.getCPOptionId());
        }
        cpDefinitionOptionRel.setCPOptionId(cpOptionId);
        cpDefinitionOptionRel.setNameMap(nameMap);
        cpDefinitionOptionRel.setDescriptionMap(descriptionMap);
        cpDefinitionOptionRel.setDDMFormFieldTypeName(ddmFormFieldTypeName);
        cpDefinitionOptionRel.setPriority(priority);
        cpDefinitionOptionRel.setFacetable(facetable);
        cpDefinitionOptionRel.setRequired(required);
        cpDefinitionOptionRel.setSkuContributor(skuContributor);
        cpDefinitionOptionRel.setPriceType(priceType);
        cpDefinitionOptionRel.setExpandoBridgeAttributes(serviceContext);
        cpDefinitionOptionRel = (CPDefinitionOptionRel)this.cpDefinitionOptionRelPersistence.update((BaseModel)cpDefinitionOptionRel);
        this._updateCPDefinitionOptionValueRels(cpDefinitionOptionRelId, priceType);
        this.cpInstanceLocalService.inactivateIncompatibleCPInstances(serviceContext.getUserId(), cpDefinitionOptionRel.getCPDefinitionId());
        this._updateCPDefinitionIgnoreSKUCombinations(cpDefinitionOptionRel.getCPDefinitionId(), serviceContext);
        this.reindexCPDefinition(cpDefinitionOptionRel.getCPDefinitionId());
        return cpDefinitionOptionRel;
    }

    protected SearchContext buildSearchContext(long companyId, long groupId, long cpDefinitionId, String keywords, int start, int end, Sort[] sorts) {
        SearchContext searchContext = new SearchContext();
        searchContext.setAttributes((Map)HashMapBuilder.put((Object)"content", (Object)keywords).put((Object)"entryClassPK", (Object)keywords).put((Object)"name", (Object)keywords).put((Object)"CPDefinitionId", (Object)cpDefinitionId).put((Object)"params", (Object)LinkedHashMapBuilder.put((Object)"keywords", (Object)keywords).build()).build());
        searchContext.setCompanyId(companyId);
        searchContext.setEnd(end);
        searchContext.setGroupIds(new long[]{groupId});
        if (Validator.isNotNull((String)keywords)) {
            searchContext.setKeywords(keywords);
        }
        if (sorts != null) {
            searchContext.setSorts(sorts);
        }
        searchContext.setStart(start);
        QueryConfig queryConfig = searchContext.getQueryConfig();
        queryConfig.setHighlightEnabled(false);
        queryConfig.setScoreEnabled(false);
        return searchContext;
    }

    protected List<CPDefinitionOptionRel> getCPDefinitionOptionRels(Hits hits) throws PortalException {
        List documents = hits.toList();
        ArrayList<CPDefinitionOptionRel> cpDefinitionOptionRels = new ArrayList<CPDefinitionOptionRel>(documents.size());
        for (Document document : documents) {
            long cpDefinitionOptionRelId = GetterUtil.getLong((String)document.get("entryClassPK"));
            CPDefinitionOptionRel cpDefinitionOptionRel = this.fetchCPDefinitionOptionRel(cpDefinitionOptionRelId);
            if (cpDefinitionOptionRel == null) {
                cpDefinitionOptionRels = null;
                Indexer indexer = IndexerRegistryUtil.getIndexer(CPDefinitionOptionRel.class);
                long companyId = GetterUtil.getLong((String)document.get("companyId"));
                indexer.delete(companyId, document.getUID());
                continue;
            }
            if (cpDefinitionOptionRels == null) continue;
            cpDefinitionOptionRels.add(cpDefinitionOptionRel);
        }
        return cpDefinitionOptionRels;
    }

    protected void reindexCPDefinition(long cpDefinitionId) throws PortalException {
        Indexer indexer = IndexerRegistryUtil.nullSafeGetIndexer(CPDefinition.class);
        indexer.reindex(CPDefinition.class.getName(), cpDefinitionId);
    }

    protected int searchCPDefinitionOptionRelsCount(SearchContext searchContext) throws PortalException {
        Indexer indexer = IndexerRegistryUtil.nullSafeGetIndexer(CPDefinitionOptionRel.class);
        return GetterUtil.getInteger((Object)indexer.searchCount(searchContext));
    }

    protected BaseModelSearchResult<CPDefinitionOptionRel> searchCPOptions(SearchContext searchContext) throws PortalException {
        Indexer indexer = IndexerRegistryUtil.nullSafeGetIndexer(CPDefinitionOptionRel.class);
        for (int i = 0; i < 10; ++i) {
            Hits hits = indexer.search(searchContext, _SELECTED_FIELD_NAMES);
            List<CPDefinitionOptionRel> cpDefinitionOptionRels = this.getCPDefinitionOptionRels(hits);
            if (cpDefinitionOptionRels == null) continue;
            return new BaseModelSearchResult(cpDefinitionOptionRels, hits.getLength());
        }
        throw new SearchException("Unable to fix the search index after 10 attempts");
    }

    private CPOptionConfiguration _getCPOptionConfiguration() throws ConfigurationException {
        return (CPOptionConfiguration)this._configurationProvider.getConfiguration(CPOptionConfiguration.class, (SettingsLocator)new SystemSettingsLocator("com.liferay.commerce.product.option"));
    }

    private boolean _hasCPDefinitionSKUContributorCPDefinitionOptionRel(long cpDefinitionId) {
        int cpDefinitionOptionRelsCount = this.cpDefinitionOptionRelPersistence.countByC_SC(cpDefinitionId, true);
        return cpDefinitionOptionRelsCount > 0;
    }

    private void _updateCPDefinitionIgnoreSKUCombinations(long cpDefintionId, ServiceContext serviceContext) throws PortalException {
        if (this._hasCPDefinitionSKUContributorCPDefinitionOptionRel(cpDefintionId)) {
            this.cpDefinitionLocalService.updateCPDefinitionIgnoreSKUCombinations(cpDefintionId, false, serviceContext);
            return;
        }
        this.cpDefinitionLocalService.updateCPDefinitionIgnoreSKUCombinations(cpDefintionId, true, serviceContext);
    }

    private void _updateCPDefinitionOptionValueRels(long cpDefinitionOptionRelId, String priceType) {
        if (!Objects.equals(priceType, "static")) {
            return;
        }
        List cpDefinitionOptionValueRels = this.cpDefinitionOptionValueRelLocalService.getCPDefinitionOptionValueRels(cpDefinitionOptionRelId);
        if (cpDefinitionOptionValueRels == null || cpDefinitionOptionValueRels.isEmpty()) {
            return;
        }
        for (CPDefinitionOptionValueRel cpDefinitionOptionValueRel : cpDefinitionOptionValueRels) {
            if (cpDefinitionOptionValueRel.getPrice() != null) continue;
            cpDefinitionOptionValueRel.setPrice(BigDecimal.ZERO);
            this.cpDefinitionOptionValueRelLocalService.updateCPDefinitionOptionValueRel(cpDefinitionOptionValueRel);
        }
    }

    private void _validateCPDefinitionOptionKey(long cpDefinitionId, String key) throws PortalException {
        CPDefinitionOptionRel cpDefinitionOptionRel = this.cpDefinitionOptionRelPersistence.fetchByC_K(cpDefinitionId, key);
        if (cpDefinitionOptionRel != null) {
            throw new DuplicateCPDefinitionOptionRelKeyException();
        }
    }

    private void _validateDDMFormFieldTypeName(String ddmFormFieldTypeName, boolean skuContributor) throws PortalException {
        if (Validator.isNull((String)ddmFormFieldTypeName)) {
            throw new CPDefinitionOptionSKUContributorException();
        }
        CPOptionConfiguration cpOptionConfiguration = this._getCPOptionConfiguration();
        Object[] ddmFormFieldTypesAllowed = cpOptionConfiguration.ddmFormFieldTypesAllowed();
        if (skuContributor) {
            ddmFormFieldTypesAllowed = CPConstants.PRODUCT_OPTION_SKU_CONTRIBUTOR_FIELD_TYPES;
        }
        if (ArrayUtil.contains((Object[])ddmFormFieldTypesAllowed, (Object)ddmFormFieldTypeName)) {
            return;
        }
        throw new CPDefinitionOptionSKUContributorException();
    }

    private void _validatePriceType(CPDefinitionOptionRel cpDefinitionOptionRel, String priceType) throws PortalException {
        if (cpDefinitionOptionRel.isNew() || !cpDefinitionOptionRel.isPriceContributor() || Objects.equals(cpDefinitionOptionRel.getPriceType(), priceType) || !this.cpDefinitionOptionValueRelLocalService.hasCPDefinitionOptionValueRels(cpDefinitionOptionRel.getCPDefinitionOptionRelId()) || Objects.equals(priceType, "static")) {
            return;
        }
        throw new CPDefinitionOptionRelPriceTypeException();
    }
}

