/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.product.service.impl;

import com.liferay.commerce.product.exception.NoSuchCPDefinitionException;
import com.liferay.commerce.product.model.CPDefinition;
import com.liferay.commerce.product.model.CPDefinitionOptionRel;
import com.liferay.commerce.product.model.CPInstance;
import com.liferay.commerce.product.model.CommerceCatalog;
import com.liferay.commerce.product.service.base.CPDefinitionOptionRelServiceBaseImpl;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.ClassedModel;
import com.liferay.portal.kernel.search.BaseModelSearchResult;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermissionFactory;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.OrderByComparator;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class CPDefinitionOptionRelServiceImpl
extends CPDefinitionOptionRelServiceBaseImpl {
    private static volatile ModelResourcePermission<CommerceCatalog> _commerceCatalogModelResourcePermission = ModelResourcePermissionFactory.getInstance(CPDefinitionOptionRelServiceImpl.class, (String)"_commerceCatalogModelResourcePermission", CommerceCatalog.class);

    public CPDefinitionOptionRel addCPDefinitionOptionRel(long cpDefinitionId, long cpOptionId, Map<Locale, String> nameMap, Map<Locale, String> descriptionMap, String ddmFormFieldTypeName, double priority, boolean facetable, boolean required, boolean skuContributor, boolean importOptionValue, ServiceContext serviceContext) throws PortalException {
        this._checkCommerceCatalog(cpDefinitionId, "UPDATE");
        return this.cpDefinitionOptionRelLocalService.addCPDefinitionOptionRel(cpDefinitionId, cpOptionId, nameMap, descriptionMap, ddmFormFieldTypeName, priority, facetable, required, skuContributor, importOptionValue, serviceContext);
    }

    public CPDefinitionOptionRel addCPDefinitionOptionRel(long cpDefinitionId, long cpOptionId, Map<Locale, String> nameMap, Map<Locale, String> descriptionMap, String ddmFormFieldTypeName, double priority, boolean facetable, boolean required, boolean skuContributor, boolean importOptionValue, String priceType, ServiceContext serviceContext) throws PortalException {
        this._checkCommerceCatalog(cpDefinitionId, "UPDATE");
        return this.cpDefinitionOptionRelLocalService.addCPDefinitionOptionRel(cpDefinitionId, cpOptionId, nameMap, descriptionMap, ddmFormFieldTypeName, priority, facetable, required, skuContributor, importOptionValue, priceType, serviceContext);
    }

    public CPDefinitionOptionRel addCPDefinitionOptionRel(long cpDefinitionId, long cpOptionId, ServiceContext serviceContext) throws PortalException {
        this._checkCommerceCatalog(cpDefinitionId, "UPDATE");
        return this.cpDefinitionOptionRelLocalService.addCPDefinitionOptionRel(cpDefinitionId, cpOptionId, true, serviceContext);
    }

    public void deleteCPDefinitionOptionRel(long cpDefinitionOptionRelId) throws PortalException {
        CPDefinitionOptionRel cpDefinitionOptionRel = this.cpDefinitionOptionRelLocalService.getCPDefinitionOptionRel(cpDefinitionOptionRelId);
        this._checkCommerceCatalog(cpDefinitionOptionRel.getCPDefinitionId(), "UPDATE");
        this.cpDefinitionOptionRelLocalService.deleteCPDefinitionOptionRel(cpDefinitionOptionRel);
    }

    public CPDefinitionOptionRel fetchCPDefinitionOptionRel(long cpDefinitionOptionRelId) throws PortalException {
        CPDefinitionOptionRel cpDefinitionOptionRel = this.cpDefinitionOptionRelLocalService.fetchCPDefinitionOptionRel(cpDefinitionOptionRelId);
        if (cpDefinitionOptionRel != null) {
            this._checkCommerceCatalog(cpDefinitionOptionRel.getCPDefinitionId(), "VIEW");
        }
        return cpDefinitionOptionRel;
    }

    public CPDefinitionOptionRel fetchCPDefinitionOptionRel(long cpDefinitionId, long cpOptionId) throws PortalException {
        this._checkCommerceCatalog(cpDefinitionId, "VIEW");
        return this.cpDefinitionOptionRelLocalService.fetchCPDefinitionOptionRel(cpDefinitionId, cpOptionId);
    }

    public CPDefinitionOptionRel getCPDefinitionOptionRel(long cpDefinitionOptionRelId) throws PortalException {
        CPDefinitionOptionRel cpDefinitionOptionRel = this.cpDefinitionOptionRelLocalService.getCPDefinitionOptionRel(cpDefinitionOptionRelId);
        this._checkCommerceCatalog(cpDefinitionOptionRel.getCPDefinitionId(), "VIEW");
        return cpDefinitionOptionRel;
    }

    public Map<Long, List<Long>> getCPDefinitionOptionRelCPDefinitionOptionValueRelIds(long cpDefinitionId, String json) throws PortalException {
        this._checkCommerceCatalog(cpDefinitionId, "VIEW");
        return this.cpDefinitionOptionRelLocalService.getCPDefinitionOptionRelCPDefinitionOptionValueRelIds(cpDefinitionId, json);
    }

    public Map<String, List<String>> getCPDefinitionOptionRelKeysCPDefinitionOptionValueRelKeys(long cpInstanceId) throws PortalException {
        CPInstance cpInstance = this.cpInstanceLocalService.getCPInstance(cpInstanceId);
        this._checkCommerceCatalog(cpInstance.getCPDefinitionId(), "VIEW");
        return this.cpDefinitionOptionRelLocalService.getCPDefinitionOptionRelKeysCPDefinitionOptionValueRelKeys(cpInstanceId);
    }

    public List<CPDefinitionOptionRel> getCPDefinitionOptionRels(long cpDefinitionId, boolean skuContributor) throws PortalException {
        this._checkCommerceCatalog(cpDefinitionId, "VIEW");
        return this.cpDefinitionOptionRelLocalService.getCPDefinitionOptionRels(cpDefinitionId, skuContributor);
    }

    public List<CPDefinitionOptionRel> getCPDefinitionOptionRels(long cpDefinitionId, int start, int end) throws PortalException {
        this._checkCommerceCatalog(cpDefinitionId, "VIEW");
        return this.cpDefinitionOptionRelLocalService.getCPDefinitionOptionRels(cpDefinitionId, start, end);
    }

    public List<CPDefinitionOptionRel> getCPDefinitionOptionRels(long cpDefinitionId, int start, int end, OrderByComparator<CPDefinitionOptionRel> orderByComparator) throws PortalException {
        this._checkCommerceCatalog(cpDefinitionId, "VIEW");
        return this.cpDefinitionOptionRelLocalService.getCPDefinitionOptionRels(cpDefinitionId, start, end, orderByComparator);
    }

    public int getCPDefinitionOptionRelsCount(long cpDefinitionId) throws PortalException {
        this._checkCommerceCatalog(cpDefinitionId, "VIEW");
        return this.cpDefinitionOptionRelLocalService.getCPDefinitionOptionRelsCount(cpDefinitionId);
    }

    public int getCPDefinitionOptionRelsCount(long cpDefinitionId, boolean skuContributor) throws PortalException {
        this._checkCommerceCatalog(cpDefinitionId, "VIEW");
        return this.cpDefinitionOptionRelLocalService.getCPDefinitionOptionRelsCount(cpDefinitionId, skuContributor);
    }

    @Deprecated
    public BaseModelSearchResult<CPDefinitionOptionRel> searchCPDefinitionOptionRels(long companyId, long groupId, long cpDefinitionId, String keywords, int start, int end, Sort sort) throws PortalException {
        return this.cpDefinitionOptionRelService.searchCPDefinitionOptionRels(companyId, groupId, cpDefinitionId, keywords, start, end, new Sort[]{sort});
    }

    public BaseModelSearchResult<CPDefinitionOptionRel> searchCPDefinitionOptionRels(long companyId, long groupId, long cpDefinitionId, String keywords, int start, int end, Sort[] sorts) throws PortalException {
        this._checkCommerceCatalog(cpDefinitionId, "VIEW");
        return this.cpDefinitionOptionRelLocalService.searchCPDefinitionOptionRels(companyId, groupId, cpDefinitionId, keywords, start, end, sorts);
    }

    public int searchCPDefinitionOptionRelsCount(long companyId, long groupId, long cpDefinitionId, String keywords) throws PortalException {
        this._checkCommerceCatalog(cpDefinitionId, "VIEW");
        return this.cpDefinitionOptionRelLocalService.searchCPDefinitionOptionRelsCount(companyId, groupId, cpDefinitionId, keywords);
    }

    public CPDefinitionOptionRel updateCPDefinitionOptionRel(long cpDefinitionOptionRelId, long cpOptionId, Map<Locale, String> nameMap, Map<Locale, String> descriptionMap, String ddmFormFieldTypeName, double priority, boolean facetable, boolean required, boolean skuContributor, ServiceContext serviceContext) throws PortalException {
        CPDefinitionOptionRel cpDefinitionOptionRel = this.cpDefinitionOptionRelLocalService.getCPDefinitionOptionRel(cpDefinitionOptionRelId);
        this._checkCommerceCatalog(cpDefinitionOptionRel.getCPDefinitionId(), "UPDATE");
        return this.cpDefinitionOptionRelLocalService.updateCPDefinitionOptionRel(cpDefinitionOptionRel.getCPDefinitionOptionRelId(), cpOptionId, nameMap, descriptionMap, ddmFormFieldTypeName, priority, facetable, required, skuContributor, serviceContext);
    }

    public CPDefinitionOptionRel updateCPDefinitionOptionRel(long cpDefinitionOptionRelId, long cpOptionId, Map<Locale, String> nameMap, Map<Locale, String> descriptionMap, String ddmFormFieldTypeName, double priority, boolean facetable, boolean required, boolean skuContributor, String priceType, ServiceContext serviceContext) throws PortalException {
        CPDefinitionOptionRel cpDefinitionOptionRel = this.cpDefinitionOptionRelLocalService.getCPDefinitionOptionRel(cpDefinitionOptionRelId);
        this._checkCommerceCatalog(cpDefinitionOptionRel.getCPDefinitionId(), "UPDATE");
        return this.cpDefinitionOptionRelLocalService.updateCPDefinitionOptionRel(cpDefinitionOptionRel.getCPDefinitionOptionRelId(), cpOptionId, nameMap, descriptionMap, ddmFormFieldTypeName, priority, facetable, required, skuContributor, priceType, serviceContext);
    }

    private void _checkCommerceCatalog(long cpDefinitionId, String actionId) throws PortalException {
        CPDefinition cpDefinition = this.cpDefinitionLocalService.fetchCPDefinition(cpDefinitionId);
        if (cpDefinition == null) {
            throw new NoSuchCPDefinitionException();
        }
        CommerceCatalog commerceCatalog = this.commerceCatalogLocalService.fetchCommerceCatalogByGroupId(cpDefinition.getGroupId());
        if (commerceCatalog == null) {
            throw new PrincipalException();
        }
        _commerceCatalogModelResourcePermission.check(this.getPermissionChecker(), (ClassedModel)commerceCatalog, actionId);
    }
}

