/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.product.service.impl;

import com.liferay.commerce.product.exception.CPDefinitionOptionValueRelCPInstanceException;
import com.liferay.commerce.product.exception.CPDefinitionOptionValueRelKeyException;
import com.liferay.commerce.product.exception.CPDefinitionOptionValueRelPriceException;
import com.liferay.commerce.product.exception.CPDefinitionOptionValueRelQuantityException;
import com.liferay.commerce.product.exception.NoSuchCPDefinitionOptionValueRelException;
import com.liferay.commerce.product.model.CPDefinition;
import com.liferay.commerce.product.model.CPDefinitionOptionRel;
import com.liferay.commerce.product.model.CPDefinitionOptionValueRel;
import com.liferay.commerce.product.model.CPInstance;
import com.liferay.commerce.product.model.CPInstanceOptionValueRel;
import com.liferay.commerce.product.model.CPOption;
import com.liferay.commerce.product.model.CPOptionValue;
import com.liferay.commerce.product.service.base.CPDefinitionOptionValueRelLocalServiceBaseImpl;
import com.liferay.expando.kernel.model.ExpandoBridge;
import com.liferay.portal.kernel.dao.orm.Criterion;
import com.liferay.portal.kernel.dao.orm.DynamicQuery;
import com.liferay.portal.kernel.dao.orm.OrderFactoryUtil;
import com.liferay.portal.kernel.dao.orm.Property;
import com.liferay.portal.kernel.dao.orm.PropertyFactoryUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.search.BaseModelSearchResult;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.Hits;
import com.liferay.portal.kernel.search.Indexable;
import com.liferay.portal.kernel.search.IndexableType;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerRegistryUtil;
import com.liferay.portal.kernel.search.QueryConfig;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.SearchException;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.security.auth.PrincipalThreadLocal;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.systemevent.SystemEvent;
import com.liferay.portal.kernel.util.FriendlyURLNormalizerUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.LinkedHashMapBuilder;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.taglib.util.CustomAttributesUtil;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;

public class CPDefinitionOptionValueRelLocalServiceImpl
extends CPDefinitionOptionValueRelLocalServiceBaseImpl {
    private static final String _FIELD_KEY = "key";
    private static final String[] _SELECTED_FIELD_NAMES = new String[]{"entryClassPK", "companyId", "groupId", "uid"};

    public CPDefinitionOptionValueRel addCPDefinitionOptionValueRel(long cpDefinitionOptionRelId, CPOptionValue cpOptionValue, ServiceContext serviceContext) throws PortalException {
        return this.cpDefinitionOptionValueRelLocalService.addCPDefinitionOptionValueRel(cpDefinitionOptionRelId, cpOptionValue.getNameMap(), cpOptionValue.getPriority(), cpOptionValue.getKey(), serviceContext);
    }

    @Indexable(type=IndexableType.REINDEX)
    public CPDefinitionOptionValueRel addCPDefinitionOptionValueRel(long cpDefinitionOptionRelId, Map<Locale, String> nameMap, double priority, String key, ServiceContext serviceContext) throws PortalException {
        User user = this.userLocalService.getUser(serviceContext.getUserId());
        key = FriendlyURLNormalizerUtil.normalize((String)key);
        this.validate(0L, cpDefinitionOptionRelId, key);
        long cpDefinitionOptionValueRelId = this.counterLocalService.increment();
        CPDefinitionOptionValueRel cpDefinitionOptionValueRel = this.cpDefinitionOptionValueRelPersistence.create(cpDefinitionOptionValueRelId);
        CPDefinitionOptionRel cpDefinitionOptionRel = this.cpDefinitionOptionRelLocalService.getCPDefinitionOptionRel(cpDefinitionOptionRelId);
        if (this.cpDefinitionLocalService.isVersionable(cpDefinitionOptionRel.getCPDefinitionId(), serviceContext.getRequest())) {
            CPDefinition newCPDefinition = this.cpDefinitionLocalService.copyCPDefinition(cpDefinitionOptionRel.getCPDefinitionId());
            cpDefinitionOptionRel = this.cpDefinitionOptionRelPersistence.findByC_C(newCPDefinition.getCPDefinitionId(), cpDefinitionOptionRel.getCPOptionId());
            cpDefinitionOptionRelId = cpDefinitionOptionRel.getCPDefinitionOptionRelId();
        }
        cpDefinitionOptionValueRel.setGroupId(cpDefinitionOptionRel.getGroupId());
        cpDefinitionOptionValueRel.setCompanyId(user.getCompanyId());
        cpDefinitionOptionValueRel.setUserId(user.getUserId());
        cpDefinitionOptionValueRel.setUserName(user.getFullName());
        cpDefinitionOptionValueRel.setCPDefinitionOptionRelId(cpDefinitionOptionRelId);
        cpDefinitionOptionValueRel.setNameMap(nameMap);
        cpDefinitionOptionValueRel.setPriority(priority);
        cpDefinitionOptionValueRel.setKey(key);
        cpDefinitionOptionValueRel.setExpandoBridgeAttributes(serviceContext);
        if (cpDefinitionOptionRel.isPriceTypeStatic()) {
            cpDefinitionOptionValueRel.setPrice(BigDecimal.ZERO);
        }
        this._validateLinkedCPDefinitionOptionValueRel(cpDefinitionOptionValueRel);
        this._validatePriceableCPDefinitionOptionValue(cpDefinitionOptionValueRel, cpDefinitionOptionRel.getPriceType());
        cpDefinitionOptionValueRel = (CPDefinitionOptionValueRel)this.cpDefinitionOptionValueRelPersistence.update((BaseModel)cpDefinitionOptionValueRel);
        this.reindexCPDefinition(cpDefinitionOptionRel);
        return cpDefinitionOptionValueRel;
    }

    @Override
    @Indexable(type=IndexableType.DELETE)
    @SystemEvent(type=1)
    public CPDefinitionOptionValueRel deleteCPDefinitionOptionValueRel(CPDefinitionOptionValueRel cpDefinitionOptionValueRel) throws PortalException {
        CPDefinitionOptionRel cpDefinitionOptionRel = cpDefinitionOptionValueRel.getCPDefinitionOptionRel();
        if (this.cpDefinitionLocalService.isVersionable(cpDefinitionOptionRel.getCPDefinitionId())) {
            CPDefinition newCPDefinition = this.cpDefinitionLocalService.copyCPDefinition(cpDefinitionOptionRel.getCPDefinitionId());
            cpDefinitionOptionRel = this.cpDefinitionOptionRelPersistence.findByC_C(newCPDefinition.getCPDefinitionId(), cpDefinitionOptionRel.getCPOptionId());
            cpDefinitionOptionValueRel = this.cpDefinitionOptionValueRelPersistence.findByC_K(cpDefinitionOptionRel.getCPDefinitionOptionRelId(), cpDefinitionOptionValueRel.getKey());
        }
        this.cpDefinitionOptionValueRelPersistence.remove((BaseModel)cpDefinitionOptionValueRel);
        this.expandoRowLocalService.deleteRows(cpDefinitionOptionValueRel.getCPDefinitionOptionValueRelId());
        this.cpInstanceLocalService.inactivateCPDefinitionOptionValueRelCPInstances(PrincipalThreadLocal.getUserId(), cpDefinitionOptionRel.getCPDefinitionId(), cpDefinitionOptionValueRel.getCPDefinitionOptionValueRelId());
        this.reindexCPDefinition(cpDefinitionOptionRel);
        return cpDefinitionOptionValueRel;
    }

    @Override
    public CPDefinitionOptionValueRel deleteCPDefinitionOptionValueRel(long cpDefinitionOptionValueRelId) throws PortalException {
        CPDefinitionOptionValueRel cpDefinitionOptionValueRel = this.cpDefinitionOptionValueRelPersistence.findByPrimaryKey(cpDefinitionOptionValueRelId);
        return this.cpDefinitionOptionValueRelLocalService.deleteCPDefinitionOptionValueRel(cpDefinitionOptionValueRel);
    }

    public void deleteCPDefinitionOptionValueRels(long cpDefinitionOptionRelId) throws PortalException {
        List cpDefinitionOptionValueRels = this.cpDefinitionOptionValueRelLocalService.getCPDefinitionOptionValueRels(cpDefinitionOptionRelId, -1, -1);
        for (CPDefinitionOptionValueRel cpDefinitionOptionValueRel : cpDefinitionOptionValueRels) {
            this.cpDefinitionOptionValueRelLocalService.deleteCPDefinitionOptionValueRel(cpDefinitionOptionValueRel);
        }
    }

    public CPDefinitionOptionValueRel fetchCPDefinitionOptionValueRel(long cpDefinitionOptionRelId, String key) {
        return this.cpDefinitionOptionValueRelPersistence.fetchByC_K(cpDefinitionOptionRelId, key);
    }

    public CPDefinitionOptionValueRel fetchPreselectedCPDefinitionOptionValueRel(long cpDefinitionOptionRelId) {
        List preselectedCPDefinitionOptionValueRels = this.cpDefinitionOptionValueRelPersistence.findByCDORI_P(cpDefinitionOptionRelId, true);
        if (preselectedCPDefinitionOptionValueRels.isEmpty()) {
            return null;
        }
        return (CPDefinitionOptionValueRel)preselectedCPDefinitionOptionValueRels.get(0);
    }

    public List<CPDefinitionOptionValueRel> filterByCPInstanceOptionValueRels(List<CPDefinitionOptionValueRel> cpDefinitionOptionValueRels, List<CPInstanceOptionValueRel> cpInstanceOptionValueRels) {
        ArrayList<CPDefinitionOptionValueRel> filteredCPDefinitionOptionValueRels = new ArrayList<CPDefinitionOptionValueRel>();
        block0: for (CPDefinitionOptionValueRel cpDefinitionOptionValueRel : cpDefinitionOptionValueRels) {
            for (CPInstanceOptionValueRel cpInstanceOptionValueRel : cpInstanceOptionValueRels) {
                long cpDefinitionOptionValueRelId2;
                long cpDefinitionOptionValueRelId1 = cpDefinitionOptionValueRel.getCPDefinitionOptionValueRelId();
                if (cpDefinitionOptionValueRelId1 != (cpDefinitionOptionValueRelId2 = cpInstanceOptionValueRel.getCPDefinitionOptionValueRelId())) continue;
                filteredCPDefinitionOptionValueRels.add(cpDefinitionOptionValueRel);
                continue block0;
            }
        }
        return filteredCPDefinitionOptionValueRels;
    }

    public List<CPDefinitionOptionValueRel> getCPDefinitionOptionValueRels(long cpDefinitionOptionRelId) {
        return this.cpDefinitionOptionValueRelPersistence.findByCPDefinitionOptionRelId(cpDefinitionOptionRelId);
    }

    public List<CPDefinitionOptionValueRel> getCPDefinitionOptionValueRels(long cpDefinitionOptionRelId, int start, int end) {
        return this.cpDefinitionOptionValueRelPersistence.findByCPDefinitionOptionRelId(cpDefinitionOptionRelId, start, end);
    }

    public List<CPDefinitionOptionValueRel> getCPDefinitionOptionValueRels(long cpDefinitionOptionRelId, int start, int end, OrderByComparator<CPDefinitionOptionValueRel> orderByComparator) {
        return this.cpDefinitionOptionValueRelPersistence.findByCPDefinitionOptionRelId(cpDefinitionOptionRelId, start, end, orderByComparator);
    }

    public List<CPDefinitionOptionValueRel> getCPDefinitionOptionValueRels(long[] cpDefinitionOptionValueRelsId) throws PortalException {
        if (cpDefinitionOptionValueRelsId == null || cpDefinitionOptionValueRelsId.length == 0) {
            return Collections.emptyList();
        }
        DynamicQuery dynamicQuery = this.dynamicQuery();
        Property property = PropertyFactoryUtil.forName((String)"CPDefinitionOptionValueRelId");
        Criterion criterion = property.in(cpDefinitionOptionValueRelsId);
        dynamicQuery.add(criterion);
        dynamicQuery.addOrder(OrderFactoryUtil.asc((String)"priority"));
        return this.cpDefinitionOptionValueRelPersistence.findWithDynamicQuery(dynamicQuery);
    }

    public List<CPDefinitionOptionValueRel> getCPDefinitionOptionValueRels(String key, int start, int end) {
        return this.cpDefinitionOptionValueRelPersistence.findByKey(key, start, end);
    }

    public int getCPDefinitionOptionValueRelsCount(long cpDefinitionOptionRelId) {
        return this.cpDefinitionOptionValueRelPersistence.countByCPDefinitionOptionRelId(cpDefinitionOptionRelId);
    }

    public CPDefinitionOptionValueRel getCPInstanceCPDefinitionOptionValueRel(long cpDefinitionOptionRelId, long cpInstanceId) throws PortalException {
        List cpInstanceCPInstanceOptionValueRels = this.cpInstanceOptionValueRelLocalService.getCPInstanceCPInstanceOptionValueRels(cpDefinitionOptionRelId, cpInstanceId);
        for (CPInstanceOptionValueRel cpInstanceCPInstanceOptionValueRel : cpInstanceCPInstanceOptionValueRels) {
            if (cpDefinitionOptionRelId != cpInstanceCPInstanceOptionValueRel.getCPDefinitionOptionRelId()) continue;
            return this.cpDefinitionOptionValueRelPersistence.findByPrimaryKey(cpInstanceCPInstanceOptionValueRel.getCPDefinitionOptionValueRelId());
        }
        throw new NoSuchCPDefinitionOptionValueRelException(String.format("Unable to find option value with CP definition option ID %d assigned to CP instance ID %d", cpDefinitionOptionRelId, cpInstanceId));
    }

    public boolean hasCPDefinitionOptionValueRels(long cpDefinitionOptionRelId) {
        int count = this.cpDefinitionOptionValueRelPersistence.countByCPDefinitionOptionRelId(cpDefinitionOptionRelId);
        return count > 0;
    }

    public boolean hasPreselectedCPDefinitionOptionValueRel(long cpDefinitionOptionRelId) {
        int count = this.cpDefinitionOptionValueRelPersistence.countByCDORI_P(cpDefinitionOptionRelId, true);
        return count != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void importCPDefinitionOptionRels(long cpDefinitionOptionRelId, ServiceContext serviceContext) throws PortalException {
        CPDefinitionOptionRel cpDefinitionOptionRel = this.cpDefinitionOptionRelLocalService.getCPDefinitionOptionRel(cpDefinitionOptionRelId);
        CPOption cpOption = this.cpOptionLocalService.fetchCPOption(cpDefinitionOptionRel.getCPOptionId());
        if (cpOption == null) {
            return;
        }
        List cpOptionValues = this.cpOptionValueLocalService.getCPOptionValues(cpOption.getCPOptionId(), -1, -1);
        Map expandoBridgeAttributes = serviceContext.getExpandoBridgeAttributes();
        try {
            this._addCPDefinitionOptionValueRel(cpDefinitionOptionRelId, cpOptionValues, serviceContext);
        }
        finally {
            serviceContext.setExpandoBridgeAttributes(expandoBridgeAttributes);
        }
    }

    public CPDefinitionOptionValueRel resetCPInstanceCPDefinitionOptionValueRel(long cpDefinitionOptionValueRelId) throws PortalException {
        CPDefinitionOptionValueRel cpDefinitionOptionValueRel = this.cpDefinitionOptionValueRelLocalService.getCPDefinitionOptionValueRel(cpDefinitionOptionValueRelId);
        cpDefinitionOptionValueRel.setCPInstanceUuid(null);
        cpDefinitionOptionValueRel.setCProductId(0L);
        cpDefinitionOptionValueRel.setQuantity(0);
        return this.cpDefinitionOptionValueRelLocalService.updateCPDefinitionOptionValueRel(cpDefinitionOptionValueRel);
    }

    public void resetCPInstanceCPDefinitionOptionValueRels(String cpInstanceUuid) {
        List cpDefinitionOptionValueRels = this.cpDefinitionOptionValueRelPersistence.findByCPInstanceUuid(cpInstanceUuid);
        for (CPDefinitionOptionValueRel cpDefinitionOptionValueRel : cpDefinitionOptionValueRels) {
            cpDefinitionOptionValueRel.setCPInstanceUuid(null);
            cpDefinitionOptionValueRel.setCProductId(0L);
            cpDefinitionOptionValueRel.setQuantity(0);
            cpDefinitionOptionValueRel.setPrice(BigDecimal.ZERO);
            this.cpDefinitionOptionValueRelPersistence.update((BaseModel)cpDefinitionOptionValueRel);
        }
    }

    public Hits search(SearchContext searchContext) {
        try {
            Indexer indexer = IndexerRegistryUtil.nullSafeGetIndexer(CPDefinitionOptionValueRel.class);
            return indexer.search(searchContext);
        }
        catch (Exception exception) {
            throw new SystemException((Throwable)exception);
        }
    }

    @Deprecated
    public BaseModelSearchResult<CPDefinitionOptionValueRel> searchCPDefinitionOptionValueRels(long companyId, long groupId, long cpDefinitionOptionRelId, String keywords, int start, int end, Sort sort) throws PortalException {
        return this.searchCPDefinitionOptionValueRels(companyId, groupId, cpDefinitionOptionRelId, keywords, start, end, new Sort[]{sort});
    }

    public BaseModelSearchResult<CPDefinitionOptionValueRel> searchCPDefinitionOptionValueRels(long companyId, long groupId, long cpDefinitionOptionRelId, String keywords, int start, int end, Sort[] sorts) throws PortalException {
        SearchContext searchContext = this.buildSearchContext(companyId, groupId, cpDefinitionOptionRelId, keywords, start, end, sorts);
        return this.searchCPOptions(searchContext);
    }

    public int searchCPDefinitionOptionValueRelsCount(long companyId, long groupId, long cpDefinitionOptionRelId, String keywords) throws PortalException {
        SearchContext searchContext = this.buildSearchContext(companyId, groupId, cpDefinitionOptionRelId, keywords, -1, -1, null);
        return this.searchCPOptionsCount(searchContext);
    }

    @Deprecated
    public CPDefinitionOptionValueRel updateCPDefinitionOptionValueRel(long cpDefinitionOptionValueRelId, Map<Locale, String> nameMap, double priority, String key, long cpInstanceId, int quantity, BigDecimal price, ServiceContext serviceContext) throws PortalException {
        return this.cpDefinitionOptionValueRelLocalService.updateCPDefinitionOptionValueRel(cpDefinitionOptionValueRelId, nameMap, priority, key, cpInstanceId, quantity, false, price, serviceContext);
    }

    @Indexable(type=IndexableType.REINDEX)
    public CPDefinitionOptionValueRel updateCPDefinitionOptionValueRel(long cpDefinitionOptionValueRelId, Map<Locale, String> nameMap, double priority, String key, long cpInstanceId, int quantity, boolean preselected, BigDecimal price, ServiceContext serviceContext) throws PortalException {
        CPDefinitionOptionValueRel cpDefinitionOptionValueRel = this.cpDefinitionOptionValueRelPersistence.findByPrimaryKey(cpDefinitionOptionValueRelId);
        key = FriendlyURLNormalizerUtil.normalize((String)key);
        this.validate(cpDefinitionOptionValueRel.getCPDefinitionOptionValueRelId(), cpDefinitionOptionValueRel.getCPDefinitionOptionRelId(), key);
        CPDefinitionOptionRel cpDefinitionOptionRel = cpDefinitionOptionValueRel.getCPDefinitionOptionRel();
        if (this.cpDefinitionLocalService.isVersionable(cpDefinitionOptionRel.getCPDefinitionId(), serviceContext.getRequest())) {
            CPDefinition newCPDefinition = this.cpDefinitionLocalService.copyCPDefinition(cpDefinitionOptionRel.getCPDefinitionId());
            cpDefinitionOptionRel = this.cpDefinitionOptionRelPersistence.findByC_C(newCPDefinition.getCPDefinitionId(), cpDefinitionOptionRel.getCPOptionId());
            cpDefinitionOptionValueRel = this.cpDefinitionOptionValueRelPersistence.findByC_K(cpDefinitionOptionRel.getCPDefinitionOptionRelId(), cpDefinitionOptionValueRel.getKey());
        }
        cpDefinitionOptionValueRel.setNameMap(nameMap);
        cpDefinitionOptionValueRel.setPriority(priority);
        cpDefinitionOptionValueRel.setKey(key);
        cpDefinitionOptionValueRel.setExpandoBridgeAttributes(serviceContext);
        this._updateCPDefinitionOptionValueRelCPInstance(cpDefinitionOptionValueRel, cpInstanceId);
        if (cpDefinitionOptionRel.isPriceTypeStatic()) {
            cpDefinitionOptionValueRel.setPrice(price);
        }
        cpDefinitionOptionValueRel.setQuantity(quantity);
        this._validateLinkedCPDefinitionOptionValueRel(cpDefinitionOptionValueRel);
        this._validatePriceableCPDefinitionOptionValue(cpDefinitionOptionValueRel, cpDefinitionOptionRel.getPriceType());
        cpDefinitionOptionValueRel = (CPDefinitionOptionValueRel)this.cpDefinitionOptionValueRelPersistence.update((BaseModel)cpDefinitionOptionValueRel);
        if (preselected) {
            cpDefinitionOptionValueRel = this.updateCPDefinitionOptionValueRelPreselected(cpDefinitionOptionValueRel.getCPDefinitionOptionValueRelId(), preselected);
        }
        this.reindexCPDefinition(cpDefinitionOptionRel);
        return cpDefinitionOptionValueRel;
    }

    @Deprecated
    public CPDefinitionOptionValueRel updateCPDefinitionOptionValueRel(long cpDefinitionOptionValueRelId, Map<Locale, String> nameMap, double priority, String key, ServiceContext serviceContext) throws PortalException {
        return this.cpDefinitionOptionValueRelLocalService.updateCPDefinitionOptionValueRel(cpDefinitionOptionValueRelId, nameMap, priority, key, 0L, 0, false, null, serviceContext);
    }

    public CPDefinitionOptionValueRel updateCPDefinitionOptionValueRelPreselected(long cpDefinitionOptionValueRelId, boolean preselected) {
        CPDefinitionOptionValueRel cpDefinitionOptionValueRel = this.cpDefinitionOptionValueRelPersistence.fetchByPrimaryKey(cpDefinitionOptionValueRelId);
        if (!preselected) {
            cpDefinitionOptionValueRel.setPreselected(false);
            return (CPDefinitionOptionValueRel)this.cpDefinitionOptionValueRelPersistence.update((BaseModel)cpDefinitionOptionValueRel);
        }
        CPDefinitionOptionValueRel curPreselectedCPDefinitionOptionValueRel = this.fetchPreselectedCPDefinitionOptionValueRel(cpDefinitionOptionValueRel.getCPDefinitionOptionRelId());
        if (curPreselectedCPDefinitionOptionValueRel != null) {
            curPreselectedCPDefinitionOptionValueRel.setPreselected(false);
            this.cpDefinitionOptionValueRelPersistence.update((BaseModel)curPreselectedCPDefinitionOptionValueRel);
        }
        cpDefinitionOptionValueRel.setPreselected(true);
        return (CPDefinitionOptionValueRel)this.cpDefinitionOptionValueRelPersistence.update((BaseModel)cpDefinitionOptionValueRel);
    }

    protected SearchContext buildSearchContext(long companyId, long groupId, long cpDefinitionOptionRelId, String keywords, int start, int end, Sort[] sorts) {
        SearchContext searchContext = new SearchContext();
        searchContext.setAttributes((Map)HashMapBuilder.put((Object)_FIELD_KEY, (Object)keywords).put((Object)"content", (Object)keywords).put((Object)"entryClassPK", (Object)keywords).put((Object)"name", (Object)keywords).put((Object)"CPDefinitionOptionRelId", (Object)cpDefinitionOptionRelId).put((Object)"params", (Object)LinkedHashMapBuilder.put((Object)"keywords", (Object)keywords).build()).build());
        searchContext.setCompanyId(companyId);
        searchContext.setEnd(end);
        searchContext.setGroupIds(new long[]{groupId});
        if (Validator.isNotNull((String)keywords)) {
            searchContext.setKeywords(keywords);
        }
        if (sorts != null) {
            searchContext.setSorts(sorts);
        }
        searchContext.setStart(start);
        QueryConfig queryConfig = searchContext.getQueryConfig();
        queryConfig.setHighlightEnabled(false);
        queryConfig.setScoreEnabled(false);
        return searchContext;
    }

    protected List<CPDefinitionOptionValueRel> getCPDefinitionOptionValueRels(Hits hits) throws PortalException {
        List documents = hits.toList();
        ArrayList<CPDefinitionOptionValueRel> cpDefinitionOptionValueRels = new ArrayList<CPDefinitionOptionValueRel>(documents.size());
        for (Document document : documents) {
            long cpDefinitionOptionValueRelId = GetterUtil.getLong((String)document.get("entryClassPK"));
            CPDefinitionOptionValueRel cpDefinitionOptionValueRel = this.fetchCPDefinitionOptionValueRel(cpDefinitionOptionValueRelId);
            if (cpDefinitionOptionValueRel == null) {
                cpDefinitionOptionValueRels = null;
                Indexer indexer = IndexerRegistryUtil.getIndexer(CPDefinitionOptionValueRel.class);
                long companyId = GetterUtil.getLong((String)document.get("companyId"));
                indexer.delete(companyId, document.getUID());
                continue;
            }
            if (cpDefinitionOptionValueRels == null) continue;
            cpDefinitionOptionValueRels.add(cpDefinitionOptionValueRel);
        }
        return cpDefinitionOptionValueRels;
    }

    protected void reindexCPDefinition(CPDefinitionOptionRel cpDefinitionOptionRel) throws PortalException {
        Indexer indexer = IndexerRegistryUtil.nullSafeGetIndexer(CPDefinition.class);
        indexer.reindex(CPDefinition.class.getName(), cpDefinitionOptionRel.getCPDefinitionId());
    }

    protected BaseModelSearchResult<CPDefinitionOptionValueRel> searchCPOptions(SearchContext searchContext) throws PortalException {
        Indexer indexer = IndexerRegistryUtil.nullSafeGetIndexer(CPDefinitionOptionValueRel.class);
        for (int i = 0; i < 10; ++i) {
            Hits hits = indexer.search(searchContext, _SELECTED_FIELD_NAMES);
            List<CPDefinitionOptionValueRel> cpDefinitionOptionValueRels = this.getCPDefinitionOptionValueRels(hits);
            if (cpDefinitionOptionValueRels == null) continue;
            return new BaseModelSearchResult(cpDefinitionOptionValueRels, hits.getLength());
        }
        throw new SearchException("Unable to fix the search index after 10 attempts");
    }

    protected int searchCPOptionsCount(SearchContext searchContext) throws PortalException {
        Indexer indexer = IndexerRegistryUtil.nullSafeGetIndexer(CPDefinitionOptionValueRel.class);
        return GetterUtil.getInteger((Object)indexer.searchCount(searchContext));
    }

    protected void validate(long cpDefinitionOptionValueRelId, long cpDefinitionOptionRelId, String key) throws PortalException {
        CPDefinitionOptionValueRel cpDefinitionOptionValueRel = this.cpDefinitionOptionValueRelPersistence.fetchByC_K(cpDefinitionOptionRelId, key);
        if (cpDefinitionOptionValueRel != null && cpDefinitionOptionValueRel.getCPDefinitionOptionValueRelId() != cpDefinitionOptionValueRelId) {
            throw new CPDefinitionOptionValueRelKeyException();
        }
    }

    private void _addCPDefinitionOptionValueRel(long cpDefinitionOptionRelId, List<CPOptionValue> cpOptionValues, ServiceContext serviceContext) throws PortalException {
        for (CPOptionValue cpOptionValue : cpOptionValues) {
            if (this._hasCustomAttributes(cpOptionValue)) {
                ExpandoBridge expandoBridge = cpOptionValue.getExpandoBridge();
                serviceContext.setExpandoBridgeAttributes(expandoBridge.getAttributes());
            } else {
                serviceContext.setExpandoBridgeAttributes(Collections.emptyMap());
            }
            this.cpDefinitionOptionValueRelLocalService.addCPDefinitionOptionValueRel(cpDefinitionOptionRelId, cpOptionValue, serviceContext);
        }
    }

    private boolean _hasCustomAttributes(CPOptionValue cpOptionValue) throws PortalException {
        try {
            return CustomAttributesUtil.hasCustomAttributes((long)cpOptionValue.getCompanyId(), (String)CPOptionValue.class.getName(), (long)cpOptionValue.getCPOptionValueId(), null);
        }
        catch (Exception exception) {
            throw new PortalException((Throwable)exception);
        }
    }

    private void _updateCPDefinitionOptionValueRelCPInstance(CPDefinitionOptionValueRel cpDefinitionOptionValueRel, long cpInstanceId) throws PortalException {
        if (cpInstanceId <= 0L) {
            cpDefinitionOptionValueRel.setCPInstanceUuid(null);
            cpDefinitionOptionValueRel.setCProductId(0L);
            return;
        }
        CPInstance cpInstance = this.cpInstanceLocalService.getCPInstance(cpInstanceId);
        cpDefinitionOptionValueRel.setCPInstanceUuid(cpInstance.getCPInstanceUuid());
        CPDefinition cpDefinition = cpInstance.getCPDefinition();
        cpDefinitionOptionValueRel.setCProductId(cpDefinition.getCProductId());
    }

    private void _validateLinkedCPDefinitionOptionValueRel(CPDefinitionOptionValueRel cpDefinitionOptionValueRel) throws PortalException {
        if (Validator.isNull((String)cpDefinitionOptionValueRel.getCPInstanceUuid()) || cpDefinitionOptionValueRel.getCProductId() == 0L) {
            return;
        }
        List cpDefinitionOptionValueRels = this.cpDefinitionOptionValueRelPersistence.findByCPDefinitionOptionRelId(cpDefinitionOptionValueRel.getCPDefinitionOptionRelId());
        for (CPDefinitionOptionValueRel curCPDefinitionOptionValueRel : cpDefinitionOptionValueRels) {
            if (cpDefinitionOptionValueRel.getCPDefinitionOptionValueRelId() == curCPDefinitionOptionValueRel.getCPDefinitionOptionValueRelId() || !Objects.equals(cpDefinitionOptionValueRel.getCPInstanceUuid(), curCPDefinitionOptionValueRel.getCPInstanceUuid()) || cpDefinitionOptionValueRel.getCProductId() != curCPDefinitionOptionValueRel.getCProductId() || cpDefinitionOptionValueRel.getQuantity() != curCPDefinitionOptionValueRel.getQuantity()) continue;
            throw new CPDefinitionOptionValueRelQuantityException();
        }
    }

    private void _validatePriceableCPDefinitionOptionValue(CPDefinitionOptionValueRel cpDefinitionOptionValueRel, String priceType) throws PortalException {
        if (cpDefinitionOptionValueRel.isNew()) {
            return;
        }
        if (Validator.isNull((String)priceType)) {
            if (Validator.isNotNull((String)cpDefinitionOptionValueRel.getCPInstanceUuid()) || cpDefinitionOptionValueRel.getPrice() != null || cpDefinitionOptionValueRel.getCProductId() != 0L || cpDefinitionOptionValueRel.getQuantity() != 0) {
                throw new CPDefinitionOptionValueRelCPInstanceException();
            }
            return;
        }
        if (Objects.equals(priceType, "static") && cpDefinitionOptionValueRel.getPrice() == null) {
            throw new CPDefinitionOptionValueRelPriceException();
        }
        CPInstance cpInstance = this.cpInstanceLocalService.fetchCProductInstance(cpDefinitionOptionValueRel.getCProductId(), cpDefinitionOptionValueRel.getCPInstanceUuid());
        if ((cpInstance == null || cpDefinitionOptionValueRel.getPrice() != null) && Objects.equals(priceType, "dynamic")) {
            throw new CPDefinitionOptionValueRelCPInstanceException();
        }
        if (cpInstance == null) {
            return;
        }
        if (this.cpDefinitionOptionRelLocalService.hasCPDefinitionRequiredCPDefinitionOptionRels(cpInstance.getCPDefinitionId()) || cpInstance.getCPSubscriptionInfo() != null) {
            throw new CPDefinitionOptionValueRelCPInstanceException();
        }
        if (cpDefinitionOptionValueRel.getQuantity() <= 0) {
            throw new CPDefinitionOptionValueRelQuantityException();
        }
        if (!cpInstance.isApproved()) {
            throw new CPDefinitionOptionValueRelCPInstanceException();
        }
    }
}

