/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.product.service.impl;

import com.liferay.commerce.product.exception.NoSuchCPDefinitionException;
import com.liferay.commerce.product.model.CPDefinition;
import com.liferay.commerce.product.model.CommerceCatalog;
import com.liferay.commerce.product.service.base.CPDefinitionServiceBaseImpl;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.ClassedModel;
import com.liferay.portal.kernel.search.BaseModelSearchResult;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermissionFactory;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.UnicodeProperties;
import java.io.Serializable;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Stream;

public class CPDefinitionServiceImpl
extends CPDefinitionServiceBaseImpl {
    private static volatile ModelResourcePermission<CommerceCatalog> _commerceCatalogModelResourcePermission = ModelResourcePermissionFactory.getInstance(CPDefinitionServiceImpl.class, (String)"_commerceCatalogModelResourcePermission", CommerceCatalog.class);

    public CPDefinition addCPDefinition(String externalReferenceCode, long groupId, long userId, Map<Locale, String> nameMap, Map<Locale, String> shortDescriptionMap, Map<Locale, String> descriptionMap, Map<Locale, String> urlTitleMap, Map<Locale, String> metaTitleMap, Map<Locale, String> metaDescriptionMap, Map<Locale, String> metaKeywordsMap, String productTypeName, boolean ignoreSKUCombinations, boolean shippable, boolean freeShipping, boolean shipSeparately, double shippingExtraPrice, double width, double height, double depth, double weight, long cpTaxCategoryId, boolean taxExempt, boolean telcoOrElectronics, String ddmStructureKey, boolean published, int displayDateMonth, int displayDateDay, int displayDateYear, int displayDateHour, int displayDateMinute, int expirationDateMonth, int expirationDateDay, int expirationDateYear, int expirationDateHour, int expirationDateMinute, boolean neverExpire, String defaultSku, boolean subscriptionEnabled, int subscriptionLength, String subscriptionType, UnicodeProperties subscriptionTypeSettingsUnicodeProperties, long maxSubscriptionCycles, boolean deliverySubscriptionEnabled, int deliverySubscriptionLength, String deliverySubscriptionType, UnicodeProperties deliverySubscriptionTypeSettingsUnicodeProperties, long deliveryMaxSubscriptionCycles, ServiceContext serviceContext) throws PortalException {
        this._checkCommerceCatalog(groupId, "UPDATE");
        return this.cpDefinitionLocalService.addCPDefinition(externalReferenceCode, groupId, userId, nameMap, shortDescriptionMap, descriptionMap, urlTitleMap, metaTitleMap, metaDescriptionMap, metaKeywordsMap, productTypeName, ignoreSKUCombinations, shippable, freeShipping, shipSeparately, shippingExtraPrice, width, height, depth, weight, cpTaxCategoryId, taxExempt, telcoOrElectronics, ddmStructureKey, published, displayDateMonth, displayDateDay, displayDateYear, displayDateHour, displayDateMinute, expirationDateMonth, expirationDateDay, expirationDateYear, expirationDateHour, expirationDateMinute, neverExpire, defaultSku, subscriptionEnabled, subscriptionLength, subscriptionType, subscriptionTypeSettingsUnicodeProperties, maxSubscriptionCycles, deliverySubscriptionEnabled, deliverySubscriptionLength, deliverySubscriptionType, deliverySubscriptionTypeSettingsUnicodeProperties, deliveryMaxSubscriptionCycles, serviceContext);
    }

    public CPDefinition addCPDefinition(String externalReferenceCode, long groupId, long userId, Map<Locale, String> nameMap, Map<Locale, String> shortDescriptionMap, Map<Locale, String> descriptionMap, Map<Locale, String> urlTitleMap, Map<Locale, String> metaTitleMap, Map<Locale, String> metaDescriptionMap, Map<Locale, String> metaKeywordsMap, String productTypeName, boolean ignoreSKUCombinations, boolean shippable, boolean freeShipping, boolean shipSeparately, double shippingExtraPrice, double width, double height, double depth, double weight, long cpTaxCategoryId, boolean taxExempt, boolean telcoOrElectronics, String ddmStructureKey, boolean published, int displayDateMonth, int displayDateDay, int displayDateYear, int displayDateHour, int displayDateMinute, int expirationDateMonth, int expirationDateDay, int expirationDateYear, int expirationDateHour, int expirationDateMinute, boolean neverExpire, String defaultSku, boolean subscriptionEnabled, int subscriptionLength, String subscriptionType, UnicodeProperties subscriptionTypeSettingsUnicodeProperties, long maxSubscriptionCycles, ServiceContext serviceContext) throws PortalException {
        this._checkCommerceCatalog(groupId, "UPDATE");
        return this.cpDefinitionLocalService.addCPDefinition(externalReferenceCode, groupId, userId, nameMap, shortDescriptionMap, descriptionMap, urlTitleMap, metaTitleMap, metaDescriptionMap, metaKeywordsMap, productTypeName, ignoreSKUCombinations, shippable, freeShipping, shipSeparately, shippingExtraPrice, width, height, depth, weight, cpTaxCategoryId, taxExempt, telcoOrElectronics, ddmStructureKey, published, displayDateMonth, displayDateDay, displayDateYear, displayDateHour, displayDateMinute, expirationDateMonth, expirationDateDay, expirationDateYear, expirationDateHour, expirationDateMinute, neverExpire, defaultSku, subscriptionEnabled, subscriptionLength, subscriptionType, subscriptionTypeSettingsUnicodeProperties, maxSubscriptionCycles, serviceContext);
    }

    public CPDefinition addOrUpdateCPDefinition(String externalReferenceCode, long groupId, long userId, Map<Locale, String> nameMap, Map<Locale, String> shortDescriptionMap, Map<Locale, String> descriptionMap, Map<Locale, String> urlTitleMap, Map<Locale, String> metaTitleMap, Map<Locale, String> metaDescriptionMap, Map<Locale, String> metaKeywordsMap, String productTypeName, boolean ignoreSKUCombinations, boolean shippable, boolean freeShipping, boolean shipSeparately, double shippingExtraPrice, double width, double height, double depth, double weight, long cpTaxCategoryId, boolean taxExempt, boolean telcoOrElectronics, String ddmStructureKey, boolean published, int displayDateMonth, int displayDateDay, int displayDateYear, int displayDateHour, int displayDateMinute, int expirationDateMonth, int expirationDateDay, int expirationDateYear, int expirationDateHour, int expirationDateMinute, boolean neverExpire, String defaultSku, boolean subscriptionEnabled, int subscriptionLength, String subscriptionType, UnicodeProperties subscriptionTypeSettingsUnicodeProperties, long maxSubscriptionCycles, boolean deliverySubscriptionEnabled, int deliverySubscriptionLength, String deliverySubscriptionType, UnicodeProperties deliverySubscriptionTypeSettingsUnicodeProperties, long deliveryMaxSubscriptionCycles, ServiceContext serviceContext) throws PortalException {
        this._checkCommerceCatalog(groupId, "UPDATE");
        return this.cpDefinitionLocalService.addOrUpdateCPDefinition(externalReferenceCode, groupId, userId, nameMap, shortDescriptionMap, descriptionMap, urlTitleMap, metaTitleMap, metaDescriptionMap, metaKeywordsMap, productTypeName, ignoreSKUCombinations, shippable, freeShipping, shipSeparately, shippingExtraPrice, width, height, depth, weight, cpTaxCategoryId, taxExempt, telcoOrElectronics, ddmStructureKey, published, displayDateMonth, displayDateDay, displayDateYear, displayDateHour, displayDateMinute, expirationDateMonth, expirationDateDay, expirationDateYear, expirationDateHour, expirationDateMinute, neverExpire, defaultSku, subscriptionEnabled, subscriptionLength, subscriptionType, subscriptionTypeSettingsUnicodeProperties, maxSubscriptionCycles, deliverySubscriptionEnabled, deliverySubscriptionLength, deliverySubscriptionType, deliverySubscriptionTypeSettingsUnicodeProperties, deliveryMaxSubscriptionCycles, serviceContext);
    }

    public CPDefinition addOrUpdateCPDefinition(String externalReferenceCode, long groupId, long userId, Map<Locale, String> nameMap, Map<Locale, String> shortDescriptionMap, Map<Locale, String> descriptionMap, Map<Locale, String> urlTitleMap, Map<Locale, String> metaTitleMap, Map<Locale, String> metaDescriptionMap, Map<Locale, String> metaKeywordsMap, String productTypeName, boolean ignoreSKUCombinations, boolean shippable, boolean freeShipping, boolean shipSeparately, double shippingExtraPrice, double width, double height, double depth, double weight, long cpTaxCategoryId, boolean taxExempt, boolean telcoOrElectronics, String ddmStructureKey, boolean published, int displayDateMonth, int displayDateDay, int displayDateYear, int displayDateHour, int displayDateMinute, int expirationDateMonth, int expirationDateDay, int expirationDateYear, int expirationDateHour, int expirationDateMinute, boolean neverExpire, String defaultSku, boolean subscriptionEnabled, int subscriptionLength, String subscriptionType, UnicodeProperties subscriptionTypeSettingsUnicodeProperties, long maxSubscriptionCycles, ServiceContext serviceContext) throws PortalException {
        this._checkCommerceCatalog(groupId, "UPDATE");
        return this.cpDefinitionLocalService.addOrUpdateCPDefinition(externalReferenceCode, groupId, userId, nameMap, shortDescriptionMap, descriptionMap, urlTitleMap, metaTitleMap, metaDescriptionMap, metaKeywordsMap, productTypeName, ignoreSKUCombinations, shippable, freeShipping, shipSeparately, shippingExtraPrice, width, height, depth, weight, cpTaxCategoryId, taxExempt, telcoOrElectronics, ddmStructureKey, published, displayDateMonth, displayDateDay, displayDateYear, displayDateHour, displayDateMinute, expirationDateMonth, expirationDateDay, expirationDateYear, expirationDateHour, expirationDateMinute, neverExpire, defaultSku, subscriptionEnabled, subscriptionLength, subscriptionType, subscriptionTypeSettingsUnicodeProperties, maxSubscriptionCycles, serviceContext);
    }

    public CPDefinition copyCPDefinition(long cpDefinitionId, long groupId) throws PortalException {
        this._checkCommerceCatalog(groupId, "UPDATE");
        return this.cpDefinitionLocalService.copyCPDefinition(cpDefinitionId, groupId);
    }

    public void deleteAssetCategoryCPDefinition(long cpDefinitionId, long categoryId, ServiceContext serviceContext) throws PortalException {
        this._checkCommerceCatalogByCPDefinitionId(cpDefinitionId, "UPDATE");
        this.cpDefinitionLocalService.deleteAssetCategoryCPDefinition(cpDefinitionId, categoryId, serviceContext);
    }

    public void deleteCPDefinition(long cpDefinitionId) throws PortalException {
        this._checkCommerceCatalogByCPDefinitionId(cpDefinitionId, "UPDATE");
        this.cpDefinitionLocalService.deleteCPDefinition(cpDefinitionId);
    }

    public CPDefinition fetchCPDefinition(long cpDefinitionId) throws PortalException {
        CPDefinition cpDefinition = this.cpDefinitionLocalService.fetchCPDefinition(cpDefinitionId);
        if (cpDefinition != null) {
            this._checkCommerceCatalogByCPDefinitionId(cpDefinitionId, "VIEW");
        }
        return cpDefinition;
    }

    public CPDefinition fetchCPDefinitionByCProductExternalReferenceCode(String externalReferenceCode, long companyId) throws PortalException {
        CPDefinition cpDefinition = this.cpDefinitionLocalService.fetchCPDefinitionByCProductExternalReferenceCode(externalReferenceCode, companyId);
        if (cpDefinition != null) {
            this._checkCommerceCatalogByCPDefinitionId(cpDefinition.getCPDefinitionId(), "VIEW");
        }
        return cpDefinition;
    }

    public CPDefinition fetchCPDefinitionByCProductId(long cProductId) throws PortalException {
        CPDefinition cpDefinition = this.cpDefinitionLocalService.fetchCPDefinitionByCProductId(cProductId);
        if (cpDefinition != null) {
            this._checkCommerceCatalogByCPDefinitionId(cpDefinition.getCPDefinitionId(), "VIEW");
        }
        return cpDefinition;
    }

    public CPDefinition getCPDefinition(long cpDefinitionId) throws PortalException {
        this._checkCommerceCatalogByCPDefinitionId(cpDefinitionId, "VIEW");
        return this.cpDefinitionLocalService.getCPDefinition(cpDefinitionId);
    }

    public List<CPDefinition> getCPDefinitions(long groupId, int status, int start, int end, OrderByComparator<CPDefinition> orderByComparator) throws PortalException {
        this._checkCommerceCatalog(groupId, "VIEW");
        return this.cpDefinitionLocalService.getCPDefinitions(groupId, status, start, end, orderByComparator);
    }

    public int getCPDefinitionsCount(long groupId, int status) throws PortalException {
        this._checkCommerceCatalog(groupId, "VIEW");
        return this.cpDefinitionLocalService.getCPDefinitionsCount(groupId, status);
    }

    @Deprecated
    public String getLayoutUuid(long cpDefinitionId) throws PortalException {
        this._checkCommerceCatalogByCPDefinitionId(cpDefinitionId, "VIEW");
        return this.cpDefinitionLocalService.getLayoutUuid(0L, cpDefinitionId);
    }

    public Map<Locale, String> getUrlTitleMap(long cpDefinitionId) throws PortalException {
        this._checkCommerceCatalogByCPDefinitionId(cpDefinitionId, "VIEW");
        return this.cpDefinitionLocalService.getUrlTitleMap(cpDefinitionId);
    }

    public String getUrlTitleMapAsXML(long cpDefinitionId) throws PortalException {
        this._checkCommerceCatalogByCPDefinitionId(cpDefinitionId, "VIEW");
        return this.cpDefinitionLocalService.getUrlTitleMapAsXML(cpDefinitionId);
    }

    public BaseModelSearchResult<CPDefinition> searchCPDefinitions(long companyId, String keywords, int status, int start, int end, Sort sort) throws PortalException {
        List commerceCatalogs = this.commerceCatalogService.getCommerceCatalogs(companyId, -1, -1);
        Stream stream = commerceCatalogs.stream();
        long[] groupIds = stream.mapToLong(CommerceCatalog::getGroupId).toArray();
        return this.cpDefinitionLocalService.searchCPDefinitions(companyId, groupIds, keywords, status, start, end, sort);
    }

    public BaseModelSearchResult<CPDefinition> searchCPDefinitions(long companyId, String keywords, String filterFields, String filterValues, int start, int end, Sort sort) throws PortalException {
        List commerceCatalogs = this.commerceCatalogService.getCommerceCatalogs(companyId, -1, -1);
        Stream stream = commerceCatalogs.stream();
        long[] groupIds = stream.mapToLong(CommerceCatalog::getGroupId).toArray();
        return this.cpDefinitionLocalService.searchCPDefinitions(companyId, groupIds, keywords, filterFields, filterValues, start, end, sort);
    }

    public BaseModelSearchResult<CPDefinition> searchCPDefinitionsByChannelGroupId(long companyId, long channelGroupId, String keywords, int status, int start, int end, Sort sort) throws PortalException {
        List commerceCatalogs = this.commerceCatalogService.getCommerceCatalogs(companyId, -1, -1);
        Stream stream = commerceCatalogs.stream();
        long[] groupIds = stream.mapToLong(CommerceCatalog::getGroupId).toArray();
        return this.cpDefinitionLocalService.searchCPDefinitionsByChannelGroupId(companyId, groupIds, channelGroupId, keywords, status, start, end, sort);
    }

    public CPDefinition updateCPDefinition(long cpDefinitionId, Map<Locale, String> nameMap, Map<Locale, String> shortDescriptionMap, Map<Locale, String> descriptionMap, Map<Locale, String> urlTitleMap, Map<Locale, String> metaTitleMap, Map<Locale, String> metaDescriptionMap, Map<Locale, String> metaKeywordsMap, boolean ignoreSKUCombinations, String ddmStructureKey, boolean published, int displayDateMonth, int displayDateDay, int displayDateYear, int displayDateHour, int displayDateMinute, int expirationDateMonth, int expirationDateDay, int expirationDateYear, int expirationDateHour, int expirationDateMinute, boolean neverExpire, ServiceContext serviceContext) throws PortalException {
        this._checkCommerceCatalogByCPDefinitionId(cpDefinitionId, "UPDATE");
        return this.cpDefinitionLocalService.updateCPDefinition(cpDefinitionId, nameMap, shortDescriptionMap, descriptionMap, urlTitleMap, metaTitleMap, metaDescriptionMap, metaKeywordsMap, ignoreSKUCombinations, ddmStructureKey, published, displayDateMonth, displayDateDay, displayDateYear, displayDateHour, displayDateMinute, expirationDateMonth, expirationDateDay, expirationDateYear, expirationDateHour, expirationDateMinute, neverExpire, serviceContext);
    }

    public CPDefinition updateCPDefinitionAccountGroupFilter(long cpDefinitionId, boolean enable) throws PortalException {
        this._checkCommerceCatalogByCPDefinitionId(cpDefinitionId, "UPDATE");
        return this.cpDefinitionLocalService.updateCPDefinitionAccountGroupFilter(cpDefinitionId, enable);
    }

    public CPDefinition updateCPDefinitionCategorization(long cpDefinitionId, ServiceContext serviceContext) throws PortalException {
        this._checkCommerceCatalogByCPDefinitionId(cpDefinitionId, "UPDATE");
        return this.cpDefinitionLocalService.updateCPDefinitionCategorization(cpDefinitionId, serviceContext);
    }

    public CPDefinition updateCPDefinitionChannelFilter(long cpDefinitionId, boolean enable) throws PortalException {
        this._checkCommerceCatalogByCPDefinitionId(cpDefinitionId, "UPDATE");
        return this.cpDefinitionLocalService.updateCPDefinitionChannelFilter(cpDefinitionId, enable);
    }

    @Deprecated
    public void updateCPDisplayLayout(long cpDefinitionId, String layoutUuid, ServiceContext serviceContext) throws PortalException {
        this._checkCommerceCatalogByCPDefinitionId(cpDefinitionId, "UPDATE");
        this.cpDisplayLayoutLocalService.addCPDisplayLayout(serviceContext.getUserId(), serviceContext.getScopeGroupId(), CPDefinition.class, cpDefinitionId, layoutUuid);
    }

    public CPDefinition updateExternalReferenceCode(String externalReferenceCode, long cpDefinitionId) throws PortalException {
        this._checkCommerceCatalogByCPDefinitionId(cpDefinitionId, "UPDATE");
        return this.cpDefinitionLocalService.updateExternalReferenceCode(externalReferenceCode, cpDefinitionId);
    }

    public CPDefinition updateShippingInfo(long cpDefinitionId, boolean shippable, boolean freeShipping, boolean shipSeparately, double shippingExtraPrice, double width, double height, double depth, double weight, ServiceContext serviceContext) throws PortalException {
        this._checkCommerceCatalogByCPDefinitionId(cpDefinitionId, "UPDATE");
        return this.cpDefinitionLocalService.updateShippingInfo(cpDefinitionId, shippable, freeShipping, shipSeparately, shippingExtraPrice, width, height, depth, weight, serviceContext);
    }

    public CPDefinition updateStatus(long userId, long cpDefinitionId, int status, ServiceContext serviceContext, Map<String, Serializable> workflowContext) throws PortalException {
        this._checkCommerceCatalogByCPDefinitionId(cpDefinitionId, "UPDATE");
        return this.cpDefinitionLocalService.updateStatus(userId, cpDefinitionId, status, serviceContext, workflowContext);
    }

    public CPDefinition updateSubscriptionInfo(long cpDefinitionId, boolean subscriptionEnabled, int subscriptionLength, String subscriptionType, UnicodeProperties subscriptionTypeSettingsUnicodeProperties, long maxSubscriptionCycles, boolean deliverySubscriptionEnabled, int deliverySubscriptionLength, String deliverySubscriptionType, UnicodeProperties deliverySubscriptionTypeSettingsUnicodeProperties, long deliveryMaxSubscriptionCycles) throws PortalException {
        this._checkCommerceCatalogByCPDefinitionId(cpDefinitionId, "UPDATE");
        return this.cpDefinitionLocalService.updateSubscriptionInfo(cpDefinitionId, subscriptionEnabled, subscriptionLength, subscriptionType, subscriptionTypeSettingsUnicodeProperties, maxSubscriptionCycles, deliverySubscriptionEnabled, deliverySubscriptionLength, deliverySubscriptionType, deliverySubscriptionTypeSettingsUnicodeProperties, deliveryMaxSubscriptionCycles);
    }

    @Deprecated
    public CPDefinition updateSubscriptionInfo(long cpDefinitionId, boolean subscriptionEnabled, int subscriptionLength, String subscriptionType, UnicodeProperties subscriptionTypeSettingsUnicodeProperties, long maxSubscriptionCycles, ServiceContext serviceContext) throws PortalException {
        this._checkCommerceCatalogByCPDefinitionId(cpDefinitionId, "UPDATE");
        return this.cpDefinitionLocalService.updateSubscriptionInfo(cpDefinitionId, subscriptionEnabled, subscriptionLength, subscriptionType, subscriptionTypeSettingsUnicodeProperties, maxSubscriptionCycles, serviceContext);
    }

    public CPDefinition updateTaxCategoryInfo(long cpDefinitionId, long cpTaxCategoryId, boolean taxExempt, boolean telcoOrElectronics) throws PortalException {
        this._checkCommerceCatalogByCPDefinitionId(cpDefinitionId, "UPDATE");
        return this.cpDefinitionLocalService.updateTaxCategoryInfo(cpDefinitionId, cpTaxCategoryId, taxExempt, telcoOrElectronics);
    }

    private void _checkCommerceCatalog(long groupId, String actionId) throws PortalException {
        CommerceCatalog commerceCatalog = this.commerceCatalogLocalService.fetchCommerceCatalogByGroupId(groupId);
        if (commerceCatalog == null) {
            throw new PrincipalException();
        }
        _commerceCatalogModelResourcePermission.check(this.getPermissionChecker(), (ClassedModel)commerceCatalog, actionId);
    }

    private void _checkCommerceCatalogByCPDefinitionId(long cpDefinitionId, String actionId) throws PortalException {
        CPDefinition cpDefinition = this.cpDefinitionLocalService.fetchCPDefinition(cpDefinitionId);
        if (cpDefinition == null) {
            throw new NoSuchCPDefinitionException();
        }
        CommerceCatalog commerceCatalog = this.commerceCatalogLocalService.fetchCommerceCatalogByGroupId(cpDefinition.getGroupId());
        _commerceCatalogModelResourcePermission.check(this.getPermissionChecker(), (ClassedModel)commerceCatalog, actionId);
    }
}

