/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.product.service.impl;

import com.liferay.commerce.product.model.CPDefinition;
import com.liferay.commerce.product.model.CPDefinitionSpecificationOptionValue;
import com.liferay.commerce.product.service.base.CPDefinitionSpecificationOptionValueLocalServiceBaseImpl;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerRegistryUtil;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.OrderByComparator;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class CPDefinitionSpecificationOptionValueLocalServiceImpl
extends CPDefinitionSpecificationOptionValueLocalServiceBaseImpl {
    public CPDefinitionSpecificationOptionValue addCPDefinitionSpecificationOptionValue(long cpDefinitionId, long cpSpecificationOptionId, long cpOptionCategoryId, Map<Locale, String> valueMap, double priority, ServiceContext serviceContext) throws PortalException {
        CPDefinition cpDefinition = this.cpDefinitionPersistence.findByPrimaryKey(cpDefinitionId);
        User user = this.userLocalService.getUser(serviceContext.getUserId());
        long cpDefinitionSpecificationOptionValueId = this.counterLocalService.increment();
        CPDefinitionSpecificationOptionValue cpDefinitionSpecificationOptionValue = this.cpDefinitionSpecificationOptionValuePersistence.create(cpDefinitionSpecificationOptionValueId);
        if (this.cpDefinitionLocalService.isVersionable(cpDefinitionId)) {
            cpDefinition = this.cpDefinitionLocalService.copyCPDefinition(cpDefinitionId);
            cpDefinitionId = cpDefinition.getCPDefinitionId();
        }
        cpDefinitionSpecificationOptionValue.setGroupId(cpDefinition.getGroupId());
        cpDefinitionSpecificationOptionValue.setCompanyId(user.getCompanyId());
        cpDefinitionSpecificationOptionValue.setUserId(user.getUserId());
        cpDefinitionSpecificationOptionValue.setUserName(user.getFullName());
        cpDefinitionSpecificationOptionValue.setCPDefinitionId(cpDefinition.getCPDefinitionId());
        cpDefinitionSpecificationOptionValue.setCPSpecificationOptionId(cpSpecificationOptionId);
        cpDefinitionSpecificationOptionValue.setCPOptionCategoryId(cpOptionCategoryId);
        cpDefinitionSpecificationOptionValue.setValueMap(valueMap);
        cpDefinitionSpecificationOptionValue.setPriority(priority);
        cpDefinitionSpecificationOptionValue.setExpandoBridgeAttributes(serviceContext);
        cpDefinitionSpecificationOptionValue = (CPDefinitionSpecificationOptionValue)this.cpDefinitionSpecificationOptionValuePersistence.update((BaseModel)cpDefinitionSpecificationOptionValue);
        this.reindexCPDefinition(cpDefinitionId);
        return cpDefinitionSpecificationOptionValue;
    }

    @Override
    public CPDefinitionSpecificationOptionValue deleteCPDefinitionSpecificationOptionValue(CPDefinitionSpecificationOptionValue cpDefinitionSpecificationOptionValue) throws PortalException {
        if (this.cpDefinitionLocalService.isVersionable(cpDefinitionSpecificationOptionValue.getCPDefinitionId())) {
            try {
                CPDefinition newCPDefinition = this.cpDefinitionLocalService.copyCPDefinition(cpDefinitionSpecificationOptionValue.getCPDefinitionId());
                cpDefinitionSpecificationOptionValue = this.cpDefinitionSpecificationOptionValuePersistence.findByC_CSOVI(newCPDefinition.getCPDefinitionId(), cpDefinitionSpecificationOptionValue.getCPDefinitionSpecificationOptionValueId());
            }
            catch (PortalException portalException) {
                throw new SystemException((Throwable)portalException);
            }
        }
        this.cpDefinitionSpecificationOptionValuePersistence.remove((BaseModel)cpDefinitionSpecificationOptionValue);
        this.expandoRowLocalService.deleteRows(cpDefinitionSpecificationOptionValue.getCPDefinitionSpecificationOptionValueId());
        this.reindexCPDefinition(cpDefinitionSpecificationOptionValue.getCPDefinitionId());
        return cpDefinitionSpecificationOptionValue;
    }

    @Override
    public CPDefinitionSpecificationOptionValue deleteCPDefinitionSpecificationOptionValue(long cpDefinitionSpecificationOptionValueId) throws PortalException {
        CPDefinitionSpecificationOptionValue cpDefinitionSpecificationOptionValue = this.cpDefinitionSpecificationOptionValuePersistence.findByPrimaryKey(cpDefinitionSpecificationOptionValueId);
        return this.cpDefinitionSpecificationOptionValueLocalService.deleteCPDefinitionSpecificationOptionValue(cpDefinitionSpecificationOptionValue);
    }

    public void deleteCPDefinitionSpecificationOptionValues(long cpDefinitionId) throws PortalException {
        List<CPDefinitionSpecificationOptionValue> cpDefinitionSpecificationOptionValues = this.getCPDefinitionSpecificationOptionValues(cpDefinitionId, -1, -1, null);
        for (CPDefinitionSpecificationOptionValue cpDefinitionSpecificationOptionValue : cpDefinitionSpecificationOptionValues) {
            this.cpDefinitionSpecificationOptionValueLocalService.deleteCPDefinitionSpecificationOptionValue(cpDefinitionSpecificationOptionValue);
        }
        this.reindexCPDefinition(cpDefinitionId);
    }

    public void deleteCPSpecificationOptionDefinitionValues(long cpSpecificationOptionId) throws PortalException {
        List<CPDefinitionSpecificationOptionValue> cpDefinitionSpecificationOptionValues = this.getCPDefinitionSpecificationOptionValues(cpSpecificationOptionId);
        for (CPDefinitionSpecificationOptionValue cpDefinitionSpecificationOptionValue : cpDefinitionSpecificationOptionValues) {
            this.cpDefinitionSpecificationOptionValueLocalService.deleteCPDefinitionSpecificationOptionValue(cpDefinitionSpecificationOptionValue);
            this.reindexCPDefinition(cpDefinitionSpecificationOptionValue.getCPDefinitionId());
        }
    }

    public CPDefinitionSpecificationOptionValue fetchCPDefinitionSpecificationOptionValue(long cpDefinitionId, long cpDefinitionSpecificationOptionValueId) {
        return this.cpDefinitionSpecificationOptionValuePersistence.fetchByC_CSOVI(cpDefinitionId, cpDefinitionSpecificationOptionValueId);
    }

    public List<CPDefinitionSpecificationOptionValue> getCPDefinitionSpecificationOptionValues(long cpSpecificationOptionId) {
        return this.cpDefinitionSpecificationOptionValuePersistence.findByCPSpecificationOptionId(cpSpecificationOptionId);
    }

    public List<CPDefinitionSpecificationOptionValue> getCPDefinitionSpecificationOptionValues(long cpSpecificationOptionId, int start, int end) {
        return this.cpDefinitionSpecificationOptionValuePersistence.findByCPSpecificationOptionId(cpSpecificationOptionId, start, end);
    }

    public List<CPDefinitionSpecificationOptionValue> getCPDefinitionSpecificationOptionValues(long cpDefinitionId, int start, int end, OrderByComparator<CPDefinitionSpecificationOptionValue> orderByComparator) {
        return this.cpDefinitionSpecificationOptionValuePersistence.findByCPDefinitionId(cpDefinitionId, start, end, orderByComparator);
    }

    public List<CPDefinitionSpecificationOptionValue> getCPDefinitionSpecificationOptionValues(long cpDefinitionId, long cpOptionCategoryId) {
        return this.cpDefinitionSpecificationOptionValuePersistence.findByC_COC(cpDefinitionId, cpOptionCategoryId);
    }

    public List<CPDefinitionSpecificationOptionValue> getCPDefinitionSpecificationOptionValuesByC_CSO(long cpDefinitionId, long cpSpecificationOptionId) {
        return this.cpDefinitionSpecificationOptionValuePersistence.findByC_CSO(cpDefinitionId, cpSpecificationOptionId);
    }

    public int getCPDefinitionSpecificationOptionValuesCount(long cpDefinitionId) {
        return this.cpDefinitionSpecificationOptionValuePersistence.countByCPDefinitionId(cpDefinitionId);
    }

    public int getCPSpecificationOptionDefinitionValuesCount(long cpSpecificationOptionId) {
        return this.cpDefinitionSpecificationOptionValuePersistence.countByCPSpecificationOptionId(cpSpecificationOptionId);
    }

    public CPDefinitionSpecificationOptionValue updateCPDefinitionSpecificationOptionValue(long cpDefinitionSpecificationOptionValueId, long cpOptionCategoryId, Map<Locale, String> valueMap, double priority, ServiceContext serviceContext) throws PortalException {
        CPDefinitionSpecificationOptionValue cpDefinitionSpecificationOptionValue = this.cpDefinitionSpecificationOptionValuePersistence.findByPrimaryKey(cpDefinitionSpecificationOptionValueId);
        if (this.cpDefinitionLocalService.isVersionable(cpDefinitionSpecificationOptionValue.getCPDefinitionId())) {
            CPDefinition newCPDefinition = this.cpDefinitionLocalService.copyCPDefinition(cpDefinitionSpecificationOptionValue.getCPDefinitionId());
            cpDefinitionSpecificationOptionValue = this.cpDefinitionSpecificationOptionValuePersistence.findByC_CSOVI(newCPDefinition.getCPDefinitionId(), cpDefinitionSpecificationOptionValue.getCPDefinitionSpecificationOptionValueId());
        }
        cpDefinitionSpecificationOptionValue.setCPOptionCategoryId(cpOptionCategoryId);
        cpDefinitionSpecificationOptionValue.setValueMap(valueMap);
        cpDefinitionSpecificationOptionValue.setPriority(priority);
        cpDefinitionSpecificationOptionValue.setExpandoBridgeAttributes(serviceContext);
        cpDefinitionSpecificationOptionValue = (CPDefinitionSpecificationOptionValue)this.cpDefinitionSpecificationOptionValuePersistence.update((BaseModel)cpDefinitionSpecificationOptionValue);
        this.reindexCPDefinition(cpDefinitionSpecificationOptionValue.getCPDefinitionId());
        return cpDefinitionSpecificationOptionValue;
    }

    public CPDefinitionSpecificationOptionValue updateCPOptionCategoryId(long cpDefinitionSpecificationOptionValueId, long cpOptionCategoryId) throws PortalException {
        CPDefinitionSpecificationOptionValue cpDefinitionSpecificationOptionValue = this.cpDefinitionSpecificationOptionValuePersistence.findByPrimaryKey(cpDefinitionSpecificationOptionValueId);
        if (this.cpDefinitionLocalService.isVersionable(cpDefinitionSpecificationOptionValue.getCPDefinitionId())) {
            CPDefinition newCPDefinition = this.cpDefinitionLocalService.copyCPDefinition(cpDefinitionSpecificationOptionValue.getCPDefinitionId());
            cpDefinitionSpecificationOptionValue = this.cpDefinitionSpecificationOptionValuePersistence.findByC_CSOVI(newCPDefinition.getCPDefinitionId(), cpDefinitionSpecificationOptionValue.getCPDefinitionSpecificationOptionValueId());
        }
        cpDefinitionSpecificationOptionValue.setCPOptionCategoryId(cpOptionCategoryId);
        cpDefinitionSpecificationOptionValue = (CPDefinitionSpecificationOptionValue)this.cpDefinitionSpecificationOptionValuePersistence.update((BaseModel)cpDefinitionSpecificationOptionValue);
        this.reindexCPDefinition(cpDefinitionSpecificationOptionValue.getCPDefinitionId());
        return cpDefinitionSpecificationOptionValue;
    }

    protected void reindexCPDefinition(long cpDefinitionId) throws PortalException {
        Indexer indexer = IndexerRegistryUtil.nullSafeGetIndexer(CPDefinition.class);
        indexer.reindex(CPDefinition.class.getName(), cpDefinitionId);
    }
}

