/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.product.service.impl;

import com.liferay.commerce.product.exception.NoSuchCPDefinitionException;
import com.liferay.commerce.product.model.CPDefinition;
import com.liferay.commerce.product.model.CPDefinitionSpecificationOptionValue;
import com.liferay.commerce.product.model.CommerceCatalog;
import com.liferay.commerce.product.service.base.CPDefinitionSpecificationOptionValueServiceBaseImpl;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.ClassedModel;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermissionFactory;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.OrderByComparator;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class CPDefinitionSpecificationOptionValueServiceImpl
extends CPDefinitionSpecificationOptionValueServiceBaseImpl {
    private static volatile ModelResourcePermission<CommerceCatalog> _commerceCatalogModelResourcePermission = ModelResourcePermissionFactory.getInstance(CPDefinitionSpecificationOptionValueServiceImpl.class, (String)"_commerceCatalogModelResourcePermission", CommerceCatalog.class);

    public CPDefinitionSpecificationOptionValue addCPDefinitionSpecificationOptionValue(long cpDefinitionId, long cpSpecificationOptionId, long cpOptionCategoryId, Map<Locale, String> valueMap, double priority, ServiceContext serviceContext) throws PortalException {
        this._checkCommerceCatalog(cpDefinitionId, "UPDATE");
        return this.cpDefinitionSpecificationOptionValueLocalService.addCPDefinitionSpecificationOptionValue(cpDefinitionId, cpSpecificationOptionId, cpOptionCategoryId, valueMap, priority, serviceContext);
    }

    public void deleteCPDefinitionSpecificationOptionValue(long cpDefinitionSpecificationOptionValueId) throws PortalException {
        CPDefinitionSpecificationOptionValue cpDefinitionSpecificationOptionValue = this.cpDefinitionSpecificationOptionValuePersistence.findByPrimaryKey(cpDefinitionSpecificationOptionValueId);
        this._checkCommerceCatalog(cpDefinitionSpecificationOptionValue.getCPDefinitionId(), "VIEW");
        this.cpDefinitionSpecificationOptionValueLocalService.deleteCPDefinitionSpecificationOptionValue(cpDefinitionSpecificationOptionValue);
    }

    public void deleteCPDefinitionSpecificationOptionValues(long cpDefinitionId) throws PortalException {
        this._checkCommerceCatalog(cpDefinitionId, "UPDATE");
        this.cpDefinitionSpecificationOptionValueLocalService.deleteCPDefinitionSpecificationOptionValues(cpDefinitionId);
    }

    public CPDefinitionSpecificationOptionValue fetchCPDefinitionSpecificationOptionValue(long cpDefinitionSpecificationOptionValueId) throws PortalException {
        CPDefinitionSpecificationOptionValue cpDefinitionSpecificationOptionValue = this.cpDefinitionSpecificationOptionValueLocalService.fetchCPDefinitionSpecificationOptionValue(cpDefinitionSpecificationOptionValueId);
        this._checkCommerceCatalog(cpDefinitionSpecificationOptionValue.getCPDefinitionId(), "VIEW");
        return cpDefinitionSpecificationOptionValue;
    }

    public CPDefinitionSpecificationOptionValue getCPDefinitionSpecificationOptionValue(long cpDefinitionSpecificationOptionValueId) throws PortalException {
        CPDefinitionSpecificationOptionValue cpDefinitionSpecificationOptionValue = this.cpDefinitionSpecificationOptionValueLocalService.getCPDefinitionSpecificationOptionValue(cpDefinitionSpecificationOptionValueId);
        this._checkCommerceCatalog(cpDefinitionSpecificationOptionValue.getCPDefinitionId(), "VIEW");
        return cpDefinitionSpecificationOptionValue;
    }

    public List<CPDefinitionSpecificationOptionValue> getCPDefinitionSpecificationOptionValues(long cpDefinitionId, int start, int end, OrderByComparator<CPDefinitionSpecificationOptionValue> orderByComparator) throws PortalException {
        this._checkCommerceCatalog(cpDefinitionId, "VIEW");
        return this.cpDefinitionSpecificationOptionValueLocalService.getCPDefinitionSpecificationOptionValues(cpDefinitionId, start, end, orderByComparator);
    }

    public List<CPDefinitionSpecificationOptionValue> getCPDefinitionSpecificationOptionValues(long cpDefinitionId, long cpOptionCategoryId) throws PortalException {
        this._checkCommerceCatalog(cpDefinitionId, "VIEW");
        return this.cpDefinitionSpecificationOptionValueLocalService.getCPDefinitionSpecificationOptionValues(cpDefinitionId, cpOptionCategoryId);
    }

    public int getCPDefinitionSpecificationOptionValuesCount(long cpDefinitionId) throws PortalException {
        this._checkCommerceCatalog(cpDefinitionId, "VIEW");
        return this.cpDefinitionSpecificationOptionValueLocalService.getCPDefinitionSpecificationOptionValuesCount(cpDefinitionId);
    }

    public CPDefinitionSpecificationOptionValue updateCPDefinitionSpecificationOptionValue(long cpDefinitionSpecificationOptionValueId, long cpOptionCategoryId, Map<Locale, String> valueMap, double priority, ServiceContext serviceContext) throws PortalException {
        CPDefinitionSpecificationOptionValue cpDefinitionSpecificationOptionValue = this.cpDefinitionSpecificationOptionValueLocalService.getCPDefinitionSpecificationOptionValue(cpDefinitionSpecificationOptionValueId);
        this._checkCommerceCatalog(cpDefinitionSpecificationOptionValue.getCPDefinitionId(), "UPDATE");
        return this.cpDefinitionSpecificationOptionValueLocalService.updateCPDefinitionSpecificationOptionValue(cpDefinitionSpecificationOptionValueId, cpOptionCategoryId, valueMap, priority, serviceContext);
    }

    private void _checkCommerceCatalog(long cpDefinitionId, String actionId) throws PortalException {
        CPDefinition cpDefinition = this.cpDefinitionLocalService.fetchCPDefinition(cpDefinitionId);
        if (cpDefinition == null) {
            throw new NoSuchCPDefinitionException();
        }
        CommerceCatalog commerceCatalog = this.commerceCatalogLocalService.fetchCommerceCatalogByGroupId(cpDefinition.getGroupId());
        if (commerceCatalog == null) {
            throw new PrincipalException();
        }
        _commerceCatalogModelResourcePermission.check(this.getPermissionChecker(), (ClassedModel)commerceCatalog, actionId);
    }
}

