/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.product.service.impl;

import com.liferay.commerce.product.exception.CPDisplayLayoutEntryException;
import com.liferay.commerce.product.exception.CPDisplayLayoutLayoutUuidException;
import com.liferay.commerce.product.model.CPDefinition;
import com.liferay.commerce.product.model.CPDisplayLayout;
import com.liferay.commerce.product.service.base.CPDisplayLayoutLocalServiceBaseImpl;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.search.BaseModelSearchResult;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.Hits;
import com.liferay.portal.kernel.search.Indexable;
import com.liferay.portal.kernel.search.IndexableType;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerRegistryUtil;
import com.liferay.portal.kernel.search.QueryConfig;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.SearchException;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.LinkedHashMapBuilder;
import com.liferay.portal.kernel.util.Validator;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class CPDisplayLayoutLocalServiceImpl
extends CPDisplayLayoutLocalServiceBaseImpl {
    private static final String[] _SELECTED_FIELD_NAMES = new String[]{"entryClassPK", "companyId", "groupId", "uid"};

    @Indexable(type=IndexableType.REINDEX)
    public CPDisplayLayout addCPDisplayLayout(long userId, long groupId, Class<?> clazz, long classPK, String layoutUuid) throws PortalException {
        this.validate(classPK, layoutUuid);
        long classNameId = this.classNameLocalService.getClassNameId(clazz);
        CPDisplayLayout oldCPDisplayLayout = this.cpDisplayLayoutPersistence.fetchByG_C_C(groupId, classNameId, classPK);
        if (clazz == CPDefinition.class && this.cpDefinitionLocalService.isVersionable(classPK)) {
            try {
                CPDefinition newCPDefinition = this.cpDefinitionLocalService.copyCPDefinition(classPK);
                classPK = newCPDefinition.getCPDefinitionId();
            }
            catch (PortalException portalException) {
                throw new SystemException((Throwable)portalException);
            }
            oldCPDisplayLayout = this.cpDisplayLayoutPersistence.fetchByG_C_C(groupId, classNameId, classPK);
        }
        if (oldCPDisplayLayout != null) {
            oldCPDisplayLayout.setLayoutUuid(layoutUuid);
            return (CPDisplayLayout)this.cpDisplayLayoutPersistence.update((BaseModel)oldCPDisplayLayout);
        }
        long cpDisplayLayoutId = this.counterLocalService.increment();
        CPDisplayLayout cpDisplayLayout = this.createCPDisplayLayout(cpDisplayLayoutId);
        cpDisplayLayout.setGroupId(groupId);
        User user = this.userLocalService.getUser(userId);
        cpDisplayLayout.setCompanyId(user.getCompanyId());
        cpDisplayLayout.setClassNameId(classNameId);
        cpDisplayLayout.setClassPK(classPK);
        cpDisplayLayout.setLayoutUuid(layoutUuid);
        return (CPDisplayLayout)this.cpDisplayLayoutPersistence.update((BaseModel)cpDisplayLayout);
    }

    @Indexable(type=IndexableType.DELETE)
    public CPDisplayLayout deleteCPDisplayLayout(Class<?> clazz, long classPK) {
        try {
            if (clazz == CPDefinition.class && this.cpDefinitionLocalService.isVersionable(classPK)) {
                this.cpDefinitionLocalService.copyCPDefinition(classPK);
            }
        }
        catch (PortalException portalException) {
            throw new SystemException((Throwable)portalException);
        }
        this.cpDisplayLayoutLocalService.deleteCPDisplayLayouts(clazz, classPK);
        return null;
    }

    public void deleteCPDisplayLayouts(Class<?> clazz, long classPK) {
        List cpDisplayLayouts = this.cpDisplayLayoutPersistence.findByC_C(this.classNameLocalService.getClassNameId(clazz), classPK);
        for (CPDisplayLayout cpDisplayLayout : cpDisplayLayouts) {
            this.cpDisplayLayoutLocalService.deleteCPDisplayLayout(cpDisplayLayout);
        }
    }

    public CPDisplayLayout fetchCPDisplayLayout(long groupId, Class<?> clazz, long classPK) {
        return this.cpDisplayLayoutPersistence.fetchByG_C_C(groupId, this.classNameLocalService.getClassNameId(clazz), classPK);
    }

    public List<CPDisplayLayout> fetchCPDisplayLayoutByGroupIdAndLayoutUuid(long groupId, String layoutUuid) {
        return this.cpDisplayLayoutPersistence.findByG_L(groupId, layoutUuid);
    }

    public List<CPDisplayLayout> fetchCPDisplayLayoutByGroupIdAndLayoutUuid(long groupId, String layoutUuid, int start, int end) {
        return this.cpDisplayLayoutPersistence.findByG_L(groupId, layoutUuid, start, end);
    }

    public BaseModelSearchResult<CPDisplayLayout> searchCPDisplayLayout(long companyId, long groupId, String className, String keywords, int start, int end, Sort sort) throws PortalException {
        SearchContext searchContext = this.buildSearchContext(companyId, groupId, className, keywords, start, end, sort);
        return this.searchCPDisplayLayout(searchContext);
    }

    @Indexable(type=IndexableType.REINDEX)
    public CPDisplayLayout updateCPDisplayLayout(long cpDisplayLayoutId, long classPK, String layoutUuid) throws PortalException {
        CPDisplayLayout cpDisplayLayout = this.cpDisplayLayoutPersistence.findByPrimaryKey(cpDisplayLayoutId);
        this.validate(cpDisplayLayout.getClassPK(), layoutUuid);
        cpDisplayLayout.setClassPK(classPK);
        cpDisplayLayout.setLayoutUuid(layoutUuid);
        return (CPDisplayLayout)this.cpDisplayLayoutPersistence.update((BaseModel)cpDisplayLayout);
    }

    protected SearchContext buildSearchContext(long companyId, long groupId, String className, String keywords, int start, int end, Sort sort) {
        SearchContext searchContext = new SearchContext();
        searchContext.setAttributes((Map)HashMapBuilder.put((Object)"entryModelClassName", (Object)className).put((Object)"params", (Object)LinkedHashMapBuilder.put((Object)"keywords", (Object)keywords).build()).put((Object)"searchFilterEnabled", (Object)true).build());
        searchContext.setCompanyId(companyId);
        searchContext.setEnd(end);
        searchContext.setGroupIds(new long[]{groupId});
        if (Validator.isNotNull((String)keywords)) {
            searchContext.setKeywords(keywords);
        }
        if (sort != null) {
            searchContext.setSorts(new Sort[]{sort});
        }
        searchContext.setStart(start);
        QueryConfig queryConfig = searchContext.getQueryConfig();
        queryConfig.setHighlightEnabled(false);
        queryConfig.setScoreEnabled(false);
        return searchContext;
    }

    protected List<CPDisplayLayout> getCPDisplayLayouts(Hits hits) throws PortalException {
        List documents = hits.toList();
        ArrayList<CPDisplayLayout> cpDisplayLayouts = new ArrayList<CPDisplayLayout>(documents.size());
        for (Document document : documents) {
            long cpDisplayLayoutId = GetterUtil.getLong((String)document.get("entryClassPK"));
            CPDisplayLayout cpDisplayLayout = this.fetchCPDisplayLayout(cpDisplayLayoutId);
            if (cpDisplayLayout == null) {
                Indexer indexer = IndexerRegistryUtil.getIndexer(CPDisplayLayout.class);
                long companyId = GetterUtil.getLong((String)document.get("companyId"));
                indexer.delete(companyId, document.getUID());
                continue;
            }
            if (cpDisplayLayout == null) continue;
            cpDisplayLayouts.add(cpDisplayLayout);
        }
        return cpDisplayLayouts;
    }

    protected BaseModelSearchResult<CPDisplayLayout> searchCPDisplayLayout(SearchContext searchContext) throws PortalException {
        Indexer indexer = IndexerRegistryUtil.nullSafeGetIndexer(CPDisplayLayout.class);
        for (int i = 0; i < 10; ++i) {
            Hits hits = indexer.search(searchContext, _SELECTED_FIELD_NAMES);
            List<CPDisplayLayout> cpDisplayLayouts = this.getCPDisplayLayouts(hits);
            if (cpDisplayLayouts == null) continue;
            return new BaseModelSearchResult(cpDisplayLayouts, hits.getLength());
        }
        throw new SearchException("Unable to fix the search index after 10 attempts");
    }

    protected void validate(long classPK, String layoutUuid) throws PortalException {
        if (classPK <= 0L) {
            throw new CPDisplayLayoutEntryException();
        }
        if (Validator.isNull((String)layoutUuid)) {
            throw new CPDisplayLayoutLayoutUuidException();
        }
    }
}

