/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.product.service.impl;

import com.liferay.asset.kernel.model.AssetCategory;
import com.liferay.commerce.product.exception.NoSuchCPDefinitionException;
import com.liferay.commerce.product.model.CPDefinition;
import com.liferay.commerce.product.model.CPDisplayLayout;
import com.liferay.commerce.product.model.CommerceCatalog;
import com.liferay.commerce.product.service.base.CPDisplayLayoutServiceBaseImpl;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.ClassedModel;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.search.BaseModelSearchResult;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermissionFactory;
import com.liferay.portal.kernel.service.permission.GroupPermissionUtil;
import com.liferay.portal.kernel.service.permission.LayoutPermissionUtil;
import com.liferay.portlet.asset.service.permission.AssetCategoryPermission;

public class CPDisplayLayoutServiceImpl
extends CPDisplayLayoutServiceBaseImpl {
    private static volatile ModelResourcePermission<CommerceCatalog> _commerceCatalogModelResourcePermission = ModelResourcePermissionFactory.getInstance(CPDisplayLayoutServiceImpl.class, (String)"_commerceCatalogModelResourcePermission", CommerceCatalog.class);

    public CPDisplayLayout addCPDisplayLayout(long userId, long groupId, Class<?> clazz, long classPK, String layoutUuid) throws PortalException {
        GroupPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)groupId, (String)"ADD_LAYOUT");
        this._checkCPDisplayLayout(clazz.getName(), classPK, "VIEW");
        return this.cpDisplayLayoutLocalService.addCPDisplayLayout(userId, groupId, clazz, classPK, layoutUuid);
    }

    public void deleteCPDisplayLayout(long cpDisplayLayoutId) throws PortalException {
        CPDisplayLayout cpDisplayLayout = this.cpDisplayLayoutLocalService.getCPDisplayLayout(cpDisplayLayoutId);
        GroupPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)cpDisplayLayout.getGroupId(), (String)"ADD_LAYOUT");
        this._checkCPDisplayLayout(cpDisplayLayout.getClassName(), cpDisplayLayout.getClassPK(), "UPDATE");
        this.cpDisplayLayoutLocalService.deleteCPDisplayLayout(cpDisplayLayout);
    }

    public CPDisplayLayout fetchCPDisplayLayout(long cpDisplayLayoutId) throws PortalException {
        CPDisplayLayout cpDisplayLayout = this.cpDisplayLayoutLocalService.fetchCPDisplayLayout(cpDisplayLayoutId);
        if (cpDisplayLayout != null) {
            LayoutPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (Layout)this._getLayout(cpDisplayLayout), (String)"VIEW");
            this._checkCPDisplayLayout(cpDisplayLayout.getClassName(), cpDisplayLayout.getClassPK(), "VIEW");
        }
        return cpDisplayLayout;
    }

    public BaseModelSearchResult<CPDisplayLayout> searchCPDisplayLayout(long companyId, long groupId, String className, String keywords, int start, int end, Sort sort) throws PortalException {
        GroupPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)groupId, (String)"UPDATE");
        return this.cpDisplayLayoutLocalService.searchCPDisplayLayout(companyId, groupId, className, keywords, start, end, sort);
    }

    public CPDisplayLayout updateCPDisplayLayout(long cpDisplayLayoutId, long classPK, String layoutUuid) throws PortalException {
        CPDisplayLayout cpDisplayLayout = this.cpDisplayLayoutLocalService.getCPDisplayLayout(cpDisplayLayoutId);
        LayoutPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (Layout)this._getLayout(cpDisplayLayout), (String)"UPDATE");
        this._checkCPDisplayLayout(cpDisplayLayout.getClassName(), classPK, "VIEW");
        return this.cpDisplayLayoutLocalService.updateCPDisplayLayout(cpDisplayLayout.getCPDisplayLayoutId(), classPK, layoutUuid);
    }

    private void _checkCPDisplayLayout(String className, long classPK, String actionId) throws PortalException {
        if (className.equals(CPDefinition.class.getName())) {
            CPDefinition cpDefinition = this.cpDefinitionLocalService.fetchCPDefinition(classPK);
            if (cpDefinition == null) {
                throw new NoSuchCPDefinitionException();
            }
            CommerceCatalog commerceCatalog = this.commerceCatalogLocalService.fetchCommerceCatalogByGroupId(cpDefinition.getGroupId());
            _commerceCatalogModelResourcePermission.check(this.getPermissionChecker(), (ClassedModel)commerceCatalog, actionId);
        } else if (className.equals(AssetCategory.class.getName())) {
            AssetCategoryPermission.check((PermissionChecker)this.getPermissionChecker(), (long)classPK, (String)actionId);
        }
    }

    private Layout _getLayout(CPDisplayLayout cpDisplayLayout) {
        Layout layout = this.layoutLocalService.fetchLayout(cpDisplayLayout.getLayoutUuid(), cpDisplayLayout.getGroupId(), false);
        if (layout != null) {
            return layout;
        }
        return this.layoutLocalService.fetchLayout(cpDisplayLayout.getLayoutUuid(), cpDisplayLayout.getGroupId(), true);
    }
}

