/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.product.service.impl;

import com.liferay.commerce.product.exception.CPInstanceDisplayDateException;
import com.liferay.commerce.product.exception.CPInstanceExpirationDateException;
import com.liferay.commerce.product.exception.CPInstanceSkuException;
import com.liferay.commerce.product.exception.NoSuchCPInstanceException;
import com.liferay.commerce.product.exception.NoSuchSkuContributorCPDefinitionOptionRelException;
import com.liferay.commerce.product.internal.util.SKUCombinationsIterator;
import com.liferay.commerce.product.model.CPDefinition;
import com.liferay.commerce.product.model.CPDefinitionOptionRel;
import com.liferay.commerce.product.model.CPDefinitionOptionValueRel;
import com.liferay.commerce.product.model.CPInstance;
import com.liferay.commerce.product.model.CProduct;
import com.liferay.commerce.product.service.base.CPInstanceLocalServiceBaseImpl;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.dao.orm.QueryDefinition;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.search.BaseModelSearchResult;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.Hits;
import com.liferay.portal.kernel.search.Indexable;
import com.liferay.portal.kernel.search.IndexableType;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerRegistryUtil;
import com.liferay.portal.kernel.search.QueryConfig;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.SearchException;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.systemevent.SystemEvent;
import com.liferay.portal.kernel.util.CalendarFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.LinkedHashMapBuilder;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.uuid.PortalUUIDUtil;
import com.liferay.portal.kernel.workflow.WorkflowHandlerRegistryUtil;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;

public class CPInstanceLocalServiceImpl
extends CPInstanceLocalServiceBaseImpl {
    private static final String[] _SELECTED_FIELD_NAMES = new String[]{"entryClassPK", "companyId", "groupId", "uid"};
    private static final Log _log = LogFactoryUtil.getLog(CPInstanceLocalServiceImpl.class);

    @Deprecated
    public CPInstance addCPInstance(long cpDefinitionId, long groupId, String sku, String gtin, String manufacturerPartNumber, boolean purchasable, String json, boolean published, int displayDateMonth, int displayDateDay, int displayDateYear, int displayDateHour, int displayDateMinute, int expirationDateMonth, int expirationDateDay, int expirationDateYear, int expirationDateHour, int expirationDateMinute, boolean neverExpire, ServiceContext serviceContext) throws PortalException {
        return this.cpInstanceLocalService.addCPInstance(cpDefinitionId, groupId, sku, gtin, manufacturerPartNumber, purchasable, json, published, displayDateMonth, displayDateDay, displayDateYear, displayDateHour, displayDateMinute, expirationDateMonth, expirationDateDay, expirationDateYear, expirationDateHour, expirationDateMinute, neverExpire, null, serviceContext);
    }

    @Deprecated
    public CPInstance addCPInstance(long cpDefinitionId, long groupId, String sku, String gtin, String manufacturerPartNumber, boolean purchasable, String json, boolean published, int displayDateMonth, int displayDateDay, int displayDateYear, int displayDateHour, int displayDateMinute, int expirationDateMonth, int expirationDateDay, int expirationDateYear, int expirationDateHour, int expirationDateMinute, boolean neverExpire, String unspsc, ServiceContext serviceContext) throws PortalException {
        CPDefinition cpDefinition = this.cpDefinitionLocalService.getCPDefinition(cpDefinitionId);
        return this.cpInstanceLocalService.addCPInstance("", cpDefinitionId, groupId, sku, gtin, manufacturerPartNumber, purchasable, this.cpDefinitionOptionRelLocalService.getCPDefinitionOptionRelCPDefinitionOptionValueRelIds(cpDefinitionId, json), cpDefinition.getWidth(), cpDefinition.getHeight(), cpDefinition.getDepth(), cpDefinition.getWeight(), BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, published, displayDateMonth, displayDateDay, displayDateYear, displayDateHour, displayDateMinute, expirationDateMonth, expirationDateDay, expirationDateYear, expirationDateHour, expirationDateMinute, neverExpire, false, false, 1, "", null, 0L, unspsc, serviceContext);
    }

    public CPInstance addCPInstance(String externalReferenceCode, long cpDefinitionId, long groupId, String sku, String gtin, String manufacturerPartNumber, boolean purchasable, Map<Long, List<Long>> cpDefinitionOptionRelIdCPDefinitionOptionValueRelIds, double width, double height, double depth, double weight, BigDecimal price, BigDecimal promoPrice, BigDecimal cost, boolean published, int displayDateMonth, int displayDateDay, int displayDateYear, int displayDateHour, int displayDateMinute, int expirationDateMonth, int expirationDateDay, int expirationDateYear, int expirationDateHour, int expirationDateMinute, boolean neverExpire, boolean overrideSubscriptionInfo, boolean subscriptionEnabled, int subscriptionLength, String subscriptionType, UnicodeProperties subscriptionTypeSettingsUnicodeProperties, long maxSubscriptionCycles, boolean deliverySubscriptionEnabled, int deliverySubscriptionLength, String deliverySubscriptionType, UnicodeProperties deliverySubscriptionTypeSettingsUnicodeProperties, long deliveryMaxSubscriptionCycles, ServiceContext serviceContext) throws PortalException {
        return this.cpInstanceLocalService.addCPInstance(externalReferenceCode, cpDefinitionId, groupId, sku, gtin, manufacturerPartNumber, purchasable, cpDefinitionOptionRelIdCPDefinitionOptionValueRelIds, width, height, depth, weight, price, promoPrice, cost, published, displayDateMonth, displayDateDay, displayDateYear, displayDateHour, displayDateMinute, expirationDateMonth, expirationDateDay, expirationDateYear, expirationDateHour, expirationDateMinute, neverExpire, overrideSubscriptionInfo, subscriptionEnabled, subscriptionLength, subscriptionType, subscriptionTypeSettingsUnicodeProperties, maxSubscriptionCycles, deliverySubscriptionEnabled, deliverySubscriptionLength, deliverySubscriptionType, deliverySubscriptionTypeSettingsUnicodeProperties, deliveryMaxSubscriptionCycles, null, serviceContext);
    }

    @Indexable(type=IndexableType.REINDEX)
    public CPInstance addCPInstance(String externalReferenceCode, long cpDefinitionId, long groupId, String sku, String gtin, String manufacturerPartNumber, boolean purchasable, Map<Long, List<Long>> cpDefinitionOptionRelIdCPDefinitionOptionValueRelIds, double width, double height, double depth, double weight, BigDecimal price, BigDecimal promoPrice, BigDecimal cost, boolean published, int displayDateMonth, int displayDateDay, int displayDateYear, int displayDateHour, int displayDateMinute, int expirationDateMonth, int expirationDateDay, int expirationDateYear, int expirationDateHour, int expirationDateMinute, boolean neverExpire, boolean overrideSubscriptionInfo, boolean subscriptionEnabled, int subscriptionLength, String subscriptionType, UnicodeProperties subscriptionTypeSettingsUnicodeProperties, long maxSubscriptionCycles, boolean deliverySubscriptionEnabled, int deliverySubscriptionLength, String deliverySubscriptionType, UnicodeProperties deliverySubscriptionTypeSettingsUnicodeProperties, long deliveryMaxSubscriptionCycles, String unspsc, ServiceContext serviceContext) throws PortalException {
        this._validateSku(cpDefinitionId, 0L, sku);
        User user = this.userLocalService.getUser(serviceContext.getUserId());
        if (Validator.isBlank((String)externalReferenceCode)) {
            externalReferenceCode = null;
        }
        Date expirationDate = null;
        Date date = new Date();
        Date displayDate = PortalUtil.getDate((int)displayDateMonth, (int)displayDateDay, (int)displayDateYear, (int)displayDateHour, (int)displayDateMinute, (TimeZone)user.getTimeZone(), CPInstanceDisplayDateException.class);
        if (!neverExpire) {
            expirationDate = PortalUtil.getDate((int)expirationDateMonth, (int)expirationDateDay, (int)expirationDateYear, (int)expirationDateHour, (int)expirationDateMinute, (TimeZone)user.getTimeZone(), CPInstanceExpirationDateException.class);
        }
        long cpInstanceId = this.counterLocalService.increment();
        CPInstance cpInstance = this.cpInstancePersistence.create(cpInstanceId);
        if (this.cpDefinitionLocalService.isVersionable(cpDefinitionId)) {
            CPDefinition newCPDefinition = this.cpDefinitionLocalService.copyCPDefinition(cpDefinitionId);
            cpDefinitionId = newCPDefinition.getCPDefinitionId();
        }
        cpInstance.setExternalReferenceCode(externalReferenceCode);
        cpInstance.setGroupId(groupId);
        cpInstance.setCompanyId(user.getCompanyId());
        cpInstance.setUserId(user.getUserId());
        cpInstance.setUserName(user.getFullName());
        cpInstance.setCPDefinitionId(cpDefinitionId);
        cpInstance.setCPInstanceUuid(PortalUUIDUtil.generate());
        cpInstance.setSku(sku);
        cpInstance.setGtin(gtin);
        cpInstance.setManufacturerPartNumber(manufacturerPartNumber);
        cpInstance.setPurchasable(purchasable);
        cpInstance.setWidth(width);
        cpInstance.setHeight(height);
        cpInstance.setDepth(depth);
        cpInstance.setWeight(weight);
        cpInstance.setPrice(price);
        cpInstance.setPromoPrice(promoPrice);
        cpInstance.setCost(cost);
        cpInstance.setPublished(published);
        cpInstance.setDisplayDate(displayDate);
        cpInstance.setExpirationDate(expirationDate);
        cpInstance.setOverrideSubscriptionInfo(overrideSubscriptionInfo);
        cpInstance.setSubscriptionEnabled(subscriptionEnabled);
        cpInstance.setSubscriptionLength(subscriptionLength);
        cpInstance.setSubscriptionType(subscriptionType);
        cpInstance.setSubscriptionTypeSettingsProperties(subscriptionTypeSettingsUnicodeProperties);
        cpInstance.setMaxSubscriptionCycles(maxSubscriptionCycles);
        cpInstance.setDeliverySubscriptionEnabled(deliverySubscriptionEnabled);
        cpInstance.setDeliverySubscriptionLength(deliverySubscriptionLength);
        cpInstance.setDeliverySubscriptionType(deliverySubscriptionType);
        cpInstance.setDeliverySubscriptionTypeSettingsProperties(deliverySubscriptionTypeSettingsUnicodeProperties);
        cpInstance.setDeliveryMaxSubscriptionCycles(deliveryMaxSubscriptionCycles);
        cpInstance.setStatus(2);
        if (displayDate != null && date.before(displayDate)) {
            cpInstance.setStatus(7);
        }
        if (!neverExpire && expirationDate.before(date)) {
            cpInstance.setStatus(3);
        }
        cpInstance.setStatusByUserId(user.getUserId());
        cpInstance.setStatusDate(serviceContext.getModifiedDate(date));
        cpInstance.setExpandoBridgeAttributes(serviceContext);
        cpInstance.setUnspsc(unspsc);
        cpInstance = (CPInstance)this.cpInstancePersistence.update((BaseModel)cpInstance);
        this.cpInstanceOptionValueRelLocalService.updateCPInstanceOptionValueRels(groupId, user.getCompanyId(), user.getUserId(), cpInstanceId, cpDefinitionOptionRelIdCPDefinitionOptionValueRelIds);
        this.reindexCPDefinition(cpDefinitionId);
        if (!this._isWorkflowActionPublish(serviceContext)) {
            return cpInstance;
        }
        CPDefinition cpDefinition = this.cpDefinitionLocalService.getCPDefinition(cpDefinitionId);
        if (cpDefinition.isIgnoreSKUCombinations()) {
            this._expireApprovedSiblingCPInstances(cpDefinition.getCPDefinitionId(), cpInstance.getCPInstanceId(), serviceContext);
        } else {
            if (!this.cpInstanceOptionValueRelLocalService.hasCPInstanceOptionValueRel(cpInstanceId)) {
                cpInstance = this.cpInstanceLocalService.updateStatus(user.getUserId(), cpInstance.getCPInstanceId(), 5);
            }
            this._expireApprovedSiblingMatchingCPInstances(cpDefinitionId, cpDefinitionOptionRelIdCPDefinitionOptionValueRelIds, serviceContext);
            this._inactivateNoOptionSiblingCPInstances(cpDefinitionId, serviceContext);
        }
        if (cpInstance.getStatus() == 2) {
            cpInstance = this.startWorkflowInstance(user.getUserId(), cpInstance, serviceContext);
        }
        return cpInstance;
    }

    public CPInstance addCPInstance(String externalReferenceCode, long cpDefinitionId, long groupId, String sku, String gtin, String manufacturerPartNumber, boolean purchasable, Map<Long, List<Long>> cpDefinitionOptionRelIdCPDefinitionOptionValueRelIds, double width, double height, double depth, double weight, BigDecimal price, BigDecimal promoPrice, BigDecimal cost, boolean published, int displayDateMonth, int displayDateDay, int displayDateYear, int displayDateHour, int displayDateMinute, int expirationDateMonth, int expirationDateDay, int expirationDateYear, int expirationDateHour, int expirationDateMinute, boolean neverExpire, boolean overrideSubscriptionInfo, boolean subscriptionEnabled, int subscriptionLength, String subscriptionType, UnicodeProperties subscriptionTypeSettingsUnicodeProperties, long maxSubscriptionCycles, ServiceContext serviceContext) throws PortalException {
        return this.cpInstanceLocalService.addCPInstance(externalReferenceCode, cpDefinitionId, groupId, sku, gtin, manufacturerPartNumber, purchasable, cpDefinitionOptionRelIdCPDefinitionOptionValueRelIds, width, height, depth, weight, price, promoPrice, cost, published, displayDateMonth, displayDateDay, displayDateYear, displayDateHour, displayDateMinute, expirationDateMonth, expirationDateDay, expirationDateYear, expirationDateHour, expirationDateMinute, neverExpire, overrideSubscriptionInfo, subscriptionEnabled, subscriptionLength, subscriptionType, subscriptionTypeSettingsUnicodeProperties, maxSubscriptionCycles, null, serviceContext);
    }

    public CPInstance addCPInstance(String externalReferenceCode, long cpDefinitionId, long groupId, String sku, String gtin, String manufacturerPartNumber, boolean purchasable, Map<Long, List<Long>> cpDefinitionOptionRelIdCPDefinitionOptionValueRelIds, double width, double height, double depth, double weight, BigDecimal price, BigDecimal promoPrice, BigDecimal cost, boolean published, int displayDateMonth, int displayDateDay, int displayDateYear, int displayDateHour, int displayDateMinute, int expirationDateMonth, int expirationDateDay, int expirationDateYear, int expirationDateHour, int expirationDateMinute, boolean neverExpire, boolean overrideSubscriptionInfo, boolean subscriptionEnabled, int subscriptionLength, String subscriptionType, UnicodeProperties subscriptionTypeSettingsUnicodeProperties, long maxSubscriptionCycles, String unspsc, ServiceContext serviceContext) throws PortalException {
        return this.cpInstanceLocalService.addCPInstance(externalReferenceCode, cpDefinitionId, groupId, sku, gtin, manufacturerPartNumber, purchasable, cpDefinitionOptionRelIdCPDefinitionOptionValueRelIds, width, height, depth, weight, price, promoPrice, cost, published, displayDateMonth, displayDateDay, displayDateYear, displayDateHour, displayDateMinute, expirationDateMonth, expirationDateDay, expirationDateYear, expirationDateHour, expirationDateMinute, neverExpire, overrideSubscriptionInfo, subscriptionEnabled, subscriptionLength, subscriptionType, subscriptionTypeSettingsUnicodeProperties, maxSubscriptionCycles, false, 1, null, null, 0L, unspsc, serviceContext);
    }

    @Deprecated
    public CPInstance addCPInstance(String externalReferenceCode, long cpDefinitionId, long groupId, String sku, String gtin, String manufacturerPartNumber, boolean purchasable, String json, double width, double height, double depth, double weight, BigDecimal price, BigDecimal promoPrice, BigDecimal cost, boolean published, int displayDateMonth, int displayDateDay, int displayDateYear, int displayDateHour, int displayDateMinute, int expirationDateMonth, int expirationDateDay, int expirationDateYear, int expirationDateHour, int expirationDateMinute, boolean neverExpire, boolean overrideSubscriptionInfo, boolean subscriptionEnabled, int subscriptionLength, String subscriptionType, UnicodeProperties subscriptionTypeSettingsUnicodeProperties, long maxSubscriptionCycles, ServiceContext serviceContext) throws PortalException {
        return this.cpInstanceLocalService.addCPInstance(externalReferenceCode, cpDefinitionId, groupId, sku, gtin, manufacturerPartNumber, purchasable, json, width, height, depth, weight, price, promoPrice, cost, published, displayDateMonth, displayDateDay, displayDateYear, displayDateHour, displayDateMinute, expirationDateMonth, expirationDateDay, expirationDateYear, expirationDateHour, expirationDateMinute, neverExpire, overrideSubscriptionInfo, subscriptionEnabled, subscriptionLength, subscriptionType, subscriptionTypeSettingsUnicodeProperties, maxSubscriptionCycles, null, serviceContext);
    }

    @Deprecated
    public CPInstance addCPInstance(String externalReferenceCode, long cpDefinitionId, long groupId, String sku, String gtin, String manufacturerPartNumber, boolean purchasable, String json, double width, double height, double depth, double weight, BigDecimal price, BigDecimal promoPrice, BigDecimal cost, boolean published, int displayDateMonth, int displayDateDay, int displayDateYear, int displayDateHour, int displayDateMinute, int expirationDateMonth, int expirationDateDay, int expirationDateYear, int expirationDateHour, int expirationDateMinute, boolean neverExpire, boolean overrideSubscriptionInfo, boolean subscriptionEnabled, int subscriptionLength, String subscriptionType, UnicodeProperties subscriptionTypeSettingsUnicodeProperties, long maxSubscriptionCycles, String unspsc, ServiceContext serviceContext) throws PortalException {
        return this.cpInstanceLocalService.addCPInstance(externalReferenceCode, cpDefinitionId, groupId, sku, gtin, manufacturerPartNumber, purchasable, this.cpDefinitionOptionRelLocalService.getCPDefinitionOptionRelCPDefinitionOptionValueRelIds(cpDefinitionId, json), width, height, depth, weight, price, promoPrice, cost, published, displayDateMonth, displayDateDay, displayDateYear, displayDateHour, displayDateMinute, expirationDateMonth, expirationDateDay, expirationDateYear, expirationDateHour, expirationDateMinute, neverExpire, overrideSubscriptionInfo, subscriptionEnabled, subscriptionLength, subscriptionType, subscriptionTypeSettingsUnicodeProperties, maxSubscriptionCycles, unspsc, serviceContext);
    }

    @Deprecated
    public CPInstance addCPInstance(String externalReferenceCode, long cpDefinitionId, long groupId, String sku, String gtin, String manufacturerPartNumber, boolean purchasable, String json, double width, double height, double depth, double weight, BigDecimal price, BigDecimal promoPrice, BigDecimal cost, boolean published, int displayDateMonth, int displayDateDay, int displayDateYear, int displayDateHour, int displayDateMinute, int expirationDateMonth, int expirationDateDay, int expirationDateYear, int expirationDateHour, int expirationDateMinute, boolean neverExpire, ServiceContext serviceContext) throws PortalException {
        return this.cpInstanceLocalService.addCPInstance(externalReferenceCode, cpDefinitionId, groupId, sku, gtin, manufacturerPartNumber, purchasable, json, width, height, depth, weight, price, promoPrice, cost, published, displayDateMonth, displayDateDay, displayDateYear, displayDateHour, displayDateMinute, expirationDateMonth, expirationDateDay, expirationDateYear, expirationDateHour, expirationDateMinute, neverExpire, null, serviceContext);
    }

    @Deprecated
    public CPInstance addCPInstance(String externalReferenceCode, long cpDefinitionId, long groupId, String sku, String gtin, String manufacturerPartNumber, boolean purchasable, String json, double width, double height, double depth, double weight, BigDecimal price, BigDecimal promoPrice, BigDecimal cost, boolean published, int displayDateMonth, int displayDateDay, int displayDateYear, int displayDateHour, int displayDateMinute, int expirationDateMonth, int expirationDateDay, int expirationDateYear, int expirationDateHour, int expirationDateMinute, boolean neverExpire, String unspsc, ServiceContext serviceContext) throws PortalException {
        return this.cpInstanceLocalService.addCPInstance(externalReferenceCode, cpDefinitionId, groupId, sku, gtin, manufacturerPartNumber, purchasable, this.cpDefinitionOptionRelLocalService.getCPDefinitionOptionRelCPDefinitionOptionValueRelIds(cpDefinitionId, json), width, height, depth, weight, price, promoPrice, cost, published, displayDateMonth, displayDateDay, displayDateYear, displayDateHour, displayDateMinute, expirationDateMonth, expirationDateDay, expirationDateYear, expirationDateHour, expirationDateMinute, neverExpire, false, false, 1, "", null, 0L, unspsc, serviceContext);
    }

    public CPInstance addOrUpdateCPInstance(String externalReferenceCode, long cpDefinitionId, long groupId, String sku, String gtin, String manufacturerPartNumber, boolean purchasable, String json, double width, double height, double depth, double weight, BigDecimal price, BigDecimal promoPrice, BigDecimal cost, boolean published, int displayDateMonth, int displayDateDay, int displayDateYear, int displayDateHour, int displayDateMinute, int expirationDateMonth, int expirationDateDay, int expirationDateYear, int expirationDateHour, int expirationDateMinute, boolean neverExpire, ServiceContext serviceContext) throws PortalException {
        return this.addOrUpdateCPInstance(externalReferenceCode, cpDefinitionId, groupId, sku, gtin, manufacturerPartNumber, purchasable, json, width, height, depth, weight, price, promoPrice, cost, published, displayDateMonth, displayDateDay, displayDateYear, displayDateHour, displayDateMinute, expirationDateMonth, expirationDateDay, expirationDateYear, expirationDateHour, expirationDateMinute, neverExpire, null, serviceContext);
    }

    public CPInstance addOrUpdateCPInstance(String externalReferenceCode, long cpDefinitionId, long groupId, String sku, String gtin, String manufacturerPartNumber, boolean purchasable, String json, double width, double height, double depth, double weight, BigDecimal price, BigDecimal promoPrice, BigDecimal cost, boolean published, int displayDateMonth, int displayDateDay, int displayDateYear, int displayDateHour, int displayDateMinute, int expirationDateMonth, int expirationDateDay, int expirationDateYear, int expirationDateHour, int expirationDateMinute, boolean neverExpire, String unspsc, ServiceContext serviceContext) throws PortalException {
        if (Validator.isBlank((String)externalReferenceCode)) {
            externalReferenceCode = null;
        } else {
            CPInstance cpInstance = this.cpInstancePersistence.fetchByC_ERC(serviceContext.getCompanyId(), externalReferenceCode);
            if (cpInstance != null) {
                return this.updateCPInstance(cpInstance.getCPInstanceId(), sku, gtin, manufacturerPartNumber, purchasable, width, height, depth, weight, price, promoPrice, cost, published, displayDateMonth, displayDateDay, displayDateYear, displayDateHour, displayDateMinute, expirationDateMonth, expirationDateDay, expirationDateYear, expirationDateHour, expirationDateMinute, neverExpire, unspsc, serviceContext);
            }
        }
        return this.addCPInstance(externalReferenceCode, cpDefinitionId, groupId, sku, gtin, manufacturerPartNumber, purchasable, json, width, height, depth, weight, price, promoPrice, cost, published, displayDateMonth, displayDateDay, displayDateYear, displayDateHour, displayDateMinute, expirationDateMonth, expirationDateDay, expirationDateYear, expirationDateHour, expirationDateMinute, neverExpire, unspsc, serviceContext);
    }

    public void buildCPInstances(long cpDefinitionId, ServiceContext serviceContext) throws PortalException {
        CPDefinition cpDefinition = this.cpDefinitionLocalService.getCPDefinition(cpDefinitionId);
        boolean neverExpire = false;
        if (cpDefinition.getExpirationDate() == null) {
            neverExpire = true;
        }
        SKUCombinationsIterator iterator = this._getSKUCombinationsIterator(cpDefinitionId);
        while (iterator.hasNext()) {
            CPDefinitionOptionValueRel[] cpDefinitionOptionValueRels = iterator.next();
            String sku = this._getSKU(cpDefinitionOptionValueRels, serviceContext.getLanguageId());
            CPInstance cpInstance = this.cpInstancePersistence.fetchByC_S(cpDefinitionId, sku);
            if (cpInstance != null) continue;
            this.addCPInstance(cpDefinitionId, cpDefinition.getGroupId(), sku, "", "", true, this._toCpDefinitionOptionRelIdCPDefinitionOptionValueRelIds(cpDefinitionOptionValueRels), cpDefinition.getWidth(), cpDefinition.getHeight(), cpDefinition.getDepth(), cpDefinition.getWeight(), BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, true, cpDefinition.getDisplayDate(), cpDefinition.getExpirationDate(), neverExpire, serviceContext);
        }
    }

    public void checkCPInstances() throws PortalException {
        this.checkCPInstancesByDisplayDate(0L);
        this.checkCPInstancesByExpirationDate();
    }

    public void checkCPInstancesByDisplayDate(long cpDefinitionId) throws PortalException {
        List cpInstances = null;
        cpInstances = cpDefinitionId > 0L ? this.cpInstancePersistence.findByC_LtD_S(cpDefinitionId, new Date(), 7) : this.cpInstancePersistence.findByLtD_S(new Date(), 7);
        for (CPInstance cpInstance : cpInstances) {
            long userId = PortalUtil.getValidUserId((long)cpInstance.getCompanyId(), (long)cpInstance.getUserId());
            ServiceContext serviceContext = new ServiceContext();
            serviceContext.setCommand("update");
            serviceContext.setScopeGroupId(cpInstance.getGroupId());
            serviceContext.setUserId(userId);
            serviceContext.setWorkflowAction(1);
            CPDefinition cpDefinition = this.cpDefinitionLocalService.getCPDefinition(cpDefinitionId);
            if (cpDefinition.isIgnoreSKUCombinations()) {
                this._expireApprovedSiblingCPInstances(cpDefinitionId, cpInstance.getCPInstanceId(), serviceContext);
            } else {
                this._expireApprovedSiblingMatchingCPInstances(cpDefinitionId, cpInstance.getCPInstanceId(), serviceContext);
            }
            this.cpInstanceLocalService.updateStatus(userId, cpInstance.getCPInstanceId(), 0);
        }
    }

    @Override
    @Indexable(type=IndexableType.DELETE)
    @SystemEvent(type=1)
    public CPInstance deleteCPInstance(CPInstance cpInstance) throws PortalException {
        if (this.cpDefinitionLocalService.isVersionable(cpInstance.getCPDefinitionId())) {
            CPDefinition newCPDefinition = this.cpDefinitionLocalService.copyCPDefinition(cpInstance.getCPDefinitionId());
            cpInstance = this.cpInstancePersistence.findByC_C(newCPDefinition.getCPDefinitionId(), cpInstance.getCPInstanceUuid());
        }
        this.cpInstancePersistence.remove((BaseModel)cpInstance);
        this.cpInstanceOptionValueRelPersistence.removeByCPInstanceId(cpInstance.getCPInstanceId());
        this.cpDefinitionOptionValueRelLocalService.resetCPInstanceCPDefinitionOptionValueRels(cpInstance.getCPInstanceUuid());
        this.expandoRowLocalService.deleteRows(cpInstance.getCPInstanceId());
        this.workflowInstanceLinkLocalService.deleteWorkflowInstanceLinks(cpInstance.getCompanyId(), cpInstance.getGroupId(), CPInstance.class.getName(), cpInstance.getCPInstanceId());
        this.reindexCPDefinition(cpInstance.getCPDefinitionId());
        return cpInstance;
    }

    @Override
    public CPInstance deleteCPInstance(long cpInstanceId) throws PortalException {
        CPInstance cpInstance = this.cpInstancePersistence.findByPrimaryKey(cpInstanceId);
        return this.cpInstanceLocalService.deleteCPInstance(cpInstance);
    }

    public void deleteCPInstances(long cpDefinitionId) throws PortalException {
        List cpInstances = this.cpInstanceLocalService.getCPDefinitionInstances(cpDefinitionId, -1, -1);
        for (CPInstance cpInstance : cpInstances) {
            this.cpInstanceLocalService.deleteCPInstance(cpInstance);
        }
    }

    public CPInstance fetchByExternalReferenceCode(String externalReferenceCode, long companyId) {
        if (Validator.isBlank((String)externalReferenceCode)) {
            return null;
        }
        return this.cpInstancePersistence.fetchByC_ERC(companyId, externalReferenceCode);
    }

    public CPInstance fetchCProductInstance(long cProductId, String cpInstanceUuid) {
        CProduct cProduct = this.cProductLocalService.fetchCProduct(cProductId);
        if (cProduct == null) {
            return null;
        }
        return this.cpInstancePersistence.fetchByC_C(cProduct.getPublishedCPDefinitionId(), cpInstanceUuid);
    }

    public List<CPInstance> getCPDefinitionApprovedCPInstances(long cpDefinitionId) {
        return this.cpInstancePersistence.findByC_ST(cpDefinitionId, 0, -1, -1, null);
    }

    @Deprecated
    public List<CPInstance> getCPDefinitionInstances(long cpDefinitionId) {
        return this.cpInstancePersistence.findByCPDefinitionId(cpDefinitionId);
    }

    @Deprecated
    public List<CPInstance> getCPDefinitionInstances(long cpDefinitionId, int start, int end) {
        return this.cpInstancePersistence.findByCPDefinitionId(cpDefinitionId, start, end);
    }

    public List<CPInstance> getCPDefinitionInstances(long cpDefinitionId, int status, int start, int end, OrderByComparator<CPInstance> orderByComparator) {
        if (status == -1) {
            return this.cpInstancePersistence.findByCPDefinitionId(cpDefinitionId, start, end, orderByComparator);
        }
        return this.cpInstancePersistence.findByC_ST(cpDefinitionId, status, start, end, orderByComparator);
    }

    public int getCPDefinitionInstancesCount(long cpDefinitionId, int status) {
        if (status == -1) {
            return this.cpInstancePersistence.countByCPDefinitionId(cpDefinitionId);
        }
        return this.cpInstancePersistence.countByC_ST(cpDefinitionId, status);
    }

    public CPInstance getCPInstance(long cpDefinitionId, String sku) throws PortalException {
        return this.cpInstancePersistence.findByC_S(cpDefinitionId, sku);
    }

    public CPInstance getCPInstanceByExternalReferenceCode(String externalReferenceCode, long companyId) throws PortalException {
        if (Validator.isBlank((String)externalReferenceCode)) {
            throw new NoSuchCPInstanceException();
        }
        return this.cpInstancePersistence.findByC_ERC(companyId, externalReferenceCode);
    }

    public List<CPInstance> getCPInstances(long groupId, int status, int start, int end, OrderByComparator<CPInstance> orderByComparator) throws PortalException {
        if (status == -1) {
            return this.cpInstancePersistence.findByGroupId(groupId, start, end, orderByComparator);
        }
        return this.cpInstancePersistence.findByG_ST(groupId, status, start, end, orderByComparator);
    }

    public int getCPInstancesCount(long groupId, int status) throws PortalException {
        if (status == -1) {
            return this.cpInstancePersistence.countByGroupId(groupId);
        }
        return this.cpInstancePersistence.countByG_ST(groupId, status);
    }

    public CPInstance getCProductInstance(long cProductId, String cpInstanceUuid) throws PortalException {
        CProduct cProduct = this.cProductLocalService.getCProduct(cProductId);
        return this.cpInstancePersistence.findByC_C(cProduct.getPublishedCPDefinitionId(), cpInstanceUuid);
    }

    public String[] getSKUs(long cpDefinitionId) {
        List<CPInstance> cpInstances = this.getCPDefinitionInstances(cpDefinitionId, 0, -1, -1, null);
        String[] skusArray = new String[cpInstances.size()];
        ArrayList<String> skus = new ArrayList<String>();
        for (CPInstance cpInstance : cpInstances) {
            skus.add(cpInstance.getSku());
        }
        return skus.toArray(skusArray);
    }

    public void inactivateCPDefinitionOptionRelCPInstances(long userId, long cpDefinitionId, long cpDefinitionOptionRelId) throws PortalException {
        this._inactivateCPDefinitionOptionRelCPInstances(userId, cpDefinitionOptionRelId, this.cpInstanceLocalService.getCPDefinitionInstances(cpDefinitionId, -1, -1, -1, null));
    }

    public void inactivateCPDefinitionOptionValueRelCPInstances(long userId, long cpDefinitionId, long cpDefinitionOptionValueRelId) throws PortalException {
        this._inactivateCPDefinitionOptionValueRelCPInstances(userId, cpDefinitionOptionValueRelId, this.cpInstanceLocalService.getCPDefinitionInstances(cpDefinitionId, -1, -1, -1, null));
    }

    public void inactivateIncompatibleCPInstances(long userId, long cpDefinitionId) throws PortalException {
        List cpInstances = this.cpInstancePersistence.findByC_ST(cpDefinitionId, 0);
        for (CPInstance curCPInstance : cpInstances) {
            if (this.cpInstanceOptionValueRelLocalService.matchesCPDefinitionOptionRels(cpDefinitionId, curCPInstance.getCPInstanceId())) continue;
            this.cpInstanceLocalService.updateStatus(userId, curCPInstance.getCPInstanceId(), 5);
        }
    }

    public Hits search(SearchContext searchContext) {
        try {
            Indexer indexer = IndexerRegistryUtil.nullSafeGetIndexer(CPInstance.class);
            return indexer.search(searchContext);
        }
        catch (Exception exception) {
            throw new SystemException((Throwable)exception);
        }
    }

    public BaseModelSearchResult<CPInstance> searchCPDefinitionInstances(long companyId, long cpDefinitionId, String keywords, int status, int start, int end, Sort sort) throws PortalException {
        SearchContext searchContext = this.buildSearchContext(companyId, cpDefinitionId, keywords, status, start, end, sort);
        return this.searchCPInstances(searchContext);
    }

    public BaseModelSearchResult<CPInstance> searchCPDefinitionInstances(long companyId, long cpDefinitionId, String keywords, int status, Sort sort) throws PortalException {
        SearchContext searchContext = this.buildSearchContext(companyId, cpDefinitionId, keywords, status, sort);
        return this.searchCPInstances(searchContext);
    }

    public BaseModelSearchResult<CPInstance> searchCPInstances(long companyId, long[] groupIds, String keywords, int status, int start, int end, Sort sort) throws PortalException {
        SearchContext searchContext = this.buildSearchContext(companyId, groupIds, keywords, status, start, end, sort);
        return this.searchCPInstances(searchContext);
    }

    public BaseModelSearchResult<CPInstance> searchCPInstances(long companyId, String keywords, int status, int start, int end, Sort sort) throws PortalException {
        SearchContext searchContext = this.buildSearchContext(companyId, keywords, status, start, end, sort);
        return this.searchCPInstances(searchContext);
    }

    public BaseModelSearchResult<CPInstance> searchCPInstances(SearchContext searchContext) throws PortalException {
        Indexer indexer = IndexerRegistryUtil.nullSafeGetIndexer(CPInstance.class);
        for (int i = 0; i < 10; ++i) {
            Hits hits = indexer.search(searchContext, _SELECTED_FIELD_NAMES);
            List<CPInstance> cpInstances = this.getCPInstances(hits);
            if (cpInstances == null) continue;
            return new BaseModelSearchResult(cpInstances, hits.getLength());
        }
        throw new SearchException("Unable to fix the search index after 10 attempts");
    }

    public CPInstance updateCPInstance(long cpInstanceId, String sku, String gtin, String manufacturerPartNumber, boolean purchasable, boolean published, int displayDateMonth, int displayDateDay, int displayDateYear, int displayDateHour, int displayDateMinute, int expirationDateMonth, int expirationDateDay, int expirationDateYear, int expirationDateHour, int expirationDateMinute, boolean neverExpire, ServiceContext serviceContext) throws PortalException {
        return this.updateCPInstance(cpInstanceId, sku, gtin, manufacturerPartNumber, purchasable, published, displayDateMonth, displayDateDay, displayDateYear, displayDateHour, displayDateMinute, expirationDateMonth, expirationDateDay, expirationDateYear, expirationDateHour, expirationDateMinute, neverExpire, null, serviceContext);
    }

    public CPInstance updateCPInstance(long cpInstanceId, String sku, String gtin, String manufacturerPartNumber, boolean purchasable, boolean published, int displayDateMonth, int displayDateDay, int displayDateYear, int displayDateHour, int displayDateMinute, int expirationDateMonth, int expirationDateDay, int expirationDateYear, int expirationDateHour, int expirationDateMinute, boolean neverExpire, String unspsc, ServiceContext serviceContext) throws PortalException {
        CPInstance cpInstance = this.cpInstancePersistence.findByPrimaryKey(cpInstanceId);
        return this.cpInstanceLocalService.updateCPInstance(cpInstanceId, sku, gtin, manufacturerPartNumber, purchasable, cpInstance.getWidth(), cpInstance.getHeight(), cpInstance.getDepth(), cpInstance.getWeight(), cpInstance.getPrice(), cpInstance.getPromoPrice(), cpInstance.getCost(), published, displayDateMonth, displayDateDay, displayDateYear, displayDateHour, displayDateMinute, expirationDateMonth, expirationDateDay, expirationDateYear, expirationDateHour, expirationDateMinute, neverExpire, unspsc, serviceContext);
    }

    @Indexable(type=IndexableType.REINDEX)
    public CPInstance updateCPInstance(long cpInstanceId, String sku, String gtin, String manufacturerPartNumber, boolean purchasable, double width, double height, double depth, double weight, BigDecimal price, BigDecimal promoPrice, BigDecimal cost, boolean published, int displayDateMonth, int displayDateDay, int displayDateYear, int displayDateHour, int displayDateMinute, int expirationDateMonth, int expirationDateDay, int expirationDateYear, int expirationDateHour, int expirationDateMinute, boolean neverExpire, ServiceContext serviceContext) throws PortalException {
        return this.updateCPInstance(cpInstanceId, sku, gtin, manufacturerPartNumber, purchasable, width, height, depth, weight, price, promoPrice, cost, published, displayDateMonth, displayDateDay, displayDateYear, displayDateHour, displayDateMinute, expirationDateMonth, expirationDateDay, expirationDateYear, expirationDateHour, expirationDateMinute, neverExpire, null, serviceContext);
    }

    @Indexable(type=IndexableType.REINDEX)
    public CPInstance updateCPInstance(long cpInstanceId, String sku, String gtin, String manufacturerPartNumber, boolean purchasable, double width, double height, double depth, double weight, BigDecimal price, BigDecimal promoPrice, BigDecimal cost, boolean published, int displayDateMonth, int displayDateDay, int displayDateYear, int displayDateHour, int displayDateMinute, int expirationDateMonth, int expirationDateDay, int expirationDateYear, int expirationDateHour, int expirationDateMinute, boolean neverExpire, String unspsc, ServiceContext serviceContext) throws PortalException {
        CPInstance cpInstance = this.cpInstancePersistence.findByPrimaryKey(cpInstanceId);
        this._validateSku(cpInstance.getCPDefinitionId(), cpInstanceId, sku);
        User user = this.userLocalService.getUser(serviceContext.getUserId());
        if (this.cpDefinitionLocalService.isVersionable(cpInstance.getCPDefinitionId())) {
            CPDefinition newCPDefinition = this.cpDefinitionLocalService.copyCPDefinition(cpInstance.getCPDefinitionId());
            cpInstance = this.cpInstancePersistence.findByC_C(newCPDefinition.getCPDefinitionId(), cpInstance.getCPInstanceUuid());
        }
        Date expirationDate = null;
        Date date = new Date();
        Date displayDate = PortalUtil.getDate((int)displayDateMonth, (int)displayDateDay, (int)displayDateYear, (int)displayDateHour, (int)displayDateMinute, (TimeZone)user.getTimeZone(), CPInstanceDisplayDateException.class);
        if (!neverExpire) {
            expirationDate = PortalUtil.getDate((int)expirationDateMonth, (int)expirationDateDay, (int)expirationDateYear, (int)expirationDateHour, (int)expirationDateMinute, (TimeZone)user.getTimeZone(), CPInstanceExpirationDateException.class);
        }
        cpInstance.setSku(sku);
        cpInstance.setGtin(gtin);
        cpInstance.setManufacturerPartNumber(manufacturerPartNumber);
        cpInstance.setPurchasable(purchasable);
        cpInstance.setWidth(width);
        cpInstance.setHeight(height);
        cpInstance.setDepth(depth);
        cpInstance.setWeight(weight);
        cpInstance.setPrice(price);
        cpInstance.setPromoPrice(promoPrice);
        cpInstance.setCost(cost);
        cpInstance.setPublished(published);
        cpInstance.setDisplayDate(displayDate);
        cpInstance.setExpirationDate(expirationDate);
        if (!neverExpire && expirationDate.before(date)) {
            cpInstance.setStatus(3);
        }
        cpInstance.setStatusByUserId(user.getUserId());
        cpInstance.setStatusDate(serviceContext.getModifiedDate(date));
        cpInstance.setExpandoBridgeAttributes(serviceContext);
        cpInstance.setUnspsc(unspsc);
        cpInstance = (CPInstance)this.cpInstancePersistence.update((BaseModel)cpInstance);
        this.reindexCPDefinition(cpInstance.getCPDefinitionId());
        if (!this._isWorkflowActionPublish(serviceContext)) {
            return cpInstance;
        }
        CPDefinition cpDefinition = this.cpDefinitionLocalService.getCPDefinition(cpInstance.getCPDefinitionId());
        if (cpDefinition.isIgnoreSKUCombinations()) {
            this._expireApprovedSiblingCPInstances(cpDefinition.getCPDefinitionId(), cpInstanceId, serviceContext);
        } else {
            if (!this.cpInstanceOptionValueRelLocalService.hasCPInstanceOptionValueRel(cpInstanceId)) {
                cpInstance = this.cpInstanceLocalService.updateStatus(user.getUserId(), cpInstance.getCPInstanceId(), 5);
            }
            this._inactivateNoOptionSiblingCPInstances(cpInstance.getCPDefinitionId(), serviceContext);
        }
        if (cpInstance.getStatus() == 0 || this._isWorkflowActionPublish(serviceContext)) {
            cpInstance = this.startWorkflowInstance(user.getUserId(), cpInstance, serviceContext);
        }
        return cpInstance;
    }

    public CPInstance updatePricingInfo(long cpInstanceId, BigDecimal price, BigDecimal promoPrice, BigDecimal cost, ServiceContext serviceContext) throws PortalException {
        CPInstance cpInstance = this.cpInstancePersistence.findByPrimaryKey(cpInstanceId);
        if (this.cpDefinitionLocalService.isVersionable(cpInstance.getCPDefinitionId())) {
            CPDefinition newCPDefinition = this.cpDefinitionLocalService.copyCPDefinition(cpInstance.getCPDefinitionId());
            cpInstance = this.cpInstancePersistence.findByC_C(newCPDefinition.getCPDefinitionId(), cpInstance.getCPInstanceUuid());
        }
        cpInstance.setPrice(price);
        cpInstance.setPromoPrice(promoPrice);
        cpInstance.setCost(cost);
        return (CPInstance)this.cpInstancePersistence.update((BaseModel)cpInstance);
    }

    public CPInstance updateShippingInfo(long cpInstanceId, double width, double height, double depth, double weight, ServiceContext serviceContext) throws PortalException {
        CPInstance cpInstance = this.cpInstancePersistence.findByPrimaryKey(cpInstanceId);
        if (this.cpDefinitionLocalService.isVersionable(cpInstance.getCPDefinitionId())) {
            CPDefinition newCPDefinition = this.cpDefinitionLocalService.copyCPDefinition(cpInstance.getCPDefinitionId());
            cpInstance = this.cpInstancePersistence.findByC_C(newCPDefinition.getCPDefinitionId(), cpInstance.getCPInstanceUuid());
        }
        cpInstance.setWidth(width);
        cpInstance.setHeight(height);
        cpInstance.setDepth(depth);
        cpInstance.setWeight(weight);
        return (CPInstance)this.cpInstancePersistence.update((BaseModel)cpInstance);
    }

    @Indexable(type=IndexableType.REINDEX)
    public CPInstance updateStatus(long userId, long cpInstanceId, int status) throws PortalException {
        Date expirationDate;
        User user = this.userLocalService.getUser(userId);
        Date date = new Date();
        CPInstance cpInstance = this.cpInstancePersistence.findByPrimaryKey(cpInstanceId);
        CPDefinition cpDefinition = cpInstance.getCPDefinition();
        if (!cpDefinition.isIgnoreSKUCombinations() && !this.cpInstanceOptionValueRelLocalService.hasCPInstanceOptionValueRel(cpInstance.getCPInstanceId())) {
            status = 5;
        }
        if (status == 0 && cpInstance.getDisplayDate() != null && date.before(cpInstance.getDisplayDate())) {
            status = 7;
        }
        if (status == 0 && (expirationDate = cpInstance.getExpirationDate()) != null && expirationDate.before(date)) {
            cpInstance.setExpirationDate(null);
        }
        if (status == 3) {
            cpInstance.setExpirationDate(date);
        }
        if (cpInstance.getStatus() == 0 && status != 0) {
            this.cpDefinitionOptionValueRelLocalService.resetCPInstanceCPDefinitionOptionValueRels(cpInstance.getCPInstanceUuid());
        }
        cpInstance.setStatus(status);
        cpInstance.setStatusByUserId(user.getUserId());
        cpInstance.setStatusByUserName(user.getFullName());
        cpInstance.setStatusDate(date);
        return (CPInstance)this.cpInstancePersistence.update((BaseModel)cpInstance);
    }

    @Deprecated
    @Indexable(type=IndexableType.REINDEX)
    public CPInstance updateStatus(long userId, long cpInstanceId, int status, ServiceContext serviceContext, Map<String, Serializable> workflowContext) throws PortalException {
        return this.updateStatus(userId, cpInstanceId, status);
    }

    @Indexable(type=IndexableType.REINDEX)
    public CPInstance updateSubscriptionInfo(long cpInstanceId, boolean overrideSubscriptionInfo, boolean subscriptionEnabled, int subscriptionLength, String subscriptionType, UnicodeProperties subscriptionTypeSettingsUnicodeProperties, long maxSubscriptionCycles, boolean deliverySubscriptionEnabled, int deliverySubscriptionLength, String deliverySubscriptionType, UnicodeProperties deliverySubscriptionTypeSettingsUnicodeProperties, long deliveryMaxSubscriptionCycles) throws PortalException {
        CPInstance cpInstance = this.cpInstancePersistence.findByPrimaryKey(cpInstanceId);
        if (this.cpDefinitionLocalService.isVersionable(cpInstance.getCPDefinitionId())) {
            CPDefinition newCPDefinition = this.cpDefinitionLocalService.copyCPDefinition(cpInstance.getCPDefinitionId());
            cpInstance = this.cpInstancePersistence.findByC_C(newCPDefinition.getCPDefinitionId(), cpInstance.getCPInstanceUuid());
        }
        cpInstance.setOverrideSubscriptionInfo(overrideSubscriptionInfo);
        cpInstance.setSubscriptionEnabled(subscriptionEnabled);
        cpInstance.setSubscriptionLength(subscriptionLength);
        cpInstance.setSubscriptionType(subscriptionType);
        cpInstance.setSubscriptionTypeSettingsProperties(subscriptionTypeSettingsUnicodeProperties);
        cpInstance.setMaxSubscriptionCycles(maxSubscriptionCycles);
        cpInstance.setDeliverySubscriptionEnabled(deliverySubscriptionEnabled);
        cpInstance.setDeliverySubscriptionLength(deliverySubscriptionLength);
        cpInstance.setDeliverySubscriptionType(deliverySubscriptionType);
        cpInstance.setDeliverySubscriptionTypeSettingsProperties(deliverySubscriptionTypeSettingsUnicodeProperties);
        cpInstance.setDeliveryMaxSubscriptionCycles(deliveryMaxSubscriptionCycles);
        return (CPInstance)this.cpInstancePersistence.update((BaseModel)cpInstance);
    }

    @Deprecated
    public CPInstance updateSubscriptionInfo(long cpInstanceId, boolean overrideSubscriptionInfo, boolean subscriptionEnabled, int subscriptionLength, String subscriptionType, UnicodeProperties subscriptionTypeSettingsUnicodeProperties, long maxSubscriptionCycles, ServiceContext serviceContext) throws PortalException {
        return this.cpInstanceLocalService.updateSubscriptionInfo(cpInstanceId, overrideSubscriptionInfo, subscriptionEnabled, subscriptionLength, subscriptionType, subscriptionTypeSettingsUnicodeProperties, maxSubscriptionCycles, false, 1, null, null, 0L);
    }

    protected CPInstance addCPInstance(long cpDefinitionId, long groupId, String sku, String gtin, String manufacturerPartNumber, boolean purchasable, Map<Long, List<Long>> cpDefinitionOptionRelIdCPDefinitionOptionValueRelIds, double width, double height, double depth, double weight, BigDecimal price, BigDecimal promoPrice, BigDecimal cost, boolean published, Date displayDate, Date expirationDate, boolean neverExpire, ServiceContext serviceContext) throws PortalException {
        return this.addCPInstance(cpDefinitionId, groupId, sku, gtin, manufacturerPartNumber, purchasable, cpDefinitionOptionRelIdCPDefinitionOptionValueRelIds, width, height, depth, weight, price, promoPrice, cost, published, displayDate, expirationDate, neverExpire, null, serviceContext);
    }

    protected CPInstance addCPInstance(long cpDefinitionId, long groupId, String sku, String gtin, String manufacturerPartNumber, boolean purchasable, Map<Long, List<Long>> cpDefinitionOptionRelIdCPDefinitionOptionValueRelIds, double width, double height, double depth, double weight, BigDecimal price, BigDecimal promoPrice, BigDecimal cost, boolean published, Date displayDate, Date expirationDate, boolean neverExpire, String unspsc, ServiceContext serviceContext) throws PortalException {
        User user = this.userLocalService.getUser(serviceContext.getUserId());
        Calendar displayDateCalendar = CalendarFactoryUtil.getCalendar((long)displayDate.getTime(), (TimeZone)user.getTimeZone());
        int displayDateMonth = displayDateCalendar.get(2);
        int displayDateDay = displayDateCalendar.get(5);
        int displayDateYear = displayDateCalendar.get(1);
        int displayDateHour = displayDateCalendar.get(10);
        int displayDateMinute = displayDateCalendar.get(12);
        int expirationDateMonth = 0;
        int expirationDateDay = 0;
        int expirationDateYear = 0;
        int expirationDateHour = 0;
        int expirationDateMinute = 0;
        if (!neverExpire) {
            Calendar expirationDateCalendar = CalendarFactoryUtil.getCalendar((long)expirationDate.getTime(), (TimeZone)user.getTimeZone());
            expirationDateMonth = expirationDateCalendar.get(2);
            expirationDateDay = expirationDateCalendar.get(5);
            expirationDateYear = expirationDateCalendar.get(1);
            expirationDateHour = expirationDateCalendar.get(10);
            expirationDateMinute = expirationDateCalendar.get(12);
        }
        return this.cpInstanceLocalService.addCPInstance("", cpDefinitionId, groupId, sku, gtin, manufacturerPartNumber, purchasable, cpDefinitionOptionRelIdCPDefinitionOptionValueRelIds, width, height, depth, weight, price, promoPrice, cost, published, displayDateMonth, displayDateDay, displayDateYear, displayDateHour, displayDateMinute, expirationDateMonth, expirationDateDay, expirationDateYear, expirationDateHour, expirationDateMinute, neverExpire, false, false, 1, "", null, 0L, unspsc, serviceContext);
    }

    protected SearchContext buildSearchContext(long companyId, long cpDefinitionId, String keywords, int status, int start, int end, Sort sort) {
        SearchContext searchContext = new SearchContext();
        searchContext.setAttributes((Map)HashMapBuilder.put((Object)"CPDefinitionId", (Object)cpDefinitionId).put((Object)"CPDefinitionStatus", (Object)-1).put((Object)"content", (Object)keywords).put((Object)"status", (Object)status).put((Object)"params", (Object)LinkedHashMapBuilder.put((Object)"keywords", (Object)keywords).build()).build());
        searchContext.setCompanyId(companyId);
        searchContext.setEnd(end);
        if (Validator.isNotNull((String)keywords)) {
            searchContext.setKeywords(keywords);
        }
        if (sort != null) {
            searchContext.setSorts(new Sort[]{sort});
        }
        searchContext.setStart(start);
        QueryConfig queryConfig = searchContext.getQueryConfig();
        queryConfig.setHighlightEnabled(false);
        queryConfig.setScoreEnabled(false);
        return searchContext;
    }

    protected SearchContext buildSearchContext(long companyId, long cpDefinitionId, String keywords, int status, Sort sort) {
        SearchContext searchContext = new SearchContext();
        searchContext.setAttributes((Map)HashMapBuilder.put((Object)"CPDefinitionId", (Object)cpDefinitionId).put((Object)"CPDefinitionStatus", (Object)-1).put((Object)"content", (Object)keywords).put((Object)"status", (Object)status).put((Object)"params", (Object)LinkedHashMapBuilder.put((Object)"keywords", (Object)keywords).build()).build());
        searchContext.setCompanyId(companyId);
        if (Validator.isNotNull((String)keywords)) {
            searchContext.setKeywords(keywords);
        }
        QueryConfig queryConfig = searchContext.getQueryConfig();
        queryConfig.setHighlightEnabled(false);
        queryConfig.setScoreEnabled(false);
        if (sort != null) {
            searchContext.setSorts(new Sort[]{sort});
        }
        return searchContext;
    }

    protected SearchContext buildSearchContext(long companyId, long[] groupIds, String keywords, int status, int start, int end, Sort sort) {
        SearchContext searchContext = new SearchContext();
        searchContext.setAttributes((Map)HashMapBuilder.put((Object)"content", (Object)keywords).put((Object)"status", (Object)status).put((Object)"params", (Object)LinkedHashMapBuilder.put((Object)"keywords", (Object)keywords).build()).build());
        searchContext.setCompanyId(companyId);
        searchContext.setEnd(end);
        searchContext.setGroupIds(groupIds);
        if (Validator.isNotNull((String)keywords)) {
            searchContext.setKeywords(keywords);
        }
        if (sort != null) {
            searchContext.setSorts(new Sort[]{sort});
        }
        searchContext.setStart(start);
        QueryConfig queryConfig = searchContext.getQueryConfig();
        queryConfig.setHighlightEnabled(false);
        queryConfig.setScoreEnabled(false);
        return searchContext;
    }

    protected SearchContext buildSearchContext(long companyId, String keywords, int status, int start, int end, Sort sort) {
        SearchContext searchContext = new SearchContext();
        searchContext.setAttributes((Map)HashMapBuilder.put((Object)"content", (Object)keywords).put((Object)"status", (Object)status).put((Object)"params", (Object)LinkedHashMapBuilder.put((Object)"keywords", (Object)keywords).build()).build());
        searchContext.setCompanyId(companyId);
        searchContext.setEnd(end);
        if (Validator.isNotNull((String)keywords)) {
            searchContext.setKeywords(keywords);
        }
        if (sort != null) {
            searchContext.setSorts(new Sort[]{sort});
        }
        searchContext.setStart(start);
        QueryConfig queryConfig = searchContext.getQueryConfig();
        queryConfig.setHighlightEnabled(false);
        queryConfig.setScoreEnabled(false);
        return searchContext;
    }

    protected void checkCPInstancesByExpirationDate() throws PortalException {
        List cpInstances = this.cpInstanceFinder.findByExpirationDate(new Date(), new QueryDefinition(0));
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Expiring " + cpInstances.size() + " commerce product instances"));
        }
        if (cpInstances != null && !cpInstances.isEmpty()) {
            for (CPInstance cpInstance : cpInstances) {
                long userId = PortalUtil.getValidUserId((long)cpInstance.getCompanyId(), (long)cpInstance.getUserId());
                ServiceContext serviceContext = new ServiceContext();
                serviceContext.setCommand("update");
                serviceContext.setScopeGroupId(cpInstance.getGroupId());
                this.cpInstanceLocalService.updateStatus(userId, cpInstance.getCPInstanceId(), 3);
            }
        }
    }

    protected List<CPInstance> getCPInstances(Hits hits) throws PortalException {
        List documents = hits.toList();
        ArrayList<CPInstance> cpInstances = new ArrayList<CPInstance>(documents.size());
        for (Document document : documents) {
            long cpInstanceId = GetterUtil.getLong((String)document.get("entryClassPK"));
            CPInstance cpInstance = this.fetchCPInstance(cpInstanceId);
            if (cpInstance == null) {
                cpInstances = null;
                Indexer indexer = IndexerRegistryUtil.getIndexer(CPInstance.class);
                long companyId = GetterUtil.getLong((String)document.get("companyId"));
                indexer.delete(companyId, document.getUID());
                continue;
            }
            if (cpInstances == null) continue;
            cpInstances.add(cpInstance);
        }
        return cpInstances;
    }

    protected void reindexCPDefinition(long cpDefinitionId) throws PortalException {
        Indexer indexer = IndexerRegistryUtil.nullSafeGetIndexer(CPDefinition.class);
        indexer.reindex(CPDefinition.class.getName(), cpDefinitionId);
    }

    protected CPInstance startWorkflowInstance(long userId, CPInstance cpInstance, ServiceContext serviceContext) throws PortalException {
        HashMap workflowContext = new HashMap();
        return (CPInstance)WorkflowHandlerRegistryUtil.startWorkflowInstance((long)cpInstance.getCompanyId(), (long)cpInstance.getGroupId(), (long)userId, (String)CPInstance.class.getName(), (long)cpInstance.getCPInstanceId(), (Object)cpInstance, (ServiceContext)serviceContext, workflowContext);
    }

    private void _expireApprovedSiblingCPInstances(long cpDefinitionId, long siblingCPInstanceId, ServiceContext serviceContext) throws PortalException {
        List cpInstances = this.cpInstancePersistence.findByC_ST(cpDefinitionId, 0);
        for (CPInstance cpInstance : cpInstances) {
            if (cpInstance.getCPInstanceId() == siblingCPInstanceId) continue;
            this.cpInstanceLocalService.updateStatus(serviceContext.getUserId(), cpInstance.getCPInstanceId(), 3);
        }
    }

    private void _expireApprovedSiblingMatchingCPInstances(long cpDefinitionId, long cpInstanceId, ServiceContext serviceContext) throws PortalException {
        List cpInstances = this.cpInstancePersistence.findByC_ST(cpDefinitionId, 0);
        List cpInstanceCPInstanceOptionValueRels = this.cpInstanceOptionValueRelLocalService.getCPInstanceCPInstanceOptionValueRels(cpInstanceId);
        for (CPInstance curCPInstance : cpInstances) {
            if (!this.cpInstanceOptionValueRelLocalService.matchesCPInstanceOptionValueRels(curCPInstance.getCPInstanceId(), cpInstanceCPInstanceOptionValueRels)) continue;
            this.cpInstanceLocalService.updateStatus(serviceContext.getUserId(), curCPInstance.getCPInstanceId(), 3);
        }
    }

    private void _expireApprovedSiblingMatchingCPInstances(long cpDefinitionId, Map<Long, List<Long>> cpDefinitionOptionRelIdCPDefinitionOptionValueRelIds, ServiceContext serviceContext) throws PortalException {
        List cpInstances = this.cpInstancePersistence.findByC_ST(cpDefinitionId, 0);
        for (CPInstance curCPInstance : cpInstances) {
            if (!this.cpInstanceOptionValueRelLocalService.matchesCPInstanceOptionValueRels(curCPInstance.getCPInstanceId(), cpDefinitionOptionRelIdCPDefinitionOptionValueRelIds)) continue;
            this.cpInstanceLocalService.updateStatus(serviceContext.getUserId(), curCPInstance.getCPInstanceId(), 3);
        }
    }

    private String _getSKU(CPDefinitionOptionValueRel[] cpDefinitionOptionValueRels, String languageId) {
        StringBundler skuSB = new StringBundler(cpDefinitionOptionValueRels.length + 1);
        for (CPDefinitionOptionValueRel cpDefinitionOptionValueRel : cpDefinitionOptionValueRels) {
            skuSB.append(StringUtil.toUpperCase((String)cpDefinitionOptionValueRel.getName(languageId)));
        }
        return skuSB.toString();
    }

    private SKUCombinationsIterator _getSKUCombinationsIterator(long cpDefinitionId) throws NoSuchSkuContributorCPDefinitionOptionRelException {
        List cpDefinitionOptionRels = this.cpDefinitionOptionRelLocalService.getCPDefinitionOptionRels(cpDefinitionId, true);
        if (cpDefinitionOptionRels.isEmpty()) {
            throw new NoSuchSkuContributorCPDefinitionOptionRelException();
        }
        HashMap<CPDefinitionOptionRel, CPDefinitionOptionValueRel[]> combinationGeneratorMap = new HashMap<CPDefinitionOptionRel, CPDefinitionOptionValueRel[]>();
        for (CPDefinitionOptionRel cpDefinitionOptionRel : cpDefinitionOptionRels) {
            List cpDefinitionOptionValueRels = cpDefinitionOptionRel.getCPDefinitionOptionValueRels();
            CPDefinitionOptionValueRel[] cpDefinitionOptionValueRelArray = new CPDefinitionOptionValueRel[cpDefinitionOptionValueRels.size()];
            cpDefinitionOptionValueRelArray = cpDefinitionOptionValueRels.toArray(cpDefinitionOptionValueRelArray);
            combinationGeneratorMap.put(cpDefinitionOptionRel, cpDefinitionOptionValueRelArray);
        }
        return new SKUCombinationsIterator(combinationGeneratorMap);
    }

    private void _inactivateCPDefinitionOptionRelCPInstances(long userId, long cpDefinitionOptionRelId, List<CPInstance> cpInstances) throws PortalException {
        for (CPInstance cpInstance : cpInstances) {
            if (cpInstance.isInactive() || !this.cpInstanceOptionValueRelLocalService.hasCPInstanceCPDefinitionOptionRel(cpDefinitionOptionRelId, cpInstance.getCPInstanceId())) continue;
            if (userId <= 0L) {
                userId = cpInstance.getUserId();
            }
            this.cpInstanceLocalService.updateStatus(userId, cpInstance.getCPInstanceId(), 5);
        }
    }

    private void _inactivateCPDefinitionOptionValueRelCPInstances(long userId, long cpDefinitionOptionValueRelId, List<CPInstance> cpInstances) throws PortalException {
        for (CPInstance cpInstance : cpInstances) {
            if (cpInstance.isInactive() || !this.cpInstanceOptionValueRelLocalService.hasCPInstanceCPDefinitionOptionValueRel(cpDefinitionOptionValueRelId, cpInstance.getCPInstanceId())) continue;
            if (userId <= 0L) {
                userId = cpInstance.getUserId();
            }
            this.cpInstanceLocalService.updateStatus(userId, cpInstance.getCPInstanceId(), 5);
        }
    }

    private void _inactivateNoOptionSiblingCPInstances(long cpDefinitionId, ServiceContext serviceContext) throws PortalException {
        List cpInstances = this.cpInstancePersistence.findByC_ST(cpDefinitionId, 0);
        for (CPInstance curCPInstance : cpInstances) {
            if (this.cpInstanceOptionValueRelLocalService.hasCPInstanceOptionValueRel(curCPInstance.getCPInstanceId())) continue;
            this.cpInstanceLocalService.updateStatus(serviceContext.getUserId(), curCPInstance.getCPInstanceId(), 5);
        }
    }

    private boolean _isWorkflowActionPublish(ServiceContext serviceContext) {
        return serviceContext.getWorkflowAction() == 1;
    }

    private Map<Long, List<Long>> _toCpDefinitionOptionRelIdCPDefinitionOptionValueRelIds(CPDefinitionOptionValueRel[] cpDefinitionOptionValueRels) {
        HashMap<Long, List<Long>> cpDefinitionOptionRelIdCPDefinitionOptionValueRelIds = new HashMap<Long, List<Long>>();
        for (CPDefinitionOptionValueRel cpDefinitionOptionValueRel : cpDefinitionOptionValueRels) {
            ArrayList<Long> cpDefinitionOptionValueRelIds = (ArrayList<Long>)cpDefinitionOptionRelIdCPDefinitionOptionValueRelIds.get(cpDefinitionOptionValueRel.getCPDefinitionOptionRelId());
            if (cpDefinitionOptionValueRelIds == null) {
                cpDefinitionOptionValueRelIds = new ArrayList<Long>();
                cpDefinitionOptionRelIdCPDefinitionOptionValueRelIds.put(cpDefinitionOptionValueRel.getCPDefinitionOptionRelId(), cpDefinitionOptionValueRelIds);
            }
            cpDefinitionOptionValueRelIds.add(cpDefinitionOptionValueRel.getCPDefinitionOptionValueRelId());
        }
        return cpDefinitionOptionRelIdCPDefinitionOptionValueRelIds;
    }

    private void _validateSku(long cpDefinitionId, long cpInstanceId, String sku) throws CPInstanceSkuException {
        if (Validator.isNull((String)sku)) {
            throw new CPInstanceSkuException("SKU value required for product definition ID " + cpDefinitionId);
        }
        CPInstance cpInstance = this.cpInstancePersistence.fetchByC_S(cpDefinitionId, sku);
        if (cpInstance == null || cpInstanceId == cpInstance.getCPInstanceId()) {
            return;
        }
        throw new CPInstanceSkuException("Duplicate SKU value for product definition ID " + cpDefinitionId);
    }
}

