/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.product.service.impl;

import com.liferay.commerce.product.exception.NoSuchCPDefinitionException;
import com.liferay.commerce.product.model.CPDefinition;
import com.liferay.commerce.product.model.CPInstance;
import com.liferay.commerce.product.model.CProduct;
import com.liferay.commerce.product.model.CommerceCatalog;
import com.liferay.commerce.product.service.base.CPInstanceServiceBaseImpl;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.ClassedModel;
import com.liferay.portal.kernel.search.BaseModelSearchResult;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermissionFactory;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.UnicodeProperties;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import java.util.stream.LongStream;
import java.util.stream.Stream;

public class CPInstanceServiceImpl
extends CPInstanceServiceBaseImpl {
    private static volatile ModelResourcePermission<CommerceCatalog> _commerceCatalogModelResourcePermission = ModelResourcePermissionFactory.getInstance(CPInstanceServiceImpl.class, (String)"_commerceCatalogModelResourcePermission", CommerceCatalog.class);

    public CPInstance addCPInstance(long cpDefinitionId, long groupId, String sku, String gtin, String manufacturerPartNumber, boolean purchasable, Map<Long, List<Long>> cpDefinitionOptionRelIdCPDefinitionOptionValueRelIds, boolean published, int displayDateMonth, int displayDateDay, int displayDateYear, int displayDateHour, int displayDateMinute, int expirationDateMonth, int expirationDateDay, int expirationDateYear, int expirationDateHour, int expirationDateMinute, boolean neverExpire, ServiceContext serviceContext) throws PortalException {
        return this.addCPInstance(cpDefinitionId, groupId, sku, gtin, manufacturerPartNumber, purchasable, cpDefinitionOptionRelIdCPDefinitionOptionValueRelIds, published, displayDateMonth, displayDateDay, displayDateYear, displayDateHour, displayDateMinute, expirationDateMonth, expirationDateDay, expirationDateYear, expirationDateHour, expirationDateMinute, neverExpire, null, serviceContext);
    }

    public CPInstance addCPInstance(long cpDefinitionId, long groupId, String sku, String gtin, String manufacturerPartNumber, boolean purchasable, Map<Long, List<Long>> cpDefinitionOptionRelIdCPDefinitionOptionValueRelIds, boolean published, int displayDateMonth, int displayDateDay, int displayDateYear, int displayDateHour, int displayDateMinute, int expirationDateMonth, int expirationDateDay, int expirationDateYear, int expirationDateHour, int expirationDateMinute, boolean neverExpire, String unspsc, ServiceContext serviceContext) throws PortalException {
        this._checkCommerceCatalogByCPDefinitionId(cpDefinitionId, "UPDATE");
        CPDefinition cpDefinition = this.cpDefinitionLocalService.getCPDefinition(cpDefinitionId);
        return this.cpInstanceLocalService.addCPInstance("", cpDefinitionId, groupId, sku, gtin, manufacturerPartNumber, purchasable, cpDefinitionOptionRelIdCPDefinitionOptionValueRelIds, cpDefinition.getWidth(), cpDefinition.getHeight(), cpDefinition.getDepth(), cpDefinition.getWeight(), BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, published, displayDateMonth, displayDateDay, displayDateYear, displayDateHour, displayDateMinute, expirationDateMonth, expirationDateDay, expirationDateYear, expirationDateHour, expirationDateMinute, neverExpire, false, false, 1, "", null, 0L, unspsc, serviceContext);
    }

    @Deprecated
    public CPInstance addCPInstance(long cpDefinitionId, long groupId, String sku, String gtin, String manufacturerPartNumber, boolean purchasable, String json, boolean published, int displayDateMonth, int displayDateDay, int displayDateYear, int displayDateHour, int displayDateMinute, int expirationDateMonth, int expirationDateDay, int expirationDateYear, int expirationDateHour, int expirationDateMinute, boolean neverExpire, ServiceContext serviceContext) throws PortalException {
        return this.addCPInstance(cpDefinitionId, groupId, sku, gtin, manufacturerPartNumber, purchasable, json, published, displayDateMonth, displayDateDay, displayDateYear, displayDateHour, displayDateMinute, expirationDateMonth, expirationDateDay, expirationDateYear, expirationDateHour, expirationDateMinute, neverExpire, null, serviceContext);
    }

    @Deprecated
    public CPInstance addCPInstance(long cpDefinitionId, long groupId, String sku, String gtin, String manufacturerPartNumber, boolean purchasable, String json, boolean published, int displayDateMonth, int displayDateDay, int displayDateYear, int displayDateHour, int displayDateMinute, int expirationDateMonth, int expirationDateDay, int expirationDateYear, int expirationDateHour, int expirationDateMinute, boolean neverExpire, String unspsc, ServiceContext serviceContext) throws PortalException {
        this._checkCommerceCatalogByCPDefinitionId(cpDefinitionId, "UPDATE");
        return this.cpInstanceLocalService.addCPInstance(cpDefinitionId, groupId, sku, gtin, manufacturerPartNumber, purchasable, json, published, displayDateMonth, displayDateDay, displayDateYear, displayDateHour, displayDateMinute, expirationDateMonth, expirationDateDay, expirationDateYear, expirationDateHour, expirationDateMinute, neverExpire, unspsc, serviceContext);
    }

    public CPInstance addOrUpdateCPInstance(String externalReferenceCode, long cpDefinitionId, long groupId, String sku, String gtin, String manufacturerPartNumber, boolean purchasable, String json, double width, double height, double depth, double weight, BigDecimal price, BigDecimal promoPrice, BigDecimal cost, boolean published, int displayDateMonth, int displayDateDay, int displayDateYear, int displayDateHour, int displayDateMinute, int expirationDateMonth, int expirationDateDay, int expirationDateYear, int expirationDateHour, int expirationDateMinute, boolean neverExpire, ServiceContext serviceContext) throws PortalException {
        return this.addOrUpdateCPInstance(externalReferenceCode, cpDefinitionId, groupId, sku, gtin, manufacturerPartNumber, purchasable, json, width, height, depth, weight, price, promoPrice, cost, published, displayDateMonth, displayDateDay, displayDateYear, displayDateHour, displayDateMinute, expirationDateMonth, expirationDateDay, expirationDateYear, expirationDateHour, expirationDateMinute, neverExpire, null, serviceContext);
    }

    public CPInstance addOrUpdateCPInstance(String externalReferenceCode, long cpDefinitionId, long groupId, String sku, String gtin, String manufacturerPartNumber, boolean purchasable, String json, double width, double height, double depth, double weight, BigDecimal price, BigDecimal promoPrice, BigDecimal cost, boolean published, int displayDateMonth, int displayDateDay, int displayDateYear, int displayDateHour, int displayDateMinute, int expirationDateMonth, int expirationDateDay, int expirationDateYear, int expirationDateHour, int expirationDateMinute, boolean neverExpire, String unspsc, ServiceContext serviceContext) throws PortalException {
        this._checkCommerceCatalog(groupId, "UPDATE");
        return this.cpInstanceLocalService.addOrUpdateCPInstance(externalReferenceCode, cpDefinitionId, groupId, sku, gtin, manufacturerPartNumber, purchasable, json, width, height, depth, weight, price, promoPrice, cost, published, displayDateMonth, displayDateDay, displayDateYear, displayDateHour, displayDateMinute, expirationDateMonth, expirationDateDay, expirationDateYear, expirationDateHour, expirationDateMinute, neverExpire, unspsc, serviceContext);
    }

    public void buildCPInstances(long cpDefinitionId, ServiceContext serviceContext) throws PortalException {
        this._checkCommerceCatalogByCPDefinitionId(cpDefinitionId, "UPDATE");
        this.cpInstanceLocalService.buildCPInstances(cpDefinitionId, serviceContext);
    }

    public void deleteCPInstance(long cpInstanceId) throws PortalException {
        CPInstance cpInstance = this.cpInstanceService.getCPInstance(cpInstanceId);
        this._checkCommerceCatalogByCPDefinitionId(cpInstance.getCPDefinitionId(), "UPDATE");
        this.cpInstanceLocalService.deleteCPInstance(cpInstance);
    }

    public CPInstance fetchByExternalReferenceCode(String externalReferenceCode, long companyId) throws PortalException {
        CPInstance cpInstance = this.cpInstanceLocalService.fetchByExternalReferenceCode(externalReferenceCode, companyId);
        if (cpInstance != null) {
            this._checkCommerceCatalogByCPDefinitionId(cpInstance.getCPDefinitionId(), "VIEW");
        }
        return cpInstance;
    }

    public CPInstance fetchCPInstance(long cpInstanceId) throws PortalException {
        CPInstance cpInstance = this.cpInstanceLocalService.fetchCPInstance(cpInstanceId);
        if (cpInstance != null) {
            this._checkCommerceCatalogByCPDefinitionId(cpInstance.getCPDefinitionId(), "VIEW");
        }
        return cpInstance;
    }

    public CPInstance fetchCProductInstance(long cProductId, String cpInstanceUuid) throws PortalException {
        CProduct cProduct = this.cProductLocalService.fetchCProduct(cProductId);
        if (cProduct == null) {
            return null;
        }
        this._checkCommerceCatalogByCPDefinitionId(cProduct.getPublishedCPDefinitionId(), "VIEW");
        return this.cpInstanceLocalService.fetchCProductInstance(cProductId, cpInstanceUuid);
    }

    public List<CPInstance> getCPDefinitionInstances(long cpDefinitionId, int status, int start, int end, OrderByComparator<CPInstance> orderByComparator) throws PortalException {
        this._checkCommerceCatalogByCPDefinitionId(cpDefinitionId, "VIEW");
        return this.cpInstanceLocalService.getCPDefinitionInstances(cpDefinitionId, status, start, end, orderByComparator);
    }

    public int getCPDefinitionInstancesCount(long cpDefinitionId, int status) throws PortalException {
        this._checkCommerceCatalogByCPDefinitionId(cpDefinitionId, "VIEW");
        return this.cpInstanceLocalService.getCPDefinitionInstancesCount(cpDefinitionId, status);
    }

    public CPInstance getCPInstance(long cpInstanceId) throws PortalException {
        CPInstance cpInstance = this.cpInstanceLocalService.getCPInstance(cpInstanceId);
        this._checkCommerceCatalogByCPDefinitionId(cpInstance.getCPDefinitionId(), "VIEW");
        return cpInstance;
    }

    public List<CPInstance> getCPInstances(long groupId, int status, int start, int end, OrderByComparator<CPInstance> orderByComparator) throws PortalException {
        this._checkCommerceCatalog(groupId, "VIEW");
        return this.cpInstanceLocalService.getCPInstances(groupId, status, start, end, orderByComparator);
    }

    public int getCPInstancesCount(long groupId, int status) throws PortalException {
        this._checkCommerceCatalog(groupId, "VIEW");
        return this.cpInstanceLocalService.getCPInstancesCount(groupId, status);
    }

    public BaseModelSearchResult<CPInstance> searchCPDefinitionInstances(long companyId, long cpDefinitionId, String keywords, int status, int start, int end, Sort sort) throws PortalException {
        if (cpDefinitionId > 0L) {
            this._checkCommerceCatalogByCPDefinitionId(cpDefinitionId, "VIEW");
        }
        return this.cpInstanceLocalService.searchCPDefinitionInstances(companyId, cpDefinitionId, keywords, status, start, end, sort);
    }

    public BaseModelSearchResult<CPInstance> searchCPDefinitionInstances(long companyId, long cpDefinitionId, String keywords, int status, Sort sort) throws PortalException {
        if (cpDefinitionId > 0L) {
            this._checkCommerceCatalogByCPDefinitionId(cpDefinitionId, "VIEW");
        }
        return this.cpInstanceLocalService.searchCPDefinitionInstances(companyId, cpDefinitionId, keywords, status, sort);
    }

    public BaseModelSearchResult<CPInstance> searchCPInstances(long companyId, long groupId, String keywords, int status, int start, int end, Sort sort) throws PortalException {
        this._checkCommerceCatalog(groupId, "VIEW");
        return this.cpInstanceLocalService.searchCPInstances(companyId, new long[]{groupId}, keywords, status, start, end, sort);
    }

    public BaseModelSearchResult<CPInstance> searchCPInstances(long companyId, String keywords, int status, int start, int end, Sort sort) throws PortalException {
        List commerceCatalogs = this.commerceCatalogService.getCommerceCatalogs(companyId, -1, -1);
        Stream stream = commerceCatalogs.stream();
        LongStream longStream = stream.mapToLong(CommerceCatalog::getGroupId);
        long[] groupIds = longStream.toArray();
        return this.cpInstanceLocalService.searchCPInstances(companyId, groupIds, keywords, status, start, end, sort);
    }

    public CPInstance updateCPInstance(long cpInstanceId, String sku, String gtin, String manufacturerPartNumber, boolean purchasable, boolean published, int displayDateMonth, int displayDateDay, int displayDateYear, int displayDateHour, int displayDateMinute, int expirationDateMonth, int expirationDateDay, int expirationDateYear, int expirationDateHour, int expirationDateMinute, boolean neverExpire, ServiceContext serviceContext) throws PortalException {
        return this.updateCPInstance(cpInstanceId, sku, gtin, manufacturerPartNumber, purchasable, published, displayDateMonth, displayDateDay, displayDateYear, displayDateHour, displayDateMinute, expirationDateMonth, expirationDateDay, expirationDateYear, expirationDateHour, expirationDateMinute, neverExpire, null, serviceContext);
    }

    public CPInstance updateCPInstance(long cpInstanceId, String sku, String gtin, String manufacturerPartNumber, boolean purchasable, boolean published, int displayDateMonth, int displayDateDay, int displayDateYear, int displayDateHour, int displayDateMinute, int expirationDateMonth, int expirationDateDay, int expirationDateYear, int expirationDateHour, int expirationDateMinute, boolean neverExpire, String unspsc, ServiceContext serviceContext) throws PortalException {
        CPInstance cpInstance = this.cpInstanceLocalService.getCPInstance(cpInstanceId);
        this._checkCommerceCatalogByCPDefinitionId(cpInstance.getCPDefinitionId(), "UPDATE");
        return this.cpInstanceLocalService.updateCPInstance(cpInstanceId, sku, gtin, manufacturerPartNumber, purchasable, published, displayDateMonth, displayDateDay, displayDateYear, displayDateHour, displayDateMinute, expirationDateMonth, expirationDateDay, expirationDateYear, expirationDateHour, expirationDateMinute, neverExpire, unspsc, serviceContext);
    }

    public CPInstance updatePricingInfo(long cpInstanceId, BigDecimal price, BigDecimal promoPrice, BigDecimal cost, ServiceContext serviceContext) throws PortalException {
        CPInstance cpInstance = this.cpInstanceLocalService.getCPInstance(cpInstanceId);
        this._checkCommerceCatalogByCPDefinitionId(cpInstance.getCPDefinitionId(), "UPDATE");
        return this.cpInstanceLocalService.updatePricingInfo(cpInstanceId, price, promoPrice, cost, serviceContext);
    }

    public CPInstance updateShippingInfo(long cpInstanceId, double width, double height, double depth, double weight, ServiceContext serviceContext) throws PortalException {
        CPInstance cpInstance = this.cpInstanceLocalService.getCPInstance(cpInstanceId);
        this._checkCommerceCatalogByCPDefinitionId(cpInstance.getCPDefinitionId(), "UPDATE");
        return this.cpInstanceLocalService.updateShippingInfo(cpInstanceId, width, height, depth, weight, serviceContext);
    }

    public CPInstance updateSubscriptionInfo(long cpInstanceId, boolean overrideSubscriptionInfo, boolean subscriptionEnabled, int subscriptionLength, String subscriptionType, UnicodeProperties subscriptionTypeSettingsUnicodeProperties, long maxSubscriptionCycles, boolean deliverySubscriptionEnabled, int deliverySubscriptionLength, String deliverySubscriptionType, UnicodeProperties deliverySubscriptionTypeSettingsUnicodeProperties, long deliveryMaxSubscriptionCycles) throws PortalException {
        CPInstance cpInstance = this.cpInstanceLocalService.getCPInstance(cpInstanceId);
        this._checkCommerceCatalogByCPDefinitionId(cpInstance.getCPDefinitionId(), "UPDATE");
        return this.cpInstanceLocalService.updateSubscriptionInfo(cpInstanceId, overrideSubscriptionInfo, subscriptionEnabled, subscriptionLength, subscriptionType, subscriptionTypeSettingsUnicodeProperties, maxSubscriptionCycles, deliverySubscriptionEnabled, deliverySubscriptionLength, deliverySubscriptionType, deliverySubscriptionTypeSettingsUnicodeProperties, deliveryMaxSubscriptionCycles);
    }

    @Deprecated
    public CPInstance updateSubscriptionInfo(long cpInstanceId, boolean overrideSubscriptionInfo, boolean subscriptionEnabled, int subscriptionLength, String subscriptionType, UnicodeProperties subscriptionTypeSettingsUnicodeProperties, long maxSubscriptionCycles, ServiceContext serviceContext) throws PortalException {
        CPInstance cpInstance = this.cpInstanceLocalService.getCPInstance(cpInstanceId);
        this._checkCommerceCatalogByCPDefinitionId(cpInstance.getCPDefinitionId(), "UPDATE");
        return this.cpInstanceLocalService.updateSubscriptionInfo(cpInstanceId, overrideSubscriptionInfo, subscriptionEnabled, subscriptionLength, subscriptionType, subscriptionTypeSettingsUnicodeProperties, maxSubscriptionCycles, serviceContext);
    }

    private void _checkCommerceCatalog(long groupId, String actionId) throws PortalException {
        CommerceCatalog commerceCatalog = this.commerceCatalogLocalService.fetchCommerceCatalogByGroupId(groupId);
        if (commerceCatalog == null) {
            throw new PrincipalException();
        }
        _commerceCatalogModelResourcePermission.check(this.getPermissionChecker(), (ClassedModel)commerceCatalog, actionId);
    }

    private void _checkCommerceCatalogByCPDefinitionId(long cpDefinitionId, String actionId) throws PortalException {
        CPDefinition cpDefinition = this.cpDefinitionLocalService.fetchCPDefinition(cpDefinitionId);
        if (cpDefinition == null) {
            throw new NoSuchCPDefinitionException();
        }
        CommerceCatalog commerceCatalog = this.commerceCatalogLocalService.fetchCommerceCatalogByGroupId(cpDefinition.getGroupId());
        if (commerceCatalog == null) {
            throw new PrincipalException();
        }
        _commerceCatalogModelResourcePermission.check(this.getPermissionChecker(), (ClassedModel)commerceCatalog, actionId);
    }
}

