/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.product.service.impl;

import com.liferay.commerce.product.exception.CPMeasurementUnitKeyException;
import com.liferay.commerce.product.model.CPMeasurementUnit;
import com.liferay.commerce.product.service.base.CPMeasurementUnitLocalServiceBaseImpl;
import com.liferay.commerce.product.util.comparator.CPMeasurementUnitPriorityComparator;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.systemevent.SystemEvent;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.OrderByComparator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class CPMeasurementUnitLocalServiceImpl
extends CPMeasurementUnitLocalServiceBaseImpl {
    public CPMeasurementUnit addCPMeasurementUnit(Map<Locale, String> nameMap, String key, double rate, boolean primary, double priority, int type, ServiceContext serviceContext) throws PortalException {
        User user = this.userLocalService.getUser(serviceContext.getUserId());
        if (primary) {
            rate = 1.0;
        }
        this.validate(0L, serviceContext.getCompanyId(), key, primary, type);
        long cpMeasurementUnitId = this.counterLocalService.increment();
        CPMeasurementUnit cpMeasurementUnit = this.cpMeasurementUnitPersistence.create(cpMeasurementUnitId);
        cpMeasurementUnit.setGroupId(serviceContext.getScopeGroupId());
        cpMeasurementUnit.setCompanyId(user.getCompanyId());
        cpMeasurementUnit.setUserId(user.getUserId());
        cpMeasurementUnit.setUserName(user.getFullName());
        cpMeasurementUnit.setNameMap(nameMap);
        cpMeasurementUnit.setKey(key);
        cpMeasurementUnit.setRate(rate);
        cpMeasurementUnit.setPrimary(primary);
        cpMeasurementUnit.setPriority(priority);
        cpMeasurementUnit.setType(type);
        return (CPMeasurementUnit)this.cpMeasurementUnitPersistence.update((BaseModel)cpMeasurementUnit);
    }

    @Override
    @SystemEvent(type=1)
    public CPMeasurementUnit deleteCPMeasurementUnit(CPMeasurementUnit cpMeasurementUnit) {
        return (CPMeasurementUnit)this.cpMeasurementUnitPersistence.remove((BaseModel)cpMeasurementUnit);
    }

    @Override
    public CPMeasurementUnit deleteCPMeasurementUnit(long cpMeasurementUnitId) throws PortalException {
        CPMeasurementUnit cpMeasurementUnit = this.cpMeasurementUnitPersistence.findByPrimaryKey(cpMeasurementUnitId);
        return this.cpMeasurementUnitLocalService.deleteCPMeasurementUnit(cpMeasurementUnit);
    }

    public void deleteCPMeasurementUnits(long companyId) {
        this.cpMeasurementUnitPersistence.removeByCompanyId(companyId);
    }

    public CPMeasurementUnit fetchPrimaryCPMeasurementUnit(long companyId, int type) {
        return this.cpMeasurementUnitPersistence.fetchByC_P_T_First(companyId, true, type, (OrderByComparator)new CPMeasurementUnitPriorityComparator());
    }

    public List<CPMeasurementUnit> getCPMeasurementUnits(long companyId) {
        return this.cpMeasurementUnitPersistence.findByCompanyId(companyId);
    }

    public List<CPMeasurementUnit> getCPMeasurementUnits(long companyId, int type, int start, int end, OrderByComparator<CPMeasurementUnit> orderByComparator) {
        return this.cpMeasurementUnitPersistence.findByC_T(companyId, type, start, end, orderByComparator);
    }

    public List<CPMeasurementUnit> getCPMeasurementUnits(long companyId, int start, int end, OrderByComparator<CPMeasurementUnit> orderByComparator) {
        return this.cpMeasurementUnitPersistence.findByCompanyId(companyId, start, end, orderByComparator);
    }

    public List<CPMeasurementUnit> getCPMeasurementUnits(long companyId, String[] keys, int type) {
        ArrayList<CPMeasurementUnit> cpMeasurementUnits = new ArrayList<CPMeasurementUnit>(keys.length);
        for (String key : keys) {
            CPMeasurementUnit cpMeasurementUnit = this.cpMeasurementUnitPersistence.fetchByC_K_T(companyId, key, type);
            if (cpMeasurementUnit == null) continue;
            cpMeasurementUnits.add(cpMeasurementUnit);
        }
        return cpMeasurementUnits;
    }

    public int getCPMeasurementUnitsCount(long companyId) {
        return this.cpMeasurementUnitPersistence.countByCompanyId(companyId);
    }

    public int getCPMeasurementUnitsCount(long companyId, int type) {
        return this.cpMeasurementUnitPersistence.countByC_T(companyId, type);
    }

    public void importDefaultValues(ServiceContext serviceContext) throws PortalException {
        this._addCPMeasurementUnit("inches", "in", 1.0, true, 1.0, 0, serviceContext);
        this._addCPMeasurementUnit("feet", "ft", 0.08333333, false, 2.0, 0, serviceContext);
        this._addCPMeasurementUnit("meters", "m", 0.0254, false, 3.0, 0, serviceContext);
        this._addCPMeasurementUnit("millimeters", "mm", 25.4, false, 1.0, 0, serviceContext);
        this._addCPMeasurementUnit("ounces", "oz", 16.0, false, 1.0, 1, serviceContext);
        this._addCPMeasurementUnit("pounds", "lb", 1.0, true, 2.0, 1, serviceContext);
        this._addCPMeasurementUnit("kilograms", "kg", 0.45359237, false, 3.0, 1, serviceContext);
        this._addCPMeasurementUnit("grams", "g", 453.59237, false, 4.0, 1, serviceContext);
    }

    public CPMeasurementUnit setPrimary(long cpMeasurementUnitId, boolean primary) throws PortalException {
        CPMeasurementUnit cpMeasurementUnit = this.cpMeasurementUnitPersistence.findByPrimaryKey(cpMeasurementUnitId);
        this.validate(cpMeasurementUnitId, cpMeasurementUnit.getCompanyId(), cpMeasurementUnit.getKey(), primary, cpMeasurementUnit.getType());
        cpMeasurementUnit.setPrimary(primary);
        return (CPMeasurementUnit)this.cpMeasurementUnitPersistence.update((BaseModel)cpMeasurementUnit);
    }

    public CPMeasurementUnit updateCPMeasurementUnit(long cpMeasurementUnitId, Map<Locale, String> nameMap, String key, double rate, boolean primary, double priority, int type, ServiceContext serviceContext) throws PortalException {
        CPMeasurementUnit cpMeasurementUnit = this.cpMeasurementUnitPersistence.findByPrimaryKey(cpMeasurementUnitId);
        if (primary) {
            rate = 1.0;
        }
        this.validate(cpMeasurementUnit.getCPMeasurementUnitId(), serviceContext.getCompanyId(), key, primary, type);
        cpMeasurementUnit.setNameMap(nameMap);
        cpMeasurementUnit.setKey(key);
        cpMeasurementUnit.setRate(rate);
        cpMeasurementUnit.setPrimary(primary);
        cpMeasurementUnit.setPriority(priority);
        cpMeasurementUnit.setType(type);
        return (CPMeasurementUnit)this.cpMeasurementUnitPersistence.update((BaseModel)cpMeasurementUnit);
    }

    protected void validate(long cpMeasurementUnitId, long companyId, String key, boolean primary, int type) throws PortalException {
        CPMeasurementUnit cpMeasurementUnit = this.cpMeasurementUnitPersistence.fetchByC_K_T(companyId, key, type);
        if (cpMeasurementUnit != null && cpMeasurementUnit.getCPMeasurementUnitId() != cpMeasurementUnitId) {
            throw new CPMeasurementUnitKeyException();
        }
        if (primary) {
            List cpMeasurementUnits = this.cpMeasurementUnitPersistence.findByC_P_T(companyId, primary, type);
            for (CPMeasurementUnit curCPMeasurementUnit : cpMeasurementUnits) {
                if (curCPMeasurementUnit.getCPMeasurementUnitId() == cpMeasurementUnitId) continue;
                curCPMeasurementUnit.setPrimary(false);
                this.cpMeasurementUnitPersistence.update((BaseModel)curCPMeasurementUnit);
            }
        }
    }

    private void _addCPMeasurementUnit(String name, String key, double rate, boolean primary, double priority, int type, ServiceContext serviceContext) throws PortalException {
        HashMap nameMap = HashMapBuilder.put((Object)serviceContext.getLocale(), (Object)name).build();
        CPMeasurementUnit cpMeasurementUnit = this.cpMeasurementUnitPersistence.fetchByC_K_T(serviceContext.getCompanyId(), key, type);
        if (cpMeasurementUnit == null) {
            this.cpMeasurementUnitLocalService.addCPMeasurementUnit((Map)nameMap, key, rate, primary, priority, type, serviceContext);
        }
    }
}

