/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.product.service.impl;

import com.liferay.commerce.product.exception.CPOptionCategoryKeyException;
import com.liferay.commerce.product.model.CPDefinitionSpecificationOptionValue;
import com.liferay.commerce.product.model.CPOptionCategory;
import com.liferay.commerce.product.model.CPSpecificationOption;
import com.liferay.commerce.product.service.base.CPOptionCategoryLocalServiceBaseImpl;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.AuditedModel;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.search.BaseModelSearchResult;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.Hits;
import com.liferay.portal.kernel.search.Indexable;
import com.liferay.portal.kernel.search.IndexableType;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerRegistryUtil;
import com.liferay.portal.kernel.search.QueryConfig;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.SearchException;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.systemevent.SystemEvent;
import com.liferay.portal.kernel.util.FriendlyURLNormalizerUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.LinkedHashMapBuilder;
import com.liferay.portal.kernel.util.Validator;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class CPOptionCategoryLocalServiceImpl
extends CPOptionCategoryLocalServiceBaseImpl {
    private static final String[] _SELECTED_FIELD_NAMES = new String[]{"entryClassPK", "companyId", "uid"};

    @Indexable(type=IndexableType.REINDEX)
    public CPOptionCategory addCPOptionCategory(long userId, Map<Locale, String> titleMap, Map<Locale, String> descriptionMap, double priority, String key, ServiceContext serviceContext) throws PortalException {
        User user = this.userLocalService.getUser(userId);
        key = FriendlyURLNormalizerUtil.normalize((String)key);
        this.validate(0L, user.getCompanyId(), key);
        long cpOptionCategoryId = this.counterLocalService.increment();
        CPOptionCategory cpOptionCategory = this.cpOptionCategoryPersistence.create(cpOptionCategoryId);
        cpOptionCategory.setCompanyId(user.getCompanyId());
        cpOptionCategory.setUserId(user.getUserId());
        cpOptionCategory.setUserName(user.getFullName());
        cpOptionCategory.setTitleMap(titleMap);
        cpOptionCategory.setDescriptionMap(descriptionMap);
        cpOptionCategory.setPriority(priority);
        cpOptionCategory.setKey(key);
        cpOptionCategory = (CPOptionCategory)this.cpOptionCategoryPersistence.update((BaseModel)cpOptionCategory);
        this.resourceLocalService.addModelResources((AuditedModel)cpOptionCategory, serviceContext);
        return cpOptionCategory;
    }

    public void deleteCPOptionCategories(long companyId) throws PortalException {
        List cpOptionCategories = this.cpOptionCategoryPersistence.findByCompanyId(companyId);
        for (CPOptionCategory cpOptionCategory : cpOptionCategories) {
            this.cpOptionCategoryLocalService.deleteCPOptionCategory(cpOptionCategory);
        }
    }

    @Override
    @Indexable(type=IndexableType.DELETE)
    @SystemEvent(type=1)
    public CPOptionCategory deleteCPOptionCategory(CPOptionCategory cpOptionCategory) throws PortalException {
        this.cpOptionCategoryPersistence.remove((BaseModel)cpOptionCategory);
        this.resourceLocalService.deleteResource((AuditedModel)cpOptionCategory, 4);
        List cpSpecificationOptions = this.cpSpecificationOptionPersistence.findByCPOptionCategoryId(cpOptionCategory.getCPOptionCategoryId());
        for (CPSpecificationOption cpSpecificationOption : cpSpecificationOptions) {
            this.cpSpecificationOptionLocalService.updateCPOptionCategoryId(cpSpecificationOption.getCPSpecificationOptionId(), 0L);
        }
        List cpDefinitionSpecificationOptionValues = this.cpDefinitionSpecificationOptionValuePersistence.findByCPOptionCategoryId(cpOptionCategory.getCPOptionCategoryId());
        for (CPDefinitionSpecificationOptionValue cpDefinitionSpecificationOptionValue : cpDefinitionSpecificationOptionValues) {
            this.cpDefinitionSpecificationOptionValueLocalService.updateCPOptionCategoryId(cpDefinitionSpecificationOptionValue.getCPDefinitionSpecificationOptionValueId(), 0L);
        }
        return cpOptionCategory;
    }

    @Override
    public CPOptionCategory deleteCPOptionCategory(long cpOptionCategoryId) throws PortalException {
        CPOptionCategory cpOptionCategory = this.cpOptionCategoryPersistence.findByPrimaryKey(cpOptionCategoryId);
        return this.cpOptionCategoryLocalService.deleteCPOptionCategory(cpOptionCategory);
    }

    public CPOptionCategory fetchCPOptionCategory(long companyId, String key) {
        return this.cpOptionCategoryPersistence.fetchByC_K(companyId, key);
    }

    public List<CPOptionCategory> getCPOptionCategories(long companyId, int start, int end) {
        return this.cpOptionCategoryPersistence.findByCompanyId(companyId, start, end);
    }

    public CPOptionCategory getCPOptionCategory(long companyId, String key) throws PortalException {
        return this.cpOptionCategoryPersistence.findByC_K(companyId, key);
    }

    public BaseModelSearchResult<CPOptionCategory> searchCPOptionCategories(long companyId, String keywords, int start, int end, Sort sort) throws PortalException {
        SearchContext searchContext = this.buildSearchContext(companyId, keywords, start, end, sort);
        return this.searchCPOptionCategories(searchContext);
    }

    @Indexable(type=IndexableType.REINDEX)
    public CPOptionCategory updateCPOptionCategory(long cpOptionCategoryId, Map<Locale, String> titleMap, Map<Locale, String> descriptionMap, double priority, String key) throws PortalException {
        CPOptionCategory cpOptionCategory = this.cpOptionCategoryPersistence.findByPrimaryKey(cpOptionCategoryId);
        key = FriendlyURLNormalizerUtil.normalize((String)key);
        this.validate(cpOptionCategory.getCPOptionCategoryId(), cpOptionCategory.getCompanyId(), key);
        cpOptionCategory.setTitleMap(titleMap);
        cpOptionCategory.setDescriptionMap(descriptionMap);
        cpOptionCategory.setPriority(priority);
        cpOptionCategory.setKey(key);
        return (CPOptionCategory)this.cpOptionCategoryPersistence.update((BaseModel)cpOptionCategory);
    }

    protected SearchContext buildSearchContext(long companyId, String keywords, int start, int end, Sort sort) {
        SearchContext searchContext = new SearchContext();
        searchContext.setAttributes((Map)HashMapBuilder.put((Object)"key", (Object)keywords).put((Object)"description", (Object)keywords).put((Object)"entryClassPK", (Object)keywords).put((Object)"title", (Object)keywords).put((Object)"params", (Object)LinkedHashMapBuilder.put((Object)"keywords", (Object)keywords).build()).build());
        searchContext.setCompanyId(companyId);
        searchContext.setEnd(end);
        if (Validator.isNotNull((String)keywords)) {
            searchContext.setKeywords(keywords);
        }
        if (sort != null) {
            searchContext.setSorts(new Sort[]{sort});
        }
        searchContext.setStart(start);
        QueryConfig queryConfig = searchContext.getQueryConfig();
        queryConfig.setHighlightEnabled(false);
        queryConfig.setScoreEnabled(false);
        return searchContext;
    }

    protected List<CPOptionCategory> getCPOptionCategories(Hits hits) throws PortalException {
        List documents = hits.toList();
        ArrayList<CPOptionCategory> cpOptionCategories = new ArrayList<CPOptionCategory>(documents.size());
        for (Document document : documents) {
            long cpOptionCategoryId = GetterUtil.getLong((String)document.get("entryClassPK"));
            CPOptionCategory cpOptionCategory = this.fetchCPOptionCategory(cpOptionCategoryId);
            if (cpOptionCategory == null) {
                Indexer indexer = IndexerRegistryUtil.getIndexer(CPOptionCategory.class);
                long companyId = GetterUtil.getLong((String)document.get("companyId"));
                indexer.delete(companyId, document.getUID());
                continue;
            }
            if (cpOptionCategory == null) continue;
            cpOptionCategories.add(cpOptionCategory);
        }
        return cpOptionCategories;
    }

    protected BaseModelSearchResult<CPOptionCategory> searchCPOptionCategories(SearchContext searchContext) throws PortalException {
        Indexer indexer = IndexerRegistryUtil.nullSafeGetIndexer(CPOptionCategory.class);
        int i = 0;
        if (i < 10) {
            Hits hits = indexer.search(searchContext, _SELECTED_FIELD_NAMES);
            return new BaseModelSearchResult(this.getCPOptionCategories(hits), hits.getLength());
        }
        throw new SearchException("Unable to fix the search index after 10 attempts");
    }

    protected void validate(long cpOptionCategoryId, long companyId, String key) throws PortalException {
        CPOptionCategory cpOptionCategory = this.cpOptionCategoryPersistence.fetchByC_K(companyId, key);
        if (cpOptionCategory != null && cpOptionCategory.getCPOptionCategoryId() != cpOptionCategoryId) {
            throw new CPOptionCategoryKeyException();
        }
    }
}

