/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.product.service.impl;

import com.liferay.commerce.product.configuration.CPOptionConfiguration;
import com.liferay.commerce.product.constants.CPConstants;
import com.liferay.commerce.product.exception.CPOptionKeyException;
import com.liferay.commerce.product.exception.CPOptionSKUContributorException;
import com.liferay.commerce.product.model.CPOption;
import com.liferay.commerce.product.service.base.CPOptionLocalServiceBaseImpl;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.AuditedModel;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.module.configuration.ConfigurationException;
import com.liferay.portal.kernel.module.configuration.ConfigurationProvider;
import com.liferay.portal.kernel.search.BaseModelSearchResult;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.Hits;
import com.liferay.portal.kernel.search.Indexable;
import com.liferay.portal.kernel.search.IndexableType;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerRegistryUtil;
import com.liferay.portal.kernel.search.QueryConfig;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.SearchException;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.settings.SettingsLocator;
import com.liferay.portal.kernel.settings.SystemSettingsLocator;
import com.liferay.portal.kernel.systemevent.SystemEvent;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.FriendlyURLNormalizerUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.LinkedHashMapBuilder;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.spring.extender.service.ServiceReference;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class CPOptionLocalServiceImpl
extends CPOptionLocalServiceBaseImpl {
    private static final String[] _SELECTED_FIELD_NAMES = new String[]{"entryClassPK", "companyId", "uid"};
    @ServiceReference(type=ConfigurationProvider.class)
    private ConfigurationProvider _configurationProvider;

    @Indexable(type=IndexableType.REINDEX)
    public CPOption addCPOption(String externalReferenceCode, long userId, Map<Locale, String> nameMap, Map<Locale, String> descriptionMap, String ddmFormFieldTypeName, boolean facetable, boolean required, boolean skuContributor, String key, ServiceContext serviceContext) throws PortalException {
        this.validateDDMFormFieldTypeName(ddmFormFieldTypeName, skuContributor);
        User user = this.userLocalService.getUser(userId);
        if (Validator.isBlank((String)externalReferenceCode)) {
            externalReferenceCode = null;
        }
        key = FriendlyURLNormalizerUtil.normalize((String)key);
        this.validateCPOptionKey(0L, user.getCompanyId(), key);
        long cpOptionId = this.counterLocalService.increment();
        CPOption cpOption = this.cpOptionPersistence.create(cpOptionId);
        cpOption.setExternalReferenceCode(externalReferenceCode);
        cpOption.setCompanyId(user.getCompanyId());
        cpOption.setUserId(user.getUserId());
        cpOption.setUserName(user.getFullName());
        cpOption.setNameMap(nameMap);
        cpOption.setDescriptionMap(descriptionMap);
        cpOption.setDDMFormFieldTypeName(ddmFormFieldTypeName);
        cpOption.setFacetable(facetable);
        cpOption.setRequired(required);
        cpOption.setSkuContributor(skuContributor);
        cpOption.setKey(key);
        cpOption.setExpandoBridgeAttributes(serviceContext);
        cpOption = (CPOption)this.cpOptionPersistence.update((BaseModel)cpOption);
        this.resourceLocalService.addModelResources((AuditedModel)cpOption, serviceContext);
        return cpOption;
    }

    public CPOption addOrUpdateCPOption(String externalReferenceCode, long userId, Map<Locale, String> nameMap, Map<Locale, String> descriptionMap, String ddmFormFieldTypeName, boolean facetable, boolean required, boolean skuContributor, String key, ServiceContext serviceContext) throws PortalException {
        if (Validator.isBlank((String)externalReferenceCode)) {
            externalReferenceCode = null;
        } else {
            CPOption cpOption = this.cpOptionPersistence.fetchByC_ERC(serviceContext.getCompanyId(), externalReferenceCode);
            if (cpOption != null) {
                return this.updateCPOption(cpOption.getCPOptionId(), nameMap, descriptionMap, ddmFormFieldTypeName, facetable, required, skuContributor, key, serviceContext);
            }
        }
        return this.addCPOption(externalReferenceCode, userId, nameMap, descriptionMap, ddmFormFieldTypeName, facetable, required, skuContributor, key, serviceContext);
    }

    @Override
    @Indexable(type=IndexableType.DELETE)
    @SystemEvent(type=1)
    public CPOption deleteCPOption(CPOption cpOption) throws PortalException {
        this.cpOptionPersistence.remove((BaseModel)cpOption);
        this.cpOptionValueLocalService.deleteCPOptionValues(cpOption.getCPOptionId());
        this.resourceLocalService.deleteResource((AuditedModel)cpOption, 4);
        this.expandoRowLocalService.deleteRows(cpOption.getCPOptionId());
        return cpOption;
    }

    @Override
    public CPOption deleteCPOption(long cpOptionId) throws PortalException {
        CPOption cpOption = this.cpOptionPersistence.findByPrimaryKey(cpOptionId);
        return this.cpOptionLocalService.deleteCPOption(cpOption);
    }

    public void deleteCPOptions(long companyId) throws PortalException {
        List cpOptions = this.cpOptionPersistence.findByCompanyId(companyId);
        for (CPOption cpOption : cpOptions) {
            this.cpOptionLocalService.deleteCPOption(cpOption);
        }
    }

    public CPOption fetchByExternalReferenceCode(String externalReferenceCode, long companyId) {
        if (Validator.isBlank((String)externalReferenceCode)) {
            return null;
        }
        return this.cpOptionPersistence.fetchByC_ERC(companyId, externalReferenceCode);
    }

    public CPOption fetchCPOption(long companyId, String key) throws PortalException {
        return this.cpOptionPersistence.fetchByC_K(companyId, key);
    }

    public List<CPOption> findCPOptionByCompanyId(long companyId, int start, int end, OrderByComparator<CPOption> orderByComparator) {
        return this.cpOptionPersistence.filterFindByCompanyId(companyId, start, end, orderByComparator);
    }

    public CPOption getCPOption(long companyId, String key) throws PortalException {
        return this.cpOptionPersistence.findByC_K(companyId, key);
    }

    public int getCPOptionsCount(long companyId) {
        return this.cpOptionPersistence.countByCompanyId(companyId);
    }

    public BaseModelSearchResult<CPOption> searchCPOptions(long companyId, String keywords, int start, int end, Sort sort) throws PortalException {
        SearchContext searchContext = this.buildSearchContext(companyId, keywords, start, end, sort);
        return this.searchCPOptions(searchContext);
    }

    @Indexable(type=IndexableType.REINDEX)
    public CPOption updateCPOption(long cpOptionId, Map<Locale, String> nameMap, Map<Locale, String> descriptionMap, String ddmFormFieldTypeName, boolean facetable, boolean required, boolean skuContributor, String key, ServiceContext serviceContext) throws PortalException {
        this.validateDDMFormFieldTypeName(ddmFormFieldTypeName, skuContributor);
        CPOption cpOption = this.cpOptionPersistence.findByPrimaryKey(cpOptionId);
        key = FriendlyURLNormalizerUtil.normalize((String)key);
        this.validateCPOptionKey(cpOption.getCPOptionId(), cpOption.getCompanyId(), key);
        cpOption.setNameMap(nameMap);
        cpOption.setDescriptionMap(descriptionMap);
        cpOption.setDDMFormFieldTypeName(ddmFormFieldTypeName);
        cpOption.setFacetable(facetable);
        cpOption.setRequired(required);
        cpOption.setSkuContributor(skuContributor);
        cpOption.setKey(key);
        cpOption.setExpandoBridgeAttributes(serviceContext);
        return (CPOption)this.cpOptionPersistence.update((BaseModel)cpOption);
    }

    @Indexable(type=IndexableType.REINDEX)
    public CPOption updateCPOptionExternalReferenceCode(String externalReferenceCode, long cpOptionId) throws PortalException {
        CPOption cpOption = this.cpOptionLocalService.getCPOption(cpOptionId);
        cpOption.setExternalReferenceCode(externalReferenceCode);
        return (CPOption)this.cpOptionPersistence.update((BaseModel)cpOption);
    }

    protected SearchContext buildSearchContext(long companyId, String keywords, int start, int end, Sort sort) {
        SearchContext searchContext = new SearchContext();
        searchContext.setAttributes((Map)HashMapBuilder.put((Object)"key", (Object)keywords).put((Object)"content", (Object)keywords).put((Object)"description", (Object)keywords).put((Object)"entryClassPK", (Object)keywords).put((Object)"name", (Object)keywords).put((Object)"params", (Object)LinkedHashMapBuilder.put((Object)"keywords", (Object)keywords).build()).build());
        searchContext.setCompanyId(companyId);
        searchContext.setEnd(end);
        if (Validator.isNotNull((String)keywords)) {
            searchContext.setKeywords(keywords);
        }
        if (sort != null) {
            searchContext.setSorts(new Sort[]{sort});
        }
        searchContext.setStart(start);
        QueryConfig queryConfig = searchContext.getQueryConfig();
        queryConfig.setHighlightEnabled(false);
        queryConfig.setScoreEnabled(false);
        return searchContext;
    }

    protected List<CPOption> getCPOptions(Hits hits) throws PortalException {
        List documents = hits.toList();
        ArrayList<CPOption> cpOptions = new ArrayList<CPOption>(documents.size());
        for (Document document : documents) {
            long cpOptionId = GetterUtil.getLong((String)document.get("entryClassPK"));
            CPOption cpOption = this.fetchCPOption(cpOptionId);
            if (cpOption == null) {
                cpOptions = null;
                Indexer indexer = IndexerRegistryUtil.getIndexer(CPOption.class);
                long companyId = GetterUtil.getLong((String)document.get("companyId"));
                indexer.delete(companyId, document.getUID());
                continue;
            }
            if (cpOptions == null) continue;
            cpOptions.add(cpOption);
        }
        return cpOptions;
    }

    protected BaseModelSearchResult<CPOption> searchCPOptions(SearchContext searchContext) throws PortalException {
        Indexer indexer = IndexerRegistryUtil.nullSafeGetIndexer(CPOption.class);
        for (int i = 0; i < 10; ++i) {
            Hits hits = indexer.search(searchContext, _SELECTED_FIELD_NAMES);
            List<CPOption> cpOptions = this.getCPOptions(hits);
            if (cpOptions == null) continue;
            return new BaseModelSearchResult(cpOptions, hits.getLength());
        }
        throw new SearchException("Unable to fix the search index after 10 attempts");
    }

    protected void validateCPOptionKey(long cpOptionId, long companyId, String key) throws PortalException {
        CPOption cpOption = this.cpOptionPersistence.fetchByC_K(companyId, key);
        if (cpOption != null && cpOption.getCPOptionId() != cpOptionId) {
            throw new CPOptionKeyException();
        }
    }

    protected void validateDDMFormFieldTypeName(String ddmFormFieldTypeName, boolean skuContributor) throws PortalException {
        if (Validator.isNull((String)ddmFormFieldTypeName)) {
            throw new CPOptionSKUContributorException();
        }
        CPOptionConfiguration cpOptionConfiguration = this._getCPOptionConfiguration();
        Object[] ddmFormFieldTypesAllowed = cpOptionConfiguration.ddmFormFieldTypesAllowed();
        if (skuContributor) {
            ddmFormFieldTypesAllowed = CPConstants.PRODUCT_OPTION_SKU_CONTRIBUTOR_FIELD_TYPES;
        }
        if (ArrayUtil.contains((Object[])ddmFormFieldTypesAllowed, (Object)ddmFormFieldTypeName)) {
            return;
        }
        throw new CPOptionSKUContributorException();
    }

    private CPOptionConfiguration _getCPOptionConfiguration() throws ConfigurationException {
        return (CPOptionConfiguration)this._configurationProvider.getConfiguration(CPOptionConfiguration.class, (SettingsLocator)new SystemSettingsLocator("com.liferay.commerce.product.option"));
    }
}

