/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.product.service.impl;

import com.liferay.commerce.product.exception.CPOptionValueKeyException;
import com.liferay.commerce.product.model.CPOption;
import com.liferay.commerce.product.model.CPOptionValue;
import com.liferay.commerce.product.service.base.CPOptionValueLocalServiceBaseImpl;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.search.BaseModelSearchResult;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.Hits;
import com.liferay.portal.kernel.search.Indexable;
import com.liferay.portal.kernel.search.IndexableType;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerRegistryUtil;
import com.liferay.portal.kernel.search.QueryConfig;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.SearchException;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.systemevent.SystemEvent;
import com.liferay.portal.kernel.util.FriendlyURLNormalizerUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.LinkedHashMapBuilder;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.Validator;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class CPOptionValueLocalServiceImpl
extends CPOptionValueLocalServiceBaseImpl {
    private static final String _FIELD_KEY = "key";
    private static final String[] _SELECTED_FIELD_NAMES = new String[]{"entryClassPK", "companyId", "groupId", "uid"};

    @Indexable(type=IndexableType.REINDEX)
    public CPOptionValue addCPOptionValue(long cpOptionId, Map<Locale, String> nameMap, double priority, String key, ServiceContext serviceContext) throws PortalException {
        return this.cpOptionValueLocalService.addCPOptionValue("", cpOptionId, nameMap, priority, key, serviceContext);
    }

    @Indexable(type=IndexableType.REINDEX)
    public CPOptionValue addCPOptionValue(String externalReferenceCode, long cpOptionId, Map<Locale, String> nameMap, double priority, String key, ServiceContext serviceContext) throws PortalException {
        User user = this.userLocalService.getUser(serviceContext.getUserId());
        if (Validator.isBlank((String)externalReferenceCode)) {
            externalReferenceCode = null;
        }
        key = FriendlyURLNormalizerUtil.normalize((String)key);
        this.validate(0L, cpOptionId, key);
        long cpOptionValueId = this.counterLocalService.increment();
        CPOptionValue cpOptionValue = this.cpOptionValuePersistence.create(cpOptionValueId);
        cpOptionValue.setExternalReferenceCode(externalReferenceCode);
        cpOptionValue.setCompanyId(user.getCompanyId());
        cpOptionValue.setUserId(user.getUserId());
        cpOptionValue.setUserName(user.getFullName());
        cpOptionValue.setCPOptionId(cpOptionId);
        cpOptionValue.setNameMap(nameMap);
        cpOptionValue.setPriority(priority);
        cpOptionValue.setKey(key);
        cpOptionValue.setExpandoBridgeAttributes(serviceContext);
        cpOptionValue = (CPOptionValue)this.cpOptionValuePersistence.update((BaseModel)cpOptionValue);
        this.reindexCPOption(cpOptionId);
        return cpOptionValue;
    }

    public CPOptionValue addOrUpdateCPOptionValue(String externalReferenceCode, long cpOptionId, Map<Locale, String> nameMap, double priority, String key, ServiceContext serviceContext) throws PortalException {
        if (Validator.isBlank((String)externalReferenceCode)) {
            externalReferenceCode = null;
        } else {
            CPOptionValue cpOptionValue = this.cpOptionValuePersistence.fetchByC_ERC(serviceContext.getCompanyId(), externalReferenceCode);
            if (cpOptionValue != null) {
                return this.cpOptionValueLocalService.updateCPOptionValue(cpOptionValue.getCPOptionValueId(), nameMap, priority, key, serviceContext);
            }
        }
        return this.cpOptionValueLocalService.addCPOptionValue(externalReferenceCode, cpOptionId, nameMap, priority, key, serviceContext);
    }

    @Override
    @Indexable(type=IndexableType.DELETE)
    @SystemEvent(type=1)
    public CPOptionValue deleteCPOptionValue(CPOptionValue cpOptionValue) throws PortalException {
        this.cpOptionValuePersistence.remove((BaseModel)cpOptionValue);
        this.expandoRowLocalService.deleteRows(cpOptionValue.getCPOptionValueId());
        this.reindexCPOption(cpOptionValue.getCPOptionId());
        return cpOptionValue;
    }

    @Override
    public CPOptionValue deleteCPOptionValue(long cpOptionValueId) throws PortalException {
        CPOptionValue cpOptionValue = this.cpOptionValuePersistence.findByPrimaryKey(cpOptionValueId);
        return this.cpOptionValueLocalService.deleteCPOptionValue(cpOptionValue);
    }

    public void deleteCPOptionValues(long cpOptionId) throws PortalException {
        List cpOptionValues = this.cpOptionValueLocalService.getCPOptionValues(cpOptionId, -1, -1);
        for (CPOptionValue cpOptionValue : cpOptionValues) {
            this.cpOptionValueLocalService.deleteCPOptionValue(cpOptionValue);
        }
    }

    public CPOptionValue fetchByExternalReferenceCode(String externalReferenceCode, long companyId) {
        if (Validator.isBlank((String)externalReferenceCode)) {
            return null;
        }
        return this.cpOptionValuePersistence.fetchByC_ERC(companyId, externalReferenceCode);
    }

    public CPOptionValue getCPOptionValue(long cpOptionId, String key) throws PortalException {
        return this.cpOptionValuePersistence.findByC_K(cpOptionId, key);
    }

    public List<CPOptionValue> getCPOptionValues(long cpOptionId, int start, int end) {
        return this.cpOptionValuePersistence.findByCPOptionId(cpOptionId, start, end);
    }

    public List<CPOptionValue> getCPOptionValues(long cpOptionId, int start, int end, OrderByComparator<CPOptionValue> orderByComparator) {
        return this.cpOptionValuePersistence.findByCPOptionId(cpOptionId, start, end, orderByComparator);
    }

    public int getCPOptionValuesCount(long cpOptionId) {
        return this.cpOptionValuePersistence.countByCPOptionId(cpOptionId);
    }

    public Hits search(SearchContext searchContext) {
        try {
            Indexer indexer = IndexerRegistryUtil.nullSafeGetIndexer(CPOptionValue.class);
            return indexer.search(searchContext);
        }
        catch (Exception exception) {
            throw new SystemException((Throwable)exception);
        }
    }

    @Deprecated
    public BaseModelSearchResult<CPOptionValue> searchCPOptionValues(long companyId, long groupId, long cpOptionId, String keywords, int start, int end, Sort sort) throws PortalException {
        return this.cpOptionValueLocalService.searchCPOptionValues(companyId, cpOptionId, keywords, start, end, new Sort[]{sort});
    }

    public BaseModelSearchResult<CPOptionValue> searchCPOptionValues(long companyId, long cpOptionId, String keywords, int start, int end, Sort[] sorts) throws PortalException {
        SearchContext searchContext = this.buildSearchContext(companyId, cpOptionId, keywords, start, end, sorts);
        return this.searchCPOptionValues(searchContext);
    }

    public int searchCPOptionValuesCount(long companyId, long cpOptionId, String keywords) throws PortalException {
        SearchContext searchContext = this.buildSearchContext(companyId, cpOptionId, keywords, -1, -1, null);
        return this.searchCPOptionValuesCount(searchContext);
    }

    @Indexable(type=IndexableType.REINDEX)
    public CPOptionValue updateCPOptionValue(long cpOptionValueId, Map<Locale, String> nameMap, double priority, String key, ServiceContext serviceContext) throws PortalException {
        CPOptionValue cpOptionValue = this.cpOptionValuePersistence.findByPrimaryKey(cpOptionValueId);
        key = FriendlyURLNormalizerUtil.normalize((String)key);
        this.validate(cpOptionValue.getCPOptionValueId(), cpOptionValue.getCPOptionId(), key);
        cpOptionValue.setNameMap(nameMap);
        cpOptionValue.setPriority(priority);
        cpOptionValue.setKey(key);
        cpOptionValue.setExpandoBridgeAttributes(serviceContext);
        cpOptionValue = (CPOptionValue)this.cpOptionValuePersistence.update((BaseModel)cpOptionValue);
        this.reindexCPOption(cpOptionValue.getCPOptionId());
        return cpOptionValue;
    }

    protected SearchContext buildSearchContext(long companyId, long cpOptionId, String keywords, int start, int end, Sort[] sorts) {
        SearchContext searchContext = new SearchContext();
        searchContext.setAttributes((Map)HashMapBuilder.put((Object)_FIELD_KEY, (Object)keywords).put((Object)"content", (Object)keywords).put((Object)"entryClassPK", (Object)keywords).put((Object)"name", (Object)keywords).put((Object)"CPOptionId", (Object)cpOptionId).put((Object)"params", (Object)LinkedHashMapBuilder.put((Object)"keywords", (Object)keywords).build()).build());
        searchContext.setCompanyId(companyId);
        searchContext.setEnd(end);
        if (Validator.isNotNull((String)keywords)) {
            searchContext.setKeywords(keywords);
        }
        if (sorts != null) {
            searchContext.setSorts(sorts);
        }
        searchContext.setStart(start);
        QueryConfig queryConfig = searchContext.getQueryConfig();
        queryConfig.setHighlightEnabled(false);
        queryConfig.setScoreEnabled(false);
        return searchContext;
    }

    protected List<CPOptionValue> getCPOptionValues(Hits hits) throws PortalException {
        List documents = hits.toList();
        ArrayList<CPOptionValue> cpOptionValues = new ArrayList<CPOptionValue>(documents.size());
        for (Document document : documents) {
            long cpOptionValueId = GetterUtil.getLong((String)document.get("entryClassPK"));
            CPOptionValue cpOptionValue = this.fetchCPOptionValue(cpOptionValueId);
            if (cpOptionValue == null) {
                cpOptionValues = null;
                Indexer indexer = IndexerRegistryUtil.getIndexer(CPOptionValue.class);
                long companyId = GetterUtil.getLong((String)document.get("companyId"));
                indexer.delete(companyId, document.getUID());
                continue;
            }
            if (cpOptionValues == null) continue;
            cpOptionValues.add(cpOptionValue);
        }
        return cpOptionValues;
    }

    protected void reindexCPOption(long cpOptionId) throws PortalException {
        Indexer indexer = IndexerRegistryUtil.nullSafeGetIndexer(CPOption.class);
        indexer.reindex(CPOption.class.getName(), cpOptionId);
    }

    protected BaseModelSearchResult<CPOptionValue> searchCPOptionValues(SearchContext searchContext) throws PortalException {
        Indexer indexer = IndexerRegistryUtil.nullSafeGetIndexer(CPOptionValue.class);
        for (int i = 0; i < 10; ++i) {
            Hits hits = indexer.search(searchContext, _SELECTED_FIELD_NAMES);
            List<CPOptionValue> cpOptionValues = this.getCPOptionValues(hits);
            if (cpOptionValues == null) continue;
            return new BaseModelSearchResult(cpOptionValues, hits.getLength());
        }
        throw new SearchException("Unable to fix the search index after 10 attempts");
    }

    protected int searchCPOptionValuesCount(SearchContext searchContext) throws PortalException {
        Indexer indexer = IndexerRegistryUtil.nullSafeGetIndexer(CPOptionValue.class);
        return GetterUtil.getInteger((Object)indexer.searchCount(searchContext));
    }

    protected void validate(long cpOptionValueId, long cpOptionId, String key) throws PortalException {
        CPOptionValue cpOptionValue = this.cpOptionValuePersistence.fetchByC_K(cpOptionId, key);
        if (cpOptionValue != null && cpOptionValue.getCPOptionValueId() != cpOptionValueId) {
            throw new CPOptionValueKeyException();
        }
    }
}

