/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.product.service.impl;

import com.liferay.commerce.product.model.CPOption;
import com.liferay.commerce.product.model.CPOptionValue;
import com.liferay.commerce.product.service.base.CPOptionValueServiceBaseImpl;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.search.BaseModelSearchResult;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermissionFactory;
import com.liferay.portal.kernel.service.ServiceContext;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class CPOptionValueServiceImpl
extends CPOptionValueServiceBaseImpl {
    private static volatile ModelResourcePermission<CPOption> _cpOptionModelResourcePermission = ModelResourcePermissionFactory.getInstance(CPOptionValueServiceImpl.class, (String)"_cpOptionModelResourcePermission", CPOption.class);

    public CPOptionValue addCPOptionValue(long cpOptionId, Map<Locale, String> titleMap, double priority, String key, ServiceContext serviceContext) throws PortalException {
        _cpOptionModelResourcePermission.check(this.getPermissionChecker(), cpOptionId, "UPDATE");
        return this.cpOptionValueLocalService.addCPOptionValue(cpOptionId, titleMap, priority, key, serviceContext);
    }

    public CPOptionValue addOrUpdateCPOptionValue(String externalReferenceCode, long cpOptionId, Map<Locale, String> nameMap, double priority, String key, ServiceContext serviceContext) throws PortalException {
        CPOptionValue cpOptionValue = this.cpOptionValueLocalService.fetchByExternalReferenceCode(externalReferenceCode, serviceContext.getCompanyId());
        if (cpOptionValue == null) {
            _cpOptionModelResourcePermission.check(this.getPermissionChecker(), cpOptionId, "UPDATE");
        }
        return this.cpOptionValueLocalService.addOrUpdateCPOptionValue(externalReferenceCode, cpOptionId, nameMap, priority, key, serviceContext);
    }

    public void deleteCPOptionValue(long cpOptionValueId) throws PortalException {
        CPOptionValue cpOptionValue = this.cpOptionValueLocalService.fetchCPOptionValue(cpOptionValueId);
        _cpOptionModelResourcePermission.check(this.getPermissionChecker(), cpOptionValue.getCPOptionId(), "UPDATE");
        this.cpOptionValueLocalService.deleteCPOptionValue(cpOptionValue);
    }

    public CPOptionValue fetchByExternalReferenceCode(String externalReferenceCode, long companyId) throws PortalException {
        CPOptionValue cpOptionValue = this.cpOptionValueLocalService.fetchByExternalReferenceCode(externalReferenceCode, companyId);
        if (cpOptionValue != null) {
            _cpOptionModelResourcePermission.check(this.getPermissionChecker(), cpOptionValue.getCPOptionId(), "VIEW");
        }
        return cpOptionValue;
    }

    public CPOptionValue fetchCPOptionValue(long cpOptionValueId) throws PortalException {
        CPOptionValue cpOptionValue = this.cpOptionValueLocalService.fetchCPOptionValue(cpOptionValueId);
        if (cpOptionValue != null) {
            _cpOptionModelResourcePermission.check(this.getPermissionChecker(), cpOptionValue.getCPOptionId(), "VIEW");
        }
        return cpOptionValue;
    }

    public CPOptionValue getCPOptionValue(long cpOptionValueId) throws PortalException {
        CPOptionValue cpOptionValue = this.cpOptionValueLocalService.getCPOptionValue(cpOptionValueId);
        _cpOptionModelResourcePermission.check(this.getPermissionChecker(), cpOptionValue.getCPOptionId(), "VIEW");
        return cpOptionValue;
    }

    public List<CPOptionValue> getCPOptionValues(long cpOptionId, int start, int end) throws PortalException {
        _cpOptionModelResourcePermission.check(this.getPermissionChecker(), cpOptionId, "VIEW");
        return this.cpOptionValueLocalService.getCPOptionValues(cpOptionId, start, end);
    }

    public int getCPOptionValuesCount(long cpOptionId) throws PortalException {
        _cpOptionModelResourcePermission.check(this.getPermissionChecker(), cpOptionId, "VIEW");
        return this.cpOptionValueLocalService.getCPOptionValuesCount(cpOptionId);
    }

    public BaseModelSearchResult<CPOptionValue> searchCPOptionValues(long companyId, long cpOptionId, String keywords, int start, int end, Sort[] sorts) throws PortalException {
        _cpOptionModelResourcePermission.check(this.getPermissionChecker(), cpOptionId, "VIEW");
        return this.cpOptionValueLocalService.searchCPOptionValues(companyId, cpOptionId, keywords, start, end, sorts);
    }

    public int searchCPOptionValuesCount(long companyId, long cpOptionId, String keywords) throws PortalException {
        _cpOptionModelResourcePermission.check(this.getPermissionChecker(), cpOptionId, "VIEW");
        return this.cpOptionValueLocalService.searchCPOptionValuesCount(companyId, cpOptionId, keywords);
    }

    public CPOptionValue updateCPOptionValue(long cpOptionValueId, Map<Locale, String> titleMap, double priority, String key, ServiceContext serviceContext) throws PortalException {
        CPOptionValue cpOptionValue = this.cpOptionValueService.getCPOptionValue(cpOptionValueId);
        _cpOptionModelResourcePermission.check(this.getPermissionChecker(), cpOptionValue.getCPOptionId(), "VIEW");
        return this.cpOptionValueLocalService.updateCPOptionValue(cpOptionValue.getCPOptionValueId(), titleMap, priority, key, serviceContext);
    }
}

