/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.product.service.impl;

import com.liferay.commerce.product.exception.CPSpecificationOptionKeyException;
import com.liferay.commerce.product.exception.CPSpecificationOptionTitleException;
import com.liferay.commerce.product.exception.DuplicateCPSpecificationOptionKeyException;
import com.liferay.commerce.product.model.CPDefinition;
import com.liferay.commerce.product.model.CPSpecificationOption;
import com.liferay.commerce.product.service.base.CPSpecificationOptionLocalServiceBaseImpl;
import com.liferay.portal.kernel.dao.orm.IndexableActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.RestrictionsFactoryUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.AuditedModel;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.search.BaseModelSearchResult;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.Hits;
import com.liferay.portal.kernel.search.Indexable;
import com.liferay.portal.kernel.search.IndexableType;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerRegistryUtil;
import com.liferay.portal.kernel.search.QueryConfig;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.SearchException;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.systemevent.SystemEvent;
import com.liferay.portal.kernel.transaction.TransactionCommitCallbackUtil;
import com.liferay.portal.kernel.util.FriendlyURLNormalizerUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.LinkedHashMapBuilder;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Callable;

public class CPSpecificationOptionLocalServiceImpl
extends CPSpecificationOptionLocalServiceBaseImpl {
    private static final String[] _SELECTED_FIELD_NAMES = new String[]{"entryClassPK", "companyId", "uid"};
    private static final Log _log = LogFactoryUtil.getLog(CPSpecificationOptionLocalServiceImpl.class);

    @Indexable(type=IndexableType.REINDEX)
    public CPSpecificationOption addCPSpecificationOption(long userId, long cpOptionCategoryId, Map<Locale, String> titleMap, Map<Locale, String> descriptionMap, boolean facetable, String key, ServiceContext serviceContext) throws PortalException {
        User user = this.userLocalService.getUser(userId);
        key = FriendlyURLNormalizerUtil.normalize((String)key);
        this.validate(0L, user.getCompanyId(), titleMap, key);
        long cpSpecificationOptionId = this.counterLocalService.increment();
        CPSpecificationOption cpSpecificationOption = this.cpSpecificationOptionPersistence.create(cpSpecificationOptionId);
        cpSpecificationOption.setCompanyId(user.getCompanyId());
        cpSpecificationOption.setUserId(user.getUserId());
        cpSpecificationOption.setUserName(user.getFullName());
        cpSpecificationOption.setCPOptionCategoryId(cpOptionCategoryId);
        cpSpecificationOption.setTitleMap(titleMap);
        cpSpecificationOption.setDescriptionMap(descriptionMap);
        cpSpecificationOption.setFacetable(facetable);
        cpSpecificationOption.setKey(key);
        cpSpecificationOption.setExpandoBridgeAttributes(serviceContext);
        cpSpecificationOption = (CPSpecificationOption)this.cpSpecificationOptionPersistence.update((BaseModel)cpSpecificationOption);
        this.resourceLocalService.addModelResources((AuditedModel)cpSpecificationOption, serviceContext);
        return cpSpecificationOption;
    }

    @Override
    @Indexable(type=IndexableType.DELETE)
    @SystemEvent(type=1)
    public CPSpecificationOption deleteCPSpecificationOption(CPSpecificationOption cpSpecificationOption) throws PortalException {
        this.cpSpecificationOptionPersistence.remove((BaseModel)cpSpecificationOption);
        this.cpDefinitionSpecificationOptionValueLocalService.deleteCPSpecificationOptionDefinitionValues(cpSpecificationOption.getCPSpecificationOptionId());
        this.resourceLocalService.deleteResource((AuditedModel)cpSpecificationOption, 4);
        this.expandoRowLocalService.deleteRows(cpSpecificationOption.getCPSpecificationOptionId());
        return cpSpecificationOption;
    }

    @Override
    public CPSpecificationOption deleteCPSpecificationOption(long cpSpecificationOptionId) throws PortalException {
        CPSpecificationOption cpSpecificationOption = this.cpSpecificationOptionPersistence.findByPrimaryKey(cpSpecificationOptionId);
        return this.cpSpecificationOptionLocalService.deleteCPSpecificationOption(cpSpecificationOption);
    }

    public void deleteCPSpecificationOptions(long companyId) throws PortalException {
        List cpSpecificationOptions = this.cpSpecificationOptionPersistence.findByCompanyId(companyId);
        for (CPSpecificationOption cpSpecificationOption : cpSpecificationOptions) {
            this.cpSpecificationOptionLocalService.deleteCPSpecificationOption(cpSpecificationOption);
        }
    }

    public CPSpecificationOption fetchCPSpecificationOption(long companyId, String key) {
        return this.cpSpecificationOptionPersistence.fetchByC_K(companyId, key);
    }

    public CPSpecificationOption getCPSpecificationOption(long companyId, String key) throws PortalException {
        return this.cpSpecificationOptionPersistence.findByC_K(companyId, key);
    }

    public BaseModelSearchResult<CPSpecificationOption> searchCPSpecificationOptions(long companyId, Boolean facetable, String keywords, int start, int end, Sort sort) throws PortalException {
        SearchContext searchContext = this.buildSearchContext(companyId, facetable, keywords, start, end, sort);
        return this.searchCPSpecificationOptions(searchContext);
    }

    public CPSpecificationOption updateCPOptionCategoryId(long cpSpecificationOptionId, long cpOptionCategoryId) throws PortalException {
        CPSpecificationOption cpSpecificationOption = this.cpSpecificationOptionPersistence.findByPrimaryKey(cpSpecificationOptionId);
        cpSpecificationOption.setCPOptionCategoryId(cpOptionCategoryId);
        return (CPSpecificationOption)this.cpSpecificationOptionPersistence.update((BaseModel)cpSpecificationOption);
    }

    @Indexable(type=IndexableType.REINDEX)
    public CPSpecificationOption updateCPSpecificationOption(long cpSpecificationOptionId, long cpOptionCategoryId, Map<Locale, String> titleMap, Map<Locale, String> descriptionMap, boolean facetable, String key, ServiceContext serviceContext) throws PortalException {
        CPSpecificationOption cpSpecificationOption = this.cpSpecificationOptionPersistence.findByPrimaryKey(cpSpecificationOptionId);
        key = FriendlyURLNormalizerUtil.normalize((String)key);
        this.validate(cpSpecificationOption.getCPSpecificationOptionId(), cpSpecificationOption.getCompanyId(), titleMap, key);
        cpSpecificationOption.setCPOptionCategoryId(cpOptionCategoryId);
        cpSpecificationOption.setTitleMap(titleMap);
        cpSpecificationOption.setDescriptionMap(descriptionMap);
        cpSpecificationOption.setFacetable(facetable);
        cpSpecificationOption.setKey(key);
        cpSpecificationOption.setExpandoBridgeAttributes(serviceContext);
        cpSpecificationOption = (CPSpecificationOption)this.cpSpecificationOptionPersistence.update((BaseModel)cpSpecificationOption);
        this.reindexCPDefinitions(cpSpecificationOption.getCompanyId(), cpSpecificationOptionId);
        return cpSpecificationOption;
    }

    protected SearchContext buildSearchContext(long companyId, Boolean facetable, String keywords, int start, int end, Sort sort) {
        SearchContext searchContext = new SearchContext();
        LinkedHashMap params = LinkedHashMapBuilder.put((Object)"keywords", (Object)keywords).build();
        searchContext.setAttributes((Map)HashMapBuilder.put((Object)"cpOptionCategoryId", (Object)keywords).put((Object)"cpOptionCategoryTitle", (Object)keywords).put((Object)"facetable", () -> facetable).put((Object)"key", (Object)keywords).put((Object)"content", (Object)keywords).put((Object)"description", (Object)keywords).put((Object)"entryClassPK", (Object)keywords).put((Object)"title", (Object)keywords).put((Object)"params", (Object)params).build());
        searchContext.setCompanyId(companyId);
        searchContext.setEnd(end);
        if (Validator.isNotNull((String)keywords)) {
            searchContext.setKeywords(keywords);
        }
        if (sort != null) {
            searchContext.setSorts(new Sort[]{sort});
        }
        searchContext.setStart(start);
        QueryConfig queryConfig = searchContext.getQueryConfig();
        queryConfig.setHighlightEnabled(false);
        queryConfig.setScoreEnabled(false);
        return searchContext;
    }

    protected List<CPSpecificationOption> getCPSpecificationOptions(Hits hits) throws PortalException {
        List documents = hits.toList();
        ArrayList<CPSpecificationOption> cpSpecificationOptions = new ArrayList<CPSpecificationOption>(documents.size());
        for (Document document : documents) {
            long cpSpecificationOptionId = GetterUtil.getLong((String)document.get("entryClassPK"));
            CPSpecificationOption cpSpecificationOption = this.fetchCPSpecificationOption(cpSpecificationOptionId);
            if (cpSpecificationOption == null) {
                cpSpecificationOptions = null;
                Indexer indexer = IndexerRegistryUtil.getIndexer(CPSpecificationOption.class);
                long companyId = GetterUtil.getLong((String)document.get("companyId"));
                indexer.delete(companyId, document.getUID());
                continue;
            }
            if (cpSpecificationOptions == null) continue;
            cpSpecificationOptions.add(cpSpecificationOption);
        }
        return cpSpecificationOptions;
    }

    protected void reindexCPDefinitions(final long companyId, final long cpSpecificationOptionId) {
        TransactionCommitCallbackUtil.registerCallback((Callable)new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                CPSpecificationOptionLocalServiceImpl.this._reindexCPDefinitions(companyId, cpSpecificationOptionId);
                return null;
            }
        });
    }

    protected BaseModelSearchResult<CPSpecificationOption> searchCPSpecificationOptions(SearchContext searchContext) throws PortalException {
        Indexer indexer = IndexerRegistryUtil.nullSafeGetIndexer(CPSpecificationOption.class);
        for (int i = 0; i < 10; ++i) {
            Hits hits = indexer.search(searchContext, _SELECTED_FIELD_NAMES);
            List<CPSpecificationOption> cpSpecificationOptions = this.getCPSpecificationOptions(hits);
            if (cpSpecificationOptions == null) continue;
            return new BaseModelSearchResult(cpSpecificationOptions, hits.getLength());
        }
        throw new SearchException("Unable to fix the search index after 10 attempts");
    }

    protected void validate(long cpSpecificationOptionId, long companyId, Map<Locale, String> titleMap, String key) throws PortalException {
        Locale locale = LocaleUtil.getSiteDefault();
        String title = titleMap.get(locale);
        if (Validator.isNull((String)title)) {
            throw new CPSpecificationOptionTitleException();
        }
        if (Validator.isNull((String)key)) {
            throw new CPSpecificationOptionKeyException.MustNotBeNull();
        }
        CPSpecificationOption cpSpecificationOption = this.cpSpecificationOptionPersistence.fetchByC_K(companyId, key);
        if (cpSpecificationOption != null && cpSpecificationOption.getCPSpecificationOptionId() != cpSpecificationOptionId) {
            throw new DuplicateCPSpecificationOptionKeyException();
        }
    }

    private void _reindexCPDefinitions(long companyId, long cpSpecificationOptionId) throws Exception {
        Indexer indexer = IndexerRegistryUtil.nullSafeGetIndexer(CPDefinition.class);
        IndexableActionableDynamicQuery indexableActionableDynamicQuery = this.cpDefinitionSpecificationOptionValueLocalService.getIndexableActionableDynamicQuery();
        indexableActionableDynamicQuery.setCompanyId(companyId);
        indexableActionableDynamicQuery.setAddCriteriaMethod(dynamicQuery -> dynamicQuery.add(RestrictionsFactoryUtil.eq((String)"CPSpecificationOptionId", (Object)cpSpecificationOptionId)));
        indexableActionableDynamicQuery.setPerformActionMethod(cpDefinitionSpecificationOptionValue -> {
            block2: {
                try {
                    indexableActionableDynamicQuery.addDocuments(new Document[]{indexer.getDocument((Object)cpDefinitionSpecificationOptionValue.getCPDefinition())});
                }
                catch (PortalException portalException) {
                    if (!_log.isWarnEnabled()) break block2;
                    CPDefinition cpDefinition = cpDefinitionSpecificationOptionValue.getCPDefinition();
                    _log.warn((Object)("Unable to index commerce product definition " + cpDefinition), (Throwable)portalException);
                }
            }
        });
        indexableActionableDynamicQuery.setSearchEngineId(indexer.getSearchEngineId());
        indexableActionableDynamicQuery.performActions();
    }
}

