/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.product.service.impl;

import com.liferay.commerce.product.exception.CPTaxCategoryNameException;
import com.liferay.commerce.product.model.CPTaxCategory;
import com.liferay.commerce.product.service.base.CPTaxCategoryLocalServiceBaseImpl;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.systemevent.SystemEvent;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.Validator;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class CPTaxCategoryLocalServiceImpl
extends CPTaxCategoryLocalServiceBaseImpl {
    @Deprecated
    public CPTaxCategory addCPTaxCategory(Map<Locale, String> nameMap, Map<Locale, String> descriptionMap, ServiceContext serviceContext) throws PortalException {
        User user = this.userLocalService.getUser(serviceContext.getUserId());
        this.validate(nameMap);
        long cpTaxCategoryId = this.counterLocalService.increment();
        CPTaxCategory cpTaxCategory = this.cpTaxCategoryPersistence.create(cpTaxCategoryId);
        cpTaxCategory.setCompanyId(user.getCompanyId());
        cpTaxCategory.setUserId(user.getUserId());
        cpTaxCategory.setUserName(user.getFullName());
        cpTaxCategory.setNameMap(nameMap);
        cpTaxCategory.setDescriptionMap(descriptionMap);
        return (CPTaxCategory)this.cpTaxCategoryPersistence.update((BaseModel)cpTaxCategory);
    }

    public CPTaxCategory addCPTaxCategory(String externalReferenceCode, Map<Locale, String> nameMap, Map<Locale, String> descriptionMap, ServiceContext serviceContext) throws PortalException {
        User user = this.userLocalService.getUser(serviceContext.getUserId());
        this.validate(nameMap);
        long cpTaxCategoryId = this.counterLocalService.increment();
        CPTaxCategory cpTaxCategory = this.cpTaxCategoryPersistence.create(cpTaxCategoryId);
        cpTaxCategory.setExternalReferenceCode(externalReferenceCode);
        cpTaxCategory.setCompanyId(user.getCompanyId());
        cpTaxCategory.setUserId(user.getUserId());
        cpTaxCategory.setUserName(user.getFullName());
        cpTaxCategory.setNameMap(nameMap);
        cpTaxCategory.setDescriptionMap(descriptionMap);
        return (CPTaxCategory)this.cpTaxCategoryPersistence.update((BaseModel)cpTaxCategory);
    }

    public int countCPTaxCategoriesByCompanyId(long companyId, String keyword) {
        return this.cpTaxCategoryFinder.countCPTaxCategoriesByCompanyId(companyId, keyword);
    }

    public void deleteCPTaxCategories(long companyId) {
        this.cpTaxCategoryPersistence.removeByCompanyId(companyId);
    }

    @Override
    @SystemEvent(type=1)
    public CPTaxCategory deleteCPTaxCategory(CPTaxCategory cpTaxCategory) throws PortalException {
        cpTaxCategory = (CPTaxCategory)this.cpTaxCategoryPersistence.remove((BaseModel)cpTaxCategory);
        this.cpDefinitionLocalService.updateCPDefinitionsByCPTaxCategoryId(cpTaxCategory.getCPTaxCategoryId());
        return cpTaxCategory;
    }

    @Override
    public CPTaxCategory deleteCPTaxCategory(long cpTaxCategoryId) throws PortalException {
        CPTaxCategory cpTaxCategory = this.cpTaxCategoryPersistence.findByPrimaryKey(cpTaxCategoryId);
        return this.cpTaxCategoryLocalService.deleteCPTaxCategory(cpTaxCategory);
    }

    public List<CPTaxCategory> findCPTaxCategoriesByCompanyId(long companyId, String keyword, int start, int end) {
        return this.cpTaxCategoryFinder.findCPTaxCategoriesByCompanyId(companyId, keyword, start, end);
    }

    public List<CPTaxCategory> getCPTaxCategories(long companyId) {
        return this.cpTaxCategoryPersistence.findByCompanyId(companyId);
    }

    public List<CPTaxCategory> getCPTaxCategories(long companyId, int start, int end, OrderByComparator<CPTaxCategory> orderByComparator) {
        return this.cpTaxCategoryPersistence.findByCompanyId(companyId, start, end, orderByComparator);
    }

    public int getCPTaxCategoriesCount(long companyId) {
        return this.cpTaxCategoryPersistence.countByCompanyId(companyId);
    }

    @Deprecated
    public CPTaxCategory updateCPTaxCategory(long cpTaxCategoryId, Map<Locale, String> nameMap, Map<Locale, String> descriptionMap) throws PortalException {
        CPTaxCategory cpTaxCategory = this.cpTaxCategoryPersistence.findByPrimaryKey(cpTaxCategoryId);
        this.validate(nameMap);
        cpTaxCategory.setNameMap(nameMap);
        cpTaxCategory.setDescriptionMap(descriptionMap);
        return (CPTaxCategory)this.cpTaxCategoryPersistence.update((BaseModel)cpTaxCategory);
    }

    public CPTaxCategory updateCPTaxCategory(String externalReferenceCode, long cpTaxCategoryId, Map<Locale, String> nameMap, Map<Locale, String> descriptionMap) throws PortalException {
        CPTaxCategory cpTaxCategory = this.cpTaxCategoryPersistence.findByPrimaryKey(cpTaxCategoryId);
        this.validate(nameMap);
        cpTaxCategory.setExternalReferenceCode(externalReferenceCode);
        cpTaxCategory.setNameMap(nameMap);
        cpTaxCategory.setDescriptionMap(descriptionMap);
        return (CPTaxCategory)this.cpTaxCategoryPersistence.update((BaseModel)cpTaxCategory);
    }

    protected void validate(Map<Locale, String> nameMap) throws PortalException {
        Locale locale = LocaleUtil.getSiteDefault();
        String name = nameMap.get(locale);
        if (Validator.isNull((String)name)) {
            throw new CPTaxCategoryNameException();
        }
    }
}

