/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.product.service.impl;

import com.liferay.commerce.product.exception.DuplicateCProductException;
import com.liferay.commerce.product.model.CPDefinition;
import com.liferay.commerce.product.model.CPInstance;
import com.liferay.commerce.product.model.CProduct;
import com.liferay.commerce.product.service.base.CProductLocalServiceBaseImpl;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerRegistryUtil;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.systemevent.SystemEvent;
import com.liferay.portal.kernel.util.Validator;

public class CProductLocalServiceImpl
extends CProductLocalServiceBaseImpl {
    public CProduct addCProduct(String externalReferenceCode, long groupId, long userId, ServiceContext serviceContext) throws PortalException {
        User user = this.userLocalService.getUser(userId);
        if (Validator.isBlank((String)externalReferenceCode)) {
            externalReferenceCode = null;
        }
        this.validate(externalReferenceCode, user.getCompanyId());
        CProduct cProduct = this.cProductLocalService.createCProduct(this.counterLocalService.increment());
        cProduct.setExternalReferenceCode(externalReferenceCode);
        cProduct.setGroupId(groupId);
        cProduct.setCompanyId(user.getCompanyId());
        cProduct.setUserId(user.getUserId());
        cProduct.setUserName(user.getFullName());
        cProduct.setLatestVersion(1);
        return (CProduct)this.cProductPersistence.update((BaseModel)cProduct);
    }

    @Override
    @SystemEvent(type=1)
    public CProduct deleteCProduct(CProduct cProduct) throws PortalException {
        this.cpDefinitionLocalService.deleteCPDefinitions(cProduct.getCProductId(), -1);
        this.cpDefinitionLinkLocalService.deleteCPDefinitionLinksByCProductId(cProduct.getCProductId());
        this.cProductPersistence.remove((BaseModel)cProduct);
        return cProduct;
    }

    @Override
    public CProduct deleteCProduct(long cProductId) throws PortalException {
        CProduct cProduct = this.cProductPersistence.findByPrimaryKey(cProductId);
        return this.cProductLocalService.deleteCProduct(cProduct);
    }

    public CProduct getCProductByCPInstanceUuid(String cpInstanceUuid) throws PortalException {
        CPInstance cpInstance = this.cpInstancePersistence.fetchByCPInstanceUuid_First(cpInstanceUuid, null);
        CPDefinition cpDefinition = cpInstance.getCPDefinition();
        return cpDefinition.getCProduct();
    }

    public int increment(long cProductId) throws PortalException {
        CProduct cProduct = this.cProductLocalService.getCProduct(cProductId);
        cProduct.setLatestVersion(cProduct.getLatestVersion() + 1);
        cProduct = (CProduct)this.cProductPersistence.update((BaseModel)cProduct);
        return cProduct.getLatestVersion();
    }

    public CProduct updateCProductExternalReferenceCode(String externalReferenceCode, long cProductId) throws PortalException {
        CProduct cProduct = this.cProductLocalService.getCProduct(cProductId);
        if (externalReferenceCode.equals(cProduct.getExternalReferenceCode())) {
            return cProduct;
        }
        this.validate(externalReferenceCode, cProduct.getCompanyId());
        cProduct.setExternalReferenceCode(externalReferenceCode);
        cProduct = (CProduct)this.cProductPersistence.update((BaseModel)cProduct);
        this.reindexCPDefinition(cProduct.getPublishedCPDefinitionId());
        return cProduct;
    }

    public CProduct updatePublishedCPDefinitionId(long cProductId, long publishedCPDefinitionId) throws PortalException {
        CProduct cProduct = this.cProductLocalService.getCProduct(cProductId);
        long originalPublishedCPDefinitionId = cProduct.getPublishedCPDefinitionId();
        if (originalPublishedCPDefinitionId == publishedCPDefinitionId) {
            return cProduct;
        }
        cProduct.setPublishedCPDefinitionId(publishedCPDefinitionId);
        cProduct = (CProduct)this.cProductPersistence.update((BaseModel)cProduct);
        this.reindexCPDefinition(originalPublishedCPDefinitionId);
        this.reindexCPDefinition(publishedCPDefinitionId);
        return cProduct;
    }

    protected void reindexCPDefinition(long cpDefinitionId) throws PortalException {
        Indexer indexer = IndexerRegistryUtil.nullSafeGetIndexer(CPDefinition.class);
        indexer.reindex(CPDefinition.class.getName(), cpDefinitionId);
    }

    protected void validate(String externalReferenceCode, long companyId) throws PortalException {
        if (Validator.isNull((String)externalReferenceCode)) {
            return;
        }
        CProduct cProduct = this.cProductPersistence.fetchByC_ERC(companyId, externalReferenceCode);
        if (cProduct != null) {
            throw new DuplicateCProductException("There is another commerce product with external reference code " + externalReferenceCode);
        }
    }
}

