/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.product.service.impl;

import com.liferay.commerce.product.exception.CommerceCatalogProductsException;
import com.liferay.commerce.product.exception.CommerceCatalogSystemException;
import com.liferay.commerce.product.model.CommerceCatalog;
import com.liferay.commerce.product.service.base.CommerceCatalogLocalServiceBaseImpl;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.AuditedModel;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.Hits;
import com.liferay.portal.kernel.search.Indexable;
import com.liferay.portal.kernel.search.IndexableType;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerRegistryUtil;
import com.liferay.portal.kernel.search.QueryConfig;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.SearchException;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.systemevent.SystemEvent;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.uuid.PortalUUIDUtil;
import java.util.ArrayList;
import java.util.List;

public class CommerceCatalogLocalServiceImpl
extends CommerceCatalogLocalServiceBaseImpl {
    private static final String[] _SELECTED_FIELD_NAMES = new String[]{"entryClassPK", "companyId"};

    @Indexable(type=IndexableType.REINDEX)
    public CommerceCatalog addCommerceCatalog(String externalReferenceCode, String name, String commerceCurrencyCode, String catalogDefaultLanguageId, boolean system, ServiceContext serviceContext) throws PortalException {
        User user = this.userLocalService.getUser(serviceContext.getUserId());
        if (Validator.isBlank((String)externalReferenceCode)) {
            externalReferenceCode = null;
        }
        long commerceCatalogId = this.counterLocalService.increment();
        CommerceCatalog commerceCatalog = this.commerceCatalogPersistence.create(commerceCatalogId);
        commerceCatalog.setExternalReferenceCode(externalReferenceCode);
        commerceCatalog.setCompanyId(user.getCompanyId());
        commerceCatalog.setUserId(user.getUserId());
        commerceCatalog.setUserName(user.getFullName());
        commerceCatalog.setName(name);
        commerceCatalog.setCommerceCurrencyCode(commerceCurrencyCode);
        commerceCatalog.setCatalogDefaultLanguageId(catalogDefaultLanguageId);
        commerceCatalog.setSystem(system);
        this.groupLocalService.addGroup(user.getUserId(), 0L, CommerceCatalog.class.getName(), commerceCatalogId, 0L, this.getLocalizationMap(name), null, 3, false, 0, null, false, true, null);
        commerceCatalog = (CommerceCatalog)this.commerceCatalogPersistence.update((BaseModel)commerceCatalog);
        this.resourceLocalService.addModelResources((AuditedModel)commerceCatalog, serviceContext);
        return commerceCatalog;
    }

    public CommerceCatalog addCommerceCatalog(String externalReferenceCode, String name, String commerceCurrencyCode, String catalogDefaultLanguageId, ServiceContext serviceContext) throws PortalException {
        return this.commerceCatalogLocalService.addCommerceCatalog(externalReferenceCode, name, commerceCurrencyCode, catalogDefaultLanguageId, false, serviceContext);
    }

    public CommerceCatalog addDefaultCommerceCatalog(long companyId) throws PortalException {
        Company company = this.companyLocalService.getCompany(companyId);
        User defaultUser = company.getDefaultUser();
        ServiceContext serviceContext = new ServiceContext();
        serviceContext.setCompanyId(company.getCompanyId());
        serviceContext.setUserId(defaultUser.getUserId());
        serviceContext.setUuid(PortalUUIDUtil.generate());
        return this.commerceCatalogLocalService.addCommerceCatalog(null, "Master", "USD", defaultUser.getLanguageId(), true, serviceContext);
    }

    @Override
    @Indexable(type=IndexableType.DELETE)
    @SystemEvent(type=1)
    public CommerceCatalog deleteCommerceCatalog(CommerceCatalog commerceCatalog) throws PortalException {
        this.validate(commerceCatalog);
        long groupId = commerceCatalog.getGroupId();
        this.commerceCatalogPersistence.remove((BaseModel)commerceCatalog);
        this.groupLocalService.deleteGroup(groupId);
        this.resourceLocalService.deleteResource((AuditedModel)commerceCatalog, 4);
        return commerceCatalog;
    }

    @Override
    public CommerceCatalog deleteCommerceCatalog(long commerceCatalogId) throws PortalException {
        CommerceCatalog commerceCatalog = this.commerceCatalogPersistence.findByPrimaryKey(commerceCatalogId);
        return this.commerceCatalogLocalService.deleteCommerceCatalog(commerceCatalog);
    }

    public void deleteCommerceCatalogs(long companyId) throws PortalException {
        List commerceCatalogs = this.commerceCatalogPersistence.findByCompanyId(companyId);
        for (CommerceCatalog commerceCatalog : commerceCatalogs) {
            this.commerceCatalogLocalService.forceDeleteCommerceCatalog(commerceCatalog);
        }
    }

    public CommerceCatalog fetchByExternalReferenceCode(String externalReferenceCode, long companyId) {
        if (Validator.isBlank((String)externalReferenceCode)) {
            return null;
        }
        return this.commerceCatalogPersistence.fetchByC_ERC(companyId, externalReferenceCode);
    }

    public CommerceCatalog fetchCommerceCatalogByGroupId(long groupId) {
        Group group = this.groupLocalService.fetchGroup(groupId);
        if (group != null && group.getClassNameId() == this.classNameLocalService.getClassNameId(CommerceCatalog.class)) {
            return this.fetchCommerceCatalog(group.getClassPK());
        }
        return null;
    }

    @Indexable(type=IndexableType.DELETE)
    @SystemEvent(type=1)
    public CommerceCatalog forceDeleteCommerceCatalog(CommerceCatalog commerceCatalog) throws PortalException {
        this.commerceCatalogPersistence.remove((BaseModel)commerceCatalog);
        this.resourceLocalService.deleteResource((AuditedModel)commerceCatalog, 4);
        Group group = this.groupLocalService.fetchGroup(commerceCatalog.getCompanyId(), this.classNameLocalService.getClassNameId(CommerceCatalog.class.getName()), commerceCatalog.getCommerceCatalogId());
        if (group != null) {
            this.groupLocalService.deleteGroup(group);
        }
        return commerceCatalog;
    }

    public Group getCommerceCatalogGroup(long commerceCatalogId) throws PortalException {
        CommerceCatalog commerceCatalog = this.commerceCatalogLocalService.getCommerceCatalog(commerceCatalogId);
        long classNameId = this.classNameLocalService.getClassNameId(CommerceCatalog.class.getName());
        Group group = this.groupLocalService.fetchGroup(commerceCatalog.getCompanyId(), classNameId, commerceCatalogId);
        if (group != null) {
            return group;
        }
        throw new PortalException();
    }

    public List<CommerceCatalog> getCommerceCatalogs(long companyId, boolean system) {
        return this.commerceCatalogPersistence.findByC_S(companyId, system);
    }

    public List<CommerceCatalog> searchCommerceCatalogs(long companyId) throws PortalException {
        return this.searchCommerceCatalogs(companyId, "", -1, -1, null);
    }

    public List<CommerceCatalog> searchCommerceCatalogs(long companyId, String keywords, int start, int end, Sort sort) throws PortalException {
        SearchContext searchContext = this.buildSearchContext(companyId, start, end, sort);
        searchContext.setKeywords(keywords);
        return this.searchCommerceCatalogs(searchContext);
    }

    public int searchCommerceCatalogsCount(long companyId, String keywords) throws PortalException {
        SearchContext searchContext = this.buildSearchContext(companyId, -1, -1, null);
        searchContext.setKeywords(keywords);
        return this.searchCommerceCatalogsCount(searchContext);
    }

    @Indexable(type=IndexableType.REINDEX)
    public CommerceCatalog updateCommerceCatalog(long commerceCatalogId, String name, String commerceCurrencyCode, String catalogDefaultLanguageId) throws PortalException {
        CommerceCatalog commerceCatalog = this.commerceCatalogPersistence.findByPrimaryKey(commerceCatalogId);
        commerceCatalog.setName(name);
        commerceCatalog.setCommerceCurrencyCode(commerceCurrencyCode);
        commerceCatalog.setCatalogDefaultLanguageId(catalogDefaultLanguageId);
        return (CommerceCatalog)this.commerceCatalogPersistence.update((BaseModel)commerceCatalog);
    }

    @Indexable(type=IndexableType.REINDEX)
    public CommerceCatalog updateCommerceCatalogExternalReferenceCode(String externalReferenceCode, long commerceCatalogId) throws PortalException {
        CommerceCatalog commerceCatalog = this.commerceCatalogPersistence.findByPrimaryKey(commerceCatalogId);
        commerceCatalog.setExternalReferenceCode(externalReferenceCode);
        return (CommerceCatalog)this.commerceCatalogPersistence.update((BaseModel)commerceCatalog);
    }

    protected SearchContext buildSearchContext(long companyId, int start, int end, Sort sort) {
        SearchContext searchContext = new SearchContext();
        searchContext.setCompanyId(companyId);
        searchContext.setEnd(end);
        if (sort != null) {
            searchContext.setSorts(new Sort[]{sort});
        }
        searchContext.setStart(start);
        QueryConfig queryConfig = searchContext.getQueryConfig();
        queryConfig.setHighlightEnabled(false);
        queryConfig.setScoreEnabled(false);
        return searchContext;
    }

    protected List<CommerceCatalog> getCommerceCatalogs(Hits hits) throws PortalException {
        List documents = hits.toList();
        ArrayList<CommerceCatalog> commerceCatalogs = new ArrayList<CommerceCatalog>(documents.size());
        for (Document document : documents) {
            long commerceCatalogId = GetterUtil.getLong((String)document.get("entryClassPK"));
            CommerceCatalog commerceCatalog = this.fetchCommerceCatalog(commerceCatalogId);
            if (commerceCatalog == null) {
                commerceCatalogs = null;
                Indexer indexer = IndexerRegistryUtil.getIndexer(CommerceCatalog.class);
                long companyId = GetterUtil.getLong((String)document.get("companyId"));
                indexer.delete(companyId, document.getUID());
                continue;
            }
            if (commerceCatalogs == null) continue;
            commerceCatalogs.add(commerceCatalog);
        }
        return commerceCatalogs;
    }

    protected List<CommerceCatalog> searchCommerceCatalogs(SearchContext searchContext) throws PortalException {
        Indexer indexer = IndexerRegistryUtil.nullSafeGetIndexer(CommerceCatalog.class);
        for (int i = 0; i < 10; ++i) {
            Hits hits = indexer.search(searchContext, _SELECTED_FIELD_NAMES);
            List<CommerceCatalog> commerceCatalogs = this.getCommerceCatalogs(hits);
            if (commerceCatalogs == null) continue;
            return commerceCatalogs;
        }
        throw new SearchException("Unable to fix the search index after 10 attempts");
    }

    protected int searchCommerceCatalogsCount(SearchContext searchContext) throws PortalException {
        Indexer indexer = IndexerRegistryUtil.nullSafeGetIndexer(CommerceCatalog.class);
        return GetterUtil.getInteger((Object)indexer.searchCount(searchContext));
    }

    protected void validate(CommerceCatalog commerceCatalog) throws PortalException {
        if (commerceCatalog.isSystem()) {
            throw new CommerceCatalogSystemException();
        }
        int cpDefinitionsCount = this.cpDefinitionLocalService.getCPDefinitionsCount(commerceCatalog.getGroupId(), -1);
        if (cpDefinitionsCount > 0) {
            throw new CommerceCatalogProductsException();
        }
    }
}

